/*===
IN: DF, UC: 53-53, LC: DF
IN: 130, UC: 130, LC: 69-307
IN: FB00, UC: 46-46, LC: FB00
IN: FB01, UC: 46-49, LC: FB01
IN: FB02, UC: 46-4C, LC: FB02
IN: FB03, UC: 46-46-49, LC: FB03
IN: FB04, UC: 46-46-4C, LC: FB04
IN: FB05, UC: 53-54, LC: FB05
IN: FB06, UC: 53-54, LC: FB06
IN: 587, UC: 535-552, LC: 587
IN: FB13, UC: 544-546, LC: FB13
IN: FB14, UC: 544-535, LC: FB14
IN: FB15, UC: 544-53B, LC: FB15
IN: FB16, UC: 54E-546, LC: FB16
IN: FB17, UC: 544-53D, LC: FB17
IN: 149, UC: 2BC-4E, LC: 149
IN: 390, UC: 399-308-301, LC: 390
IN: 3B0, UC: 3A5-308-301, LC: 3B0
IN: 1F0, UC: 4A-30C, LC: 1F0
IN: 1E96, UC: 48-331, LC: 1E96
IN: 1E97, UC: 54-308, LC: 1E97
IN: 1E98, UC: 57-30A, LC: 1E98
IN: 1E99, UC: 59-30A, LC: 1E99
IN: 1E9A, UC: 41-2BE, LC: 1E9A
IN: 1F50, UC: 3A5-313, LC: 1F50
IN: 1F52, UC: 3A5-313-300, LC: 1F52
IN: 1F54, UC: 3A5-313-301, LC: 1F54
IN: 1F56, UC: 3A5-313-342, LC: 1F56
IN: 1FB6, UC: 391-342, LC: 1FB6
IN: 1FC6, UC: 397-342, LC: 1FC6
IN: 1FD2, UC: 399-308-300, LC: 1FD2
IN: 1FD3, UC: 399-308-301, LC: 1FD3
IN: 1FD6, UC: 399-342, LC: 1FD6
IN: 1FD7, UC: 399-308-342, LC: 1FD7
IN: 1FE2, UC: 3A5-308-300, LC: 1FE2
IN: 1FE3, UC: 3A5-308-301, LC: 1FE3
IN: 1FE4, UC: 3A1-313, LC: 1FE4
IN: 1FE6, UC: 3A5-342, LC: 1FE6
IN: 1FE7, UC: 3A5-308-342, LC: 1FE7
IN: 1FF6, UC: 3A9-342, LC: 1FF6
IN: 345, UC: 399, LC: 345
IN: 1F80, UC: 1F08-399, LC: 1F80
IN: 1F81, UC: 1F09-399, LC: 1F81
IN: 1F82, UC: 1F0A-399, LC: 1F82
IN: 1F83, UC: 1F0B-399, LC: 1F83
IN: 1F84, UC: 1F0C-399, LC: 1F84
IN: 1F85, UC: 1F0D-399, LC: 1F85
IN: 1F86, UC: 1F0E-399, LC: 1F86
IN: 1F87, UC: 1F0F-399, LC: 1F87
IN: 1F88, UC: 1F08-399, LC: 1F80
IN: 1F89, UC: 1F09-399, LC: 1F81
IN: 1F8A, UC: 1F0A-399, LC: 1F82
IN: 1F8B, UC: 1F0B-399, LC: 1F83
IN: 1F8C, UC: 1F0C-399, LC: 1F84
IN: 1F8D, UC: 1F0D-399, LC: 1F85
IN: 1F8E, UC: 1F0E-399, LC: 1F86
IN: 1F8F, UC: 1F0F-399, LC: 1F87
IN: 1F90, UC: 1F28-399, LC: 1F90
IN: 1F91, UC: 1F29-399, LC: 1F91
IN: 1F92, UC: 1F2A-399, LC: 1F92
IN: 1F93, UC: 1F2B-399, LC: 1F93
IN: 1F94, UC: 1F2C-399, LC: 1F94
IN: 1F95, UC: 1F2D-399, LC: 1F95
IN: 1F96, UC: 1F2E-399, LC: 1F96
IN: 1F97, UC: 1F2F-399, LC: 1F97
IN: 1F98, UC: 1F28-399, LC: 1F90
IN: 1F99, UC: 1F29-399, LC: 1F91
IN: 1F9A, UC: 1F2A-399, LC: 1F92
IN: 1F9B, UC: 1F2B-399, LC: 1F93
IN: 1F9C, UC: 1F2C-399, LC: 1F94
IN: 1F9D, UC: 1F2D-399, LC: 1F95
IN: 1F9E, UC: 1F2E-399, LC: 1F96
IN: 1F9F, UC: 1F2F-399, LC: 1F97
IN: 1FA0, UC: 1F68-399, LC: 1FA0
IN: 1FA1, UC: 1F69-399, LC: 1FA1
IN: 1FA2, UC: 1F6A-399, LC: 1FA2
IN: 1FA3, UC: 1F6B-399, LC: 1FA3
IN: 1FA4, UC: 1F6C-399, LC: 1FA4
IN: 1FA5, UC: 1F6D-399, LC: 1FA5
IN: 1FA6, UC: 1F6E-399, LC: 1FA6
IN: 1FA7, UC: 1F6F-399, LC: 1FA7
IN: 1FA8, UC: 1F68-399, LC: 1FA0
IN: 1FA9, UC: 1F69-399, LC: 1FA1
IN: 1FAA, UC: 1F6A-399, LC: 1FA2
IN: 1FAB, UC: 1F6B-399, LC: 1FA3
IN: 1FAC, UC: 1F6C-399, LC: 1FA4
IN: 1FAD, UC: 1F6D-399, LC: 1FA5
IN: 1FAE, UC: 1F6E-399, LC: 1FA6
IN: 1FAF, UC: 1F6F-399, LC: 1FA7
IN: 1FB3, UC: 391-399, LC: 1FB3
IN: 1FBC, UC: 391-399, LC: 1FB3
IN: 1FC3, UC: 397-399, LC: 1FC3
IN: 1FCC, UC: 397-399, LC: 1FC3
IN: 1FF3, UC: 3A9-399, LC: 1FF3
IN: 1FFC, UC: 3A9-399, LC: 1FF3
IN: 1FB2, UC: 1FBA-399, LC: 1FB2
IN: 1FB4, UC: 386-399, LC: 1FB4
IN: 1FC2, UC: 1FCA-399, LC: 1FC2
IN: 1FC4, UC: 389-399, LC: 1FC4
IN: 1FF2, UC: 1FFA-399, LC: 1FF2
IN: 1FF4, UC: 38F-399, LC: 1FF4
IN: 1FB7, UC: 391-342-399, LC: 1FB7
IN: 1FC7, UC: 397-342-399, LC: 1FC7
IN: 1FF7, UC: 3A9-342-399, LC: 1FF7
IN: 3A3, UC: 3A3, LC: 3C3
IN: 3C3, UC: 3A3, LC: 3C3
IN: 3C2, UC: 3A3, LC: 3C2
IN: 307, UC: 307, LC: 307
IN: 49, UC: 49, LC: 69
IN: 4A, UC: 4A, LC: 6A
IN: 12E, UC: 12E, LC: 12F
IN: CC, UC: CC, LC: EC
IN: CD, UC: CD, LC: ED
IN: 128, UC: 128, LC: 129
IN: 130, UC: 130, LC: 69-307
IN: 307, UC: 307, LC: 307
IN: 49, UC: 49, LC: 69
IN: 69, UC: 49, LC: 69
IN: 131, UC: 49, LC: 131
done
===*/

function formatCodepoints(v) {
    var tmp = [];
    for (var i = 0; i < v.length; i++) {
        tmp.push(v.charCodeAt(i));
    }
    return tmp.map(function (v) { return v.toString(16).toUpperCase(); }).join('-');
}

function test(v) {
    print('IN: ' + formatCodepoints(v) +
          ', UC: ' + formatCodepoints(v.toUpperCase()) +
          ', LC: ' + formatCodepoints(v.toLowerCase()));
}

// Unconditional mappings.

test('\u00DF');
test('\u0130');

test('\uFB00');
test('\uFB01');
test('\uFB02');
test('\uFB03');
test('\uFB04');
test('\uFB05');
test('\uFB06');

test('\u0587');
test('\uFB13');
test('\uFB14');
test('\uFB15');
test('\uFB16');
test('\uFB17');

test('\u0149');
test('\u0390');
test('\u03B0');
test('\u01F0');
test('\u1E96');
test('\u1E97');
test('\u1E98');
test('\u1E99');
test('\u1E9A');
test('\u1F50');
test('\u1F52');
test('\u1F54');
test('\u1F56');
test('\u1FB6');
test('\u1FC6');
test('\u1FD2');
test('\u1FD3');
test('\u1FD6');
test('\u1FD7');
test('\u1FE2');
test('\u1FE3');
test('\u1FE4');
test('\u1FE6');
test('\u1FE7');
test('\u1FF6');

test('\u0345');

test('\u1F80');
test('\u1F81');
test('\u1F82');
test('\u1F83');
test('\u1F84');
test('\u1F85');
test('\u1F86');
test('\u1F87');
test('\u1F88');
test('\u1F89');
test('\u1F8A');
test('\u1F8B');
test('\u1F8C');
test('\u1F8D');
test('\u1F8E');
test('\u1F8F');
test('\u1F90');
test('\u1F91');
test('\u1F92');
test('\u1F93');
test('\u1F94');
test('\u1F95');
test('\u1F96');
test('\u1F97');
test('\u1F98');
test('\u1F99');
test('\u1F9A');
test('\u1F9B');
test('\u1F9C');
test('\u1F9D');
test('\u1F9E');
test('\u1F9F');
test('\u1FA0');
test('\u1FA1');
test('\u1FA2');
test('\u1FA3');
test('\u1FA4');
test('\u1FA5');
test('\u1FA6');
test('\u1FA7');
test('\u1FA8');
test('\u1FA9');
test('\u1FAA');
test('\u1FAB');
test('\u1FAC');
test('\u1FAD');
test('\u1FAE');
test('\u1FAF');
test('\u1FB3');
test('\u1FBC');
test('\u1FC3');
test('\u1FCC');
test('\u1FF3');
test('\u1FFC');

test('\u1FB2');
test('\u1FB4');
test('\u1FC2');
test('\u1FC4');
test('\u1FF2');
test('\u1FF4');

test('\u1FB7');
test('\u1FC7');
test('\u1FF7');

// Conditional mappings.  Behavior depends on context.  Here just test for
// what happens for the individual codepoints.

test('\u03A3');
test('\u03C3');
test('\u03C2');

// Language specific.  Cover what happens for individual codepoints.

test('\u0307');

test('\u0049');
test('\u004A');
test('\u012E');
test('\u00CC');
test('\u00CD');
test('\u0128');

test('\u0130');

test('\u0307');

test('\u0049');

test('\u0069');

test('\u0131');

print('done');
