; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

declare void @use(i1)

; Make sure we do not crash when trying to inject info about vector values from SCEV.
define void @test_vector_iv(i32 %x, i1 %c) {
; CHECK-LABEL: @test_vector_iv(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[PRE:%.*]], label [[BB2:%.*]]
; CHECK:       pre:
; CHECK-NEXT:    [[C_1:%.*]] = icmp ule i32 [[X:%.*]], 10
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP:%.*]], label [[BB2]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi <4 x i8> [ zeroinitializer, [[PRE]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[T_1:%.*]] = icmp ule i32 [[X]], 10
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[F_1:%.*]] = icmp ugt i32 [[X]], 10
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    [[C_2:%.*]] = icmp ule i32 [[X]], 9
; CHECK-NEXT:    call void @use(i1 [[C_2]])
; CHECK-NEXT:    [[C_3:%.*]] = icmp ugt i32 [[X]], 9
; CHECK-NEXT:    call void @use(i1 [[C_3]])
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw <4 x i8> [[IV]], <i8 1, i8 1, i8 1, i8 1>
; CHECK-NEXT:    [[E:%.*]] = extractelement <4 x i8> [[IV_NEXT]], i8 2
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i8 [[E]], 100
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[C_4:%.*]] = icmp ule i32 [[X]], 10
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    ret void
; CHECK:       bb2:
; CHECK-NEXT:    [[C_5:%.*]] = icmp ugt i32 [[X]], 10
; CHECK-NEXT:    call void @use(i1 [[C_5]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %c, label %pre, label %bb2

pre:
  %c.1 = icmp ule i32 %x, 10
  br i1 %c.1, label %loop, label %bb2

loop:
  %iv = phi <4 x i8> [ zeroinitializer, %pre ], [ %iv.next, %loop ]
  %t.1 = icmp ule i32 %x, 10
  call void @use(i1 %t.1)
  %f.1 = icmp ugt i32 %x, 10
  call void @use(i1 %f.1)

  %c.2 = icmp ule i32 %x, 9
  call void @use(i1 %c.2)
  %c.3 = icmp ugt i32 %x, 9
  call void @use(i1 %c.3)

  %iv.next = add nuw nsw <4 x i8> %iv, <i8 1, i8 1, i8 1, i8 1>
  %e = extractelement <4 x i8> %iv.next, i8 2
  %ec = icmp eq i8 %e, 100
  br i1 %ec, label %exit, label %loop

exit:
  %c.4 = icmp ule i32 %x, 10
  call void @use(i1 %c.4)
  ret void

bb2:
  %c.5 = icmp ugt i32 %x, 10
  call void @use(i1 %c.5)
  ret void
}
