#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Warhammer 40,000: Dawn of War:
# - Dawn of War (original game)
# - Winter Assault
# - Dark Crusade
# - Soulstorm
###

script_version=20230918.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='warhammer-40k-dawn-of-war'
GAME_NAME='Warhammer 40,000: Dawn of War'

GAME_ID_WA="${GAME_ID}-winter-assault"
GAME_NAME_WA="$GAME_NAME - Winter Assault"

GAME_ID_DC="${GAME_ID}-dark-crusade"
GAME_NAME_DC="$GAME_NAME - Dark Crusade"

GAME_ID_SS="${GAME_ID}-soulstorm"
GAME_NAME_SS="$GAME_NAME - Soulstorm"

# Archives

## Dawn of War (base game)

ARCHIVE_BASE_DOW_EN_0_NAME='setup_warhammer_40000_dawn_of_war_0.19_(64626).exe'
ARCHIVE_BASE_DOW_EN_0_MD5='a45fc06675d678b282e7f72f39c2591c'
ARCHIVE_BASE_DOW_EN_0_TYPE='innosetup'
ARCHIVE_BASE_DOW_EN_0_PART1_NAME='setup_warhammer_40000_dawn_of_war_0.19_(64626)-1.bin'
ARCHIVE_BASE_DOW_EN_0_PART1_MD5='e89415bc33d078598a19650ddd80d2be'
ARCHIVE_BASE_DOW_EN_0_SIZE='2800000'
ARCHIVE_BASE_DOW_EN_0_VERSION='1.51-gog64626'
ARCHIVE_BASE_DOW_EN_0_URL='https://www.gog.com/game/warhammer_40000_dawn_of_war'

ARCHIVE_BASE_DOW_FR_0_NAME='setup_warhammer_40000_dawn_of_war_0.19_(french)_(64626).exe'
ARCHIVE_BASE_DOW_FR_0_MD5='e1cdc8cc2b9a81b390cd1996053d5c04'
ARCHIVE_BASE_DOW_FR_0_TYPE='innosetup'
ARCHIVE_BASE_DOW_FR_0_PART1_NAME='setup_warhammer_40000_dawn_of_war_0.19_(french)_(64626)-1.bin'
ARCHIVE_BASE_DOW_FR_0_PART1_MD5='32eecc81507d84f6d39f9c74aeb5e1ef'
ARCHIVE_BASE_DOW_FR_0_SIZE='2800000'
ARCHIVE_BASE_DOW_FR_0_VERSION='1.51-gog64626'
ARCHIVE_BASE_DOW_FR_0_URL='https://www.gog.com/game/warhammer_40000_dawn_of_war'

## Winter Assault

ARCHIVE_BASE_WA_EN_0_NAME='setup_warhammer_40000_dawn_of_war_-_winter_assault_0.19_(64626).exe'
ARCHIVE_BASE_WA_EN_0_MD5='a610066c44aee835f0ac608864c31ef9'
ARCHIVE_BASE_WA_EN_0_TYPE='innosetup'
ARCHIVE_BASE_WA_EN_0_PART1_NAME='setup_warhammer_40000_dawn_of_war_-_winter_assault_0.19_(64626)-1.bin'
ARCHIVE_BASE_WA_EN_0_PART1_MD5='fd954304b3f38cccf859edf7ca4e1dd5'
ARCHIVE_BASE_WA_EN_0_SIZE='2800000'
ARCHIVE_BASE_WA_EN_0_VERSION='1.51-gog64626'
ARCHIVE_BASE_WA_EN_0_URL='https://www.gog.com/game/warhammer_40000_dawn_of_war'

ARCHIVE_BASE_WA_FR_0_NAME='setup_warhammer_40000_dawn_of_war_-_winter_assault_0.19_(french)_(64626).exe'
ARCHIVE_BASE_WA_FR_0_MD5='9423b22d50f707d794e961aef63a9a44'
ARCHIVE_BASE_WA_FR_0_TYPE='innosetup'
ARCHIVE_BASE_WA_FR_0_PART1_NAME='setup_warhammer_40000_dawn_of_war_-_winter_assault_0.19_(french)_(64626)-1.bin'
ARCHIVE_BASE_WA_FR_0_PART1_MD5='b4a188c7ed2012a9c4fd300af07c831d'
ARCHIVE_BASE_WA_FR_0_SIZE='2800000'
ARCHIVE_BASE_WA_FR_0_VERSION='1.51-gog64626'
ARCHIVE_BASE_WA_FR_0_URL='https://www.gog.com/game/warhammer_40000_dawn_of_war'

## Dark Crusade

ARCHIVE_BASE_DC_EN_0_NAME='setup_warhammer_40000_dawn_of_war_-_dark_crusade_0.19_(64626).exe'
ARCHIVE_BASE_DC_EN_0_MD5='e54248e3e006fa378e374a9a60f33418'
ARCHIVE_BASE_DC_EN_0_TYPE='innosetup'
ARCHIVE_BASE_DC_EN_0_PART1_NAME='setup_warhammer_40000_dawn_of_war_-_dark_crusade_0.19_(64626)-1.bin'
ARCHIVE_BASE_DC_EN_0_PART1_MD5='8830adc7aa004a800411b0f95919af5f'
ARCHIVE_BASE_DC_EN_0_SIZE='4500000'
ARCHIVE_BASE_DC_EN_0_VERSION='1.20-gog64626'
ARCHIVE_BASE_DC_EN_0_URL='https://www.gog.com/game/warhammer_40000_dawn_of_war'

ARCHIVE_BASE_DC_FR_0_NAME='setup_warhammer_40000_dawn_of_war_-_dark_crusade_0.19_(french)_(64626).exe'
ARCHIVE_BASE_DC_FR_0_MD5='5a254443909788b595baf16610809056'
ARCHIVE_BASE_DC_FR_0_TYPE='innosetup'
ARCHIVE_BASE_DC_FR_0_PART1_NAME='setup_warhammer_40000_dawn_of_war_-_dark_crusade_0.19_(french)_(64626)-1.bin'
ARCHIVE_BASE_DC_FR_0_PART1_MD5='0a64baaffaa392b9afd570a0a811cb2f'
ARCHIVE_BASE_DC_FR_0_SIZE='4600000'
ARCHIVE_BASE_DC_FR_0_VERSION='1.20-gog64626'
ARCHIVE_BASE_DC_FR_0_URL='https://www.gog.com/game/warhammer_40000_dawn_of_war'

## Soulstorm

ARCHIVE_BASE_SS_EN_1_NAME='setup_warhammer_40000_dawn_of_war_-_soulstorm_0.21_(64955).exe'
ARCHIVE_BASE_SS_EN_1_MD5='8da443afebb589ca1f1b0100579325d2'
ARCHIVE_BASE_SS_EN_1_TYPE='innosetup'
ARCHIVE_BASE_SS_EN_1_PART1_NAME='setup_warhammer_40000_dawn_of_war_-_soulstorm_0.21_(64955)-1.bin'
ARCHIVE_BASE_SS_EN_1_PART1_MD5='ac634ca5d861d3fc502325646cffbd83'
ARCHIVE_BASE_SS_EN_1_PART2='setup_warhammer_40000_dawn_of_war_-_soulstorm_0.21_(64955)-2.bin'
ARCHIVE_BASE_SS_EN_1_PART2_MD5='5c4cde5ecf4dae72bbdbc97a7659dbe5'
ARCHIVE_BASE_SS_EN_1_SIZE='5458668'
ARCHIVE_BASE_SS_EN_1_VERSION='1.2.0-gog64955'
ARCHIVE_BASE_SS_EN_1_URL='https://www.gog.com/game/warhammer_40000_dawn_of_war'

ARCHIVE_BASE_SS_FR_1_NAME='setup_warhammer_40000_dawn_of_war_-_soulstorm_0.21_(french)_(64955).exe'
ARCHIVE_BASE_SS_FR_1_MD5='e2fd0c36f0b36a9ad06c10ff4d044478'
ARCHIVE_BASE_SS_FR_1_TYPE='innosetup'
ARCHIVE_BASE_SS_FR_1_PART1_NAME='setup_warhammer_40000_dawn_of_war_-_soulstorm_0.21_(french)_(64955)-1.bin'
ARCHIVE_BASE_SS_FR_1_PART1_MD5='29203f3fc2424b33f3251e44fbe65d13'
ARCHIVE_BASE_SS_FR_1_PART2='setup_warhammer_40000_dawn_of_war_-_soulstorm_0.21_(french)_(64955)-2.bin'
ARCHIVE_BASE_SS_FR_1_PART2_MD5='6ad688745bba4fe353b1da9b330e956a'
ARCHIVE_BASE_SS_FR_1_SIZE='5459544'
ARCHIVE_BASE_SS_FR_1_VERSION='1.2.0-gog64955'
ARCHIVE_BASE_SS_FR_1_URL='https://www.gog.com/game/warhammer_40000_dawn_of_war'

ARCHIVE_BASE_SS_EN_0_NAME='setup_warhammer_40000_dawn_of_war_-_soulstorm_0.19_(64626).exe'
ARCHIVE_BASE_SS_EN_0_MD5='ccf68576db62f61c3d4967a1e66d3863'
ARCHIVE_BASE_SS_EN_0_TYPE='innosetup'
ARCHIVE_BASE_SS_EN_0_PART1_NAME='setup_warhammer_40000_dawn_of_war_-_soulstorm_0.19_(64626)-1.bin'
ARCHIVE_BASE_SS_EN_0_PART1_MD5='944e2a30b2036dbfb37b1b649c370541'
ARCHIVE_BASE_SS_EN_0_PART2_NAME='setup_warhammer_40000_dawn_of_war_-_soulstorm_0.19_(64626)-2.bin'
ARCHIVE_BASE_SS_EN_0_PART2_MD5='949587a4ce461c4900636913ab53e5a1'
ARCHIVE_BASE_SS_EN_0_SIZE='5500000'
ARCHIVE_BASE_SS_EN_0_VERSION='1.2.0-gog64626'

ARCHIVE_BASE_SS_FR_0_NAME='setup_warhammer_40000_dawn_of_war_-_soulstorm_0.19_(french)_(64626).exe'
ARCHIVE_BASE_SS_FR_0_MD5='a652d618bdc2071ad476842939b63373'
ARCHIVE_BASE_SS_FR_0_TYPE='innosetup'
ARCHIVE_BASE_SS_FR_0_PART1_NAME='setup_warhammer_40000_dawn_of_war_-_soulstorm_0.19_(french)_(64626)-1.bin'
ARCHIVE_BASE_SS_FR_0_PART1_MD5='3ffd1c39b68c984acb23263c9ffec133'
ARCHIVE_BASE_SS_FR_0_PART2_NAME='setup_warhammer_40000_dawn_of_war_-_soulstorm_0.19_(french)_(64626)-2.bin'
ARCHIVE_BASE_SS_FR_0_PART2_MD5='6ba9d30068b91823d838812c8930c8b3'
ARCHIVE_BASE_SS_FR_0_SIZE='5500000'
ARCHIVE_BASE_SS_FR_0_VERSION='1.2.0-gog64626'


CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
bugreport
*.dll
*.exe
*.ini'
CONTENT_GAME_L10N_FILES='
bugreport/english
bugreport/french
dxp2/locale
engine/locale
graphicsoptions/locale
w40k/locale
wxp/locale
regions.ini'
CONTENT_GAME_DATA_FILES='
drivers
dxp2
engine
graphicsoptions
patch
w40k
wxp
*.dat
*.module'
CONTENT_DOC_L10N_FILES='
*.htm'

USER_PERSISTENT_DIRECTORIES='
badges
banners
playback
profiles
screenshots
stats'
USER_PERSISTENT_FILES='
drivers/spdx9_config.txt
local.ini'

APP_MAIN_EXE_DOW='w40k.exe'
APP_MAIN_EXE_WA='w40kwa.exe'
APP_MAIN_EXE_DC='darkcrusade.exe'
APP_MAIN_EXE_SS='soulstorm.exe'
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=101'
## Type must be set explicitly,
## or it will be wrongly identified as a Mono application.
APP_MAIN_TYPE='wine'

# Packages

PACKAGES_LIST='PKG_L10N PKG_BIN PKG_DATA'

PKG_L10N_DESCRIPTION_EN='English localization'
PKG_L10N_DESCRIPTION_FR='French localization'

PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'

## Dawn of War (base game)

PKG_L10N_ID_DOW="${GAME_ID}-l10n"
PKG_L10N_ID_DOW_EN="${PKG_L10N_ID_DOW}-en"
PKG_L10N_ID_DOW_FR="${PKG_L10N_ID_DOW}-fr"
PKG_L10N_PROVIDES_DOW="
$PKG_L10N_ID_DOW"
PKG_L10N_DESCRIPTION_DOW_EN="$PKG_L10N_DESCRIPTION_EN"
PKG_L10N_DESCRIPTION_DOW_FR="$PKG_L10N_DESCRIPTION_FR"

PKG_DATA_ID_DOW="${GAME_ID}-data"

PKG_BIN_DEPS_DOW="$PKG_L10N_ID_DOW $PKG_DATA_ID_DOW"

## Winter Assault

PKG_L10N_ID_WA="${GAME_ID_WA}-l10n"
PKG_L10N_ID_WA_EN="${PKG_L10N_ID_WA}-en"
PKG_L10N_ID_WA_FR="${PKG_L10N_ID_WA}-fr"
PKG_L10N_PROVIDES_WA="
$PKG_L10N_ID_WA"
PKG_L10N_DESCRIPTION_WA_EN="$PKG_L10N_DESCRIPTION_EN"
PKG_L10N_DESCRIPTION_WA_FR="$PKG_L10N_DESCRIPTION_FR"

PKG_DATA_ID_WA="${GAME_ID_WA}-data"

PKG_BIN_DEPS_WA="$PKG_L10N_ID_WA $PKG_DATA_ID_WA"

## Dark Crusade

PKG_L10N_ID_DC="${GAME_ID_DC}-l10n"
PKG_L10N_ID_DC_EN="${PKG_L10N_ID_DC}-en"
PKG_L10N_ID_DC_FR="${PKG_L10N_ID_DC}-fr"
PKG_L10N_PROVIDES_DC="
$PKG_L10N_ID_DC"
PKG_L10N_DESCRIPTION_DC_EN="$PKG_L10N_DESCRIPTION_EN"
PKG_L10N_DESCRIPTION_DC_FR="$PKG_L10N_DESCRIPTION_FR"

PKG_DATA_ID_DC="${GAME_ID_DC}-data"

PKG_BIN_DEPS_DC="$PKG_L10N_ID_DC $PKG_DATA_ID_DC"

## Soulstorm

PKG_L10N_ID_SS="${GAME_ID_SS}-l10n"
PKG_L10N_ID_SS_EN="${PKG_L10N_ID_SS}-en"
PKG_L10N_ID_SS_FR="${PKG_L10N_ID_SS}-fr"
PKG_L10N_PROVIDES_SS="
$PKG_L10N_ID_SS"
PKG_L10N_DESCRIPTION_SS_EN="$PKG_L10N_DESCRIPTION_EN"
PKG_L10N_DESCRIPTION_SS_FR="$PKG_L10N_DESCRIPTION_FR"

PKG_DATA_ID_SS="${GAME_ID_SS}-data"

PKG_BIN_DEPS_SS="$PKG_L10N_ID_SS $PKG_DATA_ID_SS"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Include Mono in the WINE prefix

ARCHIVE_REQUIRED_MONO_NAME='wine-mono-8.0.0-x86.msi'
ARCHIVE_REQUIRED_MONO_MD5='4fe5c683fcd9634c7f6571f252b3603c'
ARCHIVE_REQUIRED_MONO_URL='https://dl.winehq.org/wine/wine-mono/8.0.0/'

archive_initialize_required 'ARCHIVE_MONO' 'ARCHIVE_REQUIRED_MONO'

mono_installer_source=$(archive_path 'ARCHIVE_MONO')
mono_installer_destination="$(package_path 'PKG_BIN')$(path_game_data)/mono/wine-mono-8.0.0-x86.msi"
install -D --mode=644 "$mono_installer_source" "$mono_installer_destination"

WINE_DLLOVERRIDES_DEFAULT='winemenubuilder.exe,mshtml='

APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')"'
# Include Mono in the WINE prefix
if [ ! -e .mono_installed ]; then
	$(wine_command) mono/wine-mono-8.0.0-x86.msi
	touch .mono_installed
fi
'

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Delete unwanted files
	rm --force --recursive \
		'__redist' \
		'app' \
		'commonappdata' \
		'tmp'

	# Prevent mouse cursor flickering
	sed_pattern='allowhwcursor 1'
	sed_replacement='allowhwcursor 0'
	sed_expression="s/${sed_pattern}/${sed_replacement}/"
	sed --in-place --expression="$sed_expression" 'drivers/spdx9_config.txt'
)

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
