;;; EMAIL-AUTO
;;; -----------------

;;(email-auto-init env) -> env
;; initialize envronment
(defund email-auto-init (env)
   (set-var 'already-answered '()
    (set-var 'user '()
     (set-var 'default-response '() env))))

;;(email-auto-command string list[<anything>] env -> env
;;
(defund email-auto-command (cmd args env)
  (cond ((equal 'SET_USER cmd)
         (let ((?user (car args)))
            (set-var 'user ?user env)))
        ((equal 'SET_DEFAULT_RESPONSE cmd)
	 (let ((resp (car args)))
	   (set-var 'already-answered '()
           (set-var 'default-response resp env))))
        (t env)))

;;(email-auto-outgoing message env) -> action
;; what transpires when an message is sent
(defund email-auto-outgoing (msg env)
  (begin
   (cw "  [email-auto-outgoing: ~x0]~%" (lookup 'user))
   (act comment "[Outgoing events not handled]")))

;;(email-auto-incoming message env) -> action
;; when a message is received
(defund email-auto-incoming (msg env)
   (if (equal '() (lookup 'user))
	(act comment "    [User not set yet --> no action]")
     (begin
      (let ((?from (message-sender msg)))
	 (if (member-equal ?from (lookup 'already-answered))
	      (act comment "[No autoresponse, already answered --> 
                  no further action]")
	   (if (equal '() (lookup 'default-response))
	       (act comment "[No default autoresponse --> no further action]~%")
	     (let ((?recip    (recipient msg))
		   (?response (lookup 'default-response)))
	       (begin 
		(cw "  respond '~x0'to ~x1~%" ?response ?recip)
		(act mail 
		     (mk-message
		      ?recip
		      (list (message-sender msg))
		      (set-var 'subject (list 're (subject msg)) '())
		      (cons ?response '()))
		     (set-var
		      'already-answered
		      (cons ?from (lookup 'already-answered))
		      env))))))))))

