/*
 * This file was automatically generated by EvoSuite
 * Thu Jun 07 15:01:11 GMT 2018
 */

package uk.ac.sanger.artemis.components.alignment;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.net.URLStreamHandler;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.xmlgraphics.java2d.GraphicsConfigurationWithoutTransparency;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.mock.java.net.MockURL;
import org.evosuite.runtime.testdata.EvoSuiteURL;
import org.evosuite.runtime.testdata.NetworkHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.DisplayAdjustmentEvent;
import uk.ac.sanger.artemis.components.FeatureDisplay;
import uk.ac.sanger.artemis.components.alignment.LookSeqPanel;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class LookSeqPanel_ESTest extends LookSeqPanel_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel();
      String string0 = lookSeqPanel0.getQueryStr();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel(" 7vXg[2d/d", " 7vXg[2d/d");
      String string0 = lookSeqPanel0.getQueryStr();
      assertEquals(" 7vXg[2d/d", string0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel();
      // Undeclared exception!
      try { 
        lookSeqPanel0.showOptions();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.LookSeqPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel();
      // Undeclared exception!
      try { 
        lookSeqPanel0.setDisplay(0, 0, (DisplayAdjustmentEvent) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.LookSeqPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel();
      // Undeclared exception!
      try { 
        lookSeqPanel0.paintComponent((Graphics) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("javax.swing.JComponent", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      EvoSuiteURL evoSuiteURL0 = new EvoSuiteURL("http://www.sanger.ac.uk/cgi-bin/teams/team112/lookseq/get_data.pl?from=157682&to=479328&chr=MAL1&output=image&width=1024&lane=sample_2a&view=indel&display=|perfect|snps|inversions|pairlinks|potsnps|uniqueness|&debug=0");
      NetworkHandling.createRemoteTextFile(evoSuiteURL0, "");
      String[] stringArray0 = new String[0];
      // Undeclared exception!
      try { 
        LookSeqPanel.main(stringArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.LookSeqPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      URLStreamHandler uRLStreamHandler0 = mock(URLStreamHandler.class, new ViolatedAssumptionAnswer());
      URL uRL0 = MockURL.URL("bKK@", "", 1927, "", uRLStreamHandler0);
      LookSeqPanel lookSeqPanel0 = null;
      try {
        lookSeqPanel0 = new LookSeqPanel(uRL0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.net.URL", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = null;
      try {
        lookSeqPanel0 = new LookSeqPanel((URL) null);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // input == null!
         //
         verifyException("javax.imageio.ImageIO", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel();
      Object object0 = new Object();
      DisplayAdjustmentEvent displayAdjustmentEvent0 = new DisplayAdjustmentEvent(object0, 0, 0, 0, 0);
      lookSeqPanel0.setImage("lane=[^&]+", "lane=[^&]+");
      lookSeqPanel0.setDisplay(6, 0, displayAdjustmentEvent0);
      assertEquals("lane=[^&]+", lookSeqPanel0.getQueryStr());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel();
      lookSeqPanel0.setImage("lane=[^&]+", "lane=[^&]+");
      lookSeqPanel0.setDisplay(6, 0, (DisplayAdjustmentEvent) null);
      assertEquals("lane=[^&]+", lookSeqPanel0.getQueryStr());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel();
      GraphicsConfigurationWithoutTransparency graphicsConfigurationWithoutTransparency0 = new GraphicsConfigurationWithoutTransparency();
      BufferedImage bufferedImage0 = graphicsConfigurationWithoutTransparency0.createCompatibleImage(4, 102, 1897);
      Graphics graphics2D0 = bufferedImage0.getGraphics();
      lookSeqPanel0.paintComponent(graphics2D0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel();
      lookSeqPanel0.setUrl("+r1X", (String) null);
      assertFalse(lookSeqPanel0.isFocusCycleRoot());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel(uRL0);
      assertFalse(lookSeqPanel0.isFocusTraversalPolicyProvider());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel("", "");
      String string0 = lookSeqPanel0.getQueryStr();
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel();
      lookSeqPanel0.setFeatureDisplay((FeatureDisplay) null);
      assertFalse(lookSeqPanel0.isFocusTraversalPolicyProvider());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      String[] stringArray0 = new String[1];
      // Undeclared exception!
      try { 
        LookSeqPanel.main(stringArray0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel();
      Integer integer0 = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB;
      DisplayAdjustmentEvent displayAdjustmentEvent0 = new DisplayAdjustmentEvent(integer0, 2734, (-873), 2734, 0);
      lookSeqPanel0.displayAdjustmentValueChanged(displayAdjustmentEvent0);
      assertFalse(lookSeqPanel0.isFocusTraversalPolicyProvider());
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      LookSeqPanel lookSeqPanel0 = new LookSeqPanel("}Pb(v~)lWf.K6&T", "}Pb(v~)lWf.K6&T");
      DisplayAdjustmentEvent displayAdjustmentEvent0 = new DisplayAdjustmentEvent("}Pb(v~)lWf.K6&T", 3, 3, 3, 1730);
      lookSeqPanel0.setDisplay(3, 3, displayAdjustmentEvent0);
      assertEquals("}Pb(v~)lWf.K6&T", lookSeqPanel0.getQueryStr());
  }
}
