/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.cojen.classfile.Attribute;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.constant.ConstantClassInfo;
import org.cojen.classfile.constant.ConstantNameAndTypeInfo;

public class EnclosingMethodAttr
extends Attribute {
    private final ConstantClassInfo mClass;
    private final ConstantNameAndTypeInfo mMethod;

    public EnclosingMethodAttr(ConstantPool cp, ConstantClassInfo enclosingClass, ConstantNameAndTypeInfo enclosingMethod) {
        this(cp, "EnclosingMethod", enclosingClass, enclosingMethod);
    }

    public EnclosingMethodAttr(ConstantPool cp, String name, ConstantClassInfo enclosingClass, ConstantNameAndTypeInfo enclosingMethod) {
        super(cp, name);
        this.mClass = enclosingClass;
        this.mMethod = enclosingMethod;
    }

    public EnclosingMethodAttr(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        super(cp, name);
        this.mClass = (ConstantClassInfo)cp.getConstant(din.readUnsignedShort());
        this.mMethod = (ConstantNameAndTypeInfo)cp.getConstant(din.readUnsignedShort());
        EnclosingMethodAttr.skipBytes(din, length - 4);
    }

    public ConstantClassInfo getEnclosingClass() {
        return this.mClass;
    }

    public ConstantNameAndTypeInfo getEnclosingMethod() {
        return this.mMethod;
    }

    public int getLength() {
        return 4;
    }

    public void writeDataTo(DataOutput dout) throws IOException {
        dout.writeShort(this.mClass.getIndex());
        dout.writeShort(this.mMethod.getIndex());
    }
}

