/*******************************************************************************
 * JMMC project ( http://www.jmmc.fr ) - Copyright (C) CNRS.
 ******************************************************************************/
/**
 * @file
 * Functions and data related to reference spectrums
 */
#define _POSIX_SOURCE 1

/*
 * System Headers
 */
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "fitsio.h"

/*
 * Local Headers
 */
#include "amdlib.h"
#include "amdlibProtected.h"

/** Reference spectrum used during spectral calibration in JHK mode */
static amdlibDOUBLE amdlibRefLowJHKSpectrumForCal[amdlibNB_BANDS]
                                              [amdlibNB_SPECTRAL_CHANNELS] =
{
    {
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        -1.5733317E-03, -1.1917216E-04, -2.4046969E-04, -3.7889986E-04,
        6.2059713E-05, -1.9999340E-04, 5.8205980E-05, -2.0363728E-04,
        -4.6164574E-04, -2.4589113E-04, -3.4312002E-04, -3.7088812E-05,
        -1.6353224E-04, -1.3574962E-04, -3.8079228E-04, -1.5107598E-04,
        -3.4872012E-04, -1.6392210E-04, -2.4976014E-04, -3.6536978E-04,
        -5.5517053E-04, -5.0148449E-04, -1.9429484E-04, -2.6544760E-04,
        -1.7156449E-04, -1.8886488E-04, -5.6292189E-05, -1.9997700E-04,
        7.2581475E-05, -2.9939055E-04, -5.6139350E-05, -2.0836644E-04,
        -6.0716502E-05, -4.6055833E-05, -1.5051253E-04, -2.4556424E-04,
        -1.2726706E-04, -2.2723108E-04, -5.4420327E-04, -1.2684407E-04,
        2.6880303E-05, -3.6696310E-04, -8.2507875E-05, -2.0338694E-05,
        -2.2669221E-05, -4.2206218E-05, -2.1947974E-04, -8.2626111E-06,
        2.1349866E-05, 1.1860599E-05, 1.1273767E-04, -1.6934950E-04,
        -1.3691490E-04, -1.0078188E-04, -1.3362357E-04, 9.3083567E-05,
        -7.7289151E-05, 1.9604150E-04, 1.4479323E-04, 3.1441999E-05,
        -1.3701165E-04, -5.4109598E-05, -2.3203402E-05, 7.9520963E-05,
        -6.0383692E-05, 3.0677154E-04, 3.9564946E-04, 4.7399977E-04,
        4.2246626E-04, 5.1628664E-04, 1.0089658E-03, 1.8462556E-03,
        3.2429695E-03, 5.7187993E-03, 9.9434610E-03, 1.8168200E-02,
        2.6520407E-02, 3.4534790E-02, 4.0805556E-02, 4.1993737E-02,
        3.7710674E-02, 3.2978259E-02, 2.6563648E-02, 2.2251923E-02,
        1.8266482E-02, 1.4416827E-02, 1.1306120E-02, 9.2432629E-03,
        7.3791398E-03, 5.9208712E-03, 4.7005122E-03, 3.7486278E-03,
        3.0240598E-03, 2.4251442E-03, 2.0461632E-03, 1.4433566E-03,
        1.4666285E-03, 1.4114964E-03, 8.9475577E-04, 9.1793848E-04,
        4.3259666E-04, 1.6250259E-04, 8.7615382E-04, 1.2216660E-03,
        1.5063948E-03, 1.5013033E-03, 1.5255552E-03, 2.0396155E-03,
        2.9851408E-03, 3.7945861E-03, 6.4278455E-03, 2.8644809E-02, 0.1616497,
        0.3992507, 0.6968028, 0.9448382, 1.000000, 0.9686517, 0.8569408,
        0.7245666, 0.5532997, 0.4343372, 0.3502789, 0.3113922, 0.2740446,
        0.2255701, 0.1892572, 0.1589029, 0.1345442, 0.1198603, 0.1103444,
        0.1006512, 9.2452481E-02, 8.0810815E-02, 6.4893760E-02, 5.4838181E-02,
        4.6875302E-02, 4.2893562E-02, 3.5280500E-02, 2.7289165E-02,
        2.3561576E-02, 1.8196234E-02, 1.5296325E-02, 1.1016913E-02,
        7.3674852E-03, 4.5456444E-03, 2.8868862E-03, 2.3130141E-03,
        1.6791791E-03, 1.5317193E-03, 1.1219541E-03, 6.8206375E-04,
        2.9522783E-04, 3.7549951E-04, 4.4018260E-04, 1.4137267E-04,
        -6.9002199E-05, 4.8500186E-04, 1.6716102E-04, 4.2711166E-04,
        -1.8316349E-04, -1.4083233E-04, -7.7192955E-05, 1.3606899E-04,
        -6.4049396E-05, -1.9944916E-04, -9.3542067E-06, 7.1152044E-06,
        -3.7437025E-05, -1.4291603E-04, -2.1182784E-04, -8.6840344E-05,
        -1.7479001E-04, -1.5819486E-04, 1.2507278E-04, -3.2274160E-04,
        1.1620150E-04, -1.0168986E-04, -1.6631978E-04, -2.9900760E-04,
        -3.6772175E-04, 1.8673432E-04, -2.0672781E-04, -2.8360140E-04,
        -1.6880875E-04, -2.0055012E-04, -1.5235673E-04, -3.1270509E-04,
        -2.0893691E-04, -2.0063351E-04, -7.5405565E-05, -3.4001633E-04,
        -3.1775850E-04, -4.6963475E-04, -3.2409298E-04, -4.8444880E-04,
        -7.6943790E-05, -2.4349977E-04, -1.6298298E-04, -1.9867347E-04,
        -9.6815034E-05, -6.0978742E-05, -2.3152115E-04, -4.1376648E-04,
        -1.0214599E-04, -2.3671484E-04, -4.1024803E-04, -4.7186823E-04,
        -3.1864044E-04, -2.2276987E-04, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000
    },
    {
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        -3.2107235E-04, 4.6065954E-05, -2.6629881E-05, -3.3467044E-05,
        8.9580295E-05, 8.0471154E-06, 6.9558599E-05, 5.5100008E-06,
        -3.6889254E-05, -2.7884503E-06, -2.3409413E-05, 4.1059284E-05,
        1.4703858E-05, 4.7176247E-05, -2.1226660E-05, 2.8148537E-05,
        -5.3379249E-06, 2.1912974E-05, 1.2145220E-05, 1.7560697E-05,
        -6.8327157E-05, -7.1510956E-05, 2.6310821E-05, -1.0590612E-05,
        3.0954936E-05, 3.6192429E-05, 5.8316382E-05, 1.8092072E-05,
        8.3686937E-05, -6.8597788E-06, 4.1190928E-05, -1.7080519E-06,
        4.2815424E-05, 5.4837401E-05, 3.2095457E-05, -3.6181693E-06,
        1.9064302E-05, 3.6908972E-05, -6.8217278E-06, 6.6461558E-05,
        8.9907604E-05, -7.9636902E-07, 5.6960063E-05, 8.8787543E-05,
        9.7431024E-05, 8.2615879E-05, 4.6434820E-05, 1.1947391E-04,
        1.1519158E-04, 1.2209169E-04, 1.6072670E-04, 7.2348848E-05,
        8.4019521E-05, 9.7020980E-05, 9.1232891E-05, 1.6010356E-04,
        1.3070961E-04, 2.0276915E-04, 1.8632189E-04, 1.6831003E-04,
        1.3107363E-04, 1.7320627E-04, 1.9137950E-04, 2.4298878E-04,
        2.4831088E-04, 2.9991454E-04, 3.4220479E-04, 3.9178701E-04,
        3.4825498E-04, 3.9900403E-04, 4.9615139E-04, 6.8857661E-04,
        1.0667475E-03, 1.7044684E-03, 2.8247845E-03, 4.9565015E-03,
        7.1704369E-03, 9.2264311E-03, 1.0928052E-02, 1.1268413E-02,
        1.0194673E-02, 8.9544179E-03, 7.2780224E-03, 6.1696898E-03,
        5.1716054E-03, 4.1428828E-03, 3.3720408E-03, 2.8573687E-03,
        2.3929353E-03, 2.0476365E-03, 1.8009425E-03, 1.7151105E-03,
        1.6545109E-03, 1.7413242E-03, 1.9840098E-03, 2.5006123E-03,
        4.9075764E-03, 1.1443740E-02, 4.2885099E-02, 0.1590595, 0.3773241,
        0.6848287, 0.9493395, 0.9993991, 0.9901925, 0.9966571, 0.9658914,
        0.9519714, 0.9565546, 0.8786293, 0.6565691, 0.4414657, 0.2934012,
        0.1588407, 4.6538245E-02, 9.9417595E-03, 4.9098604E-03, 4.0283226E-03,
        3.5565449E-03, 3.0151808E-03, 2.4176822E-03, 1.9686033E-03,
        1.6071247E-03, 1.4445251E-03, 1.2861951E-03, 9.8408223E-04,
        9.5293223E-04, 7.0823944E-04, 7.0939364E-04, 7.2391354E-04,
        7.4606301E-04, 8.0536737E-04, 8.4605248E-04, 8.2957384E-04,
        6.0513080E-04, 5.0495769E-04, 4.1521873E-04, 4.2553002E-04,
        3.0449766E-04, 3.3256790E-04, 4.1149688E-04, 3.4257831E-04,
        2.6376065E-04, 2.1599304E-04, 1.4929264E-04, 9.7798096E-05,
        2.7557520E-05, 1.2620793E-04, 6.4860862E-05, 2.0903046E-04,
        1.2498361E-04, 7.4317635E-05, 6.5568129E-05, 5.5496781E-05,
        1.9443057E-04, 1.2280187E-04, 2.1471251E-05, 1.1653985E-04,
        4.9323731E-05, 1.4090868E-04, -4.4933342E-05, -5.1999556E-05,
        -3.6965059E-05, 7.7401237E-06, 1.3530042E-05, 7.6197175E-05,
        5.5949735E-05, 7.7809982E-06, 3.3610926E-05, -2.5578227E-05,
        -8.6103806E-05, -1.4661687E-05, 4.7357644E-06, -1.4705853E-05,
        3.6229914E-05, -6.5285640E-05, 6.1893115E-05, 3.3841654E-05,
        -3.3995570E-05, -4.7671536E-05, -2.1672018E-05, 1.1741660E-04,
        2.9699142E-06, -5.4969361E-05, -1.3504388E-05, -3.1720912E-05,
        -3.6630270E-05, -8.0940372E-05, -4.8366455E-05, -4.4623317E-05,
        -1.5982076E-05, -5.5214372E-05, -6.0533832E-05, -1.0294130E-04,
        -2.8299350E-05, -1.1760571E-04, 4.7569083E-05, -1.3445375E-05,
        -2.4321431E-05, -2.2966036E-05, 1.8142573E-05, 3.7843802E-05,
        -2.4572868E-05, -8.3573403E-05, 1.9617289E-06, -3.5863628E-05,
        -8.3349849E-05, -7.4229516E-05, -5.5907414E-05, -1.2578599E-06, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000
    },
    {
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        -1.8819088E-04, 5.9819668E-05, 8.6507462E-06, -6.6798825E-06,
        7.6418626E-05, 1.4353109E-05, 7.5696786E-05, 3.3591634E-05,
        -6.7604133E-06, 2.6802561E-05, 1.1362484E-05, 5.9970171E-05,
        1.7587136E-05, 2.9993671E-05, -1.2433133E-05, 3.1958254E-05,
        -6.6475159E-06, 4.2731455E-05, 4.7507143E-05, 3.5380621E-05,
        -1.0903559E-05, 3.6580350E-06, 5.1609048E-05, 2.3900537E-05,
        5.5289787E-05, 5.3486252E-05, 7.2056086E-05, 3.6787056E-05,
        1.1365362E-04, 3.6965943E-05, 8.9755224E-05, 2.6356778E-05,
        9.9356141E-05, 8.3560401E-05, 5.5157536E-05, 4.7795176E-05,
        9.5084921E-05, 7.8702193E-05, 1.0363780E-04, 1.2406023E-04,
        1.4933140E-04, 9.9781486E-05, 1.6562626E-04, 1.6341887E-04,
        1.8230487E-04, 1.6103001E-04, 1.2674548E-04, 1.8666359E-04,
        2.0404372E-04, 1.9673986E-04, 2.5412437E-04, 1.9286506E-04,
        1.8800881E-04, 2.1491919E-04, 1.9298230E-04, 2.7765331E-04,
        2.2783245E-04, 2.9739254E-04, 2.6976803E-04, 2.5972931E-04,
        2.2048369E-04, 2.4333662E-04, 2.4218063E-04, 2.8689828E-04,
        2.8396692E-04, 3.1365792E-04, 3.7361615E-04, 4.2970380E-04,
        4.6273437E-04, 5.5042550E-04, 7.2532392E-04, 1.0579396E-03,
        1.6997184E-03, 2.9906298E-03, 5.8374978E-03, 1.2872973E-02,
        2.4903886E-02, 4.6361703E-02, 8.8574313E-02, 0.1519925, 0.2331196,
        0.3517703, 0.4628852, 0.6124794, 0.7433454, 0.8390652, 0.8752457,
        0.8936772, 0.8771752, 0.8926103, 0.9316412, 1.000000, 0.9692807,
        0.9246415, 0.8073642, 0.6588188, 0.5060554, 0.3425836, 0.2012957,
        8.6962819E-02, 2.4828117E-02, 7.5675827E-03, 4.4814027E-03,
        2.8946868E-03, 1.9353306E-03, 1.4630328E-03, 1.0858242E-03,
        8.1516267E-04, 8.1469031E-04, 6.2620227E-04, 5.4824539E-04,
        3.9630619E-04, 3.1806948E-04, 3.1660625E-04, 2.1157876E-04,
        1.7404146E-04, 2.0480197E-04, 1.8842172E-04, 2.1997139E-04,
        1.8177080E-04, 1.8670780E-04, 1.5284002E-04, 1.2944288E-04,
        1.7148946E-04, 2.7134284E-04, 1.9492944E-04, 2.9092337E-04,
        1.1056810E-04, 1.6621510E-04, 1.5578514E-04, 1.2368207E-04,
        1.2733438E-04, 1.1667961E-04, 8.4793151E-05, -1.0376571E-06,
        1.4398598E-05, -3.7098092E-05, 8.5780157E-05, 2.8646604E-05,
        1.2183939E-04, 1.8073022E-04, 2.2431283E-04, 2.5531347E-04,
        3.1356711E-04, 3.4146660E-04, 3.5022173E-04, 3.8858660E-04,
        7.2828098E-04, 9.5058460E-04, 1.5267507E-03, 2.1246579E-03,
        2.3551865E-03, 2.2587983E-03, 2.1546897E-03, 1.9030331E-03,
        1.9702727E-03, 1.8917738E-03, 1.8183842E-03, 1.3188934E-03,
        1.2057900E-03, 7.4187794E-04, 4.4727765E-04, 2.5479673E-04,
        1.2539627E-04, 2.3654951E-05, -3.6108362E-05, 4.1196156E-05,
        3.2947148E-05, 3.2257289E-05, -1.5749540E-05, -7.0530412E-05,
        -1.0350982E-05, -3.3443166E-06, 2.2379063E-06, 6.0468032E-05,
        -3.4003755E-05, 4.8555416E-05, 1.8296641E-05, 1.6044325E-05,
        -4.9977339E-06, -3.2215608E-05, 7.0264658E-05, 5.4403217E-06,
        -5.7883812E-05, 2.2786793E-05, 7.6668102E-06, 1.1829807E-05,
        -4.2542728E-05, -1.6310720E-05, -3.5310026E-05, -1.3429714E-05,
        -5.0266015E-05, -4.6398800E-05, -1.2699865E-04, -2.6550726E-05,
        -1.7353594E-04, 1.9257257E-05, -1.5565725E-05, -1.2637637E-05,
        -9.2405180E-06, 2.1336323E-06, -2.9445862E-06, -1.7829912E-05,
        -7.7434284E-05, 1.4523114E-05, -3.5373068E-05, -5.3970693E-05,
        -4.7709098E-05, -2.1409969E-05, 1.1017060E-05, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 
        0.000000, 0.000000
    }
};

/** Reference spectral dispersion for JHK mode. */
/* The first and last values of this table which do not belong to [1000 -
 * 3500] are not significant. They have been added to suppress discontinuity
 * disturbing the FFT used to compute wavelenght table offset. */
static amdlibDOUBLE amdlibRefLowJHKSpectralDispersion[amdlibNB_SPECTRAL_CHANNELS] =
{
/* new law could be */
/*     8302.704, 8278.158, 8253.612, 8229.099, 8204.520, 8179.974, 8155.428, */
/*     8130.882, 8106.336, 8081.79, 8057.244, 8032.698, 8008.152, 7983.606, */
/*     7959.06, 7934.514, 7909.968, 7885.422, 7860.876, 7836.33, 7811.784, */
/*     7787.238, 7762.692, 7738.146, 7713.60, 7689.054, 7664.508, 7639.962, */
/*     7615.416, 7590.87, 7566.324, 7541.778, 7517.232, 7492.686, 7468.14, */
/*     7443.594, 7419.048, 7394.502, 7369.956, 7345.41, 7320.864, 7296.318, */
/*     7271.772, 7247.226, 7222.68, 7198.134, 7173.588, 7149.042, 7124.496, */
/*     7099.95, 7075.404, 7050.858, 7026.312, 7001.766, 6977.22, 6952.674, */
/*     6928.128, 6903.582, 6879.036, 6854.49, 6829.944, 6805.398, 6780.852, */
/*     6756.306, 6731.76, 6707.214, 6682.668, 6658.122, 6633.576, 6609.03, */
/*     6584.484, 6559.938, 6535.392, 6510.846, 6486.30, 6461.754, 6437.208, */
/*     6412.662, 6388.116, 6363.57, 6339.024, 6314.478, 6289.932, 6265.386, */
/*     6240.84, 6216.294, 6191.748, 6167.202, 6142.656, 6118.11, 6093.564, */
/*     6069.018, 6044.472, 6019.926, 5995.38, 5970.834, 5946.288, 5921.742, */
/*     5897.196, 5872.65, 5848.104, 5823.558, 5799.012, 5774.466, 5749.92, */
/*     5725.374, 5700.828, 5676.282, 5651.736, 5627.19, 5602.644, 5578.098, */
/*     5553.552, 5529.006, 5504.46, 5479.914, 5455.368, 5430.822, 5406.276, */
/*     5381.73, 5357.184, 5332.638, 5308.092, 5283.546, 5259.00, 5234.454, */
/*     5209.908, 5185.362, 5160.816, 5136.27, 5111.724, 5087.178, 5062.632, */
/*     5038.086, 5013.54, 4988.994, 4964.448, 4939.902, 4915.356, 4890.81, */
/*     4866.264, 4841.718, 4817.172, 4792.626, 4768.08, 4743.534, 4718.988, */
/*     4694.442, 4669.896, 4645.35, 4620.804, 4596.258, 4571.712, 4547.166, */
/*     4522.62, 4498.074, 4473.528, 4448.982, 4424.436, 4399.89, 4375.344, */
/*     4350.798, 4326.252, 4301.706, 4277.16, 4252.614, 4228.068, 4203.522, */
/*     4178.976, 4154.43, 4129.884, 4105.338, 4080.792, 4056.246, 4031.70, */
/*     4007.154, 3982.608, 3958.062, 3933.516, 3908.970, 3884.424, 3859.878, */
/*     3835.332, 3810.786, 3786.240, 3761.694, 3737.148, 3712.602, 3688.056, */
/*     3663.510, 3638.964, 3614.418, 3589.872, 3565.326, 3540.780, 3516.234, */
/*     3491.688, 3467.142, 3442.596, 3418.050, 3393.504, 3368.958, 3344.412, */
/*     3319.866, 3295.32, 3270.774, 3246.228, 3221.682, 3197.136, 3148.044, */
/*     3123.498, 3098.952, 3073.797, 3048.053, 3021.742, 2994.886, 2967.508, */
/*     2939.627, 2911.267, 2882.448, 2853.193, 2823.523, 2793.460, 2763.025, */
/*     2732.240, 2701.128, 2669.708, 2638.004, 2733.059, 2698.242, 2663.421, */
/*     2628.599, 2593.778, 2558.957, 2524.136, 2489.315, 2454.494, 2419.673, */
/*     2384.852, 2350.031, 2315.210, 2280.389, 2245.568, 2210.747, 2175.926, */
/*     2141.105, 2106.284, 2071.463, 2036.642, 2001.821, 1967.000, 1932.178, */
/*     1897.357, 1922.179, 1889.707, 1857.235, 1824.763, 1792.291, 1759.819, */
/*     1727.347, 1694.875, 1662.403, 1629.931, 1597.459, 1564.987, 1532.514, */
/*     1500.042, 1467.569, 1376.652, 1356.504, 1336.355, 1316.207, 1296.058, */
/*     1275.910, 1255.761, 1235.613, 1215.464, 1195.316, 1175.167, 1155.019, */
/*     1134.870, 1114.722, 1094.599, 1074.452, 1054.303, 1034.155, 1014.008, */
/*     993.8599, 973.7119, 953.5639, 953.046, 952.957, 952.8680, 952.7790, */
/*     952.690, 951.6010, 951.5120, 951.4230, 945.3340, 937.245, 929.1560, */
/*     921.0670, 912.9780, 904.8890, 896.800, 888.7110, 880.6220, 872.5330, */
/*     864.4440, 856.355, 848.2660, 840.1770, 832.0880, 823.9990, 815.910, */
/*     807.8210, 799.7320, 791.6430, 783.5540, 775.465, 767.3760, 759.2870, */
/*     751.1980, 743.1090, 735.020, 726.9310, 718.8420, 710.7530, 702.6640, */
/*     694.575, 686.4860, 678.3970, 670.3080, 662.2190, 654.130, 646.0410, */
/*     637.9520, 629.8630, 621.7740, 613.685, 605.5960, 597.5070, 589.4180, */
/*     581.3290, 573.240, 565.1510, 557.0620, 548.9730, 540.8840, 532.795, */
/*     524.7060, 516.6170, 508.5280, 500.4390, 492.350, 484.2610, 476.1720, */
/*     468.0830, 459.9940, 451.905, 443.8160, 435.7270, 427.6380, 419.5490, */
/*     411.460, 403.3710, 395.2820, 387.1930, 379.1040, 371.015, 362.9260, */
/*     354.8370, 346.7480, 338.6590, 330.570, 322.4810, 314.3920, 306.3030, */
/*     298.2140, 290.125, 282.0360, 273.9470, 265.8580, 257.7690, 249.680, */
/*     241.5910, 233.5020, 225.4130, 217.3240, 209.235, 201.1460, 193.0570, */
/*     184.9680, 176.8790, 168.790, 160.7010, 152.6120, 144.5230, 136.4340, */
/*     128.345, 120.2560, 112.1670, 104.0780, 95.98900, 87.9000, 79.81100, */
/*     71.72200, 63.63300, 55.54400, 47.4550, 39.36600, 31.27700, 23.18800, */
/*     15.09900, 7.01000, -1.07900, -9.16800, -17.2570, -25.3460, -33.435, */
/*     -41.5240, -49.6130, -57.7020, -65.7910, -73.880, -81.9690, -90.0580, */
/*     -98.1470, -106.236, -114.32, -122.414, -130.503, -138.592, -146.681, */
/*     -154.77, -162.859, -170.948, -179.037, -187.126, -195.21, -203.304, */
/*     -211.393, -219.482, -227.571, -235.66, -243.749, -251.838, -259.927, */
/*     -268.016, -276.10, -284.194, -292.283, -300.372, -308.461, -316.55, */
/*     -324.639, -332.728, -340.817, -348.906, -356.99, -365.084, -373.173, */
/*     -381.262, -389.351, -397.44, -405.529, -413.618, -421.707, -429.796, */
/*     -437.88, -445.974, -454.063, -462.152, -470.241, -478.33, -486.419, */
/*     -494.508, -502.597, -510.686, -518.77, -526.864, -534.953, -543.042, */
/*     -551.131, -559.22, -567.309, -575.398, -583.487, -591.576, -599.66, */
/*     -607.754, -615.843, -623.932, -632.021, -640.11, -648.199, -656.288, */
/*     -664.377, -672.466, -680.55, -688.644, -696.733, -704.822, -712.911, */
/*     -721.00, -729.089, -737.178, -745.267, -753.356, -761.44, -769.534, */
/*     -777.623 */

    8302.704, 8278.158, 8253.612, 8229.099, 8204.520,
    8179.974, 8155.428, 8130.882, 8106.336, 8081.790,
    8057.244, 8032.698, 8008.152, 7983.606, 7959.060,
    7934.514, 7909.968, 7885.422, 7860.876, 7836.330,
    7811.784, 7787.238, 7762.692, 7738.146, 7713.600,
    7689.054, 7664.508, 7639.962, 7615.416, 7590.870,
    7566.324, 7541.778, 7517.232, 7492.686, 7468.140,
    7443.594, 7419.048, 7394.502, 7369.956, 7345.410,
    7320.864, 7296.318, 7271.772, 7247.226, 7222.680,
    7198.134, 7173.588, 7149.042, 7124.496, 7099.950,
    7075.404, 7050.858, 7026.312, 7001.766, 6977.220,
    6952.674, 6928.128, 6903.582, 6879.036, 6854.490,
    6829.944, 6805.398, 6780.852, 6756.306, 6731.760,
    6707.214, 6682.668, 6658.122, 6633.576, 6609.030,
    6584.484, 6559.938, 6535.392, 6510.846, 6486.300,
    6461.754, 6437.208, 6412.662, 6388.116, 6363.570,
    6339.024, 6314.478, 6289.932, 6265.386, 6240.840,
    6216.294, 6191.748, 6167.202, 6142.656, 6118.110,
    6093.564, 6069.018, 6044.472, 6019.926, 5995.380,
    5970.834, 5946.288, 5921.742, 5897.196, 5872.650,
    5848.104, 5823.558, 5799.012, 5774.466, 5749.920,
    5725.374, 5700.828, 5676.282, 5651.736, 5627.190,
    5602.644, 5578.098, 5553.552, 5529.006, 5504.460,
    5479.914, 5455.368, 5430.822, 5406.276, 5381.730,
    5357.184, 5332.638, 5308.092, 5283.546, 5259.000,
    5234.454, 5209.908, 5185.362, 5160.816, 5136.270,
    5111.724, 5087.178, 5062.632, 5038.086, 5013.540,
    4988.994, 4964.448, 4939.902, 4915.356, 4890.810,
    4866.264, 4841.718, 4817.172, 4792.626, 4768.080,
    4743.534, 4718.988, 4694.442, 4669.896, 4645.350,
    4620.804, 4596.258, 4571.712, 4547.166, 4522.620,
    4498.074, 4473.528, 4448.982, 4424.436, 4399.890,
    4375.344, 4350.798, 4326.252, 4301.706, 4277.160,
    4252.614, 4228.068, 4203.522, 4178.976, 4154.430,
    4129.884, 4105.338, 4080.792, 4056.246, 4031.700,
    4007.154, 3982.608, 3958.062, 3933.516, 3908.970,
    3884.424, 3859.878, 3835.332, 3810.786, 3786.240,
    3761.694, 3737.148, 3712.602, 3688.056, 3663.510,
    3638.964, 3614.418, 3589.872, 3565.326, 3540.780,
    3516.234, 3491.688, 3467.142, 3442.596, 3418.050,
    3393.504, 3368.958, 3344.412, 3319.866, 3295.32,
    3270.774, 3246.228, 3221.682, 3197.136, 3148.044,
    3123.498, 3098.952, 3073.797, 3048.053, 3021.742,
    2994.886, 2967.508, 2939.627, 2911.267, 2882.448,
    2853.193, 2823.523, 2793.460, 2763.025, 2732.240,
    2701.128, 2669.708, 2638.004, 2606.037, 2573.828,
    2541.400, 2508.773, 2475.970, 2443.012, 2409.922,
    2376.719, 2343.427, 2310.067, 2276.661, 2243.229,
    2209.795, 2176.379, 2143.004, 2109.691, 2076.461,
    2043.337, 2010.339, 1977.491, 1944.813, 1912.327,
    1880.054, 1848.017, 1816.237, 1784.736, 1753.535,
    1722.656, 1692.121, 1661.952, 1632.169, 1602.796,
    1573.853, 1545.362, 1517.344, 1489.823, 1462.818,
    1436.353, 1410.448, 1385.125, 1360.406, 1336.313,
    1312.867, 1290.089, 1268.003, 1246.628, 1225.988,
    1206.103, 1186.995, 1168.687, 1151.199, 1134.553,
    1118.772, 1103.876, 1089.887, 1076.828, 1064.719,
    1053.582, 1043.440, 1034.313, 1026.224, 1018.135,
    1010.046, 1001.957, 993.8680, 985.7790, 977.6900,
    969.6010, 961.5120, 953.4230, 945.3340, 937.2450,
    929.1560, 921.0670, 912.9780, 904.8890, 896.8000,
    888.7110, 880.6220, 872.5330, 864.4440, 856.3550,
    848.2660, 840.1770, 832.0880, 823.9990, 815.9100,
    807.8210, 799.7320, 791.6430, 783.5540, 775.4650,
    767.3760, 759.2870, 751.1980, 743.1090, 735.0200,
    726.9310, 718.8420, 710.7530, 702.6640, 694.5750,
    686.4860, 678.3970, 670.3080, 662.2190, 654.1300,
    646.0410, 637.9520, 629.8630, 621.7740, 613.6850,
    605.5960, 597.5070, 589.4180, 581.3290, 573.2400,
    565.1510, 557.0620, 548.9730, 540.8840, 532.7950,
    524.7060, 516.6170, 508.5280, 500.4390, 492.3500,
    484.2610, 476.1720, 468.0830, 459.9940, 451.9050,
    443.8160, 435.7270, 427.6380, 419.5490, 411.4600,
    403.3710, 395.2820, 387.1930, 379.1040, 371.0150,
    362.9260, 354.8370, 346.7480, 338.6590, 330.5700,
    322.4810, 314.3920, 306.3030, 298.2140, 290.1250,
    282.0360, 273.9470, 265.8580, 257.7690, 249.6800,
    241.5910, 233.5020, 225.4130, 217.3240, 209.2350,
    201.1460, 193.0570, 184.9680, 176.8790, 168.7900,
    160.7010, 152.6120, 144.5230, 136.4340, 128.3450,
    120.2560, 112.1670, 104.0780, 95.98900, 87.90000,
    79.81100, 71.72200, 63.63300, 55.54400, 47.45500,
    39.36600, 31.27700, 23.18800, 15.09900, 7.010000,
    -1.07900, -9.16800, -17.2570, -25.3460, -33.4350,
    -41.5240, -49.6130, -57.7020, -65.7910, -73.8800,
    -81.9690, -90.0580, -98.1470, -106.236, -114.325,
    -122.414, -130.503, -138.592, -146.681, -154.770,
    -162.859, -170.948, -179.037, -187.126, -195.215,
    -203.304, -211.393, -219.482, -227.571, -235.660,
    -243.749, -251.838, -259.927, -268.016, -276.105,
    -284.194, -292.283, -300.372, -308.461, -316.550,
    -324.639, -332.728, -340.817, -348.906, -356.995,
    -365.084, -373.173, -381.262, -389.351, -397.440,
    -405.529, -413.618, -421.707, -429.796, -437.885,
    -445.974, -454.063, -462.152, -470.241, -478.330,
    -486.419, -494.508, -502.597, -510.686, -518.775,
    -526.864, -534.953, -543.042, -551.131, -559.220,
    -567.309, -575.398, -583.487, -591.576, -599.665,
    -607.754, -615.843, -623.932, -632.021, -640.110,
    -648.199, -656.288, -664.377, -672.466, -680.555,
    -688.644, -696.733, -704.822, -712.911, -721.000,
    -729.089, -737.178, -745.267, -753.356, -761.445,
    -769.534, -777.623
};

/**
 * Get the reference spectrum for low JHK spectral calibration 
 *
 * @param bandState state of the shutters for each band; 0 shutters are closed
 * and 1 shutters are open.
 * @param refSpec array where reference spectrum will be stored.
 *
 * @return
 * amdlibSUCCESS on successful completion. Otherwise amdlibFAILURE is returned.
 */
amdlibCOMPL_STAT amdlibGetRefLowJHKSpectrumForCal
    (int bandState[amdlibNB_BANDS], 
     amdlibDOUBLE refSpec[amdlibNB_SPECTRAL_CHANNELS])
{
    int l, band;
    amdlibLogTrace("amdlibGetRefSpectrumForLowJHKCal()");

    /* Reset reference spectrum */
    for (l = 0; l < amdlibNB_SPECTRAL_CHANNELS; l++)   
    {
        refSpec[l] = 0.0;
    }

    /* Set reference spectrum by summing J, H and K spectrum according to status
     * of band shutters */
    for (band = amdlibJ_BAND; band <= amdlibK_BAND; band++)
    {
        if (bandState[band] == 1) 
        {
            for (l = 0; l < amdlibNB_SPECTRAL_CHANNELS; l++)  
            {
                refSpec[l] += amdlibRefLowJHKSpectrumForCal[band][l];
            }
        }
    }

    return amdlibSUCCESS;
}

/**
 * Get the reference spectral dispersion table for low JHK mode 
 *
 * @param specTable table where spectral dispersion will be stored.
 *
 * @return
 * amdlibSUCCESS on successful completion. Otherwise amdlibFAILURE is returned.
 */
amdlibCOMPL_STAT amdlibGetRefLowJHKSpectralDispersion
    (amdlibDOUBLE specTable[amdlibNB_SPECTRAL_CHANNELS])
{
    int l;
    amdlibLogTrace("amdlibGetRefJHKSpectralDispersion()");

    /* Copy reference spectral dispersion table */
    for (l = 0; l < amdlibNB_SPECTRAL_CHANNELS; l++)   
    {
        specTable[l] = amdlibRefLowJHKSpectralDispersion[l];
    }

    return amdlibSUCCESS;
}
/*___oOo__*/
