/* This file is -*-C++-*-
------------------------------------------------------------------------------
denef - Decode NEF image files
Copyright (C) 2000 Daniel Stephens (daniel@cheeseplant.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
------------------------------------------------------------------------------

$Id: options.h,v 1.2 2000/12/10 22:11:00 daniel Exp $

*/

#ifndef OPTIONS_H_INCLUDED
#define OPTIONS_H_INCLUDED

#include <vector>

struct options {
public:
    class optionInterface {
    private:
	const char *long_name;
	char short_name;
	bool takes_args;
	bool requires_argument;
    public:
	optionInterface(const char *n, char sn, bool ta=false, bool ar=true)
	    : long_name(n), short_name(sn), 
	      takes_args(ta), requires_argument(ar)
	{};
	virtual ~optionInterface();

	const char *Long_Name()         const {return long_name;}
	char        Short_Name()        const {return short_name;}
	bool        Takes_Argument()    const {return takes_args;}
	bool        Requires_Argument() const {return requires_argument;}

	virtual bool Process(const char *) const {return true;} ;
    };

    class boolSetOption : public optionInterface {
    private:
	bool &b;
    public:
	boolSetOption(const char *l, char s, bool &bv) 
	    : optionInterface(l,s,false,false), b(bv) {};
	
	virtual bool Process(const char *) const;
    };

    class boolClearOption : public optionInterface {
    private:
	bool &b;
    public:	
	boolClearOption(const char *l, char s, bool &bv) 
	    : optionInterface(l,s,false,false), b(bv) {};

	virtual bool Process(const char *) const; 
    };

    class boolOption : public optionInterface {
    private:
	bool &b;
	bool defval;
    public:	
	boolOption(const char *l, char s, bool &bv, bool dv) 
	    : optionInterface(l,s,true,false), b(bv), defval(dv) {};

	boolOption(const char *l, char s, bool &bv) 
	    : optionInterface(l,s,true,true), b(bv) {};

	virtual bool Process(const char *) const; 
    };

    class intSetOption : public optionInterface {
    private:
	int &var;
	int val;
	
    public:
	intSetOption(const char *l, char s, int &vr, int vl) 
	    : optionInterface(l,s,false,false), var(vr), val(vl) {};

	virtual bool Process(const char *) const;
    };

    class stringOption : public optionInterface {
    private:
	const char *&var;
	
    public:
	stringOption(const char *l, char s, const char *&vr, bool req=true) 
	    : optionInterface(l,s,true,req), var(vr) {};

	virtual bool Process(const char *) const;
    };

    class intOption : public optionInterface {
    private:
	int &var;
	
    public:
	intOption(const char *l, char s, int &vr, bool req=true) 
	    : optionInterface(l,s,true,req), var(vr) {};

	virtual bool Process(const char *) const;
    };

    class doubleOption : public optionInterface {
    private:
	double &var;
	
    public:
	doubleOption(const char *l, char s, double &vr, bool req=true) 
	    : optionInterface(l,s,true,req), var(vr) {};

	virtual bool Process(const char *) const;
    };

    class actionOption : public optionInterface {
    public:
	actionOption(const char *l, char s) 
	    : optionInterface(l,s,false,false) {};
	~actionOption();

	virtual bool Process(const char *) const;
	virtual bool Action() const = 0;
    };

    static bool Process_Options(int &argc, 
				char **&argv, 
				const vector<optionInterface *> &opts,
				bool dash_delimits_files=true,
				bool allow_intermixed_files=true);
};

#endif /* OPTIONS_H_INCLUDED */
