/////////////////////////////////////////////////////////////////////////////
// Name:        TemplateDlg.h
// Purpose:     Select DVD menu template dialog
// Author:      Alex Thuering
// Created:     20.10.2009
// RCS-ID:      $Id: TemplateDlg.h,v 1.3 2011/09/11 18:51:43 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef TEMPLATE_DLG_H
#define TEMPLATE_DLG_H

#include "DVD.h"
#include "wxVillaLib/Thumbnails.h"
#include <wx/wx.h>
#include <wx/image.h>
#include <vector>

using namespace std;

// begin wxGlade: ::dependencies
#include <wx/statline.h>
// end wxGlade

// begin wxGlade: ::extracode

// end wxGlade


class TemplateDlg: public wxDialog {
public:
    // begin wxGlade: TemplateDlg::ids
    // end wxGlade
    TemplateDlg(wxWindow* parent, AspectRatio aspectRatio);
    wxString GetTemplate();
    wxString GetTitle();

protected:
    // begin wxGlade: TemplateDlg::attributes
    wxStaticText* m_categoryLabel;
    wxStaticText* m_titleLabel;
    wxTextCtrl* m_titleText;
    wxListBox* m_categoryListBox;
    wxThumbnails* m_thumbnails;
    wxStaticLine* m_staticLine;
    wxButton* m_okBt;
    wxButton* m_cancelBt;
    // end wxGlade
    
private:
    // begin wxGlade: TemplateDlg::methods
    void set_properties();
    void do_layout();
    // end wxGlade
    
    AspectRatio m_aspectRatio;
    wxArrayString m_dirs;
    void LoadThumbnails(wxString dir);
    void OnThumbDoubleClick(wxCommandEvent& event);
    virtual void OnCategorySelect(wxCommandEvent &event); // wxGlade: <event_handler>
    
private:
    DECLARE_EVENT_TABLE()
}; // wxGlade: end class


#endif // TEMPLATE_DLG_H
