#!/usr/bin/env python
# -*- encoding: utf-8


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment
        self.key_macro = [
            [1, "KEY_LEFTCTRL"],
            [1, "KEY_S"],
            [0.05, "SLEEP"],
            [0, "KEY_S"],
            [0, "KEY_LEFTCTRL"],
        ]

    def shutdown(self):
        pass

    def get_description(self):
        return "Save your work."

    def run(self):
        self.env["runtime"]["OutputManager"].present_text(
            "Okay, you will now be asked to save your work.", interrupt=True
        )
        if self.env["runtime"]["InputManager"].get_shortcut_type() in ["KEY"]:
            self.env["runtime"]["InputManager"].send_keys(self.key_macro)
        elif self.env["runtime"]["InputManager"].get_shortcut_type() in [
            "BYTE"
        ]:
            self.env["runtime"]["ByteManager"].send_bytes(self.byteMakro)

    def set_callback(self, callback):
        pass
