;; Scheduling description for PowerPC 603 processor.
;;   Copyright (C) 2003-2013 Free Software Foundation, Inc.
;;
;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

(define_automaton "ppc603,ppc603fp")
(define_cpu_unit "iu_603" "ppc603")
(define_cpu_unit "fpu_603" "ppc603fp")
(define_cpu_unit "lsu_603,bpu_603,sru_603" "ppc603")

;; PPC603/PPC603e 32-bit IU, LSU, FPU, BPU, SRU
;; Max issue 3 insns/clock cycle (includes 1 branch)

;; Branches go straight to the BPU.  All other insns are handled
;; by a dispatch unit which can issue a max of 2 insns per cycle.

;; The PPC603e user's manual recommends that to reduce branch mispredictions,
;; the insn that sets CR bits should be separated from the branch insn
;; that evaluates them; separation by more than 9 insns ensures that the CR
;; bits will be immediately available for execution.
;; This could be artificially achieved by exaggerating the latency of
;; compare insns but at the expense of a poorer schedule.

;; CR insns get executed in the SRU.  Not modelled.

(define_insn_reservation "ppc603-load" 2
  (and (eq_attr "type" "load,load_ext,load_ux,load_u,load_l")
       (eq_attr "cpu" "ppc603"))
  "lsu_603")

(define_insn_reservation "ppc603-store" 2
  (and (eq_attr "type" "store,store_ux,store_u,fpstore,fpstore_ux,fpstore_u")
       (eq_attr "cpu" "ppc603"))
  "lsu_603*2")

(define_insn_reservation "ppc603-fpload" 2
  (and (eq_attr "type" "fpload,fpload_ux,fpload_u")
       (eq_attr "cpu" "ppc603"))
  "lsu_603")

(define_insn_reservation "ppc603-storec" 8
  (and (eq_attr "type" "store_c")
       (eq_attr "cpu" "ppc603"))
  "lsu_603")

(define_insn_reservation "ppc603-integer" 1
  (and (eq_attr "type" "integer,insert_word,insert_dword,shift,trap,\
                        var_shift_rotate,cntlz,exts,isel")
       (eq_attr "cpu" "ppc603"))
  "iu_603")

(define_insn_reservation "ppc603-two" 1
  (and (eq_attr "type" "two")
       (eq_attr "cpu" "ppc603"))
  "iu_603,iu_603")

(define_insn_reservation "ppc603-three" 1
  (and (eq_attr "type" "three")
       (eq_attr "cpu" "ppc603"))
  "iu_603,iu_603,iu_603")

; This takes 2 or 3 cycles
(define_insn_reservation "ppc603-imul" 3
  (and (eq_attr "type" "imul,imul_compare")
       (eq_attr "cpu" "ppc603"))
  "iu_603*2")

(define_insn_reservation "ppc603-imul2" 2
  (and (eq_attr "type" "imul2,imul3")
       (eq_attr "cpu" "ppc603"))
  "iu_603*2")

(define_insn_reservation "ppc603-idiv" 37
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "ppc603"))
  "iu_603*37")

(define_insn_reservation "ppc603-compare" 3
  (and (eq_attr "type" "cmp,fast_compare,compare,delayed_compare,\
                        var_delayed_compare")
       (eq_attr "cpu" "ppc603"))
  "iu_603,nothing,bpu_603")

(define_insn_reservation "ppc603-fpcompare" 3
  (and (eq_attr "type" "fpcompare")
       (eq_attr "cpu" "ppc603"))
  "(fpu_603+iu_603*2),bpu_603")

(define_insn_reservation "ppc603-fp" 3
  (and (eq_attr "type" "fp")
       (eq_attr "cpu" "ppc603"))
  "fpu_603")

(define_insn_reservation "ppc603-dmul" 4
  (and (eq_attr "type" "dmul")
       (eq_attr "cpu" "ppc603"))
  "fpu_603*2")

; Divides are not pipelined
(define_insn_reservation "ppc603-sdiv" 18
  (and (eq_attr "type" "sdiv")
       (eq_attr "cpu" "ppc603"))
  "fpu_603*18")

(define_insn_reservation "ppc603-ddiv" 33
  (and (eq_attr "type" "ddiv")
       (eq_attr "cpu" "ppc603"))
  "fpu_603*33")

(define_insn_reservation "ppc603-crlogical" 2
  (and (eq_attr "type" "cr_logical,delayed_cr,mfcr,mtcr")
       (eq_attr "cpu" "ppc603"))
  "sru_603")

(define_insn_reservation "ppc603-mtjmpr" 4
  (and (eq_attr "type" "mtjmpr")
       (eq_attr "cpu" "ppc603"))
  "sru_603")

(define_insn_reservation "ppc603-mfjmpr" 2
  (and (eq_attr "type" "mfjmpr,isync,sync")
       (eq_attr "cpu" "ppc603"))
  "sru_603")

(define_insn_reservation "ppc603-jmpreg" 1
  (and (eq_attr "type" "jmpreg,branch")
       (eq_attr "cpu" "ppc603"))
  "bpu_603")

