extern "C" void abort ();

struct S { S (); S (long int, long int); ~S (); static int cnt1, cnt2, cnt3; long int s, t; };

int S::cnt1;
int S::cnt2;
int S::cnt3;

S::S ()
{
  #pragma omp atomic
  cnt1++;
}

S::S (long int x, long int y) : s (x), t (y)
{
  #pragma omp atomic update
  ++cnt2;
}

S::~S ()
{
  #pragma omp atomic
  cnt3 = cnt3 + 1;
  if (t < 3 || t > 9 || (t & 1) == 0)
    abort ();
}

void
bar (S *p, S *o)
{
  p->s = 1;
  if (o->t != 5)
    abort ();
  p->t = 9;
}

static inline void
baz (S *o, S *i)
{
  if (o->t != 5 || i->t != 9)
    abort ();
  o->s *= i->s;
}

#pragma omp declare reduction (+: S : omp_out.s += omp_in.s) initializer (omp_priv (0, 3))
#pragma omp declare reduction (*: S : baz (&omp_out, &omp_in)) initializer (bar (&omp_priv, &omp_orig))

S as[2] = { { 0, 7 }, { 0, 7 } };
S (&a)[2] = as;
S bs[7] = { { 9, 5 }, { 11, 5 }, { 1, 5 }, { 1, 5 }, { 1, 5 }, { 13, 5 }, { 15, 5 } };
S (&b)[7] = bs;
S es[3] = { { 5, 7 }, { 0, 7 }, { 5, 7 } };
S (&e)[3] = es;
S fs[5] = { { 6, 7 }, { 7, 7 }, { 0, 7 }, { 0, 7 }, { 9, 7 } };
S (&f)[5] = fs;
S gs[4] = { { 1, 7 }, { 0, 7 }, { 0, 7 }, { 2, 7 } };
S (&g)[4] = gs;
S hs[3] = { { 0, 7 }, { 1, 7 }, { 4, 7 } };
S (&h)[3] = hs;
S ks[4][2] = { { { 5, 7 }, { 6, 7 } }, { { 0, 7 }, { 0, 7 } }, { { 0, 7 }, { 0, 7 } }, { { 7, 7 }, { 8, 7 } } };
S (&k)[4][2] = ks;
S *ss;
S *&s = ss;
S (*ts)[2];
S (*&t)[2] = ts;

void
foo (int &n, S *&c, S *&d, S (&m)[3], S *&r, S (&o)[4], S *&p, S (&q)[4][2])
{
  int i;
  for (i = 0; i < 2; i++)
    #pragma omp task in_reduction (+: a, c[ :2]) in_reduction (*: b[2 * n:3 * n], d[0:2]) \
		     in_reduction (+: o[n:n*2], m[1], k[1:2][ : ], p[0], f[2:2]) \
		     in_reduction (+: q[1:2][ : ], g[n:n*2], e[1], h[0], r[2:2]) \
		     in_reduction (*: s[1:2], t[2:2][ : ])
    {
      a[0].s += 7;
      a[1].s += 17;
      b[2].s *= 2;
      b[4].s *= 2;
      c[0].s += 6;
      d[1].s *= 2;
      e[1].s += 19;
      f[2].s += 21;
      f[3].s += 23;
      g[1].s += 25;
      g[2].s += 27;
      h[0].s += 29;
      k[1][0].s += 31;
      k[2][1].s += 33;
      m[1].s += 19;
      r[2].s += 21;
      r[3].s += 23;
      o[1].s += 25;
      o[2].s += 27;
      p[0].s += 29;
      q[1][0].s += 31;
      q[2][1].s += 33;
      s[1].s *= 2;
      t[2][0].s *= 2;
      t[3][1].s *= 2;
      if ((e[1].t != 7 && e[1].t != 3) || (h[0].t != 7 && h[0].t != 3)
	  || (m[1].t != 7 && m[1].t != 3) || (p[0].t != 7 && p[0].t != 3))
	abort ();
      for (int z = 0; z < 2; z++)
	if ((a[z].t != 7 && a[z].t != 3) || (c[z].t != 7 && c[z].t != 3)
	    || (d[z].t != 5 && d[z].t != 9) || (f[z + 2].t != 7 && f[z + 2].t != 3)
	    || (g[z + 1].t != 7 && g[z + 1].t != 3) || (r[z + 2].t != 7 && r[z + 2].t != 3)
	    || (s[z + 1].t != 5 && s[z + 1].t != 9) || (o[z + 1].t != 7 && o[z + 1].t != 3)
	    || (k[z + 1][0].t != 7 && k[z + 1][0].t != 3) || (k[z + 1][1].t != 7 && k[z + 1][1].t != 3)
	    || (q[z + 1][0].t != 7 && q[z + 1][0].t != 3) || (q[z + 1][1].t != 7 && q[z + 1][1].t != 3)
	    || (t[z + 2][0].t != 5 && t[z + 2][0].t != 9) || (t[z + 2][1].t != 5 && t[z + 2][1].t != 9))
	  abort ();
      for (int z = 0; z < 3; z++)
	if (b[z + 2].t != 5 && b[z + 2].t != 9)
	  abort ();
    }
}

void
test (int &n)
{
  S cs[2] = { { 0, 7 }, { 0, 7 } };
  S (&c)[2] = cs;
  S ps[3] = { { 0, 7 }, { 1, 7 }, { 4, 7 } };
  S (&p)[3] = ps;
  S qs[4][2] = { { { 5, 7 }, { 6, 7 } }, { { 0, 7 }, { 0, 7 } }, { { 0, 7 }, { 0, 7 } }, { { 7, 7 }, { 8, 7 } } };
  S (&q)[4][2] = qs;
  S sb[4] = { { 5, 5 }, { 1, 5 }, { 1, 5 }, { 6, 5 } };
  S tb[5][2] = { { { 9, 5 }, { 10, 5 } }, { { 11, 5 }, { 12, 5 } }, { { 1, 5 }, { 1, 5 } }, { { 1, 5 }, { 1, 5 } }, { { 13, 5 }, { 14, 5 } } };
  S ms[3] = { { 5, 7 }, { 0, 7 }, { 5, 7 } };
  S os[4] = { { 1, 7 }, { 0, 7 }, { 0, 7 }, { 2, 7 } };
  s = sb;
  t = tb;
  #pragma omp parallel
  #pragma omp single
  {
    S ds[] = { { 1, 5 }, { 1, 5 } };
    S (&d)[2] = ds;
    S (&m)[3] = ms;
    S rs[5] = { { 6, 7 }, { 7, 7 }, { 0, 7 }, { 0, 7 }, { 9, 7 } };
    S (&r)[5] = rs;
    S (&o)[4] = os;
    #pragma omp taskgroup task_reduction (+: a, c) task_reduction (*: b[2 * n:3 * n], d) \
			  task_reduction (+: e[1], f[2:2], g[n:n*2], h[0], k[1:2][0:2]) \
			  task_reduction (+: o[n:n*2], m[1], q[1:2][ : ], p[0], r[2:2]) \
			  task_reduction (*: t[2:2][ : ], s[1:n + 1])
    {
      int i;
      for (i = 0; i < 4; i++)
	#pragma omp task in_reduction (+: a, c) in_reduction (*: b[2 * n:3 * n], d) \
			 in_reduction (+: o[n:n*2], q[1:2][ : ], p[0], m[1], r[2:2]) \
			 in_reduction (+: g[n:n * 2], e[1], k[1:2][ : ], h[0], f[2:2]) \
			 in_reduction (*: s[1:2], t[2:2][ : ])
	{
	  int j;
	  a[0].s += 2;
	  a[1].s += 3;
	  b[2].s *= 2;
	  f[3].s += 8;
	  g[1].s += 9;
	  g[2].s += 10;
	  h[0].s += 11;
	  k[1][1].s += 13;
	  k[2][1].s += 15;
	  m[1].s += 16;
	  r[2].s += 8;
	  s[1].s *= 2;
	  t[2][1].s *= 2;
	  t[3][1].s *= 2;
	  if ((e[1].t != 7 && e[1].t != 3) || (h[0].t != 7 && h[0].t != 3)
	      || (m[1].t != 7 && m[1].t != 3) || (p[0].t != 7 && p[0].t != 3))
	    abort ();
	  for (int z = 0; z < 2; z++)
	    if ((a[z].t != 7 && a[z].t != 3) || (c[z].t != 7 && c[z].t != 3)
		|| (d[z].t != 5 && d[z].t != 9) || (f[z + 2].t != 7 && f[z + 2].t != 3)
		|| (g[z + 1].t != 7 && g[z + 1].t != 3) || (r[z + 2].t != 7 && r[z + 2].t != 3)
		|| (s[z + 1].t != 5 && s[z + 1].t != 9) || (o[z + 1].t != 7 && o[z + 1].t != 3)
		|| (k[z + 1][0].t != 7 && k[z + 1][0].t != 3) || (k[z + 1][1].t != 7 && k[z + 1][1].t != 3)
		|| (q[z + 1][0].t != 7 && q[z + 1][0].t != 3) || (q[z + 1][1].t != 7 && q[z + 1][1].t != 3)
		|| (t[z + 2][0].t != 5 && t[z + 2][0].t != 9) || (t[z + 2][1].t != 5 && t[z + 2][1].t != 9))
	      abort ();
	  for (int z = 0; z < 3; z++)
	    if (b[z + 2].t != 5 && b[z + 2].t != 9)
	      abort ();
	  for (j = 0; j < 2; j++)
	    #pragma omp task in_reduction (+: a, c[ :2]) \
			     in_reduction (*: b[2 * n:3 * n], d[n - 1:n + 1]) \
			     in_reduction (+: e[1], f[2:2], g[n:n*2], h[0], k[1:2][ :2]) \
			     in_reduction (+: m[1], r[2:2], o[n:n*2], p[0], q[1:2][ :2]) \
			     in_reduction (*: s[n:2], t[2:2][ : ])
	    {
	      m[1].s += 6;
	      r[2].s += 7;
	      q[1][0].s += 17;
	      q[2][0].s += 19;
	      a[0].s += 4;
	      a[1].s += 5;
	      b[3].s *= 2;
	      b[4].s *= 2;
	      f[3].s += 18;
	      g[1].s += 29;
	      g[2].s += 18;
	      h[0].s += 19;
	      s[2].s *= 2;
	      t[2][0].s *= 2;
	      t[3][0].s *= 2;
	      S *cp = c;
	      S *dp = d;
	      S *rp = r;
	      S *pp = p;
	      if ((e[1].t != 7 && e[1].t != 3) || (h[0].t != 7 && h[0].t != 3)
		  || (m[1].t != 7 && m[1].t != 3) || (p[0].t != 7 && p[0].t != 3))
		abort ();
	      for (int z = 0; z < 2; z++)
		if ((a[z].t != 7 && a[z].t != 3) || (c[z].t != 7 && c[z].t != 3)
		    || (d[z].t != 5 && d[z].t != 9) || (f[z + 2].t != 7 && f[z + 2].t != 3)
		    || (g[z + 1].t != 7 && g[z + 1].t != 3) || (r[z + 2].t != 7 && r[z + 2].t != 3)
		    || (s[z + 1].t != 5 && s[z + 1].t != 9) || (o[z + 1].t != 7 && o[z + 1].t != 3)
		    || (k[z + 1][0].t != 7 && k[z + 1][0].t != 3) || (k[z + 1][1].t != 7 && k[z + 1][1].t != 3)
		    || (q[z + 1][0].t != 7 && q[z + 1][0].t != 3) || (q[z + 1][1].t != 7 && q[z + 1][1].t != 3)
		    || (t[z + 2][0].t != 5 && t[z + 2][0].t != 9) || (t[z + 2][1].t != 5 && t[z + 2][1].t != 9))
		  abort ();
	      for (int z = 0; z < 3; z++)
		if (b[z + 2].t != 5 && b[z + 2].t != 9)
		  abort ();
	      foo (n, cp, dp, m, rp, o, pp, q);
	      r[3].s += 18;
	      o[1].s += 29;
	      o[2].s += 18;
	      p[0].s += 19;
	      c[0].s += 4;
	      c[1].s += 5;
	      d[0].s *= 2;
	      e[1].s += 6;
	      f[2].s += 7;
	      k[1][0].s += 17;
	      k[2][0].s += 19;
	    }
	  r[3].s += 8;
	  o[1].s += 9;
	  o[2].s += 10;
	  p[0].s += 11;
	  q[1][1].s += 13;
	  q[2][1].s += 15;
	  b[3].s *= 2;
	  c[0].s += 4;
	  c[1].s += 9;
	  d[0].s *= 2;
	  e[1].s += 16;
	  f[2].s += 8;
	}
    }
    if (d[0].s != 1LL << (8 + 4)
	|| d[1].s != 1LL << 16
	|| m[0].s != 5
	|| m[1].s != 19 * 16 + 6 * 8 + 16 * 4
	|| m[2].s != 5
	|| r[0].s != 6
	|| r[1].s != 7
	|| r[2].s != 21 * 16 + 7 * 8 + 8 * 4
	|| r[3].s != 23 * 16 + 18 * 8 + 8 * 4
	|| r[4].s != 9
	|| o[0].s != 1
	|| o[1].s != 25 * 16 + 29 * 8 + 9 * 4
	|| o[2].s != 27 * 16 + 18 * 8 + 10 * 4
	|| o[3].s != 2)
      abort ();
    if (e[1].t != 7 || h[0].t != 7 || m[1].t != 7 || p[0].t != 7)
      abort ();
    for (int z = 0; z < 2; z++)
      if (a[z].t != 7 || c[z].t != 7 || d[z].t != 5 || f[z + 2].t != 7
	  || g[z + 1].t != 7 || r[z + 2].t != 7 || s[z + 1].t != 5 || o[z + 1].t != 7
	  || k[z + 1][0].t != 7 || k[z + 1][1].t != 7 || q[z + 1][0].t != 7 || q[z + 1][1].t != 7
	  || t[z + 2][0].t != 5 || t[z + 2][1].t != 5)
	abort ();
    for (int z = 0; z < 3; z++)
      if (b[z + 2].t != 5)
	abort ();
  }
  if (a[0].s != 7 * 16 + 4 * 8 + 2 * 4
      || a[1].s != 17 * 16 + 5 * 8 + 3 * 4
      || b[0].s != 9 || b[1].s != 11
      || b[2].s != 1LL << (16 + 4)
      || b[3].s != 1LL << (8 + 4)
      || b[4].s != 1LL << (16 + 8)
      || b[5].s != 13 || b[6].s != 15
      || c[0].s != 6 * 16 + 4 * 8 + 4 * 4
      || c[1].s != 5 * 8 + 9 * 4
      || e[0].s != 5
      || e[1].s != 19 * 16 + 6 * 8 + 16 * 4
      || e[2].s != 5
      || f[0].s != 6
      || f[1].s != 7
      || f[2].s != 21 * 16 + 7 * 8 + 8 * 4
      || f[3].s != 23 * 16 + 18 * 8 + 8 * 4
      || f[4].s != 9
      || g[0].s != 1
      || g[1].s != 25 * 16 + 29 * 8 + 9 * 4
      || g[2].s != 27 * 16 + 18 * 8 + 10 * 4
      || g[3].s != 2
      || h[0].s != 29 * 16 + 19 * 8 + 11 * 4
      || h[1].s != 1 || h[2].s != 4
      || k[0][0].s != 5 || k[0][1].s != 6
      || k[1][0].s != 31 * 16 + 17 * 8
      || k[1][1].s != 13 * 4
      || k[2][0].s != 19 * 8
      || k[2][1].s != 33 * 16 + 15 * 4
      || k[3][0].s != 7 || k[3][1].s != 8
      || p[0].s != 29 * 16 + 19 * 8 + 11 * 4
      || p[1].s != 1 || p[2].s != 4
      || q[0][0].s != 5 || q[0][1].s != 6
      || q[1][0].s != 31 * 16 + 17 * 8
      || q[1][1].s != 13 * 4
      || q[2][0].s != 19 * 8
      || q[2][1].s != 33 * 16 + 15 * 4
      || q[3][0].s != 7 || q[3][1].s != 8
      || sb[0].s != 5
      || sb[1].s != 1LL << (16 + 4)
      || sb[2].s != 1LL << 8
      || sb[3].s != 6
      || tb[0][0].s != 9 || tb[0][1].s != 10 || tb[1][0].s != 11 || tb[1][1].s != 12
      || tb[2][0].s != 1LL << (16 + 8)
      || tb[2][1].s != 1LL << 4
      || tb[3][0].s != 1LL << 8
      || tb[3][1].s != 1LL << (16 + 4)
      || tb[4][0].s != 13 || tb[4][1].s != 14)
    abort ();
}

int
main ()
{
  int c1 = S::cnt1, c2 = S::cnt2, c3 = S::cnt3;
  int n = 1;
  test (n);
  if (S::cnt1 + S::cnt2 - c1 - c2 != S::cnt3 - c3)
    abort ();
  return 0;
}
