//**************************************************************************************************
//                                        PnlNgSpiceAC.hpp                                         *
//                                       ------------------                                        *
// Description : This class derives from the Analysis Panel base class and provides a GUI for a    *
//               user to configure a AC Analysis for the NG-Spice electronic circuit simulation    *
//               engine.                                                                           *
// Started     : 2004-08-04                                                                        *
// Last Update : 2015-01-12                                                                        *
// Copyright   : (C) 2004 by MSWaters                                                              *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef PNLNGSPICEAC_HPP
#define PNLNGSPICEAC_HPP

// Application Includes

#include "TypeDefs.hpp"
#include "base/PnlAnaBase.hpp"
#include "netlist/SimnNgSpice.hpp"

//**************************************************************************************************

class PnlNgSpiceAC : public PnlAnaBase
{
  private :

    void  Create( void );

    void  InitScale( void );
    bool  bSetScale( eTypeScale eScale );

  public :

          PnlNgSpiceAC( wxWindow * poWin );
         ~PnlNgSpiceAC( );

    bool  bClear( void );

    bool  bLoad( SimnNgSpice & roSimn );
    bool  bSave( SimnNgSpice & roSimn );

    // Event handlers
    void  OnScale  ( wxCommandEvent & roEvtCmd );
    void  OnSrcName( wxCommandEvent & roEvtCmd );

    // Leave this as the last line as private access is envoked by macro
    wxDECLARE_EVENT_TABLE( );
};

//**************************************************************************************************

#endif // PNLNGSPICEAC_HPP
