<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2//EN">
<HTML><HEAD>
  <$define Version:string="0.934">
  <$define pre-release:string="0">
  <$define release-date:string="04-Feb-2004">

  <$define DESCRIPTION:string=("This is the documentation to hsc, a "
    +"developer tool for HTML projects. It acts as a preprocessor "
    +"and supports macros, expressions, conditionals, include files, "
    +" replaces special characters, performs a structure check, tests "
    +" existence of local links and several other things."
    +" Optionally it can keep track of documents being processed and"
    +" maintain the dependencies between them, making it relatively"
    +" easy to integrate it into existing developer environments."
   )>


  <TITLE>Hsc - Manual</TITLE>
  <LINK REV="owns" TITLE="Matthias Bethke" HREF="mailto:Matthias.Bethke@gmx.net">
  <LINK REL="Home" HREF=":index.html">
  <LINK REL="Copyright" HREF=":copy.html">
  <LINK REL="Next" HREF=":about.html">
  <META HTTP-EQUIV="keywords" CONTENT="hsc,html,xhtml,preprocessor,macro,include,suck">
  <META HTTP-EQUIV="description" CONTENT=(DESCRIPTION)>
</HEAD>

<BODY>

<html-only>
<* pseudo-navigation-bar *>
<IMG SRC=":image/nomain.png" ALT="----" ALIGN="middle">
<IMG SRC=":image/noindex.png" ALT="-----" ALIGN="middle">
<A HREF=":copy.html"><IMG SRC=":image/copy.png" ALT="Copyright" ALIGN="middle"></A>
<IMG SRC=":image/noback.png" ALT="--" ALIGN="middle">
<IMG SRC=":image/noprev.png" ALT="--------" ALIGN="middle">
<A HREF="about.html"><IMG SRC=":image/next.png" ALT="Next" ALIGN="middle"></A>
<hr>
</html-only>

<***************************************************************************
 *
 * Contents of header
 *
 * This includes:
 * - silly quote
 * - headings
 * - version information
 *
 **************************************************************************>

<P ALIGN="right">
<I>Don't believe the hype<BR>
Take a look at the small print<BR>
Ignore the bold type<BR></I>
(Carter U.S.M, "Do Re Me, So Far So Good")
</P>

<* heading *>
<html-only>
<H1>Hsc</H1>
</html-only>

<* version info *>
<html-only>
<P><STRONG>(Version <(Version)>
<$if cond=(pre-release<>"0")>
  (pre-release#<(pre-release)>)
</$if>
<$stripws type="both">
, <(release-date)>)</STRONG></P>

<P LANG="de"><IMG SRC="image/teutsch.png" ALT="[german]" ALIGN="middle">Es
gibt keine <A HREF="teutsch.html">deutschsprachige
Dokumentation</A>.</P>
</html-only>

<postscript-only>
<H1>Preface</H1>
<H2>About The Program</H2>
</postscript-only>

<P><(DESCRIPTION)></P>

<html-only>
<IMG SRC="image/hsc.png" ALT="..SUCK SUCK SUCK.." ALIGN="right">
</html-only>

<P>A current version of this program and manual should always be
available from <A
HREF="http://www.linguistik.uni-erlangen.de/~msbethke/software.html"><(HSC.ANCHOR)></A>, both as
hypertext (html) and printable (Postscript) document (well...don't count on
the latter 8-) -mb).</P>

<***************************************************************************
 *
 * Contents of Postscript-version
 *
 **************************************************************************>
<postscript-only>

<P>The version of the program described herein is <STRONG>version <(version)></STRONG>,
released <(release-date)>.</P>

<H2>About This Manual</H2>

This manual was generated from the online documentation, however
there are a few minor differences:

<UL>
<LI>This first chapter looks totally different.

<LI>There is no tool-bar for navigation, as this apparently does not
    make sense in a printed document.

<LI>The table of contents is at the end of the manual - not because I
    think that is very smart, but because the conversion is easier for
    me that way. But as these pages are numbered using Roman digits,
    you can easily grab them and put them to the beginning of the
    manual without getting confused.

<LI>Several plain text files, like <CODE>CHANGES</CODE>,
    <CODE>NEWS</CODE>, but also some example scripts in <grafflwerk>,
    are not part of this manual, but can be viewed in the
    hypertext version by means of links.

<LI>Instead of images, you will only see their <CODE>ALT</CODE>-text.
    (Maybe I get this EPS-stuff to work some day,
    but do not count on it.)
</UL>

<P>As this is the first release with a printable manual, it might
contain some quirks, where a specific rendering or a certain phrase
does not make sense. Although I tried to avoid this of course - at
least there should not be any shitty <qq>Click here!</qq>. If you feel
like, you might considers these to be bugs and report them (with page
number, please). Hopefully no whole chapters are missing. </P>

<P>To those who are now going to mock <qq>And it took you more than two
years to convert the manual to Postscript?</qq> (the first public release
of <hsc> was in October 1995) I'd like to say: No, but it took more
than two years for somebody to provide an at least rudimentarily
bearable application to do this. See the chapter about Use-Cases for
details.</P>

<P>(Can you imagine a w3-browser, where you can push <qq>Print
all</qq>, and it automatically analyzes the document for stuff like
<TG>LINK REL="next" HREF=..</TG>, gets all related documents and
prints them in correct sequence? Can you imagine getting rid of these
crappy html2<I>insert-your-favourite-print-format-here</I> converters?
Even if you can, the browser developers can't. At least not in 1998,
several years after this HTML-and-W3-disaster was initiated.)</P>

<P>Furthermore I have to admit that I never really read this flavour
of the manual myself. Partially, because Ghostscript for Amiga has a
painful user interface, therfore I just gave a glimpse to a few
randomly selected pages.</P>

<P>Partially because I am a dedicated Postscript hater, as you can not
do much with files in this format: you can not in search it, you can not
quickly display it, you can not link around in it and you can hardly
convert it to something more reasonable. &mdash; <qq>Hey, you can convert it to
PDF!</qq> - Yeah, great! That changes everything.</P>

<P>And finally, because you will have to reprint most of it after the
next release and throw away all the paper. &mdash; <qq>Who cares, I printed it
for free at my university!</qq> - Oh really, and who pays back the tree
they had to cut?</P>

<P>(Note for Americans: paper usually is made from trees. - <qq>Can't be,
in my town we have a so called paper factory!</qq> - Oh, sorry for
confusing you. Forget what I said.)</P>

<P>So this is dedicated to those who prefer to waste paper instead of
bandwidth or disk storage,</P>

<P Align="right">
<$let hsc.format.time="%B %Y">
<I>Thomas Aglassinger<BR>
Oulu, <(gettime())></I></P>
</postscript-only>

<***************************************************************************
 *
 * Contents of HTML version
 *
 **************************************************************************>
<html-only>
<H2>About The Program</H2>
<UL>
<LI><A HREF="about.html">Introduction</A> <ndash> What's this all about?</li>
<LI><A HREF="copy.html">Copyright And Disclaimer</A> <ndash> not-my-fault, Freeware, source included</li>
<LI><A HREF="author.html">Author</A> <ndash> how to contact me</li>
<LI><A HREF="changes.html">Changes And News</A> <ndash> what's new with this release</li>
<LI><A HREF="updates.html">Updates</A> <ndash> where to find them</li>
</UL>

<H2>Before You Begin</H2>
<UL>
<LI><A HREF="require.html">Requirements</A> <ndash> what to own and know</li>
<* <LI><A HREF="distrib.html">Archive Contents</A> <ndash> things coming along *>
<LI><A HREF="install.html">Installation</A> <ndash> where to put the whole 
    damn thing</li>
</UL>

<H2>Usage</H2>
<UL>
<LI><A HREF="options.html">Invoking <hsc></A> <ndash> options, switches, exit code</li>
<LI><A HREF="examples.html">Example Usage</A> <ndash> how it is supposed to work</li>
<LI><A HREF="fileargs.html">File Arguments</A> <ndash> specifying input and output</li>
<LI><A HREF="messages.html">Messages</A> <ndash> shit happens
    <UL>
    <LI><A HREF="messages.html#elements">Message Elements</A></li>
    <LI><A HREF="messages.html#classes">Message Classes</A></li>
    <LI><A HREF="messages.html#options">Message Options</A></li>
    <LI><A HREF="message-list.html">List Of Messages</A></li>
    </UL></li>
<LI><A HREF="envvar.html">Environment Variables</A> <ndash> save the nature</li>
</UL>

<H2>Features</H2>
<UL>
<LI><A HREF="features/spctags.html">Special Tags</A> <ndash> make life a bit easier</li>
<LI><A HREF="features/checkuri.html">Check Existence</A> of local URIs to avoid dangling links</li>
<LI><A HREF="features/uris.html#prjrel">Project Relative URIs</A> <ndash> avoid paths like "../../../image/back.gif"</li>
<LI><A HREF="features/rplcent.html">Replace Special Characters</A> by their entities</li>
<LI><A HREF="features/getsize.html">Get Size</A> of images and use it for the browser's benefit</li>
<LI><A HREF="features/spcattr.html">Special Attributes</A> <ndash> access various information</li>
<LI><A HREF="features/strip.html">Strip Specific Elements</A> <ndash> comments, redundant linefeeds and white-spaces, unneeded tags, tags with external references</li>
<LI><A HREF="features/syntax.html">Structure And Syntax Check</A> to avoid surprises with different browsers</li>
<LI><A HREF="features/css.html">Cascading Style Sheet support</A> <ndash> ready for the XML madness</li>
</UL>

<H2>Advanced Topics</H2>
<UL>
<LI><A HREF="features/assign.html">Attribute Assignments</A></li>
<LI><A HREF="features/expressions.html">Expressions</A> <ndash> there's more to life than strings
    <UL>
    <LI><A HREF=":features/expressions.html#operators">Operators</A></li>
    <LI><A HREF=":features/expressions.html#boolean">Boolean Expressions</A></li>
    <LI><A HREF=":features/expressions.html#priorities">Priorities</A></li>
    </UL></li>
<LI><A HREF="macro/macros.html">Macros</A> <ndash> create your own shortcuts and templates.
    <UL>
    <LI><A HREF=":macro/flag.html">Macro Modifiers</A></li>
    <LI><A HREF=":macro/attrib.html">Attribute Declaration</A></li>
    <LI><A HREF=":macro/attrib.html#type">Attribute Types</A></li>
    <LI><A HREF=":macro/attrib.html#modifier">Attribute Modifiers</A></li>
    </UL></li>
<LI><A HREF="features/if.html">Conditionals</A> <ndash> what if..?
    <UL>
    <LI><A HREF=":features/if.html#general">General Syntax</A></li>
    <LI><A HREF=":features/if.html#simple">Some Simple Examples</A></li>
    <LI><A HREF=":features/if.html#nesting">Nesting Conditionals</A></li>
    <LI><A HREF=":features/if.html#macros">Conditionals And Macros</A></li>
    </UL></li>
<LI><A HREF="features/prefs.html">Syntax Definition</A> <ndash> what to do if HTML version 17.3 is out</li>
<LI><A HREF="features/exec.html">Execute Shell Commands</A> <ndash> poor man's pseudo-CGI</li>
<LI><A HREF="project/index.html">Project Management</A> <ndash> I'll <make> ya
    <UL>
    <LI><A HREF="project/prjfile.html">Project Files</A> <ndash> where <hsc> stores information about a project</li>
    <LI><hscpitt LINK> <ndash> <hsc> project interfering and trashing tool</li>
    <LI><A HREF="project/make.html">make</A> <ndash> a general purpose tool for project management</li>
    <LI><A HREF="project/makefile.html">Makefiles</A> <ndash> how to adopt them for <hsc></li>
    <LI><hscdepp LINK> <ndash> <hsc> dependency procreator</li>
    <LI><A HREF="project/hscpaltrow.html"><hscpaltrow></A> <ndash> a Rexx-script utilizing <hscpitt></li>
    </UL>
<LI><A HREF="usecases.html">Some Use-Cases</A> <ndash> hints how to do certain things</li>
<LI><A HREF="undocumented.html">"Undocumented" stuff</A> <ndash> use this if you dare!</li>
</UL>

<H2>Miscellaneous</H2>

<UL>
<LI><A HREF="questions.html">Questions</A> <ndash> and maybe some answers..</li>
<LI><A HREF="source.html">Source Code</A> <ndash> compiling it</li>
<LI><A HREF="ports.html">Existing Ports</A> <ndash> Amiga rulez? Not really.</li>
<LI><A HREF="others.html">Other HTML Extensions</A> <ndash> preprotranscessingpost</li>
<LI><A HREF="bugs.html">Known Bugs, Problems and Limitations</A> <ndash> don't whizz on the electric fence</li>
<LI><A HREF="future.html">Future?</A> <ndash> Yo, future!</li>
<LI><A HREF="related.html">Related stuff</A> <ndash> tools and further information</li>
</UL>

<HR>

<$let hsc.format.time="%d-%b-%Y">
<ADDRESS>
  <A HREF=":author.html">Matthias Bethke</A> (Matthias.Bethke@gmx.net)
  <(gettime())>
</ADDRESS>

</html-only>

</BODY></HTML>

