/* This file is part of the Zebra server.
   Copyright (C) 1994-2011 Index Data

Zebra is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

Zebra is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#ifndef IDZEBRA_VERSION_H
#define IDZEBRA_VERSION_H

#include <yaz/yconfig.h>

YAZ_BEGIN_CDECL

/** \brief Version as string */
#define ZEBRAVER "2.2.3"

/** \brief Version as integer (for comparison purposes) */
#define ZEBRA_VERSIONL 0x20203

/** \brief Version for Windows DLL/EXE */
#define ZEBRA_FILEVERSION 2,2,3,1

/** \brief SHA1 ID as generated by Git */
#define ZEBRA_VERSION_SHA1 "6deac2408d36773b991ada867da4a9393bcc658e"

/** \brief Returns Zebra version and SHA1 ID as generated by Git
    \param version_str buffer for version (at least 16 bytes)
    \param sha1_str SHA1 ID. Use NULL for not getting the ID
    \returns version as integer

    The sha1_str if non-NULL must point to a buffer of at least
    65 bytes (64 ID + null char).
*/
YAZ_EXPORT
void zebra_get_version(char *version_str, char *sha1_str);

YAZ_END_CDECL

#endif
/*
 * Local variables:
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */

