/*
 * Decompiled with CFR 0.152.
 */
package com.sqlmagic.tinysql;

import com.sqlmagic.tinysql.FieldTokenizer;
import com.sqlmagic.tinysql.UtilString;
import com.sqlmagic.tinysql.Utils;
import com.sqlmagic.tinysql.tinySQLException;
import com.sqlmagic.tinysql.tinySQLGlobals;
import com.sqlmagic.tinysql.tinySQLTable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class tsColumn
implements Cloneable {
    public String name = null;
    public String alias = null;
    public String longName = null;
    public Vector contextList;
    public int type = -1;
    public int size = 0;
    public int decimalPlaces = 0;
    public String defaultVal = null;
    public int position = 0;
    public String tableName = "";
    public tinySQLTable columnTable = null;
    public String newLine = System.getProperty("line.separator");
    String functionName = null;
    String functionArgString = null;
    Vector functionArgs = null;
    boolean notNull = false;
    boolean valueSet = false;
    String stringValue = null;
    int intValue = Integer.MIN_VALUE;
    float floatValue = Float.MIN_VALUE;
    SimpleDateFormat fmtyyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");
    Calendar today = Calendar.getInstance();
    boolean isConstant = false;
    boolean groupedColumn = false;

    tsColumn(String string) throws tinySQLException {
        this(string, null, "SELECT");
    }

    tsColumn(String string, Hashtable hashtable, String string2) throws tinySQLException {
        this.longName = this.name = string;
        int n = this.name.length();
        this.contextList = new Vector();
        this.contextList.addElement(string2);
        FieldTokenizer fieldTokenizer = new FieldTokenizer(this.name, '(', false);
        if (fieldTokenizer.countFields() == 2) {
            this.functionName = fieldTokenizer.getField(0).toUpperCase();
            if (this.functionName.equals("COUNT")) {
                this.type = 4;
                this.size = 10;
                this.intValue = Integer.MIN_VALUE;
                this.groupedColumn = true;
            } else if (this.functionName.equals("SUM")) {
                this.type = 6;
                this.size = 10;
                this.groupedColumn = true;
            } else if (this.functionName.equals("TO_DATE")) {
                this.type = 91;
                this.size = 10;
            } else if (this.functionName.equals("CONCAT") | this.functionName.equals("UPPER") | this.functionName.equals("SUBSTR") | this.functionName.equals("TRIM")) {
                this.type = 1;
            }
            this.functionArgString = fieldTokenizer.getField(1);
            FieldTokenizer fieldTokenizer2 = new FieldTokenizer(this.functionArgString, ',', false);
            this.functionArgs = new Vector();
            int n2 = 0;
            while (fieldTokenizer2.hasMoreFields()) {
                String string3 = fieldTokenizer2.nextField();
                tsColumn tsColumn2 = new tsColumn(string3, hashtable, string2);
                if (tsColumn2.isGroupedColumn()) {
                    this.groupedColumn = true;
                }
                if (this.functionName.equals("MAX") | this.functionName.equals("MIN")) {
                    if (n2 > 0) {
                        throw new tinySQLException("Function can only have 1 argument");
                    }
                    this.groupedColumn = true;
                    this.type = tsColumn2.type;
                    this.size = tsColumn2.size;
                } else if (this.functionName.equals("CONCAT")) {
                    this.type = 1;
                    this.size += tsColumn2.size;
                } else if (this.functionName.equals("UPPER")) {
                    this.type = 1;
                    this.size = tsColumn2.size;
                } else if (this.functionName.equals("TO_DATE")) {
                    this.type = 91;
                    this.size = 10;
                } else if (this.functionName.equals("TRIM")) {
                    this.type = 1;
                    this.size = tsColumn2.size;
                } else if (this.functionName.equals("SUBSTR")) {
                    this.type = 1;
                    if (n2 == 0 & tsColumn2.type != 1) {
                        throw new tinySQLException("SUBSTR first argument must be character");
                    }
                    if (n2 == 1) {
                        if (tsColumn2.type != 4 | tsColumn2.intValue < 1) {
                            throw new tinySQLException("SUBSTR second argument " + tsColumn2.getString() + " must be integer > 0");
                        }
                    } else if (n2 == 2) {
                        if (tsColumn2.type != 4 | tsColumn2.intValue < 1) {
                            throw new tinySQLException("SUBSTR third argument " + tsColumn2.getString() + " must be integer > 0");
                        }
                        this.size = tsColumn2.intValue;
                    }
                }
                ++n2;
                this.functionArgs.addElement(tsColumn2);
            }
        } else if (this.name.toUpperCase().equals("SYSDATE")) {
            this.isConstant = true;
            this.type = 91;
            this.size = 10;
            this.notNull = true;
            this.valueSet = true;
            this.stringValue = this.fmtyyyyMMdd.format(this.today.getTime());
        } else if (UtilString.isQuotedString(this.name)) {
            this.isConstant = true;
            this.type = 1;
            this.stringValue = UtilString.removeQuotes(this.name);
            if (this.stringValue != (String)null) {
                this.size = this.stringValue.length();
                this.notNull = true;
                this.valueSet = true;
            }
        } else {
            int n3 = UtilString.getValueType(this.name);
            if (n3 == 4) {
                this.intValue = Integer.valueOf(this.name);
                this.size = 10;
                this.type = n3;
                this.isConstant = true;
                this.notNull = true;
                this.valueSet = true;
            } else if (n3 == 6) {
                this.floatValue = Float.valueOf(this.name).floatValue();
                this.size = 10;
                this.type = n3;
                this.isConstant = true;
                this.notNull = true;
                this.valueSet = true;
            } else {
                int n4;
                this.columnTable = null;
                String string4 = this.name.toUpperCase();
                if (tinySQLGlobals.DEBUG) {
                    System.out.println("Trying to find table for " + string4);
                }
                if ((n4 = string4.indexOf(".")) > -1) {
                    this.tableName = string4.substring(0, n4);
                    if (hashtable != (Hashtable)null & this.tableName.indexOf("->") < 0) {
                        Vector vector = (Vector)hashtable.get("TABLE_SELECT_ORDER");
                        this.tableName = UtilString.findTableAlias(this.tableName, vector);
                    }
                    if ((string4 = string4.substring(n4 + 1)).length() > 11) {
                        this.longName = this.name;
                        string4 = tinySQLGlobals.getShortName(string4);
                    }
                    this.columnTable = (tinySQLTable)hashtable.get(this.tableName);
                } else if (hashtable != (Hashtable)null) {
                    if (string4.length() > 11) {
                        this.longName = this.name;
                        string4 = tinySQLGlobals.getShortName(string4);
                    }
                    Vector vector = (Vector)hashtable.get("TABLE_SELECT_ORDER");
                    int n5 = 0;
                    while (n5 < vector.size()) {
                        this.tableName = (String)vector.elementAt(n5);
                        tinySQLTable tinySQLTable2 = (tinySQLTable)hashtable.get(this.tableName);
                        Enumeration enumeration = tinySQLTable2.column_info.keys();
                        while (enumeration.hasMoreElements()) {
                            String string5 = (String)enumeration.nextElement();
                            if (!string5.equals(string4)) continue;
                            string4 = string5;
                            this.columnTable = tinySQLTable2;
                            break;
                        }
                        if (this.columnTable == (tinySQLTable)null) {
                            ++n5;
                            continue;
                        }
                        break;
                    }
                } else if (tinySQLGlobals.DEBUG) {
                    System.out.println("No table definitions.");
                }
                if (this.columnTable != (tinySQLTable)null) {
                    this.name = this.columnTable.table + "->" + this.columnTable.tableAlias + "." + string4;
                    this.type = this.columnTable.ColType(string4);
                    this.size = this.columnTable.ColSize(string4);
                    this.decimalPlaces = this.columnTable.ColDec(string4);
                    this.tableName = this.columnTable.table + "->" + this.columnTable.tableAlias;
                }
            }
        }
    }

    public boolean clear() {
        return this.clear(null);
    }

    public boolean clear(String string) {
        block3: {
            block2: {
                block5: {
                    block4: {
                        if (this.functionName != (String)null) break block2;
                        if (this.isConstant) break block3;
                        if (string != (String)null) break block4;
                        this.notNull = false;
                        this.valueSet = false;
                        break block3;
                    }
                    if (this.tableName != (String)null) break block5;
                    this.notNull = false;
                    this.valueSet = false;
                    break block3;
                }
                if (!this.tableName.equals(string)) break block3;
                this.notNull = false;
                this.valueSet = false;
                break block3;
            }
            int n = 0;
            while (n < this.functionArgs.size()) {
                tsColumn tsColumn2 = (tsColumn)this.functionArgs.elementAt(n);
                boolean bl = tsColumn2.clear(string);
                if (bl & Utils.clearFunction(this.functionName)) {
                    this.notNull = false;
                    this.valueSet = false;
                }
                ++n;
            }
        }
        return this.isNull();
    }

    public void update(String string, String string2) throws tinySQLException {
        if (this.isConstant | string == (String)null) {
            return;
        }
        if (string.trim().length() == 0) {
            return;
        }
        if (this.functionName == (String)null) {
            if (this.name.equals("*") & this.valueSet) {
                return;
            }
            if (string.equals(this.name) | this.name.equals("*")) {
                if (tinySQLGlobals.DEBUG) {
                    System.out.println("Set " + this.contextToString() + " column " + this.name + " = " + string2.trim());
                }
                this.valueSet = true;
                this.notNull = false;
                this.stringValue = null;
                this.intValue = Integer.MIN_VALUE;
                this.floatValue = Float.MIN_VALUE;
                if (string2 == (String)null) {
                    return;
                }
                if (string2.trim().length() == 0) {
                    return;
                }
                this.notNull = true;
                if (this.type == 1 | this.type == 91 | this.type == -1) {
                    this.stringValue = string2;
                } else if (this.type == 4 & this.notNull) {
                    try {
                        this.intValue = Integer.parseInt(string2.trim());
                    }
                    catch (Exception exception) {
                        throw new tinySQLException(string2 + " is not an integer.");
                    }
                } else if (this.type == 6 & this.notNull) {
                    try {
                        this.floatValue = Float.valueOf(string2.trim()).floatValue();
                    }
                    catch (Exception exception) {
                        throw new tinySQLException(string2 + " is not a Float.");
                    }
                }
            }
        } else {
            int n = 0;
            while (n < this.functionArgs.size()) {
                tsColumn tsColumn2 = (tsColumn)this.functionArgs.elementAt(n);
                tsColumn2.update(string, string2);
                ++n;
            }
        }
    }

    public void updateFunctions() throws tinySQLException {
        String string = "-JAN-FEB-MAR-APR-MAY-JUN-JUL-AUG-SEP-OCT-NOV-DEC-";
        if (this.isConstant) {
            return;
        }
        if (this.functionName == (String)null) {
            return;
        }
        if (this.functionName.equals("CONCAT")) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.functionArgs.size()) {
                tsColumn tsColumn2 = (tsColumn)this.functionArgs.elementAt(n);
                tsColumn2.updateFunctions();
                if (tsColumn2.isValueSet()) {
                    this.valueSet = true;
                }
                if (tsColumn2.notNull) {
                    stringBuffer.append(tsColumn2.getString());
                    this.notNull = true;
                }
                ++n;
            }
            this.stringValue = stringBuffer.toString();
        } else if (this.functionName.equals("UPPER")) {
            tsColumn tsColumn3 = (tsColumn)this.functionArgs.elementAt(0);
            tsColumn3.updateFunctions();
            if (tsColumn3.isValueSet()) {
                this.valueSet = true;
            }
            if (tsColumn3.notNull) {
                this.stringValue = tsColumn3.getString().toUpperCase();
                this.notNull = true;
            }
        } else if (this.functionName.equals("TRIM")) {
            tsColumn tsColumn4 = (tsColumn)this.functionArgs.elementAt(0);
            tsColumn4.updateFunctions();
            if (tsColumn4.isValueSet()) {
                this.valueSet = true;
            }
            if (tsColumn4.notNull) {
                this.stringValue = tsColumn4.getString().trim();
                this.notNull = true;
            }
        } else if (this.functionName.equals("SUBSTR")) {
            if (this.functionArgs.size() != 3) {
                throw new tinySQLException("Wrong number of arguments for SUBSTR");
            }
            tsColumn tsColumn5 = (tsColumn)this.functionArgs.elementAt(1);
            int n = tsColumn5.intValue;
            tsColumn5 = (tsColumn)this.functionArgs.elementAt(2);
            int n2 = tsColumn5.intValue;
            tsColumn5 = (tsColumn)this.functionArgs.elementAt(0);
            tsColumn5.updateFunctions();
            if (tsColumn5.isValueSet()) {
                this.valueSet = true;
            }
            if (tsColumn5.notNull) {
                this.stringValue = tsColumn5.stringValue;
                if (n < this.stringValue.length() - 1 & n2 > 0) {
                    this.stringValue = this.stringValue.substring(n - 1, n + n2 - 1);
                    this.notNull = true;
                } else {
                    this.stringValue = null;
                }
            }
        } else if (this.functionName.equals("COUNT")) {
            tsColumn tsColumn6 = (tsColumn)this.functionArgs.elementAt(0);
            tsColumn6.updateFunctions();
            this.notNull = true;
            this.valueSet = true;
            this.intValue = this.intValue == Integer.MIN_VALUE ? 0 : ++this.intValue;
        } else if (this.functionName.equals("TO_DATE")) {
            tsColumn tsColumn7 = (tsColumn)this.functionArgs.elementAt(0);
            tsColumn7.updateFunctions();
            if (tsColumn7.isValueSet()) {
                this.valueSet = true;
            }
            this.type = 91;
            this.size = 10;
            if (tsColumn7.notNull) {
                this.stringValue = tsColumn7.getString().trim();
                FieldTokenizer fieldTokenizer = new FieldTokenizer(this.stringValue, '-', false);
                String[] stringArray = fieldTokenizer.getFields();
                if (stringArray.length < 3) {
                    throw new tinySQLException(this.stringValue + " is not a date with " + "format DD-MON-YY!");
                }
                try {
                    String string2;
                    int n = Integer.parseInt(stringArray[0]);
                    if (n < 1 | n > 31) {
                        throw new tinySQLException(this.stringValue + " day not " + "between 1 and 31.");
                    }
                    String string3 = stringArray[1].toUpperCase();
                    int n3 = string.indexOf("-" + string3 + "-");
                    if (n3 == -1) {
                        throw new tinySQLException(this.stringValue + " month not " + "recognized.");
                    }
                    int n4 = (n3 + 4) / 4;
                    int n5 = Integer.parseInt(stringArray[2]);
                    if (n5 < 0 | n5 > 2100) {
                        throw new tinySQLException(this.stringValue + " year not " + "recognized.");
                    }
                    if (n5 < 50) {
                        n5 = 2000 + n5;
                    } else if (n5 < 100) {
                        n5 = 1900 + n5;
                    }
                    String string4 = Integer.toString(n);
                    if (string4.length() < 2) {
                        string4 = "0" + string4;
                    }
                    if ((string2 = Integer.toString(n4)).length() < 2) {
                        string2 = "0" + string2;
                    }
                    String string5 = Integer.toString(n5);
                    this.stringValue = string5 + "-" + string2 + "-" + string4;
                }
                catch (Exception exception) {
                    throw new tinySQLException(this.stringValue + " exception " + exception.getMessage());
                }
                this.notNull = true;
            }
        } else if (this.functionName.equals("SUM")) {
            tsColumn tsColumn8 = (tsColumn)this.functionArgs.elementAt(0);
            tsColumn8.updateFunctions();
            if (tsColumn8.isValueSet()) {
                this.valueSet = true;
            }
            if (tsColumn8.type == 1 | tsColumn8.type == 91) {
                throw new tinySQLException(tsColumn8.name + " is not numeric!");
            }
            if (tsColumn8.notNull) {
                this.notNull = true;
                this.floatValue = this.floatValue == Float.MIN_VALUE ? 0.0f : (tsColumn8.type == 4 ? (this.floatValue += new Integer(tsColumn8.intValue).floatValue()) : (this.floatValue += tsColumn8.floatValue));
            }
        } else if (this.functionName.equals("MAX") | this.functionName.equals("MIN")) {
            tsColumn tsColumn9 = (tsColumn)this.functionArgs.elementAt(0);
            tsColumn9.updateFunctions();
            if (tsColumn9.isValueSet()) {
                this.valueSet = true;
            }
            if (tsColumn9.notNull) {
                this.notNull = true;
                if (tsColumn9.type == 1 | tsColumn9.type == 91) {
                    if (this.stringValue == null) {
                        this.stringValue = tsColumn9.stringValue;
                    } else if (this.functionName.equals("MAX") & tsColumn9.stringValue.compareTo(this.stringValue) > 0) {
                        this.stringValue = tsColumn9.stringValue;
                    } else if (this.functionName.equals("MIN") & tsColumn9.stringValue.compareTo(this.stringValue) < 0) {
                        this.stringValue = tsColumn9.stringValue;
                    }
                } else if (tsColumn9.type == 4) {
                    if (this.intValue == Integer.MIN_VALUE) {
                        this.intValue = tsColumn9.intValue;
                    } else if (this.functionName.equals("MIN") & tsColumn9.intValue < this.intValue) {
                        this.intValue = tsColumn9.intValue;
                    } else if (this.functionName.equals("MAX") & tsColumn9.intValue > this.intValue) {
                        this.intValue = tsColumn9.intValue;
                    }
                } else if (tsColumn9.type == 6) {
                    if (this.floatValue == Float.MIN_VALUE) {
                        this.floatValue = tsColumn9.floatValue;
                    } else if (this.functionName.equals("MIN") & tsColumn9.floatValue < this.floatValue) {
                        this.floatValue = tsColumn9.floatValue;
                    } else if (this.functionName.equals("MAX") & tsColumn9.floatValue > this.floatValue) {
                        this.floatValue = tsColumn9.floatValue;
                    }
                }
            }
        }
    }

    public boolean isGroupedColumn() {
        return this.groupedColumn;
    }

    public boolean isValueSet() {
        return this.valueSet;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public boolean isNull() {
        return !this.notNull;
    }

    public boolean like(tsColumn tsColumn2) throws tinySQLException {
        if (!Utils.isCharColumn(this.type) | !Utils.isCharColumn(tsColumn2.type)) {
            throw new tinySQLException("Column " + this.name + " or " + tsColumn2.name + " is not character.");
        }
        FieldTokenizer fieldTokenizer = new FieldTokenizer(tsColumn2.stringValue, '%', true);
        boolean bl = true;
        int n = 0;
        String string = null;
        String string2 = null;
        while (fieldTokenizer.hasMoreFields()) {
            String string3;
            string2 = string3 = fieldTokenizer.nextField();
            if (string == (String)null && !(string = string3).equals("%") & !this.stringValue.startsWith(string)) {
                bl = false;
                break;
            }
            if (string3.equals("%")) continue;
            if (this.stringValue.indexOf(string3, n) < 0) {
                bl = false;
                break;
            }
            n = this.stringValue.indexOf(string3, n) + 1;
        }
        if (!string2.equals("%") & !this.stringValue.endsWith(string2)) {
            bl = false;
        }
        if (tinySQLGlobals.DEBUG) {
            System.out.println("Is " + this.getString() + " like " + tsColumn2.getString() + " ? " + bl);
        }
        return bl;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int compareTo(Object object) throws tinySQLException {
        tsColumn tsColumn2 = (tsColumn)object;
        int n = tsColumn2.type;
        double d = Double.MIN_VALUE;
        double d2 = Double.MIN_VALUE;
        int n2 = 0;
        if (Utils.isCharColumn(this.type)) {
            if (!Utils.isCharColumn(n)) {
                throw new tinySQLException("Type mismatch between " + this.getString() + " and " + tsColumn2.getString());
            }
            if (this.stringValue == (String)null | tsColumn2.stringValue == (String)null) {
                throw new tinySQLException("One of the values is NULL");
            }
            n2 = this.stringValue.compareTo(tsColumn2.stringValue);
        } else if (Utils.isDateColumn(this.type)) {
            if (!Utils.isDateColumn(n)) {
                throw new tinySQLException("Type mismatch between " + this.getString() + " and " + tsColumn2.getString());
            }
            if (this.stringValue == (String)null | tsColumn2.stringValue == (String)null) {
                throw new tinySQLException("One of the values is NULL");
            }
            String string = UtilString.toStandardDate(tsColumn2.stringValue);
            String string2 = UtilString.toStandardDate(this.stringValue);
            n2 = string2.compareTo(string);
        } else if (Utils.isNumberColumn(this.type)) {
            if (this.type == 4) {
                d = this.intValue;
            } else if (this.type == 6) {
                d = this.floatValue;
            }
            if (n == 4) {
                d2 = tsColumn2.intValue;
            } else if (n == 6) {
                d2 = tsColumn2.floatValue;
            }
            if (d > d2) {
                n2 = 1;
            } else if (d < d2) {
                n2 = -1;
            }
        } else {
            System.out.println("Cannot sort unknown type");
        }
        if (tinySQLGlobals.DEBUG) {
            System.out.println("Comparing " + this.getString() + " to " + tsColumn2.getString() + " gave " + n2);
        }
        return n2;
    }

    public void addContext(String string) {
        if (string != (String)null) {
            this.contextList.addElement(string);
        }
    }

    public String contextToString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.contextList.size()) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append((String)this.contextList.elementAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean getContext(String string) {
        int n = 0;
        while (n < this.contextList.size()) {
            String string2 = (String)this.contextList.elementAt(n);
            if (string2 != (String)null && string2.equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getString() {
        if (!this.notNull) {
            return "null";
        }
        if (this.type == 1 | this.type == 91 | this.type == -1) {
            return this.stringValue;
        }
        if (this.type == 4) {
            if (this.intValue == Integer.MIN_VALUE) {
                return null;
            }
            return Integer.toString(this.intValue);
        }
        if (this.type == 6) {
            if (this.floatValue == Float.MIN_VALUE) {
                return null;
            }
            return Float.toString(this.floatValue);
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.functionName == (String)null) {
            stringBuffer.append("-----------------------------------" + this.newLine + "Column Name: " + this.name + this.newLine + "Table: " + this.tableName + this.newLine + "IsNotNull: " + this.notNull + this.newLine + "valueSet: " + this.valueSet + this.newLine + "IsConstant: " + this.isConstant + this.newLine + "Type: " + this.type + this.newLine + "Size: " + this.size + this.newLine + "Context: " + this.contextToString() + this.newLine + "Value: " + this.getString());
        } else {
            stringBuffer.append("Function: " + this.functionName + this.newLine + "IsNotNull: " + this.notNull + this.newLine + "Type: " + this.type + this.newLine + "Size: " + this.size + this.newLine + "Value: " + this.getString());
            int n = 0;
            while (n < this.functionArgs.size()) {
                stringBuffer.append(this.newLine + "Argument " + n + " follows" + this.newLine + ((tsColumn)this.functionArgs.elementAt(n)).toString() + this.newLine);
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

