/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#ifndef HEADER_REMOTECOMPUTER
#define HEADER_REMOTECOMPUTER

#include <QWidget>
#include <QProgressDialog>
#include <QTabWidget>
#include <QPushButton>
#include <QMessageBox>
#include <QVBoxLayout>
#include <QCloseEvent>
#include <QLabel>
#include <QIcon>
#include <QProgressBar>
#include "../core/network/socket_controller.h"
#include "../core/bean/os_characteristic.h"
#include "tabui/share_files.h"
#include "tabui/identity_client.h"
#include "tabui/exec_shell.h"

class RemoteComputer : public QFrame
{
    Q_OBJECT

public:
    RemoteComputer(QString remote_ip, QString remote_port, QString remote_port_file, QString remote_password, int nbr);
    ~RemoteComputer();
    SocketController *controller;
    QLabel *label;
    QProgressBar *progress;
    int client_nbr;
    int id_server;
    QString ip;
    QString port;
    QString portFile;
    ExecShell *execShell;

public slots:
    void disconnected(int error);
    void tcp_state(int state);
    void wrong_password_slot();
    void client_characteristics_slot(OsCharacteristic *characteristics);
    void error();
    void showMessageSlot(QString title, QString content, int duration);
    void showLabel(QString text);
    void file_received_slot(File *file);
    void file_uploaded_slot(File *file);
    void update_percent_slot(int current, int total);
    void ask_screenshot_to_server(QString to, QString from, QString file_name);
    void refresh_view_slot(Folder *folder_info);
    void add_command_to_database_slot(Command *command);

signals:
    void remove_tab_signal(int client_nbr);
    void showMessage(QString title, QString content, int duration);
    void update_os_information(QString os, QString title, int client_nbr);
    void refresh_view(Folder *folder_info);
    void add_command_to_database(Command *command);

private:
    QString password;
    OsCharacteristic *os;
    QTabWidget *client_tab;
    ShareFiles *shareFiles;
    IdentityClient *identity;
    QSettings *settings;
    QString user_mode;
    bool isScreenshot;
};

#endif
