/* Copyright (c) 2011-2012, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/mfd/wcd9xxx/wcd9310_registers.h>
#include "wcd9310.h"

const u8 tabla_reg_readable[TABLA_CACHE_SIZE] = {
	[TABLA_A_CHIP_CTL] = 1,
	[TABLA_A_CHIP_STATUS] = 1,
	[TABLA_A_CHIP_ID_BYTE_0] = 1,
	[TABLA_A_CHIP_ID_BYTE_1] = 1,
	[TABLA_A_CHIP_ID_BYTE_2] = 1,
	[TABLA_A_CHIP_ID_BYTE_3] = 1,
	[TABLA_A_CHIP_VERSION] = 1,
	[TABLA_A_SB_VERSION] = 1,
	[TABLA_A_SLAVE_ID_1] = 1,
	[TABLA_A_SLAVE_ID_2] = 1,
	[TABLA_A_SLAVE_ID_3] = 1,
	[TABLA_A_PIN_CTL_OE0] = 1,
	[TABLA_A_PIN_CTL_OE1] = 1,
	[TABLA_A_PIN_CTL_DATA0] = 1,
	[TABLA_A_PIN_CTL_DATA1] = 1,
	[TABLA_A_HDRIVE_GENERIC] = 1,
	[TABLA_A_HDRIVE_OVERRIDE] = 1,
	[TABLA_A_ANA_CSR_WAIT_STATE] = 1,
	[TABLA_A_PROCESS_MONITOR_CTL0] = 1,
	[TABLA_A_PROCESS_MONITOR_CTL1] = 1,
	[TABLA_A_PROCESS_MONITOR_CTL2] = 1,
	[TABLA_A_PROCESS_MONITOR_CTL3] = 1,
	[TABLA_A_QFUSE_CTL] = 1,
	[TABLA_A_QFUSE_STATUS] = 1,
	[TABLA_A_QFUSE_DATA_OUT0] = 1,
	[TABLA_A_QFUSE_DATA_OUT1] = 1,
	[TABLA_A_QFUSE_DATA_OUT2] = 1,
	[TABLA_A_QFUSE_DATA_OUT3] = 1,
	[TABLA_A_CDC_CTL] = 1,
	[TABLA_A_LEAKAGE_CTL] = 1,
	[TABLA_A_INTR_MODE] = 1,
	[TABLA_A_INTR_MASK0] = 1,
	[TABLA_A_INTR_MASK1] = 1,
	[TABLA_A_INTR_MASK2] = 1,
	[TABLA_A_INTR_STATUS0] = 1,
	[TABLA_A_INTR_STATUS1] = 1,
	[TABLA_A_INTR_STATUS2] = 1,
	[TABLA_A_INTR_CLEAR0] = 0,
	[TABLA_A_INTR_CLEAR1] = 0,
	[TABLA_A_INTR_CLEAR2] = 0,
	[TABLA_A_INTR_LEVEL0] = 1,
	[TABLA_A_INTR_LEVEL1] = 1,
	[TABLA_A_INTR_LEVEL2] = 1,
	[TABLA_A_INTR_TEST0] = 1,
	[TABLA_A_INTR_TEST1] = 1,
	[TABLA_A_INTR_TEST2] = 1,
	[TABLA_A_INTR_SET0] = 1,
	[TABLA_A_INTR_SET1] = 1,
	[TABLA_A_INTR_SET2] = 1,
	[TABLA_A_CDC_TX_I2S_SCK_MODE] = 1,
	[TABLA_A_CDC_TX_I2S_WS_MODE] = 1,
	[TABLA_A_CDC_DMIC_DATA0_MODE] = 1,
	[TABLA_A_CDC_DMIC_CLK0_MODE] = 1,
	[TABLA_A_CDC_DMIC_DATA1_MODE] = 1,
	[TABLA_A_CDC_DMIC_CLK1_MODE] = 1,
	[TABLA_A_CDC_RX_I2S_SCK_MODE] = 1,
	[TABLA_A_CDC_RX_I2S_WS_MODE] = 1,
	[TABLA_A_CDC_DMIC_DATA2_MODE] = 1,
	[TABLA_A_CDC_DMIC_CLK2_MODE] = 1,
	[TABLA_A_CDC_INTR_MODE] = 1,
	[TABLA_A_BIAS_REF_CTL] = 1,
	[TABLA_A_BIAS_CENTRAL_BG_CTL] = 1,
	[TABLA_A_BIAS_PRECHRG_CTL] = 1,
	[TABLA_A_BIAS_CURR_CTL_1] = 1,
	[TABLA_A_BIAS_CURR_CTL_2] = 1,
	[TABLA_A_BIAS_CONFIG_MODE_BG_CTL] = 1,
	[TABLA_A_BIAS_BG_STATUS] = 1,
	[TABLA_A_CLK_BUFF_EN1] = 1,
	[TABLA_A_CLK_BUFF_EN2] = 1,
	[TABLA_A_LDO_H_MODE_1] = 1,
	[TABLA_A_LDO_H_MODE_2] = 1,
	[TABLA_A_LDO_H_LOOP_CTL] = 1,
	[TABLA_A_LDO_H_COMP_1] = 1,
	[TABLA_A_LDO_H_COMP_2] = 1,
	[TABLA_A_LDO_H_BIAS_1] = 1,
	[TABLA_A_LDO_H_BIAS_2] = 1,
	[TABLA_A_LDO_H_BIAS_3] = 1,
	[TABLA_A_LDO_L_MODE_1] = 1,
	[TABLA_A_LDO_L_MODE_2] = 1,
	[TABLA_A_LDO_L_LOOP_CTL] = 1,
	[TABLA_A_LDO_L_COMP_1] = 1,
	[TABLA_A_LDO_L_COMP_2] = 1,
	[TABLA_A_LDO_L_BIAS_1] = 1,
	[TABLA_A_LDO_L_BIAS_2] = 1,
	[TABLA_A_LDO_L_BIAS_3] = 1,
	[TABLA_A_MICB_CFILT_1_CTL] = 1,
	[TABLA_A_MICB_CFILT_1_VAL] = 1,
	[TABLA_A_MICB_CFILT_1_PRECHRG] = 1,
	[TABLA_A_MICB_1_CTL] = 1,
	[TABLA_A_MICB_1_INT_RBIAS] = 1,
	[TABLA_A_MICB_1_MBHC] = 1,
	[TABLA_A_MICB_CFILT_2_CTL] = 1,
	[TABLA_A_MICB_CFILT_2_VAL] = 1,
	[TABLA_A_MICB_CFILT_2_PRECHRG] = 1,
	[TABLA_A_MICB_2_CTL] = 1,
	[TABLA_A_MICB_2_INT_RBIAS] = 1,
	[TABLA_A_MICB_2_MBHC] = 1,
	[TABLA_A_MICB_CFILT_3_CTL] = 1,
	[TABLA_A_MICB_CFILT_3_VAL] = 1,
	[TABLA_A_MICB_CFILT_3_PRECHRG] = 1,
	[TABLA_A_MICB_3_CTL] = 1,
	[TABLA_A_MICB_3_INT_RBIAS] = 1,
	[TABLA_A_MICB_3_MBHC] = 1,
	[TABLA_A_TX_COM_BIAS] = 1,
	[TABLA_A_MBHC_SCALING_MUX_1] = 1,
	[TABLA_A_MBHC_SCALING_MUX_2] = 1,
	[TABLA_A_TX_SUP_SWITCH_CTRL_1] = 1,
	[TABLA_A_TX_SUP_SWITCH_CTRL_2] = 1,
	[TABLA_A_TX_1_2_EN] = 1,
	[TABLA_A_TX_1_2_TEST_EN] = 1,
	[TABLA_A_TX_1_2_ADC_CH1] = 1,
	[TABLA_A_TX_1_2_ADC_CH2] = 1,
	[TABLA_A_TX_1_2_ATEST_REFCTRL] = 1,
	[TABLA_A_TX_1_2_TEST_CTL] = 1,
	[TABLA_A_TX_1_2_TEST_BLOCK_EN] = 1,
	[TABLA_A_TX_1_2_TXFE_CLKDIV] = 1,
	[TABLA_A_TX_1_2_SAR_ERR_CH1] = 1,
	[TABLA_A_TX_1_2_SAR_ERR_CH2] = 1,
	[TABLA_A_TX_3_4_EN] = 1,
	[TABLA_A_TX_3_4_TEST_EN] = 1,
	[TABLA_A_TX_3_4_ADC_CH3] = 1,
	[TABLA_A_TX_3_4_ADC_CH4] = 1,
	[TABLA_A_TX_3_4_ATEST_REFCTRL] = 1,
	[TABLA_A_TX_3_4_TEST_CTL] = 1,
	[TABLA_A_TX_3_4_TEST_BLOCK_EN] = 1,
	[TABLA_A_TX_3_4_TXFE_CKDIV] = 1,
	[TABLA_A_TX_3_4_SAR_ERR_CH3] = 1,
	[TABLA_A_TX_3_4_SAR_ERR_CH4] = 1,
	[TABLA_A_TX_5_6_EN] = 1,
	[TABLA_A_TX_5_6_TEST_EN] = 1,
	[TABLA_A_TX_5_6_ADC_CH5] = 1,
	[TABLA_A_TX_5_6_ADC_CH6] = 1,
	[TABLA_A_TX_5_6_ATEST_REFCTRL] = 1,
	[TABLA_A_TX_5_6_TEST_CTL] = 1,
	[TABLA_A_TX_5_6_TEST_BLOCK_EN] = 1,
	[TABLA_A_TX_5_6_TXFE_CKDIV] = 1,
	[TABLA_A_TX_5_6_SAR_ERR_CH5] = 1,
	[TABLA_A_TX_5_6_SAR_ERR_CH6] = 1,
	[TABLA_A_TX_7_MBHC_EN] = 1,
	[TABLA_A_TX_7_MBHC_ATEST_REFCTRL] = 1,
	[TABLA_A_TX_7_MBHC_ADC] = 1,
	[TABLA_A_TX_7_MBHC_TEST_CTL] = 1,
	[TABLA_A_TX_7_MBHC_SAR_ERR] = 1,
	[TABLA_A_TX_7_TXFE_CLKDIV] = 1,
	[TABLA_A_AUX_COM_CTL] = 1,
	[TABLA_A_AUX_COM_ATEST] = 1,
	[TABLA_A_AUX_L_EN] = 1,
	[TABLA_A_AUX_L_GAIN] = 1,
	[TABLA_A_AUX_L_PA_CONN] = 1,
	[TABLA_A_AUX_L_PA_CONN_INV] = 1,
	[TABLA_A_AUX_R_EN] = 1,
	[TABLA_A_AUX_R_GAIN] = 1,
	[TABLA_A_AUX_R_PA_CONN] = 1,
	[TABLA_A_AUX_R_PA_CONN_INV] = 1,
	[TABLA_A_CP_EN] = 1,
	[TABLA_A_CP_CLK] = 1,
	[TABLA_A_CP_STATIC] = 1,
	[TABLA_A_CP_DCC1] = 1,
	[TABLA_A_CP_DCC3] = 1,
	[TABLA_A_CP_ATEST] = 1,
	[TABLA_A_CP_DTEST] = 1,
	[TABLA_A_RX_COM_TIMER_DIV] = 1,
	[TABLA_A_RX_COM_OCP_CTL] = 1,
	[TABLA_A_RX_COM_OCP_COUNT] = 1,
	[TABLA_A_RX_COM_DAC_CTL] = 1,
	[TABLA_A_RX_COM_BIAS] = 1,
	[TABLA_A_RX_HPH_BIAS_PA] = 1,
	[TABLA_A_RX_HPH_BIAS_LDO] = 1,
	[TABLA_A_RX_HPH_BIAS_CNP] = 1,
	[TABLA_A_RX_HPH_BIAS_WG] = 1,
	[TABLA_A_RX_HPH_OCP_CTL] = 1,
	[TABLA_A_RX_HPH_CNP_EN] = 1,
	[TABLA_A_RX_HPH_CNP_WG_CTL] = 1,
	[TABLA_A_RX_HPH_CNP_WG_TIME] = 1,
	[TABLA_A_RX_HPH_L_GAIN] = 1,
	[TABLA_A_RX_HPH_L_TEST] = 1,
	[TABLA_A_RX_HPH_L_PA_CTL] = 1,
	[TABLA_A_RX_HPH_L_DAC_CTL] = 1,
	[TABLA_A_RX_HPH_L_ATEST] = 1,
	[TABLA_A_RX_HPH_L_STATUS] = 1,
	[TABLA_A_RX_HPH_R_GAIN] = 1,
	[TABLA_A_RX_HPH_R_TEST] = 1,
	[TABLA_A_RX_HPH_R_PA_CTL] = 1,
	[TABLA_A_RX_HPH_R_DAC_CTL] = 1,
	[TABLA_A_RX_HPH_R_ATEST] = 1,
	[TABLA_A_RX_HPH_R_STATUS] = 1,
	[TABLA_A_RX_EAR_BIAS_PA] = 1,
	[TABLA_A_RX_EAR_BIAS_CMBUFF] = 1,
	[TABLA_A_RX_EAR_EN] = 1,
	[TABLA_A_RX_EAR_GAIN] = 1,
	[TABLA_A_RX_EAR_CMBUFF] = 1,
	[TABLA_A_RX_EAR_ICTL] = 1,
	[TABLA_A_RX_EAR_CCOMP] = 1,
	[TABLA_A_RX_EAR_VCM] = 1,
	[TABLA_A_RX_EAR_CNP] = 1,
	[TABLA_A_RX_EAR_ATEST] = 1,
	[TABLA_A_RX_EAR_STATUS] = 1,
	[TABLA_A_RX_LINE_BIAS_PA] = 1,
	[TABLA_A_RX_LINE_BIAS_DAC] = 1,
	[TABLA_A_RX_LINE_BIAS_CNP] = 1,
	[TABLA_A_RX_LINE_COM] = 1,
	[TABLA_A_RX_LINE_CNP_EN] = 1,
	[TABLA_A_RX_LINE_CNP_WG_CTL] = 1,
	[TABLA_A_RX_LINE_CNP_WG_TIME] = 1,
	[TABLA_A_RX_LINE_1_GAIN] = 1,
	[TABLA_A_RX_LINE_1_TEST] = 1,
	[TABLA_A_RX_LINE_1_DAC_CTL] = 1,
	[TABLA_A_RX_LINE_1_STATUS] = 1,
	[TABLA_A_RX_LINE_2_GAIN] = 1,
	[TABLA_A_RX_LINE_2_TEST] = 1,
	[TABLA_A_RX_LINE_2_DAC_CTL] = 1,
	[TABLA_A_RX_LINE_2_STATUS] = 1,
	[TABLA_A_RX_LINE_3_GAIN] = 1,
	[TABLA_A_RX_LINE_3_TEST] = 1,
	[TABLA_A_RX_LINE_3_DAC_CTL] = 1,
	[TABLA_A_RX_LINE_3_STATUS] = 1,
	[TABLA_A_RX_LINE_4_GAIN] = 1,
	[TABLA_A_RX_LINE_4_TEST] = 1,
	[TABLA_A_RX_LINE_4_DAC_CTL] = 1,
	[TABLA_A_RX_LINE_4_STATUS] = 1,
	[TABLA_A_RX_LINE_5_GAIN] = 1,
	[TABLA_A_RX_LINE_5_TEST] = 1,
	[TABLA_A_RX_LINE_5_DAC_CTL] = 1,
	[TABLA_A_RX_LINE_5_STATUS] = 1,
	[TABLA_A_RX_LINE_CNP_DBG] = 1,
	[TABLA_A_MBHC_HPH] = 1,
	[TABLA_A_CONFIG_MODE_FREQ] = 1,
	[TABLA_A_CONFIG_MODE_TEST] = 1,
	[TABLA_A_CONFIG_MODE_STATUS] = 1,
	[TABLA_A_CONFIG_MODE_TUNER] = 1,
	[TABLA_A_CDC_ANC1_CTL] = 1,
	[TABLA_A_CDC_ANC1_SHIFT] = 1,
	[TABLA_A_CDC_ANC1_FILT1_B1_CTL] = 1,
	[TABLA_A_CDC_ANC1_FILT1_B2_CTL] = 1,
	[TABLA_A_CDC_ANC1_FILT1_B3_CTL] = 1,
	[TABLA_A_CDC_ANC1_FILT1_B4_CTL] = 1,
	[TABLA_A_CDC_ANC1_FILT2_B1_CTL] = 1,
	[TABLA_A_CDC_ANC1_FILT2_B2_CTL] = 1,
	[TABLA_A_CDC_ANC1_FILT2_B3_CTL] = 1,
	[TABLA_A_CDC_ANC1_SPARE] = 1,
	[TABLA_A_CDC_ANC1_FILT3_CTL] = 1,
	[TABLA_A_CDC_ANC1_FILT4_CTL] = 1,
	[TABLA_A_CDC_TX1_VOL_CTL_TIMER] = 1,
	[TABLA_A_CDC_TX2_VOL_CTL_TIMER] = 1,
	[TABLA_A_CDC_TX3_VOL_CTL_TIMER] = 1,
	[TABLA_A_CDC_TX4_VOL_CTL_TIMER] = 1,
	[TABLA_A_CDC_TX5_VOL_CTL_TIMER] = 1,
	[TABLA_A_CDC_TX6_VOL_CTL_TIMER] = 1,
	[TABLA_A_CDC_TX7_VOL_CTL_TIMER] = 1,
	[TABLA_A_CDC_TX8_VOL_CTL_TIMER] = 1,
	[TABLA_A_CDC_TX9_VOL_CTL_TIMER] = 1,
	[TABLA_A_CDC_TX10_VOL_CTL_TIMER] = 1,
	[TABLA_A_CDC_TX1_VOL_CTL_GAIN] = 1,
	[TABLA_A_CDC_TX2_VOL_CTL_GAIN] = 1,
	[TABLA_A_CDC_TX3_VOL_CTL_GAIN] = 1,
	[TABLA_A_CDC_TX4_VOL_CTL_GAIN] = 1,
	[TABLA_A_CDC_TX5_VOL_CTL_GAIN] = 1,
	[TABLA_A_CDC_TX6_VOL_CTL_GAIN] = 1,
	[TABLA_A_CDC_TX7_VOL_CTL_GAIN] = 1,
	[TABLA_A_CDC_TX8_VOL_CTL_GAIN] = 1,
	[TABLA_A_CDC_TX9_VOL_CTL_GAIN] = 1,
	[TABLA_A_CDC_TX10_VOL_CTL_GAIN] = 1,
	[TABLA_A_CDC_TX1_VOL_CTL_CFG] = 1,
	[TABLA_A_CDC_TX2_VOL_CTL_CFG] = 1,
	[TABLA_A_CDC_TX3_VOL_CTL_CFG] = 1,
	[TABLA_A_CDC_TX4_VOL_CTL_CFG] = 1,
	[TABLA_A_CDC_TX5_VOL_CTL_CFG] = 1,
	[TABLA_A_CDC_TX6_VOL_CTL_CFG] = 1,
	[TABLA_A_CDC_TX7_VOL_CTL_CFG] = 1,
	[TABLA_A_CDC_TX8_VOL_CTL_CFG] = 1,
	[TABLA_A_CDC_TX9_VOL_CTL_CFG] = 1,
	[TABLA_A_CDC_TX10_VOL_CTL_CFG] = 1,
	[TABLA_A_CDC_TX1_MUX_CTL] = 1,
	[TABLA_A_CDC_TX2_MUX_CTL] = 1,
	[TABLA_A_CDC_TX3_MUX_CTL] = 1,
	[TABLA_A_CDC_TX4_MUX_CTL] = 1,
	[TABLA_A_CDC_TX5_MUX_CTL] = 1,
	[TABLA_A_CDC_TX6_MUX_CTL] = 1,
	[TABLA_A_CDC_TX7_MUX_CTL] = 1,
	[TABLA_A_CDC_TX8_MUX_CTL] = 1,
	[TABLA_A_CDC_TX9_MUX_CTL] = 1,
	[TABLA_A_CDC_TX10_MUX_CTL] = 1,
	[TABLA_A_CDC_TX1_CLK_FS_CTL] = 1,
	[TABLA_A_CDC_TX2_CLK_FS_CTL] = 1,
	[TABLA_A_CDC_TX3_CLK_FS_CTL] = 1,
	[TABLA_A_CDC_TX4_CLK_FS_CTL] = 1,
	[TABLA_A_CDC_TX5_CLK_FS_CTL] = 1,
	[TABLA_A_CDC_TX6_CLK_FS_CTL] = 1,
	[TABLA_A_CDC_TX7_CLK_FS_CTL] = 1,
	[TABLA_A_CDC_TX8_CLK_FS_CTL] = 1,
	[TABLA_A_CDC_TX9_CLK_FS_CTL] = 1,
	[TABLA_A_CDC_TX10_CLK_FS_CTL] = 1,
	[TABLA_A_CDC_TX1_DMIC_CTL] = 1,
	[TABLA_A_CDC_TX2_DMIC_CTL] = 1,
	[TABLA_A_CDC_TX3_DMIC_CTL] = 1,
	[TABLA_A_CDC_TX4_DMIC_CTL] = 1,
	[TABLA_A_CDC_TX5_DMIC_CTL] = 1,
	[TABLA_A_CDC_TX6_DMIC_CTL] = 1,
	[TABLA_A_CDC_TX7_DMIC_CTL] = 1,
	[TABLA_A_CDC_TX8_DMIC_CTL] = 1,
	[TABLA_A_CDC_TX9_DMIC_CTL] = 1,
	[TABLA_A_CDC_TX10_DMIC_CTL] = 1,
	[TABLA_A_CDC_ANC2_CTL] = 1,
	[TABLA_A_CDC_ANC2_SHIFT] = 1,
	[TABLA_A_CDC_ANC2_FILT1_B1_CTL] = 1,
	[TABLA_A_CDC_ANC2_FILT1_B2_CTL] = 1,
	[TABLA_A_CDC_ANC2_FILT1_B3_CTL] = 1,
	[TABLA_A_CDC_ANC2_FILT1_B4_CTL] = 1,
	[TABLA_A_CDC_ANC2_FILT2_B1_CTL] = 1,
	[TABLA_A_CDC_ANC2_FILT2_B2_CTL] = 1,
	[TABLA_A_CDC_ANC2_FILT2_B3_CTL] = 1,
	[TABLA_A_CDC_ANC2_SPARE] = 1,
	[TABLA_A_CDC_ANC2_FILT3_CTL] = 1,
	[TABLA_A_CDC_ANC2_FILT4_CTL] = 1,
	[TABLA_A_CDC_SRC1_PDA_CFG] = 1,
	[TABLA_A_CDC_SRC2_PDA_CFG] = 1,
	[TABLA_A_CDC_SRC1_FS_CTL] = 1,
	[TABLA_A_CDC_SRC2_FS_CTL] = 1,
	[TABLA_A_CDC_RX1_B1_CTL] = 1,
	[TABLA_A_CDC_RX2_B1_CTL] = 1,
	[TABLA_A_CDC_RX3_B1_CTL] = 1,
	[TABLA_A_CDC_RX4_B1_CTL] = 1,
	[TABLA_A_CDC_RX5_B1_CTL] = 1,
	[TABLA_A_CDC_RX6_B1_CTL] = 1,
	[TABLA_A_CDC_RX7_B1_CTL] = 1,
	[TABLA_A_CDC_RX1_B2_CTL] = 1,
	[TABLA_A_CDC_RX2_B2_CTL] = 1,
	[TABLA_A_CDC_RX3_B2_CTL] = 1,
	[TABLA_A_CDC_RX4_B2_CTL] = 1,
	[TABLA_A_CDC_RX5_B2_CTL] = 1,
	[TABLA_A_CDC_RX6_B2_CTL] = 1,
	[TABLA_A_CDC_RX7_B2_CTL] = 1,
	[TABLA_A_CDC_RX1_B3_CTL] = 1,
	[TABLA_A_CDC_RX2_B3_CTL] = 1,
	[TABLA_A_CDC_RX3_B3_CTL] = 1,
	[TABLA_A_CDC_RX4_B3_CTL] = 1,
	[TABLA_A_CDC_RX5_B3_CTL] = 1,
	[TABLA_A_CDC_RX6_B3_CTL] = 1,
	[TABLA_A_CDC_RX7_B3_CTL] = 1,
	[TABLA_A_CDC_RX1_B4_CTL] = 1,
	[TABLA_A_CDC_RX2_B4_CTL] = 1,
	[TABLA_A_CDC_RX3_B4_CTL] = 1,
	[TABLA_A_CDC_RX4_B4_CTL] = 1,
	[TABLA_A_CDC_RX5_B4_CTL] = 1,
	[TABLA_A_CDC_RX6_B4_CTL] = 1,
	[TABLA_A_CDC_RX7_B4_CTL] = 1,
	[TABLA_A_CDC_RX1_B5_CTL] = 1,
	[TABLA_A_CDC_RX2_B5_CTL] = 1,
	[TABLA_A_CDC_RX3_B5_CTL] = 1,
	[TABLA_A_CDC_RX4_B5_CTL] = 1,
	[TABLA_A_CDC_RX5_B5_CTL] = 1,
	[TABLA_A_CDC_RX6_B5_CTL] = 1,
	[TABLA_A_CDC_RX7_B5_CTL] = 1,
	[TABLA_A_CDC_RX1_B6_CTL] = 1,
	[TABLA_A_CDC_RX2_B6_CTL] = 1,
	[TABLA_A_CDC_RX3_B6_CTL] = 1,
	[TABLA_A_CDC_RX4_B6_CTL] = 1,
	[TABLA_A_CDC_RX5_B6_CTL] = 1,
	[TABLA_A_CDC_RX6_B6_CTL] = 1,
	[TABLA_A_CDC_RX7_B6_CTL] = 1,
	[TABLA_A_CDC_RX1_VOL_CTL_B1_CTL] = 1,
	[TABLA_A_CDC_RX2_VOL_CTL_B1_CTL] = 1,
	[TABLA_A_CDC_RX3_VOL_CTL_B1_CTL] = 1,
	[TABLA_A_CDC_RX4_VOL_CTL_B1_CTL] = 1,
	[TABLA_A_CDC_RX5_VOL_CTL_B1_CTL] = 1,
	[TABLA_A_CDC_RX6_VOL_CTL_B1_CTL] = 1,
	[TABLA_A_CDC_RX7_VOL_CTL_B1_CTL] = 1,
	[TABLA_A_CDC_RX1_VOL_CTL_B2_CTL] = 1,
	[TABLA_A_CDC_RX2_VOL_CTL_B2_CTL] = 1,
	[TABLA_A_CDC_RX3_VOL_CTL_B2_CTL] = 1,
	[TABLA_A_CDC_RX4_VOL_CTL_B2_CTL] = 1,
	[TABLA_A_CDC_RX5_VOL_CTL_B2_CTL] = 1,
	[TABLA_A_CDC_RX6_VOL_CTL_B2_CTL] = 1,
	[TABLA_A_CDC_RX7_VOL_CTL_B2_CTL] = 1,
	[TABLA_A_CDC_CLK_ANC_RESET_CTL] = 1,
	[TABLA_A_CDC_CLK_RX_RESET_CTL] = 1,
	[TABLA_A_CDC_CLK_TX_RESET_B1_CTL] = 1,
	[TABLA_A_CDC_CLK_TX_RESET_B2_CTL] = 1,
	[TABLA_A_CDC_CLK_DMIC_CTL] = 1,
	[TABLA_A_CDC_CLK_RX_I2S_CTL] = 1,
	[TABLA_A_CDC_CLK_TX_I2S_CTL] = 1,
	[TABLA_A_CDC_CLK_OTHR_RESET_CTL] = 1,
	[TABLA_A_CDC_CLK_TX_CLK_EN_B1_CTL] = 1,
	[TABLA_A_CDC_CLK_TX_CLK_EN_B2_CTL] = 1,
	[TABLA_A_CDC_CLK_OTHR_CTL] = 1,
	[TABLA_A_CDC_CLK_RDAC_CLK_EN_CTL] = 1,
	[TABLA_A_CDC_CLK_ANC_CLK_EN_CTL] = 1,
	[TABLA_A_CDC_CLK_RX_B1_CTL] = 1,
	[TABLA_A_CDC_CLK_RX_B2_CTL] = 1,
	[TABLA_A_CDC_CLK_MCLK_CTL] = 1,
	[TABLA_A_CDC_CLK_PDM_CTL] = 1,
	[TABLA_A_CDC_CLK_SD_CTL] = 1,
	[TABLA_A_CDC_CLSG_FREQ_THRESH_B1_CTL] = 1,
	[TABLA_A_CDC_CLSG_FREQ_THRESH_B2_CTL] = 1,
	[TABLA_A_CDC_CLSG_FREQ_THRESH_B3_CTL] = 1,
	[TABLA_A_CDC_CLSG_FREQ_THRESH_B4_CTL] = 1,
	[TABLA_A_CDC_CLSG_GAIN_THRESH_CTL] = 1,
	[TABLA_A_CDC_CLSG_TIMER_B1_CFG] = 1,
	[TABLA_A_CDC_CLSG_TIMER_B2_CFG] = 1,
	[TABLA_A_CDC_CLSG_CTL] = 1,
	[TABLA_A_CDC_IIR1_GAIN_B1_CTL] = 1,
	[TABLA_A_CDC_IIR2_GAIN_B1_CTL] = 1,
	[TABLA_A_CDC_IIR1_GAIN_B2_CTL] = 1,
	[TABLA_A_CDC_IIR2_GAIN_B2_CTL] = 1,
	[TABLA_A_CDC_IIR1_GAIN_B3_CTL] = 1,
	[TABLA_A_CDC_IIR2_GAIN_B3_CTL] = 1,
	[TABLA_A_CDC_IIR1_GAIN_B4_CTL] = 1,
	[TABLA_A_CDC_IIR2_GAIN_B4_CTL] = 1,
	[TABLA_A_CDC_IIR1_GAIN_B5_CTL] = 1,
	[TABLA_A_CDC_IIR2_GAIN_B5_CTL] = 1,
	[TABLA_A_CDC_IIR1_GAIN_B6_CTL] = 1,
	[TABLA_A_CDC_IIR2_GAIN_B6_CTL] = 1,
	[TABLA_A_CDC_IIR1_GAIN_B7_CTL] = 1,
	[TABLA_A_CDC_IIR2_GAIN_B7_CTL] = 1,
	[TABLA_A_CDC_IIR1_GAIN_B8_CTL] = 1,
	[TABLA_A_CDC_IIR2_GAIN_B8_CTL] = 1,
	[TABLA_A_CDC_IIR1_CTL] = 1,
	[TABLA_A_CDC_IIR2_CTL] = 1,
	[TABLA_A_CDC_IIR1_GAIN_TIMER_CTL] = 1,
	[TABLA_A_CDC_IIR2_GAIN_TIMER_CTL] = 1,
	[TABLA_A_CDC_IIR1_COEF_B1_CTL] = 1,
	[TABLA_A_CDC_IIR2_COEF_B1_CTL] = 1,
	[TABLA_A_CDC_IIR1_COEF_B2_CTL] = 1,
	[TABLA_A_CDC_IIR2_COEF_B2_CTL] = 1,
	[TABLA_A_CDC_IIR1_COEF_B3_CTL] = 1,
	[TABLA_A_CDC_IIR2_COEF_B3_CTL] = 1,
	[TABLA_A_CDC_IIR1_COEF_B4_CTL] = 1,
	[TABLA_A_CDC_IIR2_COEF_B4_CTL] = 1,
	[TABLA_A_CDC_IIR1_COEF_B5_CTL] = 1,
	[TABLA_A_CDC_IIR2_COEF_B5_CTL] = 1,
	[TABLA_A_CDC_TOP_GAIN_UPDATE] = 1,
	[TABLA_A_CDC_DEBUG_B1_CTL] = 1,
	[TABLA_A_CDC_DEBUG_B2_CTL] = 1,
	[TABLA_A_CDC_DEBUG_B3_CTL] = 1,
	[TABLA_A_CDC_DEBUG_B4_CTL] = 1,
	[TABLA_A_CDC_DEBUG_B5_CTL] = 1,
	[TABLA_A_CDC_DEBUG_B6_CTL] = 1,
	[TABLA_A_CDC_COMP1_B1_CTL] = 1,
	[TABLA_A_CDC_COMP1_B2_CTL] = 1,
	[TABLA_A_CDC_COMP1_B3_CTL] = 1,
	[TABLA_A_CDC_COMP1_B4_CTL] = 1,
	[TABLA_A_CDC_COMP1_B5_CTL] = 1,
	[TABLA_A_CDC_COMP1_B6_CTL] = 1,
	[TABLA_A_CDC_COMP1_SHUT_DOWN_STATUS] = 1,
	[TABLA_A_CDC_COMP1_FS_CFG] = 1,
	[TABLA_A_CDC_COMP2_B1_CTL] = 1,
	[TABLA_A_CDC_COMP2_B2_CTL] = 1,
	[TABLA_A_CDC_COMP2_B3_CTL] = 1,
	[TABLA_A_CDC_COMP2_B4_CTL] = 1,
	[TABLA_A_CDC_COMP2_B5_CTL] = 1,
	[TABLA_A_CDC_COMP2_B6_CTL] = 1,
	[TABLA_A_CDC_COMP2_SHUT_DOWN_STATUS] = 1,
	[TABLA_A_CDC_COMP2_FS_CFG] = 1,
	[TABLA_A_CDC_CONN_RX1_B1_CTL] = 1,
	[TABLA_A_CDC_CONN_RX1_B2_CTL] = 1,
	[TABLA_A_CDC_CONN_RX1_B3_CTL] = 1,
	[TABLA_A_CDC_CONN_RX2_B1_CTL] = 1,
	[TABLA_A_CDC_CONN_RX2_B2_CTL] = 1,
	[TABLA_A_CDC_CONN_RX2_B3_CTL] = 1,
	[TABLA_A_CDC_CONN_RX3_B1_CTL] = 1,
	[TABLA_A_CDC_CONN_RX3_B2_CTL] = 1,
	[TABLA_A_CDC_CONN_RX3_B3_CTL] = 1,
	[TABLA_A_CDC_CONN_RX4_B1_CTL] = 1,
	[TABLA_A_CDC_CONN_RX4_B2_CTL] = 1,
	[TABLA_A_CDC_CONN_RX5_B1_CTL] = 1,
	[TABLA_A_CDC_CONN_RX5_B2_CTL] = 1,
	[TABLA_A_CDC_CONN_RX6_B1_CTL] = 1,
	[TABLA_A_CDC_CONN_RX6_B2_CTL] = 1,
	[TABLA_A_CDC_CONN_RX7_B1_CTL] = 1,
	[TABLA_A_CDC_CONN_RX7_B2_CTL] = 1,
	[TABLA_A_CDC_CONN_ANC_B1_CTL] = 1,
	[TABLA_A_CDC_CONN_ANC_B2_CTL] = 1,
	[TABLA_A_CDC_CONN_TX_B1_CTL] = 1,
	[TABLA_A_CDC_CONN_TX_B2_CTL] = 1,
	[TABLA_A_CDC_CONN_TX_B3_CTL] = 1,
	[TABLA_A_CDC_CONN_TX_B4_CTL] = 1,
	[TABLA_A_CDC_CONN_EQ1_B1_CTL] = 1,
	[TABLA_A_CDC_CONN_EQ1_B2_CTL] = 1,
	[TABLA_A_CDC_CONN_EQ1_B3_CTL] = 1,
	[TABLA_A_CDC_CONN_EQ1_B4_CTL] = 1,
	[TABLA_A_CDC_CONN_EQ2_B1_CTL] = 1,
	[TABLA_A_CDC_CONN_EQ2_B2_CTL] = 1,
	[TABLA_A_CDC_CONN_EQ2_B3_CTL] = 1,
	[TABLA_A_CDC_CONN_EQ2_B4_CTL] = 1,
	[TABLA_A_CDC_CONN_SRC1_B1_CTL] = 1,
	[TABLA_A_CDC_CONN_SRC1_B2_CTL] = 1,
	[TABLA_A_CDC_CONN_SRC2_B1_CTL] = 1,
	[TABLA_A_CDC_CONN_SRC2_B2_CTL] = 1,
	[TABLA_A_CDC_CONN_TX_SB_B1_CTL] = 1,
	[TABLA_A_CDC_CONN_TX_SB_B2_CTL] = 1,
	[TABLA_A_CDC_CONN_TX_SB_B3_CTL] = 1,
	[TABLA_A_CDC_CONN_TX_SB_B4_CTL] = 1,
	[TABLA_A_CDC_CONN_TX_SB_B5_CTL] = 1,
	[TABLA_A_CDC_CONN_TX_SB_B6_CTL] = 1,
	[TABLA_A_CDC_CONN_TX_SB_B7_CTL] = 1,
	[TABLA_A_CDC_CONN_TX_SB_B8_CTL] = 1,
	[TABLA_A_CDC_CONN_TX_SB_B9_CTL] = 1,
	[TABLA_A_CDC_CONN_TX_SB_B10_CTL] = 1,
	[TABLA_A_CDC_CONN_TX_SB_B11_CTL] = 1,
	[TABLA_A_CDC_CONN_RX_SB_B1_CTL] = 1,
	[TABLA_A_CDC_CONN_RX_SB_B2_CTL] = 1,
	[TABLA_A_CDC_CONN_CLSG_CTL] = 1,
	[TABLA_A_CDC_CONN_SPARE] = 1,
	[TABLA_A_CDC_MBHC_EN_CTL] = 1,
	[TABLA_A_CDC_MBHC_FEATURE_B1_CFG] = 1,
	[TABLA_A_CDC_MBHC_FEATURE_B2_CFG] = 1,
	[TABLA_A_CDC_MBHC_TIMER_B1_CTL] = 1,
	[TABLA_A_CDC_MBHC_TIMER_B2_CTL] = 1,
	[TABLA_A_CDC_MBHC_TIMER_B3_CTL] = 1,
	[TABLA_A_CDC_MBHC_TIMER_B4_CTL] = 1,
	[TABLA_A_CDC_MBHC_TIMER_B5_CTL] = 1,
	[TABLA_A_CDC_MBHC_TIMER_B6_CTL] = 1,
	[TABLA_A_CDC_MBHC_B1_STATUS] = 1,
	[TABLA_A_CDC_MBHC_B2_STATUS] = 1,
	[TABLA_A_CDC_MBHC_B3_STATUS] = 1,
	[TABLA_A_CDC_MBHC_B4_STATUS] = 1,
	[TABLA_A_CDC_MBHC_B5_STATUS] = 1,
	[TABLA_A_CDC_MBHC_B1_CTL] = 1,
	[TABLA_A_CDC_MBHC_B2_CTL] = 1,
	[TABLA_A_CDC_MBHC_VOLT_B1_CTL] = 1,
	[TABLA_A_CDC_MBHC_VOLT_B2_CTL] = 1,
	[TABLA_A_CDC_MBHC_VOLT_B3_CTL] = 1,
	[TABLA_A_CDC_MBHC_VOLT_B4_CTL] = 1,
	[TABLA_A_CDC_MBHC_VOLT_B5_CTL] = 1,
	[TABLA_A_CDC_MBHC_VOLT_B6_CTL] = 1,
	[TABLA_A_CDC_MBHC_VOLT_B7_CTL] = 1,
	[TABLA_A_CDC_MBHC_VOLT_B8_CTL] = 1,
	[TABLA_A_CDC_MBHC_VOLT_B9_CTL] = 1,
	[TABLA_A_CDC_MBHC_VOLT_B10_CTL] = 1,
	[TABLA_A_CDC_MBHC_VOLT_B11_CTL] = 1,
	[TABLA_A_CDC_MBHC_VOLT_B12_CTL] = 1,
	[TABLA_A_CDC_MBHC_CLK_CTL] = 1,
	[TABLA_A_CDC_MBHC_INT_CTL] = 1,
	[TABLA_A_CDC_MBHC_DEBUG_CTL] = 1,
	[TABLA_A_CDC_MBHC_SPARE] = 1,
};

const unsigned int tabla_1_reg_readable[TABLA_1_X_ONLY_REGISTERS] = {
	TABLA_1_A_MICB_4_CTL,
	TABLA_1_A_MICB_4_INT_RBIAS,
	TABLA_1_A_MICB_4_MBHC,
};

const unsigned int tabla_2_reg_readable[TABLA_2_HIGHER_ONLY_REGISTERS] = {
	TABLA_2_A_MICB_4_CTL,
	TABLA_2_A_MICB_4_INT_RBIAS,
	TABLA_2_A_MICB_4_MBHC,
};

const u8 tabla_reg_defaults[TABLA_CACHE_SIZE] = {
	[TABLA_A_CHIP_CTL] = TABLA_A_CHIP_CTL__POR,
	[TABLA_A_CHIP_STATUS] = TABLA_A_CHIP_STATUS__POR,
	[TABLA_A_CHIP_ID_BYTE_0] = TABLA_A_CHIP_ID_BYTE_0__POR,
	[TABLA_A_CHIP_ID_BYTE_1] = TABLA_A_CHIP_ID_BYTE_1__POR,
	[TABLA_A_CHIP_ID_BYTE_2] = TABLA_A_CHIP_ID_BYTE_2__POR,
	[TABLA_A_CHIP_ID_BYTE_3] = TABLA_A_CHIP_ID_BYTE_3__POR,
	[TABLA_A_CHIP_VERSION] = TABLA_A_CHIP_VERSION__POR,
	[TABLA_A_SB_VERSION] = TABLA_A_SB_VERSION__POR,
	[TABLA_A_SLAVE_ID_1] = TABLA_A_SLAVE_ID_1__POR,
	[TABLA_A_SLAVE_ID_2] = TABLA_A_SLAVE_ID_2__POR,
	[TABLA_A_SLAVE_ID_3] = TABLA_A_SLAVE_ID_3__POR,
	[TABLA_A_PIN_CTL_OE0] = TABLA_A_PIN_CTL_OE0__POR,
	[TABLA_A_PIN_CTL_OE1] = TABLA_A_PIN_CTL_OE1__POR,
	[TABLA_A_PIN_CTL_DATA0] = TABLA_A_PIN_CTL_DATA0__POR,
	[TABLA_A_PIN_CTL_DATA1] = TABLA_A_PIN_CTL_DATA1__POR,
	[TABLA_A_HDRIVE_GENERIC] = TABLA_A_HDRIVE_GENERIC__POR,
	[TABLA_A_HDRIVE_OVERRIDE] = TABLA_A_HDRIVE_OVERRIDE__POR,
	[TABLA_A_ANA_CSR_WAIT_STATE] = TABLA_A_ANA_CSR_WAIT_STATE__POR,
	[TABLA_A_PROCESS_MONITOR_CTL0] = TABLA_A_PROCESS_MONITOR_CTL0__POR,
	[TABLA_A_PROCESS_MONITOR_CTL1] = TABLA_A_PROCESS_MONITOR_CTL1__POR,
	[TABLA_A_PROCESS_MONITOR_CTL2] = TABLA_A_PROCESS_MONITOR_CTL2__POR,
	[TABLA_A_PROCESS_MONITOR_CTL3] = TABLA_A_PROCESS_MONITOR_CTL3__POR,
	[TABLA_A_QFUSE_CTL] = TABLA_A_QFUSE_CTL__POR,
	[TABLA_A_QFUSE_STATUS] = TABLA_A_QFUSE_STATUS__POR,
	[TABLA_A_QFUSE_DATA_OUT0] = TABLA_A_QFUSE_DATA_OUT0__POR,
	[TABLA_A_QFUSE_DATA_OUT1] = TABLA_A_QFUSE_DATA_OUT1__POR,
	[TABLA_A_QFUSE_DATA_OUT2] = TABLA_A_QFUSE_DATA_OUT2__POR,
	[TABLA_A_QFUSE_DATA_OUT3] = TABLA_A_QFUSE_DATA_OUT3__POR,
	[TABLA_A_CDC_CTL] = TABLA_A_CDC_CTL__POR,
	[TABLA_A_LEAKAGE_CTL] = TABLA_A_LEAKAGE_CTL__POR,
	[TABLA_A_INTR_MODE] = TABLA_A_INTR_MODE__POR,
	[TABLA_A_INTR_MASK0] = TABLA_A_INTR_MASK0__POR,
	[TABLA_A_INTR_MASK1] = TABLA_A_INTR_MASK1__POR,
	[TABLA_A_INTR_MASK2] = TABLA_A_INTR_MASK2__POR,
	[TABLA_A_INTR_STATUS0] = TABLA_A_INTR_STATUS0__POR,
	[TABLA_A_INTR_STATUS1] = TABLA_A_INTR_STATUS1__POR,
	[TABLA_A_INTR_STATUS2] = TABLA_A_INTR_STATUS2__POR,
	[TABLA_A_INTR_CLEAR0] = TABLA_A_INTR_CLEAR0__POR,
	[TABLA_A_INTR_CLEAR1] = TABLA_A_INTR_CLEAR1__POR,
	[TABLA_A_INTR_CLEAR2] = TABLA_A_INTR_CLEAR2__POR,
	[TABLA_A_INTR_LEVEL0] = TABLA_A_INTR_LEVEL0__POR,
	[TABLA_A_INTR_LEVEL1] = TABLA_A_INTR_LEVEL1__POR,
	[TABLA_A_INTR_LEVEL2] = TABLA_A_INTR_LEVEL2__POR,
	[TABLA_A_INTR_TEST0] = TABLA_A_INTR_TEST0__POR,
	[TABLA_A_INTR_TEST1] = TABLA_A_INTR_TEST1__POR,
	[TABLA_A_INTR_TEST2] = TABLA_A_INTR_TEST2__POR,
	[TABLA_A_INTR_SET0] = TABLA_A_INTR_SET0__POR,
	[TABLA_A_INTR_SET1] = TABLA_A_INTR_SET1__POR,
	[TABLA_A_INTR_SET2] = TABLA_A_INTR_SET2__POR,
	[TABLA_A_CDC_TX_I2S_SCK_MODE] = TABLA_A_CDC_TX_I2S_SCK_MODE__POR,
	[TABLA_A_CDC_TX_I2S_WS_MODE] = TABLA_A_CDC_TX_I2S_WS_MODE__POR,
	[TABLA_A_CDC_DMIC_DATA0_MODE] = TABLA_A_CDC_DMIC_DATA0_MODE__POR,
	[TABLA_A_CDC_DMIC_CLK0_MODE] = TABLA_A_CDC_DMIC_CLK0_MODE__POR,
	[TABLA_A_CDC_DMIC_DATA1_MODE] = TABLA_A_CDC_DMIC_DATA1_MODE__POR,
	[TABLA_A_CDC_DMIC_CLK1_MODE] = TABLA_A_CDC_DMIC_CLK1_MODE__POR,
	[TABLA_A_CDC_RX_I2S_SCK_MODE] = TABLA_A_CDC_RX_I2S_SCK_MODE__POR,
	[TABLA_A_CDC_RX_I2S_WS_MODE] = TABLA_A_CDC_RX_I2S_WS_MODE__POR,
	[TABLA_A_CDC_DMIC_DATA2_MODE] = TABLA_A_CDC_DMIC_DATA2_MODE__POR,
	[TABLA_A_CDC_DMIC_CLK2_MODE] = TABLA_A_CDC_DMIC_CLK2_MODE__POR,
	[TABLA_A_CDC_INTR_MODE] = TABLA_A_CDC_INTR_MODE__POR,
	[TABLA_A_BIAS_REF_CTL] = TABLA_A_BIAS_REF_CTL__POR,
	[TABLA_A_BIAS_CENTRAL_BG_CTL] = TABLA_A_BIAS_CENTRAL_BG_CTL__POR,
	[TABLA_A_BIAS_PRECHRG_CTL] = TABLA_A_BIAS_PRECHRG_CTL__POR,
	[TABLA_A_BIAS_CURR_CTL_1] = TABLA_A_BIAS_CURR_CTL_1__POR,
	[TABLA_A_BIAS_CURR_CTL_2] = TABLA_A_BIAS_CURR_CTL_2__POR,
	[TABLA_A_BIAS_CONFIG_MODE_BG_CTL] =
		TABLA_A_BIAS_CONFIG_MODE_BG_CTL__POR,
	[TABLA_A_BIAS_BG_STATUS] = TABLA_A_BIAS_BG_STATUS__POR,
	[TABLA_A_CLK_BUFF_EN1] = TABLA_A_CLK_BUFF_EN1__POR,
	[TABLA_A_CLK_BUFF_EN2] = TABLA_A_CLK_BUFF_EN2__POR,
	[TABLA_A_LDO_H_MODE_1] = TABLA_A_LDO_H_MODE_1__POR,
	[TABLA_A_LDO_H_MODE_2] = TABLA_A_LDO_H_MODE_2__POR,
	[TABLA_A_LDO_H_LOOP_CTL] = TABLA_A_LDO_H_LOOP_CTL__POR,
	[TABLA_A_LDO_H_COMP_1] = TABLA_A_LDO_H_COMP_1__POR,
	[TABLA_A_LDO_H_COMP_2] = TABLA_A_LDO_H_COMP_2__POR,
	[TABLA_A_LDO_H_BIAS_1] = TABLA_A_LDO_H_BIAS_1__POR,
	[TABLA_A_LDO_H_BIAS_2] = TABLA_A_LDO_H_BIAS_2__POR,
	[TABLA_A_LDO_H_BIAS_3] = TABLA_A_LDO_H_BIAS_3__POR,
	[TABLA_A_LDO_L_MODE_1] = TABLA_A_LDO_L_MODE_1__POR,
	[TABLA_A_LDO_L_MODE_2] = TABLA_A_LDO_L_MODE_2__POR,
	[TABLA_A_LDO_L_LOOP_CTL] = TABLA_A_LDO_L_LOOP_CTL__POR,
	[TABLA_A_LDO_L_COMP_1] = TABLA_A_LDO_L_COMP_1__POR,
	[TABLA_A_LDO_L_COMP_2] = TABLA_A_LDO_L_COMP_2__POR,
	[TABLA_A_LDO_L_BIAS_1] = TABLA_A_LDO_L_BIAS_1__POR,
	[TABLA_A_LDO_L_BIAS_2] = TABLA_A_LDO_L_BIAS_2__POR,
	[TABLA_A_LDO_L_BIAS_3] = TABLA_A_LDO_L_BIAS_3__POR,
	[TABLA_A_MICB_CFILT_1_CTL] = TABLA_A_MICB_CFILT_1_CTL__POR,
	[TABLA_A_MICB_CFILT_1_VAL] = TABLA_A_MICB_CFILT_1_VAL__POR,
	[TABLA_A_MICB_CFILT_1_PRECHRG] = TABLA_A_MICB_CFILT_1_PRECHRG__POR,
	[TABLA_A_MICB_1_CTL] = TABLA_A_MICB_1_CTL__POR,
	[TABLA_A_MICB_1_INT_RBIAS] = TABLA_A_MICB_1_INT_RBIAS__POR,
	[TABLA_A_MICB_1_MBHC] = TABLA_A_MICB_1_MBHC__POR,
	[TABLA_A_MICB_CFILT_2_CTL] = TABLA_A_MICB_CFILT_2_CTL__POR,
	[TABLA_A_MICB_CFILT_2_VAL] = TABLA_A_MICB_CFILT_2_VAL__POR,
	[TABLA_A_MICB_CFILT_2_PRECHRG] = TABLA_A_MICB_CFILT_2_PRECHRG__POR,
	[TABLA_A_MICB_2_CTL] = TABLA_A_MICB_2_CTL__POR,
	[TABLA_A_MICB_2_INT_RBIAS] = TABLA_A_MICB_2_INT_RBIAS__POR,
	[TABLA_A_MICB_2_MBHC] = TABLA_A_MICB_2_MBHC__POR,
	[TABLA_A_MICB_CFILT_3_CTL] = TABLA_A_MICB_CFILT_3_CTL__POR,
	[TABLA_A_MICB_CFILT_3_VAL] = TABLA_A_MICB_CFILT_3_VAL__POR,
	[TABLA_A_MICB_CFILT_3_PRECHRG] = TABLA_A_MICB_CFILT_3_PRECHRG__POR,
	[TABLA_A_MICB_3_CTL] = TABLA_A_MICB_3_CTL__POR,
	[TABLA_A_MICB_3_INT_RBIAS] = TABLA_A_MICB_3_INT_RBIAS__POR,
	[TABLA_A_MICB_3_MBHC] = TABLA_A_MICB_3_MBHC__POR,
	[TABLA_1_A_MICB_4_CTL] = TABLA_A_MICB_4_CTL__POR,
	[TABLA_1_A_MICB_4_INT_RBIAS] = TABLA_A_MICB_4_INT_RBIAS__POR,
	[TABLA_1_A_MICB_4_MBHC] = TABLA_A_MICB_4_MBHC__POR,
	[TABLA_2_A_MICB_4_CTL] = TABLA_A_MICB_4_CTL__POR,
	[TABLA_2_A_MICB_4_INT_RBIAS] = TABLA_A_MICB_4_INT_RBIAS__POR,
	[TABLA_2_A_MICB_4_MBHC] = TABLA_A_MICB_4_MBHC__POR,
	[TABLA_A_TX_COM_BIAS] = TABLA_A_TX_COM_BIAS__POR,
	[TABLA_A_MBHC_SCALING_MUX_1] = TABLA_A_MBHC_SCALING_MUX_1__POR,
	[TABLA_A_MBHC_SCALING_MUX_2] = TABLA_A_MBHC_SCALING_MUX_2__POR,
	[TABLA_A_TX_SUP_SWITCH_CTRL_1] = TABLA_A_TX_SUP_SWITCH_CTRL_1__POR,
	[TABLA_A_TX_SUP_SWITCH_CTRL_2] = TABLA_A_TX_SUP_SWITCH_CTRL_2__POR,
	[TABLA_A_TX_1_2_EN] = TABLA_A_TX_1_2_EN__POR,
	[TABLA_A_TX_1_2_TEST_EN] = TABLA_A_TX_1_2_TEST_EN__POR,
	[TABLA_A_TX_1_2_ADC_CH1] = TABLA_A_TX_1_2_ADC_CH1__POR,
	[TABLA_A_TX_1_2_ADC_CH2] = TABLA_A_TX_1_2_ADC_CH2__POR,
	[TABLA_A_TX_1_2_ATEST_REFCTRL] = TABLA_A_TX_1_2_ATEST_REFCTRL__POR,
	[TABLA_A_TX_1_2_TEST_CTL] = TABLA_A_TX_1_2_TEST_CTL__POR,
	[TABLA_A_TX_1_2_TEST_BLOCK_EN] = TABLA_A_TX_1_2_TEST_BLOCK_EN__POR,
	[TABLA_A_TX_1_2_TXFE_CLKDIV] = TABLA_A_TX_1_2_TXFE_CLKDIV__POR,
	[TABLA_A_TX_1_2_SAR_ERR_CH1] = TABLA_A_TX_1_2_SAR_ERR_CH1__POR,
	[TABLA_A_TX_1_2_SAR_ERR_CH2] = TABLA_A_TX_1_2_SAR_ERR_CH2__POR,
	[TABLA_A_TX_3_4_EN] = TABLA_A_TX_3_4_EN__POR,
	[TABLA_A_TX_3_4_TEST_EN] = TABLA_A_TX_3_4_TEST_EN__POR,
	[TABLA_A_TX_3_4_ADC_CH3] = TABLA_A_TX_3_4_ADC_CH3__POR,
	[TABLA_A_TX_3_4_ADC_CH4] = TABLA_A_TX_3_4_ADC_CH4__POR,
	[TABLA_A_TX_3_4_ATEST_REFCTRL] = TABLA_A_TX_3_4_ATEST_REFCTRL__POR,
	[TABLA_A_TX_3_4_TEST_CTL] = TABLA_A_TX_3_4_TEST_CTL__POR,
	[TABLA_A_TX_3_4_TEST_BLOCK_EN] = TABLA_A_TX_3_4_TEST_BLOCK_EN__POR,
	[TABLA_A_TX_3_4_TXFE_CKDIV] = TABLA_A_TX_3_4_TXFE_CKDIV__POR,
	[TABLA_A_TX_3_4_SAR_ERR_CH3] = TABLA_A_TX_3_4_SAR_ERR_CH3__POR,
	[TABLA_A_TX_3_4_SAR_ERR_CH4] = TABLA_A_TX_3_4_SAR_ERR_CH4__POR,
	[TABLA_A_TX_5_6_EN] = TABLA_A_TX_5_6_EN__POR,
	[TABLA_A_TX_5_6_TEST_EN] = TABLA_A_TX_5_6_TEST_EN__POR,
	[TABLA_A_TX_5_6_ADC_CH5] = TABLA_A_TX_5_6_ADC_CH5__POR,
	[TABLA_A_TX_5_6_ADC_CH6] = TABLA_A_TX_5_6_ADC_CH6__POR,
	[TABLA_A_TX_5_6_ATEST_REFCTRL] = TABLA_A_TX_5_6_ATEST_REFCTRL__POR,
	[TABLA_A_TX_5_6_TEST_CTL] = TABLA_A_TX_5_6_TEST_CTL__POR,
	[TABLA_A_TX_5_6_TEST_BLOCK_EN] = TABLA_A_TX_5_6_TEST_BLOCK_EN__POR,
	[TABLA_A_TX_5_6_TXFE_CKDIV] = TABLA_A_TX_5_6_TXFE_CKDIV__POR,
	[TABLA_A_TX_5_6_SAR_ERR_CH5] = TABLA_A_TX_5_6_SAR_ERR_CH5__POR,
	[TABLA_A_TX_5_6_SAR_ERR_CH6] = TABLA_A_TX_5_6_SAR_ERR_CH6__POR,
	[TABLA_A_TX_7_MBHC_EN] = TABLA_A_TX_7_MBHC_EN__POR,
	[TABLA_A_TX_7_MBHC_ATEST_REFCTRL] =
		TABLA_A_TX_7_MBHC_ATEST_REFCTRL__POR,
	[TABLA_A_TX_7_MBHC_ADC] = TABLA_A_TX_7_MBHC_ADC__POR,
	[TABLA_A_TX_7_MBHC_TEST_CTL] = TABLA_A_TX_7_MBHC_TEST_CTL__POR,
	[TABLA_A_TX_7_MBHC_SAR_ERR] = TABLA_A_TX_7_MBHC_SAR_ERR__POR,
	[TABLA_A_TX_7_TXFE_CLKDIV] = TABLA_A_TX_7_TXFE_CLKDIV__POR,
	[TABLA_A_AUX_COM_CTL] = TABLA_A_AUX_COM_CTL__POR,
	[TABLA_A_AUX_COM_ATEST] = TABLA_A_AUX_COM_ATEST__POR,
	[TABLA_A_AUX_L_EN] = TABLA_A_AUX_L_EN__POR,
	[TABLA_A_AUX_L_GAIN] = TABLA_A_AUX_L_GAIN__POR,
	[TABLA_A_AUX_L_PA_CONN] = TABLA_A_AUX_L_PA_CONN__POR,
	[TABLA_A_AUX_L_PA_CONN_INV] = TABLA_A_AUX_L_PA_CONN_INV__POR,
	[TABLA_A_AUX_R_EN] = TABLA_A_AUX_R_EN__POR,
	[TABLA_A_AUX_R_GAIN] = TABLA_A_AUX_R_GAIN__POR,
	[TABLA_A_AUX_R_PA_CONN] = TABLA_A_AUX_R_PA_CONN__POR,
	[TABLA_A_AUX_R_PA_CONN_INV] = TABLA_A_AUX_R_PA_CONN_INV__POR,
	[TABLA_A_CP_EN] = TABLA_A_CP_EN__POR,
	[TABLA_A_CP_CLK] = TABLA_A_CP_CLK__POR,
	[TABLA_A_CP_STATIC] = TABLA_A_CP_STATIC__POR,
	[TABLA_A_CP_DCC1] = TABLA_A_CP_DCC1__POR,
	[TABLA_A_CP_DCC3] = TABLA_A_CP_DCC3__POR,
	[TABLA_A_CP_ATEST] = TABLA_A_CP_ATEST__POR,
	[TABLA_A_CP_DTEST] = TABLA_A_CP_DTEST__POR,
	[TABLA_A_RX_COM_TIMER_DIV] = TABLA_A_RX_COM_TIMER_DIV__POR,
	[TABLA_A_RX_COM_OCP_CTL] = TABLA_A_RX_COM_OCP_CTL__POR,
	[TABLA_A_RX_COM_OCP_COUNT] = TABLA_A_RX_COM_OCP_COUNT__POR,
	[TABLA_A_RX_COM_DAC_CTL] = TABLA_A_RX_COM_DAC_CTL__POR,
	[TABLA_A_RX_COM_BIAS] = TABLA_A_RX_COM_BIAS__POR,
	[TABLA_A_RX_HPH_BIAS_PA] = TABLA_A_RX_HPH_BIAS_PA__POR,
	[TABLA_A_RX_HPH_BIAS_LDO] = TABLA_A_RX_HPH_BIAS_LDO__POR,
	[TABLA_A_RX_HPH_BIAS_CNP] = TABLA_A_RX_HPH_BIAS_CNP__POR,
	[TABLA_A_RX_HPH_BIAS_WG] = TABLA_A_RX_HPH_BIAS_WG__POR,
	[TABLA_A_RX_HPH_OCP_CTL] = TABLA_A_RX_HPH_OCP_CTL__POR,
	[TABLA_A_RX_HPH_CNP_EN] = TABLA_A_RX_HPH_CNP_EN__POR,
	[TABLA_A_RX_HPH_CNP_WG_CTL] = TABLA_A_RX_HPH_CNP_WG_CTL__POR,
	[TABLA_A_RX_HPH_CNP_WG_TIME] = TABLA_A_RX_HPH_CNP_WG_TIME__POR,
	[TABLA_A_RX_HPH_L_GAIN] = TABLA_A_RX_HPH_L_GAIN__POR,
	[TABLA_A_RX_HPH_L_TEST] = TABLA_A_RX_HPH_L_TEST__POR,
	[TABLA_A_RX_HPH_L_PA_CTL] = TABLA_A_RX_HPH_L_PA_CTL__POR,
	[TABLA_A_RX_HPH_L_DAC_CTL] = TABLA_A_RX_HPH_L_DAC_CTL__POR,
	[TABLA_A_RX_HPH_L_ATEST] = TABLA_A_RX_HPH_L_ATEST__POR,
	[TABLA_A_RX_HPH_L_STATUS] = TABLA_A_RX_HPH_L_STATUS__POR,
	[TABLA_A_RX_HPH_R_GAIN] = TABLA_A_RX_HPH_R_GAIN__POR,
	[TABLA_A_RX_HPH_R_TEST] = TABLA_A_RX_HPH_R_TEST__POR,
	[TABLA_A_RX_HPH_R_PA_CTL] = TABLA_A_RX_HPH_R_PA_CTL__POR,
	[TABLA_A_RX_HPH_R_DAC_CTL] = TABLA_A_RX_HPH_R_DAC_CTL__POR,
	[TABLA_A_RX_HPH_R_ATEST] = TABLA_A_RX_HPH_R_ATEST__POR,
	[TABLA_A_RX_HPH_R_STATUS] = TABLA_A_RX_HPH_R_STATUS__POR,
	[TABLA_A_RX_EAR_BIAS_PA] = TABLA_A_RX_EAR_BIAS_PA__POR,
	[TABLA_A_RX_EAR_BIAS_CMBUFF] = TABLA_A_RX_EAR_BIAS_CMBUFF__POR,
	[TABLA_A_RX_EAR_EN] = TABLA_A_RX_EAR_EN__POR,
	[TABLA_A_RX_EAR_GAIN] = TABLA_A_RX_EAR_GAIN__POR,
	[TABLA_A_RX_EAR_CMBUFF] = TABLA_A_RX_EAR_CMBUFF__POR,
	[TABLA_A_RX_EAR_ICTL] = TABLA_A_RX_EAR_ICTL__POR,
	[TABLA_A_RX_EAR_CCOMP] = TABLA_A_RX_EAR_CCOMP__POR,
	[TABLA_A_RX_EAR_VCM] = TABLA_A_RX_EAR_VCM__POR,
	[TABLA_A_RX_EAR_CNP] = TABLA_A_RX_EAR_CNP__POR,
	[TABLA_A_RX_EAR_ATEST] = TABLA_A_RX_EAR_ATEST__POR,
	[TABLA_A_RX_EAR_STATUS] = TABLA_A_RX_EAR_STATUS__POR,
	[TABLA_A_RX_LINE_BIAS_PA] = TABLA_A_RX_LINE_BIAS_PA__POR,
	[TABLA_A_RX_LINE_BIAS_DAC] = TABLA_A_RX_LINE_BIAS_DAC__POR,
	[TABLA_A_RX_LINE_BIAS_CNP] = TABLA_A_RX_LINE_BIAS_CNP__POR,
	[TABLA_A_RX_LINE_COM] = TABLA_A_RX_LINE_COM__POR,
	[TABLA_A_RX_LINE_CNP_EN] = TABLA_A_RX_LINE_CNP_EN__POR,
	[TABLA_A_RX_LINE_CNP_WG_CTL] = TABLA_A_RX_LINE_CNP_WG_CTL__POR,
	[TABLA_A_RX_LINE_CNP_WG_TIME] = TABLA_A_RX_LINE_CNP_WG_TIME__POR,
	[TABLA_A_RX_LINE_1_GAIN] = TABLA_A_RX_LINE_1_GAIN__POR,
	[TABLA_A_RX_LINE_1_TEST] = TABLA_A_RX_LINE_1_TEST__POR,
	[TABLA_A_RX_LINE_1_DAC_CTL] = TABLA_A_RX_LINE_1_DAC_CTL__POR,
	[TABLA_A_RX_LINE_1_STATUS] = TABLA_A_RX_LINE_1_STATUS__POR,
	[TABLA_A_RX_LINE_2_GAIN] = TABLA_A_RX_LINE_2_GAIN__POR,
	[TABLA_A_RX_LINE_2_TEST] = TABLA_A_RX_LINE_2_TEST__POR,
	[TABLA_A_RX_LINE_2_DAC_CTL] = TABLA_A_RX_LINE_2_DAC_CTL__POR,
	[TABLA_A_RX_LINE_2_STATUS] = TABLA_A_RX_LINE_2_STATUS__POR,
	[TABLA_A_RX_LINE_3_GAIN] = TABLA_A_RX_LINE_3_GAIN__POR,
	[TABLA_A_RX_LINE_3_TEST] = TABLA_A_RX_LINE_3_TEST__POR,
	[TABLA_A_RX_LINE_3_DAC_CTL] = TABLA_A_RX_LINE_3_DAC_CTL__POR,
	[TABLA_A_RX_LINE_3_STATUS] = TABLA_A_RX_LINE_3_STATUS__POR,
	[TABLA_A_RX_LINE_4_GAIN] = TABLA_A_RX_LINE_4_GAIN__POR,
	[TABLA_A_RX_LINE_4_TEST] = TABLA_A_RX_LINE_4_TEST__POR,
	[TABLA_A_RX_LINE_4_DAC_CTL] = TABLA_A_RX_LINE_4_DAC_CTL__POR,
	[TABLA_A_RX_LINE_4_STATUS] = TABLA_A_RX_LINE_4_STATUS__POR,
	[TABLA_A_RX_LINE_5_GAIN] = TABLA_A_RX_LINE_5_GAIN__POR,
	[TABLA_A_RX_LINE_5_TEST] = TABLA_A_RX_LINE_5_TEST__POR,
	[TABLA_A_RX_LINE_5_DAC_CTL] = TABLA_A_RX_LINE_5_DAC_CTL__POR,
	[TABLA_A_RX_LINE_5_STATUS] = TABLA_A_RX_LINE_5_STATUS__POR,
	[TABLA_A_RX_LINE_CNP_DBG] = TABLA_A_RX_LINE_CNP_DBG__POR,
	[TABLA_A_MBHC_HPH] = TABLA_A_MBHC_HPH__POR,
	[TABLA_A_CONFIG_MODE_FREQ] = TABLA_A_CONFIG_MODE_FREQ__POR,
	[TABLA_A_CONFIG_MODE_TEST] = TABLA_A_CONFIG_MODE_TEST__POR,
	[TABLA_A_CONFIG_MODE_STATUS] = TABLA_A_CONFIG_MODE_STATUS__POR,
	[TABLA_A_CONFIG_MODE_TUNER] = TABLA_A_CONFIG_MODE_TUNER__POR,
	[TABLA_A_CDC_ANC1_CTL] = TABLA_A_CDC_ANC1_CTL__POR,
	[TABLA_A_CDC_ANC1_SHIFT] = TABLA_A_CDC_ANC1_SHIFT__POR,
	[TABLA_A_CDC_ANC1_FILT1_B1_CTL] = TABLA_A_CDC_ANC1_FILT1_B1_CTL__POR,
	[TABLA_A_CDC_ANC1_FILT1_B2_CTL] = TABLA_A_CDC_ANC1_FILT1_B2_CTL__POR,
	[TABLA_A_CDC_ANC1_FILT1_B3_CTL] = TABLA_A_CDC_ANC1_FILT1_B3_CTL__POR,
	[TABLA_A_CDC_ANC1_FILT1_B4_CTL] = TABLA_A_CDC_ANC1_FILT1_B4_CTL__POR,
	[TABLA_A_CDC_ANC1_FILT2_B1_CTL] = TABLA_A_CDC_ANC1_FILT2_B1_CTL__POR,
	[TABLA_A_CDC_ANC1_FILT2_B2_CTL] = TABLA_A_CDC_ANC1_FILT2_B2_CTL__POR,
	[TABLA_A_CDC_ANC1_FILT2_B3_CTL] = TABLA_A_CDC_ANC1_FILT2_B3_CTL__POR,
	[TABLA_A_CDC_ANC1_SPARE] = TABLA_A_CDC_ANC1_SPARE__POR,
	[TABLA_A_CDC_ANC1_FILT3_CTL] = TABLA_A_CDC_ANC1_FILT3_CTL__POR,
	[TABLA_A_CDC_ANC1_FILT4_CTL] = TABLA_A_CDC_ANC1_FILT4_CTL__POR,
	[TABLA_A_CDC_TX1_VOL_CTL_TIMER] = TABLA_A_CDC_TX1_VOL_CTL_TIMER__POR,
	[TABLA_A_CDC_TX2_VOL_CTL_TIMER] = TABLA_A_CDC_TX2_VOL_CTL_TIMER__POR,
	[TABLA_A_CDC_TX3_VOL_CTL_TIMER] = TABLA_A_CDC_TX3_VOL_CTL_TIMER__POR,
	[TABLA_A_CDC_TX4_VOL_CTL_TIMER] = TABLA_A_CDC_TX4_VOL_CTL_TIMER__POR,
	[TABLA_A_CDC_TX5_VOL_CTL_TIMER] = TABLA_A_CDC_TX5_VOL_CTL_TIMER__POR,
	[TABLA_A_CDC_TX6_VOL_CTL_TIMER] = TABLA_A_CDC_TX6_VOL_CTL_TIMER__POR,
	[TABLA_A_CDC_TX7_VOL_CTL_TIMER] = TABLA_A_CDC_TX7_VOL_CTL_TIMER__POR,
	[TABLA_A_CDC_TX8_VOL_CTL_TIMER] = TABLA_A_CDC_TX8_VOL_CTL_TIMER__POR,
	[TABLA_A_CDC_TX9_VOL_CTL_TIMER] = TABLA_A_CDC_TX9_VOL_CTL_TIMER__POR,
	[TABLA_A_CDC_TX10_VOL_CTL_TIMER] = TABLA_A_CDC_TX10_VOL_CTL_TIMER__POR,
	[TABLA_A_CDC_TX1_VOL_CTL_GAIN] = TABLA_A_CDC_TX1_VOL_CTL_GAIN__POR,
	[TABLA_A_CDC_TX2_VOL_CTL_GAIN] = TABLA_A_CDC_TX2_VOL_CTL_GAIN__POR,
	[TABLA_A_CDC_TX3_VOL_CTL_GAIN] = TABLA_A_CDC_TX3_VOL_CTL_GAIN__POR,
	[TABLA_A_CDC_TX4_VOL_CTL_GAIN] = TABLA_A_CDC_TX4_VOL_CTL_GAIN__POR,
	[TABLA_A_CDC_TX5_VOL_CTL_GAIN] = TABLA_A_CDC_TX5_VOL_CTL_GAIN__POR,
	[TABLA_A_CDC_TX6_VOL_CTL_GAIN] = TABLA_A_CDC_TX6_VOL_CTL_GAIN__POR,
	[TABLA_A_CDC_TX7_VOL_CTL_GAIN] = TABLA_A_CDC_TX7_VOL_CTL_GAIN__POR,
	[TABLA_A_CDC_TX8_VOL_CTL_GAIN] = TABLA_A_CDC_TX8_VOL_CTL_GAIN__POR,
	[TABLA_A_CDC_TX9_VOL_CTL_GAIN] = TABLA_A_CDC_TX9_VOL_CTL_GAIN__POR,
	[TABLA_A_CDC_TX10_VOL_CTL_GAIN] = TABLA_A_CDC_TX10_VOL_CTL_GAIN__POR,
	[TABLA_A_CDC_TX1_VOL_CTL_CFG] = TABLA_A_CDC_TX1_VOL_CTL_CFG__POR,
	[TABLA_A_CDC_TX2_VOL_CTL_CFG] = TABLA_A_CDC_TX2_VOL_CTL_CFG__POR,
	[TABLA_A_CDC_TX3_VOL_CTL_CFG] = TABLA_A_CDC_TX3_VOL_CTL_CFG__POR,
	[TABLA_A_CDC_TX4_VOL_CTL_CFG] = TABLA_A_CDC_TX4_VOL_CTL_CFG__POR,
	[TABLA_A_CDC_TX5_VOL_CTL_CFG] = TABLA_A_CDC_TX5_VOL_CTL_CFG__POR,
	[TABLA_A_CDC_TX6_VOL_CTL_CFG] = TABLA_A_CDC_TX6_VOL_CTL_CFG__POR,
	[TABLA_A_CDC_TX7_VOL_CTL_CFG] = TABLA_A_CDC_TX7_VOL_CTL_CFG__POR,
	[TABLA_A_CDC_TX8_VOL_CTL_CFG] = TABLA_A_CDC_TX8_VOL_CTL_CFG__POR,
	[TABLA_A_CDC_TX9_VOL_CTL_CFG] = TABLA_A_CDC_TX9_VOL_CTL_CFG__POR,
	[TABLA_A_CDC_TX10_VOL_CTL_CFG] = TABLA_A_CDC_TX10_VOL_CTL_CFG__POR,
	[TABLA_A_CDC_TX1_MUX_CTL] = TABLA_A_CDC_TX1_MUX_CTL__POR,
	[TABLA_A_CDC_TX2_MUX_CTL] = TABLA_A_CDC_TX2_MUX_CTL__POR,
	[TABLA_A_CDC_TX3_MUX_CTL] = TABLA_A_CDC_TX3_MUX_CTL__POR,
	[TABLA_A_CDC_TX4_MUX_CTL] = TABLA_A_CDC_TX4_MUX_CTL__POR,
	[TABLA_A_CDC_TX5_MUX_CTL] = TABLA_A_CDC_TX5_MUX_CTL__POR,
	[TABLA_A_CDC_TX6_MUX_CTL] = TABLA_A_CDC_TX6_MUX_CTL__POR,
	[TABLA_A_CDC_TX7_MUX_CTL] = TABLA_A_CDC_TX7_MUX_CTL__POR,
	[TABLA_A_CDC_TX8_MUX_CTL] = TABLA_A_CDC_TX8_MUX_CTL__POR,
	[TABLA_A_CDC_TX9_MUX_CTL] = TABLA_A_CDC_TX9_MUX_CTL__POR,
	[TABLA_A_CDC_TX10_MUX_CTL] = TABLA_A_CDC_TX10_MUX_CTL__POR,
	[TABLA_A_CDC_TX1_CLK_FS_CTL] = TABLA_A_CDC_TX1_CLK_FS_CTL__POR,
	[TABLA_A_CDC_TX2_CLK_FS_CTL] = TABLA_A_CDC_TX2_CLK_FS_CTL__POR,
	[TABLA_A_CDC_TX3_CLK_FS_CTL] = TABLA_A_CDC_TX3_CLK_FS_CTL__POR,
	[TABLA_A_CDC_TX4_CLK_FS_CTL] = TABLA_A_CDC_TX4_CLK_FS_CTL__POR,
	[TABLA_A_CDC_TX5_CLK_FS_CTL] = TABLA_A_CDC_TX5_CLK_FS_CTL__POR,
	[TABLA_A_CDC_TX6_CLK_FS_CTL] = TABLA_A_CDC_TX6_CLK_FS_CTL__POR,
	[TABLA_A_CDC_TX7_CLK_FS_CTL] = TABLA_A_CDC_TX7_CLK_FS_CTL__POR,
	[TABLA_A_CDC_TX8_CLK_FS_CTL] = TABLA_A_CDC_TX8_CLK_FS_CTL__POR,
	[TABLA_A_CDC_TX9_CLK_FS_CTL] = TABLA_A_CDC_TX9_CLK_FS_CTL__POR,
	[TABLA_A_CDC_TX10_CLK_FS_CTL] = TABLA_A_CDC_TX10_CLK_FS_CTL__POR,
	[TABLA_A_CDC_TX1_DMIC_CTL] = TABLA_A_CDC_TX1_DMIC_CTL__POR,
	[TABLA_A_CDC_TX2_DMIC_CTL] = TABLA_A_CDC_TX2_DMIC_CTL__POR,
	[TABLA_A_CDC_TX3_DMIC_CTL] = TABLA_A_CDC_TX3_DMIC_CTL__POR,
	[TABLA_A_CDC_TX4_DMIC_CTL] = TABLA_A_CDC_TX4_DMIC_CTL__POR,
	[TABLA_A_CDC_TX5_DMIC_CTL] = TABLA_A_CDC_TX5_DMIC_CTL__POR,
	[TABLA_A_CDC_TX6_DMIC_CTL] = TABLA_A_CDC_TX6_DMIC_CTL__POR,
	[TABLA_A_CDC_TX7_DMIC_CTL] = TABLA_A_CDC_TX7_DMIC_CTL__POR,
	[TABLA_A_CDC_TX8_DMIC_CTL] = TABLA_A_CDC_TX8_DMIC_CTL__POR,
	[TABLA_A_CDC_TX9_DMIC_CTL] = TABLA_A_CDC_TX9_DMIC_CTL__POR,
	[TABLA_A_CDC_TX10_DMIC_CTL] = TABLA_A_CDC_TX10_DMIC_CTL__POR,
	[TABLA_A_CDC_SRC1_PDA_CFG] = TABLA_A_CDC_SRC1_PDA_CFG__POR,
	[TABLA_A_CDC_SRC2_PDA_CFG] = TABLA_A_CDC_SRC2_PDA_CFG__POR,
	[TABLA_A_CDC_SRC1_FS_CTL] = TABLA_A_CDC_SRC1_FS_CTL__POR,
	[TABLA_A_CDC_SRC2_FS_CTL] = TABLA_A_CDC_SRC2_FS_CTL__POR,
	[TABLA_A_CDC_RX1_B1_CTL] = TABLA_A_CDC_RX1_B1_CTL__POR,
	[TABLA_A_CDC_RX2_B1_CTL] = TABLA_A_CDC_RX2_B1_CTL__POR,
	[TABLA_A_CDC_RX3_B1_CTL] = TABLA_A_CDC_RX3_B1_CTL__POR,
	[TABLA_A_CDC_RX4_B1_CTL] = TABLA_A_CDC_RX4_B1_CTL__POR,
	[TABLA_A_CDC_RX5_B1_CTL] = TABLA_A_CDC_RX5_B1_CTL__POR,
	[TABLA_A_CDC_RX6_B1_CTL] = TABLA_A_CDC_RX6_B1_CTL__POR,
	[TABLA_A_CDC_RX7_B1_CTL] = TABLA_A_CDC_RX7_B1_CTL__POR,
	[TABLA_A_CDC_RX1_B2_CTL] = TABLA_A_CDC_RX1_B2_CTL__POR,
	[TABLA_A_CDC_RX2_B2_CTL] = TABLA_A_CDC_RX2_B2_CTL__POR,
	[TABLA_A_CDC_RX3_B2_CTL] = TABLA_A_CDC_RX3_B2_CTL__POR,
	[TABLA_A_CDC_RX4_B2_CTL] = TABLA_A_CDC_RX4_B2_CTL__POR,
	[TABLA_A_CDC_RX5_B2_CTL] = TABLA_A_CDC_RX5_B2_CTL__POR,
	[TABLA_A_CDC_RX6_B2_CTL] = TABLA_A_CDC_RX6_B2_CTL__POR,
	[TABLA_A_CDC_RX7_B2_CTL] = TABLA_A_CDC_RX7_B2_CTL__POR,
	[TABLA_A_CDC_RX1_B3_CTL] = TABLA_A_CDC_RX1_B3_CTL__POR,
	[TABLA_A_CDC_RX2_B3_CTL] = TABLA_A_CDC_RX2_B3_CTL__POR,
	[TABLA_A_CDC_RX3_B3_CTL] = TABLA_A_CDC_RX3_B3_CTL__POR,
	[TABLA_A_CDC_RX4_B3_CTL] = TABLA_A_CDC_RX4_B3_CTL__POR,
	[TABLA_A_CDC_RX5_B3_CTL] = TABLA_A_CDC_RX5_B3_CTL__POR,
	[TABLA_A_CDC_RX6_B3_CTL] = TABLA_A_CDC_RX6_B3_CTL__POR,
	[TABLA_A_CDC_RX7_B3_CTL] = TABLA_A_CDC_RX7_B3_CTL__POR,
	[TABLA_A_CDC_RX1_B4_CTL] = TABLA_A_CDC_RX1_B4_CTL__POR,
	[TABLA_A_CDC_RX2_B4_CTL] = TABLA_A_CDC_RX2_B4_CTL__POR,
	[TABLA_A_CDC_RX3_B4_CTL] = TABLA_A_CDC_RX3_B4_CTL__POR,
	[TABLA_A_CDC_RX4_B4_CTL] = TABLA_A_CDC_RX4_B4_CTL__POR,
	[TABLA_A_CDC_RX5_B4_CTL] = TABLA_A_CDC_RX5_B4_CTL__POR,
	[TABLA_A_CDC_RX6_B4_CTL] = TABLA_A_CDC_RX6_B4_CTL__POR,
	[TABLA_A_CDC_RX7_B4_CTL] = TABLA_A_CDC_RX7_B4_CTL__POR,
	[TABLA_A_CDC_RX1_B5_CTL] = TABLA_A_CDC_RX1_B5_CTL__POR,
	[TABLA_A_CDC_RX2_B5_CTL] = TABLA_A_CDC_RX2_B5_CTL__POR,
	[TABLA_A_CDC_RX3_B5_CTL] = TABLA_A_CDC_RX3_B5_CTL__POR,
	[TABLA_A_CDC_RX4_B5_CTL] = TABLA_A_CDC_RX4_B5_CTL__POR,
	[TABLA_A_CDC_RX5_B5_CTL] = TABLA_A_CDC_RX5_B5_CTL__POR,
	[TABLA_A_CDC_RX6_B5_CTL] = TABLA_A_CDC_RX6_B5_CTL__POR,
	[TABLA_A_CDC_RX7_B5_CTL] = TABLA_A_CDC_RX7_B5_CTL__POR,
	[TABLA_A_CDC_RX1_B6_CTL] = TABLA_A_CDC_RX1_B6_CTL__POR,
	[TABLA_A_CDC_RX2_B6_CTL] = TABLA_A_CDC_RX2_B6_CTL__POR,
	[TABLA_A_CDC_RX3_B6_CTL] = TABLA_A_CDC_RX3_B6_CTL__POR,
	[TABLA_A_CDC_RX4_B6_CTL] = TABLA_A_CDC_RX4_B6_CTL__POR,
	[TABLA_A_CDC_RX5_B6_CTL] = TABLA_A_CDC_RX5_B6_CTL__POR,
	[TABLA_A_CDC_RX6_B6_CTL] = TABLA_A_CDC_RX6_B6_CTL__POR,
	[TABLA_A_CDC_RX7_B6_CTL] = TABLA_A_CDC_RX7_B6_CTL__POR,
	[TABLA_A_CDC_RX1_VOL_CTL_B1_CTL] = TABLA_A_CDC_RX1_VOL_CTL_B1_CTL__POR,
	[TABLA_A_CDC_RX2_VOL_CTL_B1_CTL] = TABLA_A_CDC_RX2_VOL_CTL_B1_CTL__POR,
	[TABLA_A_CDC_RX3_VOL_CTL_B1_CTL] = TABLA_A_CDC_RX3_VOL_CTL_B1_CTL__POR,
	[TABLA_A_CDC_RX4_VOL_CTL_B1_CTL] = TABLA_A_CDC_RX4_VOL_CTL_B1_CTL__POR,
	[TABLA_A_CDC_RX5_VOL_CTL_B1_CTL] = TABLA_A_CDC_RX5_VOL_CTL_B1_CTL__POR,
	[TABLA_A_CDC_RX6_VOL_CTL_B1_CTL] = TABLA_A_CDC_RX6_VOL_CTL_B1_CTL__POR,
	[TABLA_A_CDC_RX7_VOL_CTL_B1_CTL] = TABLA_A_CDC_RX7_VOL_CTL_B1_CTL__POR,
	[TABLA_A_CDC_RX1_VOL_CTL_B2_CTL] = TABLA_A_CDC_RX1_VOL_CTL_B2_CTL__POR,
	[TABLA_A_CDC_RX2_VOL_CTL_B2_CTL] = TABLA_A_CDC_RX2_VOL_CTL_B2_CTL__POR,
	[TABLA_A_CDC_RX3_VOL_CTL_B2_CTL] = TABLA_A_CDC_RX3_VOL_CTL_B2_CTL__POR,
	[TABLA_A_CDC_RX4_VOL_CTL_B2_CTL] = TABLA_A_CDC_RX4_VOL_CTL_B2_CTL__POR,
	[TABLA_A_CDC_RX5_VOL_CTL_B2_CTL] = TABLA_A_CDC_RX5_VOL_CTL_B2_CTL__POR,
	[TABLA_A_CDC_RX6_VOL_CTL_B2_CTL] = TABLA_A_CDC_RX6_VOL_CTL_B2_CTL__POR,
	[TABLA_A_CDC_RX7_VOL_CTL_B2_CTL] = TABLA_A_CDC_RX7_VOL_CTL_B2_CTL__POR,
	[TABLA_A_CDC_CLK_RX_RESET_CTL] = TABLA_A_CDC_CLK_RX_RESET_CTL__POR,
	[TABLA_A_CDC_CLK_ANC_RESET_CTL] = TABLA_A_CDC_CLK_ANC_RESET_CTL__POR,
	[TABLA_A_CDC_CLK_TX_RESET_B1_CTL] =
		TABLA_A_CDC_CLK_TX_RESET_B1_CTL__POR,
	[TABLA_A_CDC_CLK_TX_RESET_B2_CTL] =
		TABLA_A_CDC_CLK_TX_RESET_B2_CTL__POR,
	[TABLA_A_CDC_CLK_DMIC_CTL] = TABLA_A_CDC_CLK_DMIC_CTL__POR,
	[TABLA_A_CDC_CLK_RX_I2S_CTL] = TABLA_A_CDC_CLK_RX_I2S_CTL__POR,
	[TABLA_A_CDC_CLK_TX_I2S_CTL] = TABLA_A_CDC_CLK_TX_I2S_CTL__POR,
	[TABLA_A_CDC_CLK_OTHR_RESET_CTL] = TABLA_A_CDC_CLK_OTHR_RESET_CTL__POR,
	[TABLA_A_CDC_CLK_TX_CLK_EN_B1_CTL] =
		TABLA_A_CDC_CLK_TX_CLK_EN_B1_CTL__POR,
	[TABLA_A_CDC_CLK_TX_CLK_EN_B2_CTL] =
		TABLA_A_CDC_CLK_TX_CLK_EN_B2_CTL__POR,
	[TABLA_A_CDC_CLK_OTHR_CTL] = TABLA_A_CDC_CLK_OTHR_CTL__POR,
	[TABLA_A_CDC_CLK_RDAC_CLK_EN_CTL] =
		TABLA_A_CDC_CLK_RDAC_CLK_EN_CTL__POR,
	[TABLA_A_CDC_CLK_ANC_CLK_EN_CTL] = TABLA_A_CDC_CLK_ANC_CLK_EN_CTL__POR,
	[TABLA_A_CDC_CLK_RX_B1_CTL] = TABLA_A_CDC_CLK_RX_B1_CTL__POR,
	[TABLA_A_CDC_CLK_RX_B2_CTL] = TABLA_A_CDC_CLK_RX_B2_CTL__POR,
	[TABLA_A_CDC_CLK_MCLK_CTL] = TABLA_A_CDC_CLK_MCLK_CTL__POR,
	[TABLA_A_CDC_CLK_PDM_CTL] = TABLA_A_CDC_CLK_PDM_CTL__POR,
	[TABLA_A_CDC_CLK_SD_CTL] = TABLA_A_CDC_CLK_SD_CTL__POR,
	[TABLA_A_CDC_CLSG_FREQ_THRESH_B1_CTL] =
		TABLA_A_CDC_CLSG_FREQ_THRESH_B1_CTL__POR,
	[TABLA_A_CDC_CLSG_FREQ_THRESH_B2_CTL] =
		TABLA_A_CDC_CLSG_FREQ_THRESH_B2_CTL__POR,
	[TABLA_A_CDC_CLSG_FREQ_THRESH_B3_CTL] =
		TABLA_A_CDC_CLSG_FREQ_THRESH_B3_CTL__POR,
	[TABLA_A_CDC_CLSG_FREQ_THRESH_B4_CTL] =
		TABLA_A_CDC_CLSG_FREQ_THRESH_B4_CTL__POR,
	[TABLA_A_CDC_CLSG_GAIN_THRESH_CTL] =
		TABLA_A_CDC_CLSG_GAIN_THRESH_CTL__POR,
	[TABLA_A_CDC_CLSG_TIMER_B1_CFG] = TABLA_A_CDC_CLSG_TIMER_B1_CFG__POR,
	[TABLA_A_CDC_CLSG_TIMER_B2_CFG] = TABLA_A_CDC_CLSG_TIMER_B2_CFG__POR,
	[TABLA_A_CDC_CLSG_CTL] = TABLA_A_CDC_CLSG_CTL__POR,
	[TABLA_A_CDC_IIR1_GAIN_B1_CTL] = TABLA_A_CDC_IIR1_GAIN_B1_CTL__POR,
	[TABLA_A_CDC_IIR2_GAIN_B1_CTL] = TABLA_A_CDC_IIR2_GAIN_B1_CTL__POR,
	[TABLA_A_CDC_IIR1_GAIN_B2_CTL] = TABLA_A_CDC_IIR1_GAIN_B2_CTL__POR,
	[TABLA_A_CDC_IIR2_GAIN_B2_CTL] = TABLA_A_CDC_IIR2_GAIN_B2_CTL__POR,
	[TABLA_A_CDC_IIR1_GAIN_B3_CTL] = TABLA_A_CDC_IIR1_GAIN_B3_CTL__POR,
	[TABLA_A_CDC_IIR2_GAIN_B3_CTL] = TABLA_A_CDC_IIR2_GAIN_B3_CTL__POR,
	[TABLA_A_CDC_IIR1_GAIN_B4_CTL] = TABLA_A_CDC_IIR1_GAIN_B4_CTL__POR,
	[TABLA_A_CDC_IIR2_GAIN_B4_CTL] = TABLA_A_CDC_IIR2_GAIN_B4_CTL__POR,
	[TABLA_A_CDC_IIR1_GAIN_B5_CTL] = TABLA_A_CDC_IIR1_GAIN_B5_CTL__POR,
	[TABLA_A_CDC_IIR2_GAIN_B5_CTL] = TABLA_A_CDC_IIR2_GAIN_B5_CTL__POR,
	[TABLA_A_CDC_IIR1_GAIN_B6_CTL] = TABLA_A_CDC_IIR1_GAIN_B6_CTL__POR,
	[TABLA_A_CDC_IIR2_GAIN_B6_CTL] = TABLA_A_CDC_IIR2_GAIN_B6_CTL__POR,
	[TABLA_A_CDC_IIR1_GAIN_B7_CTL] = TABLA_A_CDC_IIR1_GAIN_B7_CTL__POR,
	[TABLA_A_CDC_IIR2_GAIN_B7_CTL] = TABLA_A_CDC_IIR2_GAIN_B7_CTL__POR,
	[TABLA_A_CDC_IIR1_GAIN_B8_CTL] = TABLA_A_CDC_IIR1_GAIN_B8_CTL__POR,
	[TABLA_A_CDC_IIR2_GAIN_B8_CTL] = TABLA_A_CDC_IIR2_GAIN_B8_CTL__POR,
	[TABLA_A_CDC_IIR1_CTL] = TABLA_A_CDC_IIR1_CTL__POR,
	[TABLA_A_CDC_IIR2_CTL] = TABLA_A_CDC_IIR2_CTL__POR,
	[TABLA_A_CDC_IIR1_GAIN_TIMER_CTL] =
		TABLA_A_CDC_IIR1_GAIN_TIMER_CTL__POR,
	[TABLA_A_CDC_IIR2_GAIN_TIMER_CTL] =
		TABLA_A_CDC_IIR2_GAIN_TIMER_CTL__POR,
	[TABLA_A_CDC_IIR1_COEF_B1_CTL] = TABLA_A_CDC_IIR1_COEF_B1_CTL__POR,
	[TABLA_A_CDC_IIR2_COEF_B1_CTL] = TABLA_A_CDC_IIR2_COEF_B1_CTL__POR,
	[TABLA_A_CDC_IIR1_COEF_B2_CTL] = TABLA_A_CDC_IIR1_COEF_B2_CTL__POR,
	[TABLA_A_CDC_IIR2_COEF_B2_CTL] = TABLA_A_CDC_IIR2_COEF_B2_CTL__POR,
	[TABLA_A_CDC_IIR1_COEF_B3_CTL] = TABLA_A_CDC_IIR1_COEF_B3_CTL__POR,
	[TABLA_A_CDC_IIR2_COEF_B3_CTL] = TABLA_A_CDC_IIR2_COEF_B3_CTL__POR,
	[TABLA_A_CDC_IIR1_COEF_B4_CTL] = TABLA_A_CDC_IIR1_COEF_B4_CTL__POR,
	[TABLA_A_CDC_IIR2_COEF_B4_CTL] = TABLA_A_CDC_IIR2_COEF_B4_CTL__POR,
	[TABLA_A_CDC_IIR1_COEF_B5_CTL] = TABLA_A_CDC_IIR1_COEF_B5_CTL__POR,
	[TABLA_A_CDC_IIR2_COEF_B5_CTL] = TABLA_A_CDC_IIR2_COEF_B5_CTL__POR,
	[TABLA_A_CDC_TOP_GAIN_UPDATE] = TABLA_A_CDC_TOP_GAIN_UPDATE__POR,
	[TABLA_A_CDC_DEBUG_B1_CTL] = TABLA_A_CDC_DEBUG_B1_CTL__POR,
	[TABLA_A_CDC_DEBUG_B2_CTL] = TABLA_A_CDC_DEBUG_B2_CTL__POR,
	[TABLA_A_CDC_DEBUG_B3_CTL] = TABLA_A_CDC_DEBUG_B3_CTL__POR,
	[TABLA_A_CDC_DEBUG_B4_CTL] = TABLA_A_CDC_DEBUG_B4_CTL__POR,
	[TABLA_A_CDC_DEBUG_B5_CTL] = TABLA_A_CDC_DEBUG_B5_CTL__POR,
	[TABLA_A_CDC_DEBUG_B6_CTL] = TABLA_A_CDC_DEBUG_B6_CTL__POR,
	[TABLA_A_CDC_COMP1_B1_CTL] = TABLA_A_CDC_COMP1_B1_CTL__POR,
	[TABLA_A_CDC_COMP1_B2_CTL] = TABLA_A_CDC_COMP1_B2_CTL__POR,
	[TABLA_A_CDC_COMP1_B3_CTL] = TABLA_A_CDC_COMP1_B3_CTL__POR,
	[TABLA_A_CDC_COMP1_B4_CTL] = TABLA_A_CDC_COMP1_B4_CTL__POR,
	[TABLA_A_CDC_COMP1_B5_CTL] = TABLA_A_CDC_COMP1_B5_CTL__POR,
	[TABLA_A_CDC_COMP1_B6_CTL] = TABLA_A_CDC_COMP1_B6_CTL__POR,
	[TABLA_A_CDC_COMP1_SHUT_DOWN_STATUS] =
		TABLA_A_CDC_COMP1_SHUT_DOWN_STATUS__POR,
	[TABLA_A_CDC_COMP1_FS_CFG] = TABLA_A_CDC_COMP1_FS_CFG__POR,
	[TABLA_A_CDC_COMP2_B1_CTL] = TABLA_A_CDC_COMP2_B1_CTL__POR,
	[TABLA_A_CDC_COMP2_B2_CTL] = TABLA_A_CDC_COMP2_B2_CTL__POR,
	[TABLA_A_CDC_COMP2_B3_CTL] = TABLA_A_CDC_COMP2_B3_CTL__POR,
	[TABLA_A_CDC_COMP2_B4_CTL] = TABLA_A_CDC_COMP2_B4_CTL__POR,
	[TABLA_A_CDC_COMP2_B5_CTL] = TABLA_A_CDC_COMP2_B5_CTL__POR,
	[TABLA_A_CDC_COMP2_B6_CTL] = TABLA_A_CDC_COMP2_B6_CTL__POR,
	[TABLA_A_CDC_COMP1_SHUT_DOWN_STATUS] =
		TABLA_A_CDC_COMP1_SHUT_DOWN_STATUS__POR,
	[TABLA_A_CDC_COMP2_FS_CFG] = TABLA_A_CDC_COMP2_FS_CFG__POR,
	[TABLA_A_CDC_CONN_RX1_B1_CTL] = TABLA_A_CDC_CONN_RX1_B1_CTL__POR,
	[TABLA_A_CDC_CONN_RX1_B2_CTL] = TABLA_A_CDC_CONN_RX1_B2_CTL__POR,
	[TABLA_A_CDC_CONN_RX1_B3_CTL] = TABLA_A_CDC_CONN_RX1_B3_CTL__POR,
	[TABLA_A_CDC_CONN_RX2_B1_CTL] = TABLA_A_CDC_CONN_RX2_B1_CTL__POR,
	[TABLA_A_CDC_CONN_RX2_B2_CTL] = TABLA_A_CDC_CONN_RX2_B2_CTL__POR,
	[TABLA_A_CDC_CONN_RX2_B3_CTL] = TABLA_A_CDC_CONN_RX2_B3_CTL__POR,
	[TABLA_A_CDC_CONN_RX3_B1_CTL] = TABLA_A_CDC_CONN_RX3_B1_CTL__POR,
	[TABLA_A_CDC_CONN_RX3_B2_CTL] = TABLA_A_CDC_CONN_RX3_B2_CTL__POR,
	[TABLA_A_CDC_CONN_RX3_B3_CTL] = TABLA_A_CDC_CONN_RX3_B3_CTL__POR,
	[TABLA_A_CDC_CONN_RX4_B1_CTL] = TABLA_A_CDC_CONN_RX4_B1_CTL__POR,
	[TABLA_A_CDC_CONN_RX4_B2_CTL] = TABLA_A_CDC_CONN_RX4_B2_CTL__POR,
	[TABLA_A_CDC_CONN_RX5_B1_CTL] = TABLA_A_CDC_CONN_RX5_B1_CTL__POR,
	[TABLA_A_CDC_CONN_RX5_B2_CTL] = TABLA_A_CDC_CONN_RX5_B2_CTL__POR,
	[TABLA_A_CDC_CONN_RX6_B1_CTL] = TABLA_A_CDC_CONN_RX6_B1_CTL__POR,
	[TABLA_A_CDC_CONN_RX6_B2_CTL] = TABLA_A_CDC_CONN_RX6_B2_CTL__POR,
	[TABLA_A_CDC_CONN_RX7_B1_CTL] = TABLA_A_CDC_CONN_RX7_B1_CTL__POR,
	[TABLA_A_CDC_CONN_RX7_B2_CTL] = TABLA_A_CDC_CONN_RX7_B2_CTL__POR,
	[TABLA_A_CDC_CONN_ANC_B1_CTL] = TABLA_A_CDC_CONN_ANC_B1_CTL__POR,
	[TABLA_A_CDC_CONN_ANC_B2_CTL] = TABLA_A_CDC_CONN_ANC_B2_CTL__POR,
	[TABLA_A_CDC_CONN_TX_B1_CTL] = TABLA_A_CDC_CONN_TX_B1_CTL__POR,
	[TABLA_A_CDC_CONN_TX_B2_CTL] = TABLA_A_CDC_CONN_TX_B2_CTL__POR,
	[TABLA_A_CDC_CONN_TX_B3_CTL] = TABLA_A_CDC_CONN_TX_B3_CTL__POR,
	[TABLA_A_CDC_CONN_TX_B4_CTL] = TABLA_A_CDC_CONN_TX_B4_CTL__POR,
	[TABLA_A_CDC_CONN_EQ1_B1_CTL] = TABLA_A_CDC_CONN_EQ1_B1_CTL__POR,
	[TABLA_A_CDC_CONN_EQ1_B2_CTL] = TABLA_A_CDC_CONN_EQ1_B2_CTL__POR,
	[TABLA_A_CDC_CONN_EQ1_B3_CTL] = TABLA_A_CDC_CONN_EQ1_B3_CTL__POR,
	[TABLA_A_CDC_CONN_EQ1_B4_CTL] = TABLA_A_CDC_CONN_EQ1_B4_CTL__POR,
	[TABLA_A_CDC_CONN_EQ2_B1_CTL] = TABLA_A_CDC_CONN_EQ2_B1_CTL__POR,
	[TABLA_A_CDC_CONN_EQ2_B2_CTL] = TABLA_A_CDC_CONN_EQ2_B2_CTL__POR,
	[TABLA_A_CDC_CONN_EQ2_B3_CTL] = TABLA_A_CDC_CONN_EQ2_B3_CTL__POR,
	[TABLA_A_CDC_CONN_EQ2_B4_CTL] = TABLA_A_CDC_CONN_EQ2_B4_CTL__POR,
	[TABLA_A_CDC_CONN_SRC1_B1_CTL] = TABLA_A_CDC_CONN_SRC1_B1_CTL__POR,
	[TABLA_A_CDC_CONN_SRC1_B2_CTL] = TABLA_A_CDC_CONN_SRC1_B2_CTL__POR,
	[TABLA_A_CDC_CONN_SRC2_B1_CTL] = TABLA_A_CDC_CONN_SRC2_B1_CTL__POR,
	[TABLA_A_CDC_CONN_SRC2_B2_CTL] = TABLA_A_CDC_CONN_SRC2_B2_CTL__POR,
	[TABLA_A_CDC_CONN_TX_SB_B1_CTL] = TABLA_A_CDC_CONN_TX_SB_B1_CTL__POR,
	[TABLA_A_CDC_CONN_TX_SB_B2_CTL] = TABLA_A_CDC_CONN_TX_SB_B2_CTL__POR,
	[TABLA_A_CDC_CONN_TX_SB_B3_CTL] = TABLA_A_CDC_CONN_TX_SB_B3_CTL__POR,
	[TABLA_A_CDC_CONN_TX_SB_B4_CTL] = TABLA_A_CDC_CONN_TX_SB_B4_CTL__POR,
	[TABLA_A_CDC_CONN_TX_SB_B5_CTL] = TABLA_A_CDC_CONN_TX_SB_B5_CTL__POR,
	[TABLA_A_CDC_CONN_TX_SB_B6_CTL] = TABLA_A_CDC_CONN_TX_SB_B6_CTL__POR,
	[TABLA_A_CDC_CONN_TX_SB_B7_CTL] = TABLA_A_CDC_CONN_TX_SB_B7_CTL__POR,
	[TABLA_A_CDC_CONN_TX_SB_B8_CTL] = TABLA_A_CDC_CONN_TX_SB_B8_CTL__POR,
	[TABLA_A_CDC_CONN_TX_SB_B9_CTL] = TABLA_A_CDC_CONN_TX_SB_B9_CTL__POR,
	[TABLA_A_CDC_CONN_TX_SB_B10_CTL] = TABLA_A_CDC_CONN_TX_SB_B10_CTL__POR,
	[TABLA_A_CDC_CONN_TX_SB_B11_CTL] = TABLA_A_CDC_CONN_TX_SB_B11_CTL__POR,
	[TABLA_A_CDC_CONN_RX_SB_B1_CTL] = TABLA_A_CDC_CONN_RX_SB_B1_CTL__POR,
	[TABLA_A_CDC_CONN_RX_SB_B2_CTL] = TABLA_A_CDC_CONN_RX_SB_B2_CTL__POR,
	[TABLA_A_CDC_CONN_CLSG_CTL] = TABLA_A_CDC_CONN_CLSG_CTL__POR,
	[TABLA_A_CDC_CONN_SPARE] = TABLA_A_CDC_CONN_SPARE__POR,
	[TABLA_A_CDC_MBHC_EN_CTL] = TABLA_A_CDC_MBHC_EN_CTL__POR,
	[TABLA_A_CDC_MBHC_FEATURE_B1_CFG] =
		TABLA_A_CDC_MBHC_FEATURE_B1_CFG__POR,
	[TABLA_A_CDC_MBHC_FEATURE_B2_CFG] =
		TABLA_A_CDC_MBHC_FEATURE_B2_CFG__POR,
	[TABLA_A_CDC_MBHC_TIMER_B1_CTL] = TABLA_A_CDC_MBHC_TIMER_B1_CTL__POR,
	[TABLA_A_CDC_MBHC_TIMER_B2_CTL] = TABLA_A_CDC_MBHC_TIMER_B2_CTL__POR,
	[TABLA_A_CDC_MBHC_TIMER_B3_CTL] = TABLA_A_CDC_MBHC_TIMER_B3_CTL__POR,
	[TABLA_A_CDC_MBHC_TIMER_B4_CTL] = TABLA_A_CDC_MBHC_TIMER_B4_CTL__POR,
	[TABLA_A_CDC_MBHC_TIMER_B5_CTL] = TABLA_A_CDC_MBHC_TIMER_B5_CTL__POR,
	[TABLA_A_CDC_MBHC_TIMER_B6_CTL] = TABLA_A_CDC_MBHC_TIMER_B6_CTL__POR,
	[TABLA_A_CDC_MBHC_B1_STATUS] = TABLA_A_CDC_MBHC_B1_STATUS__POR,
	[TABLA_A_CDC_MBHC_B2_STATUS] = TABLA_A_CDC_MBHC_B2_STATUS__POR,
	[TABLA_A_CDC_MBHC_B3_STATUS] = TABLA_A_CDC_MBHC_B3_STATUS__POR,
	[TABLA_A_CDC_MBHC_B4_STATUS] = TABLA_A_CDC_MBHC_B4_STATUS__POR,
	[TABLA_A_CDC_MBHC_B5_STATUS] = TABLA_A_CDC_MBHC_B5_STATUS__POR,
	[TABLA_A_CDC_MBHC_B1_CTL] = TABLA_A_CDC_MBHC_B1_CTL__POR,
	[TABLA_A_CDC_MBHC_B2_CTL] = TABLA_A_CDC_MBHC_B2_CTL__POR,
	[TABLA_A_CDC_MBHC_VOLT_B1_CTL] = TABLA_A_CDC_MBHC_VOLT_B1_CTL__POR,
	[TABLA_A_CDC_MBHC_VOLT_B2_CTL] = TABLA_A_CDC_MBHC_VOLT_B2_CTL__POR,
	[TABLA_A_CDC_MBHC_VOLT_B3_CTL] = TABLA_A_CDC_MBHC_VOLT_B3_CTL__POR,
	[TABLA_A_CDC_MBHC_VOLT_B4_CTL] = TABLA_A_CDC_MBHC_VOLT_B4_CTL__POR,
	[TABLA_A_CDC_MBHC_VOLT_B5_CTL] = TABLA_A_CDC_MBHC_VOLT_B5_CTL__POR,
	[TABLA_A_CDC_MBHC_VOLT_B6_CTL] = TABLA_A_CDC_MBHC_VOLT_B6_CTL__POR,
	[TABLA_A_CDC_MBHC_VOLT_B7_CTL] = TABLA_A_CDC_MBHC_VOLT_B7_CTL__POR,
	[TABLA_A_CDC_MBHC_VOLT_B8_CTL] = TABLA_A_CDC_MBHC_VOLT_B8_CTL__POR,
	[TABLA_A_CDC_MBHC_VOLT_B9_CTL] = TABLA_A_CDC_MBHC_VOLT_B9_CTL__POR,
	[TABLA_A_CDC_MBHC_VOLT_B10_CTL] = TABLA_A_CDC_MBHC_VOLT_B10_CTL__POR,
	[TABLA_A_CDC_MBHC_VOLT_B11_CTL] = TABLA_A_CDC_MBHC_VOLT_B11_CTL__POR,
	[TABLA_A_CDC_MBHC_VOLT_B12_CTL] = TABLA_A_CDC_MBHC_VOLT_B12_CTL__POR,
	[TABLA_A_CDC_MBHC_CLK_CTL] = TABLA_A_CDC_MBHC_CLK_CTL__POR,
	[TABLA_A_CDC_MBHC_INT_CTL] = TABLA_A_CDC_MBHC_INT_CTL__POR,
	[TABLA_A_CDC_MBHC_DEBUG_CTL] = TABLA_A_CDC_MBHC_DEBUG_CTL__POR,
	[TABLA_A_CDC_MBHC_SPARE] = TABLA_A_CDC_MBHC_SPARE__POR,
};
