/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class HelpFrame
extends JFrame {
    public HelpFrame() {
        this.setTitle("gnupdf Help");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JTextArea jTextArea = new JTextArea(20, 40);
        jTextArea.setLineWrap(true);
        jTextArea.append(this.getHelpText());
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        container.add(jScrollPane);
        this.setSize(jScrollPane.getSize());
        this.setLocation(new Point(200, 200));
        this.pack();
        this.toFront();
        this.setVisible(true);
        jTextArea.setCaretPosition(0);
        jTextArea.setEditable(false);
    }

    private String getHelpText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("gnujpdf Help File and Tutorial\n");
        stringBuilder.append("\n");
        stringBuilder.append("This file contains some general help and a simple tutorial on the\n");
        stringBuilder.append("gnujpdf java package (gnu.jpdf.*).  More information can be\n");
        stringBuilder.append("obtained from the website, http://gnujpdf.sourceforge.net.\n");
        stringBuilder.append("\n");
        stringBuilder.append("gnujpdf is a set of Java classes that allows a programmer to use\n");
        stringBuilder.append("extended versions of java.awt.Graphics and java.awt.PrintJob to\n");
        stringBuilder.append("generate and print pdf files.  The idea is to use methods and\n");
        stringBuilder.append("classes that act on a Graphics object to produce the same output\n");
        stringBuilder.append("in a pdf file, on the screen, and on the printer.\n");
        stringBuilder.append("\n");
        stringBuilder.append("The best source of information for a programmer wishing to use\n");
        stringBuilder.append("this simple API is the source code in PDFTest.java.  It\n");
        stringBuilder.append("demonstrates a simple application that displays various\n");
        stringBuilder.append("formatting and simultaneously writes a pdf file that will be an\n");
        stringBuilder.append("identical copy of what is seen on the screen.\n");
        stringBuilder.append("\n");
        stringBuilder.append("The starting point for creating any PDF document with this\n");
        stringBuilder.append("library is the PDFJob class.\n");
        stringBuilder.append("\n");
        stringBuilder.append("PDFJob job = new PDFJob(fileOutputStream);\n");
        stringBuilder.append("\n");
        stringBuilder.append("The fileOutputStream is normally a stream initialized with the\n");
        stringBuilder.append("name of the pdf you wish to generate, such as \"test.pdf\".  A\n");
        stringBuilder.append("PDFGraphics object can be obtained from the job by calling:\n");
        stringBuilder.append("\n");
        stringBuilder.append("Graphics pdfGraphics = job.getGraphics();\n");
        stringBuilder.append("\n");
        stringBuilder.append("This Graphics object can be passed into the same methods used to\n");
        stringBuilder.append("draw to the screen.  Most of the common methods in\n");
        stringBuilder.append("java.awt.Graphics have been implemented (with a few important\n");
        stringBuilder.append("exceptions - this is a beta product, so there is still plenty of\n");
        stringBuilder.append("work to be done - see the source code for more specifics).  When\n");
        stringBuilder.append("calling methods such as drawString(..)  or drawImage(..), what is\n");
        stringBuilder.append("actually happening is that the PDFGraphics object is writing the\n");
        stringBuilder.append("necessary markup to the output stream.\n");
        stringBuilder.append("\n");
        stringBuilder.append("A new pdf page is initialized by disposing of the exisiting\n");
        stringBuilder.append("Graphics object and getting a new one from the job.\n");
        stringBuilder.append("\n");
        stringBuilder.append("pdfGraphics.dispose(); \n");
        stringBuilder.append("pdfGraphics = job.getGraphics();\n");
        stringBuilder.append("\n");
        stringBuilder.append("Any Graphics operations will now be made on a new page in the pdf\n");
        stringBuilder.append("document.  When the document is finished, the job must be closed\n");
        stringBuilder.append("out:\n");
        stringBuilder.append("\n");
        stringBuilder.append("pdfGraphics.dispose();\n");
        stringBuilder.append("job.end();\n");
        stringBuilder.append("\n");
        stringBuilder.append("And the fileOutputStream will need to be closed properly as well,\n");
        stringBuilder.append("as this is not guaranteed to be taken care of by the PDF classes.\n");
        stringBuilder.append("\n");
        stringBuilder.append("----------------\n");
        stringBuilder.append("End of Help File\n");
        stringBuilder.append("\n");
        stringBuilder.append("For more information, see http://gnujpdf.sourceforge.net\n");
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

