package test;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.effects.GhostPaintingUtils;
import org.jvnet.lafwidget.utils.LafConstants.AnimationKind;

public class ButtonRolloverDemo extends JFrame {
	public ButtonRolloverDemo() {
		super("Button Rollover Demo");

		this.setLayout(new BorderLayout());
		final JPanel buttons = new JPanel(new FlowLayout());
		buttons.add(new JButton("Cut", new ImageIcon(ButtonRolloverDemo.class
				.getResource("/test/icons/edit-cut.png"))));
//		buttons.add(new JButton("Copy", new ImageIcon(ButtonRolloverDemo.class
//				.getResource("/test/icons/edit-copy.png"))));
		buttons.add(new JButton("Paste", new ImageIcon(ButtonRolloverDemo.class
				.getResource("/test/icons/edit-paste.png"))));
//		buttons.add(new JButton("Delete", new ImageIcon(
//				ButtonRolloverDemo.class
//						.getResource("/test/icons/edit-delete.png"))));
//		buttons.add(new JButton("Select All", new ImageIcon(
//				ButtonRolloverDemo.class
//						.getResource("/test/icons/edit-select-all.png"))));

		this.add(buttons, BorderLayout.CENTER);

		JPanel controls = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		controls.setBackground(new Color(255, 240, 150));
		final JComboBox animKindCombo = new JComboBox(new Object[] {
				AnimationKind.NONE, AnimationKind.FAST, AnimationKind.REGULAR,
				AnimationKind.SLOW });
		animKindCombo.setRenderer(new DefaultListCellRenderer() {
			@Override
			public Component getListCellRendererComponent(JList list,
					Object value, int index, boolean isSelected,
					boolean cellHasFocus) {
				AnimationKind ak = (AnimationKind) value;
				return super.getListCellRendererComponent(list, ak.getName(),
						index, isSelected, cellHasFocus);
			}
		});
		animKindCombo.setSelectedItem(LafWidgetUtilities
				.getAnimationKind(buttons));
		controls.add(animKindCombo);
		animKindCombo.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				buttons.putClientProperty(LafWidget.ANIMATION_KIND,
						animKindCombo.getSelectedItem());
			}
		});
		this.add(controls, BorderLayout.SOUTH);

		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setSize(300, 120);
		this.setLocationRelativeTo(null);
	}

	public static void main(String[] args) throws Exception {
		if ((args.length == 1) && ("-contrast".equals(args[0]))) {
			GhostPaintingUtils.MAX_ICON_GHOSTING_ALPHA = 0.8f;
			GhostPaintingUtils.MIN_ICON_GHOSTING_ALPHA = 0.6f;
		}
		if ((args.length == 1) && ("-highcontrast".equals(args[0]))) {
			GhostPaintingUtils.MAX_ICON_GHOSTING_ALPHA = 0.8f;
			GhostPaintingUtils.MIN_ICON_GHOSTING_ALPHA = 0.6f;
			GhostPaintingUtils.MAX_PRESS_GHOSTING_ALPHA = 0.7f;
			GhostPaintingUtils.MIN_PRESS_GHOSTING_ALPHA = 0.5f;
		}
		JFrame.setDefaultLookAndFeelDecorated(true);
		FadeConfigurationManager.getInstance().allowFades(
				FadeKind.GHOSTING_ICON_ROLLOVER);
		FadeConfigurationManager.getInstance().allowFades(
				FadeKind.GHOSTING_BUTTON_PRESS);
		UIManager.put(LafWidget.ANIMATION_KIND, AnimationKind.SLOW);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new ButtonRolloverDemo().setVisible(true);
			}
		});

	}
}
