/*

Copyright (C) 2002 - 2003 Christian Kreibich, Vern Paxson.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>

char pcap_errbuf[PCAP_ERRBUF_SIZE];


void
handler(u_char *user_data, const struct pcap_pkthdr *hdr, const u_char *data)
{
  long unsigned offset;

  offset = (long unsigned) ftell(pcap_file((pcap_t *) user_data));
  printf(" %lu.%lu len: %u caplen: %u\n%lu (%lu)",
	 hdr->ts.tv_sec, hdr->ts.tv_usec,
	 hdr->len, hdr->caplen,
	 offset, offset - sizeof(struct pcap_file_header));
}


int
main(int argn, char **argv)
{
  pcap_t *pcap;
  long unsigned offset;
  int status;

  if (argn < 2)
    {
      printf("Usage: %s <tracefile>\n", argv[0]);
      exit(-1);
    }

  if (! (pcap = pcap_open_offline(argv[1], pcap_errbuf)))
    {
      printf("Pcap error: %s\n", pcap_errbuf);
      exit(-1);
    }

  offset = ftell(pcap_file(pcap));
  
  printf("%lu (%lu)", offset, offset - sizeof(struct pcap_file_header));
  status = pcap_loop(pcap, -1, handler, (u_char *) pcap);

  printf("\n");

  if (status != 0)
    printf("%s\n", pcap_geterr(pcap));

  pcap_close(pcap);
}
