# - Find FONTCONFIG
# Find the native FONTCONFIG headers and libraries.
#
#  FONTCONFIG_INCLUDE_DIR -  where to find fontconfig.h, etc.
#  FONTCONFIG_LIBRARIES    - List of libraries when using FONTCONFIG.
#  FONTCONFIG_FOUND        - True if FONTCONFIG found.


# Look for the header file.
FIND_PATH( FONTCONFIG_INCLUDE_DIR NAMES fontconfig/fontconfig.h
                                  DOC "Path in which the file fontconfig/fontconfig.h is located." )
MARK_AS_ADVANCED(FONTCONFIG_INCLUDE_DIR)

# Look for the library.
FIND_LIBRARY( FONTCONFIG_LIBRARY NAMES fontconfig
                                 DOC "Path to fontconfig library." )
MARK_AS_ADVANCED(FONTCONFIG_LIBRARY)

# Copy the results to the output variables.
IF(FONTCONFIG_INCLUDE_DIR AND FONTCONFIG_LIBRARY)
  SET(FONTCONFIG_FOUND 1)
  SET(FONTCONFIG_LIBRARIES ${FONTCONFIG_LIBRARY})
  SET(FONTCONFIG_INCLUDE_DIR ${FONTCONFIG_INCLUDE_DIR})
ELSE(FONTCONFIG_INCLUDE_DIR AND FONTCONFIG_LIBRARY)
  SET(FONTCONFIG_FOUND 0)
  SET(FONTCONFIG_LIBRARIES)
  SET(FONTCONFIG_INCLUDE_DIR)
ENDIF(FONTCONFIG_INCLUDE_DIR AND FONTCONFIG_LIBRARY)

# Report the results.
IF(NOT FONTCONFIG_FOUND)
  SET(FONTCONFIG_DIR_MESSAGE
    "FONTCONFIG was not found. Make sure FONTCONFIG_LIBRARY and FONTCONFIG_INCLUDE_DIR are set.")
  IF(FontConfig_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "${FONTCONFIG_DIR_MESSAGE}")
  ELSEIF(NOT FontConfig_FIND_QUIETLY)
    MESSAGE(STATUS "${FONTCONFIG_DIR_MESSAGE}")
  ENDIF(FontConfig_FIND_REQUIRED)
ENDIF(NOT FONTCONFIG_FOUND)
