/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef StringLine_H
#include "StringLine.h"
#endif

#ifndef XMString_H
#include "XMString.h"
#endif

#ifndef XMText_H
#include "XMText.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#ifndef RequestPanel_H
#include "RequestPanel.h"
#endif

#ifndef Tokenizer_H
#include "Tokenizer.h"
#endif

#ifndef LineFactory_H
#include "LineFactory.h"
#endif



#include <mars.h>

StringLine::StringLine(RequestPanel& owner,const Parameter& param):
	XRequestPanelLine<UITextLine_c>(owner,param),
	changed_(false)
{
}

StringLine::~StringLine()
{
}

void StringLine::refresh(const vector<string>& values)
{
	string s;
	for(vector<string>::const_iterator j = values.begin(); j != values.end(); ++j)
	{
			if(s.length()) s += "/";
			s += *j;
	}
	
	XMText text(text_);
	text.set(s);
}

void StringLine::apply()
{
	if(changed_) owner_.changed(*this);
}

void StringLine::set(Request& r)
{
	XMText text(text_);
	vector<string> v;
	v.push_back(text.get());
	r.set(param_.name(),v);
}

void StringLine::activateCB(Widget,XtPointer)
{
	changed_ = false;
	owner_.changed(*this);
}

void StringLine::changedCB(Widget,XtPointer)
{
	changed_ = true;
	decache();
}

void StringLine::loosingFocusCB(Widget,XtPointer)
{
	printf("TextLine::loosingFocusCB\n");
}

void StringLine::loosingPrimaryCB(Widget,XtPointer)
{
	printf("TextLine::loosingPrimaryCB\n");
}

static LineMaker<StringLine> maker("string");
