/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <MvApplication.h>
#include "PlotModBatch.h"
#include "PlotModConst.h"

PlotModBatch::PlotModBatch()
{
    isInteractive_   = false;
    isWindow_        = false;
    plotDestination_ = MVFILE;
    printerName_     = "";
}

// print a message to the log window or the output; if 'priority', then
// it will be visible without '-slog'
void PlotModBatch::printMessage(const string& msg, MessageLevel level, bool priority)
{
    if (priority) {
        sendMessageToService(msg);
    } else {
        writeToLog(msg, level);
    }
}

void PlotModBatch::SystemError(const string& message, const string& title)
{
    // Call the MetviewError method to get some output to the user
    string fullMessage = title + ": " + message;
    MetviewError(fullMessage, "ERROR");
}


#if 0
void
PlotMod::InternalError ( const string & message, const string & title )
{
  MvRequest reqst("USER_MESSAGE");
  reqst("INFO") = message.c_str(); 

  send_message(PlotModApp::Instance().getService(),(request*)reqst);
}

#endif
