#######################################################
# 
# DumpData.py
# Python implementation of the Class DumpData
# Generated by Enterprise Architect
# Created on:      14-Aug-2019 10:12:02 AM
# Original author: talve
# 
#######################################################
from fetchers.ResourceDumpFetcher import ResourceDumpFetcher
from resource_data.QueryData import QueryData
from validation.ArgToMenuVerifier import ArgToMenuVerifier
from utils import constants as cs


class DumpData:
    """this class is responsible for getting the dump segment.
    """

    @classmethod
    def get_dump(cls, **kwargs):
        """this method is getting the menu segment by using QueryData and verify it with
        the user inputs using the ArgToMenuVerifier, if the verification pass, its uses
        the core dump fetcher to fetch the core dump segments.
        """
        dump_segments = None

        # get the query data
        # need to call query data
        res = QueryData.get_query(kwargs["device_name"], kwargs["vHCAid"])

        # validate that the dump supported by calling ArgToMenuVerifier
        rc = ArgToMenuVerifier.verify(res, **kwargs)

        # if args passes the verify
        if rc:
            # segment type can be name, this method will convert the name (if needed) to seg number in hex (str)
            kwargs[cs.UI_ARG_SEGMENT] = res.get_segment_type_by_segment_name(kwargs[cs.UI_ARG_SEGMENT])
            dump_segments = ResourceDumpFetcher(kwargs["device_name"]).fetch_data(**kwargs)
        else:
            raise Exception("not supported or missing argument")

        return dump_segments
