package testRename;

import java.io.IOException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;

public class MyDataLoader extends UniFileLoader {
    
    public static final String REQUIRED_MIME = "text/x-my";
    
    private static final long serialVersionUID = 1L;
    
    public MyDataLoader() {
        super("testRename.MyDataObject");
    }
    
    protected String defaultDisplayName() {
        return NbBundle.getMessage(MyDataLoader.class, "LBL_My_loader_name");
    }
    
    protected void initialize() {
        super.initialize();
        getExtensions().addMimeType(REQUIRED_MIME);
    }
    
    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        return new MyDataObject(primaryFile, this);
    }
    
    protected String actionsContext() {
        return "Loaders/" + REQUIRED_MIME + "/Actions";
    }
    
}
