C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_spbe.F 
C> The nwxcm_c_spbe functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_spbe functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& 0.1325688999052018\,{\it t_3}+1.0\\\\ 
C>   {\it t_5} &=& \sqrt{{\it t_2}}\\\\ 
C>   {\it t_6} &=& {{1}\over{{\it t_5}}}\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_5}}
C>    \over{0.7876233178997433\,{\it t_6}\,\left(0.7876233178997433
C>    \,{\it t_6}\,\left(0.02414199311453321\,{\it t_6}
C>    +0.10186556948\right)+0.22308199064\right)+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_9} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{10}} &=& 1.0-{\it t_8}\,{\it t_9}\\\\ 
C>   {\it t_{11}} &=& {\it t_8}\,{\it t_9}+1.0\\\\ 
C>   {\it t_{12}} &=& 0.06901399211255826\,{\it t_3}+1.0\\\\ 
C>   {\it t_{13}} &=& \log \left({{1.269642451250142\,{
C>    \it t_5}}\over{0.7876233178997433\,{\it t_6}\,
C>    \left(0.7876233178997433\,{\it t_6}\,\left(0.01321299881039884
C>    \,{\it t_6}+0.029729725188\right)+0.12236585478\right)
C>    +0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{14}} &=& 0.5848223622634648\,\left(1.923661050931536
C>    \,{\it t_{11}}^{{{4}\over{3}}}+1.923661050931536\,{
C>    \it t_{10}}^{{{4}\over{3}}}-3.847322101863072\right)\,
C>    \left({{{\it t_8}^4\,\left(1.709920934161365\,\left(0.0621814
C>    \,{\it t_4}\,{\it t_7}-0.0310907\,\left(0.1274696188700087
C>    \,{\it t_3}+1.0\right)\,\log \left({{1.269642451250142\,{
C>    \it t_5}}\over{0.7876233178997433\,{\it t_6}\,
C>    \left(0.7876233178997433\,{\it t_6}\,\left(0.01530901310039024
C>    \,{\it t_6}+0.10465751434\right)+0.19269083139\right)
C>    +0.43896648423}}+1.0\right)\right)-0.0337738\,{\it t_{12}}
C>    \,{\it t_{13}}\right)}\over{{\it t_1}^4}}+0.0337738\,{
C>    \it t_{12}}\,{\it t_{13}}\right)-0.0621814\,{\it t_4}\,{
C>    \it t_7}\\\\ 
C>   {\it t_{15}} &=& 0.5\,{\it t_{11}}^{{{2}\over{3}}}+0.5\,{
C>    \it t_{10}}^{{{2}\over{3}}}\\\\ 
C>   {\it t_{16}} &=& {\it t_{15}}^{3.0}\\\\ 
C>   {\it t_{17}} &=& {{1}\over{\left({
C>    \it t_1}^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{18}} &=& {{1}\over{{\it t_{15}}^{2.0}}}\\\\ 
C>   {\it t_{19}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{20}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{21}} &=& \sqrt{{\it t_{20}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{{\it t_{21}}}}\\\\ 
C>   {\it t_{23}} &=& {{1}\over{{\it t_{20}}}}\\\\ 
C>   {\it t_{24}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{21}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{22}}+0.10186556948\right)
C>    \,{\it t_{22}}+0.22308199064\right)\,{\it t_{22}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{25}} &=& 0.1325688999052018\,{\it t_{23}}+1.0\\\\ 
C>   {\it t_{26}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{21}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{22}}
C>    +0.029729725188\right)\,{\it t_{22}}+0.12236585478\right)\,{
C>    \it t_{22}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{27}} &=& 0.06901399211255826\,{\it t_{23}}+1.0\\\\ 
C>   {\it t_{28}} &=& 0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{26}}\,{\it t_{27}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{24}}\,{\it t_{25}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{21}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{22}}+0.10465751434\right)
C>    \,{\it t_{22}}+0.19269083139\right)\,{\it t_{22}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{23}}+1.0\right)\right)-0.0337738\,{\it t_{26}}\,{
C>    \it t_{27}}\right)\right)-0.0621814\,{\it t_{24}}\,{
C>    \it t_{25}}\\\\ 
C>   {\it t_{29}} &=& {{1}\over{
C>    \left(\rho_s^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   f &=& 0.03109069086965489\,{\it t_1}\,{\it t_{16}}\,\log 
C>    \left({{0.1362107888567592\,{\it t_{17}}\,{\it t_{18}}\,{
C>    \it t_{19}}}\over{{{0.1362107888567592\,{\it t_{17}}\,{
C>    \it t_{18}}\,{\it t_{19}}}\over{{{1}
C>    \over{e^{{{32.16396844291483\,{\it t_{14}}}\over{{
C>    \it t_{16}}}}}}}-1.0}}+1.0}}+1.0\right)+1.0\,{\it t_1}\,{
C>    \it t_{14}}\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 0.01554534543482744\,\rho_s\,\log 
C>    \left({{0.2162211495206379\,{\it t_{29}}\,\sigma_{ss}}
C>    \over{{{0.2162211495206379\,{\it t_{29}}\,\sigma_{ss}}
C>    \over{{{1}\over{e^{64.32793688582967\,{\it t_{28}}}}}-1.0}}
C>    +1.0}}+1.0\right)+1.0\,{\it t_{28}}\,\rho_s\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] M Swart, M Sola, FM Bickelhaupt, J.Chem.Phys. 131
C>    , 094103 (2009)  , DOI: 
C> <a href="https://doi.org/10.1063/1.3213193 "> 
C> 10.1063/1.3213193 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_spbe(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Cmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = log(1.4251254664507676d+0*t2/(7.016926042943223d-1*t3*(
     1         7.016926042943223d-1*(2.150807071909054d-2*t3+1.018655694
     2         8d-1)*t3+2.2308199064d-1)+4.7231125998d-1)+1.0d+0)
            t5 = 1/t1
            t6 = 1.0522000558389215d-1*t5+1.0d+0
            t7 = rhoa**1.1666666666666667d+0
            t8 = 1/t7**2.0d+0
            t9 = 2.1508070719090538d-2*t3+1.0186556948d-1
            t10 = 7.016926042943222d-1*t3*t9+2.2308199064d-1
            t11 = 7.016926042943222d-1*t10*t3+4.7231125998d-1
            t12 = 1/t11
            t13 = 1.425125466450768d+0*t12*t2+1.0d+0
            t14 = log(t13)
            t15 = 1.0522000558389213d-1*t5+1.0d+0
            t16 = 1/t2**3
            t17 = 1/rhoa**6.666666666666667d-1
            t18 = 1.090454542535705d-3*t14/rhoa**1.3333333333333333d+0-6
     1         .21814d-2*t15*(1.1876045553756398d-1*t12*t17*t3-1.4251254
     2         66450768d+0*t2*(7.016926042943222d-1*t3*(-5.8474383691193
     3         52d-2*t16*t17*t9-1.2576711796854242d-3/rhoa**1.3333333333
     4         333336d+0)-5.847438369119352d-2*t10*t16*t17)/t11**2)/t13
            t19 = exp(2.0000005873362642d+0*t14*t15)
            t20 = t19-1.0d+0
            t21 = 1/t20
            t22 = 1.0811057476031893d-1*gammaaa*t21*t8+1.0d+0
            t23 = 1/t22
            t24 = 1.0811057476031893d-1*gammaaa*t23*t8+1.0d+0
            t25 = 1/t24
            t26 = rhoa**1.6666666666666674d-1
            t27 = 1/t7**3.0d+0
            t28 = 1/t22**2
            t29 = 1/t7**4.0d+0
            fnc(iq) = (6.218138173930978d-2*rhoa*log(1.0811057476031892d
     1         -1*gammaaa*t8/(1.0811057476031892d-1*gammaaa*t8/(exp(2.00
     2         00005873362642d+0*t4*t6)-1.0d+0)+1.0d+0)+1.0d+0)-1.243628
     3         d-1*rhoa*t4*t6)*wght+fnc(iq)
            Amat(iq,D1_RA) = (6.218138173930978d-2*rhoa*t25*(-1.08110574
     1         76031893d-1*gammaaa*t28*t8*(3.4772651149362827d+0*gammaaa
     2         *t18*t19*t8/t20**2-1.2612900388703877d-1*gammaaa*t21*t26*
     3         t27)-1.2612900388703877d-1*gammaaa*t23*t26*t27)+3.1090690
     4         86965489d-2*log(t24)+2.0d+0*rhoa*t18-6.21814d-2*t14*t15)*
     5         wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 6.218138173930978d-2*rhoa*t25*(2.702764369
     1         0079733d-2*t23*t8-2.9219740937516275d-3*gammaaa*t21*t28*t
     2         29)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 6.218138173930978d-2*rhoa*t25*(5.405528738
     1         015947d-2*t23*t8-5.843948187503255d-3*gammaaa*t21*t28*t29
     2         )*wght+Cmat(iq,D1_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = 1/t2
            t4 = 1.325688999052018d-1*t3+1.0d+0
            t5 = t2**5.0d-1
            t6 = 1/t5
            t7 = 2.4141993114533214d-2*t6+1.0186556948d-1
            t8 = 7.876233178997433d-1*t6*t7+2.2308199064d-1
            t9 = 7.876233178997433d-1*t6*t8+4.7231125998d-1
            t10 = 1/t9
            t11 = 1.269642451250142d+0*t10*t5+1.0d+0
            t12 = log(t11)
            t13 = rhoa-rhob
            t14 = 1/t1
            t15 = 1.0d+0-t13*t14
            t16 = t13*t14+1.0d+0
            t17 = 1.923661050931536d+0*t16**1.3333333333333333d+0+1.9236
     1         61050931536d+0*t15**1.3333333333333333d+0-3.8473221018630
     2         72d+0
            t18 = 6.901399211255826d-2*t3+1.0d+0
            t19 = 1.3212998810398843d-2*t6+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t6+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t6+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t22*t5+1.0d+0
            t24 = log(t23)
            t25 = t13**4
            t26 = 1/t1**4
            t27 = 1.2746961887000874d-1*t3+1.0d+0
            t28 = 1.530901310039024d-2*t6+1.0465751434d-1
            t29 = 7.876233178997433d-1*t28*t6+1.9269083139d-1
            t30 = 7.876233178997433d-1*t29*t6+4.3896648423d-1
            t31 = 1/t30
            t32 = 1.269642451250142d+0*t31*t5+1.0d+0
            t33 = log(t32)
            t34 = 1.709920934161365d+0*(6.21814d-2*t12*t4-3.10907d-2*t27
     1         *t33)-3.37738d-2*t18*t24
            t35 = t25*t26*t34+3.37738d-2*t18*t24
            t36 = 5.848223622634648d-1*t17*t35-6.21814d-2*t12*t4
            t37 = 5.0d-1*t16**6.666666666666666d-1+5.0d-1*t15**6.6666666
     1         66666666d-1
            t38 = t37**3.0d+0
            t39 = gammabb+2.0d+0*gammaab+gammaaa
            t40 = t1**1.1666666666666667d+0
            t41 = 1/t40**2.0d+0
            t42 = t37**2.0d+0
            t43 = 1/t42
            t44 = 1/t38
            t45 = exp(-3.216396844291483d+1*t36*t44)
            t46 = t45-1.0d+0
            t47 = 1/t46
            t48 = 1.3621078885675922d-1*t39*t41*t43*t47+1.0d+0
            t49 = 1/t48
            t50 = 1.3621078885675922d-1*t39*t41*t43*t49+1.0d+0
            t51 = log(t50)
            t52 = 1/t1**1.3333333333333336d+0
            t53 = 1/t1**6.666666666666667d-1
            t54 = 1/t5**3
            t55 = 2.11607075208357d-1*t10*t53*t6-1.269642451250142d+0*t5
     1         *(7.876233178997433d-1*t6*(-1.3127055298329054d-1*t53*t54
     2         *t7-3.169132786263567d-3*t52)-1.3127055298329054d-1*t53*t
     3         54*t8)/t9**2
            t56 = 1/t11
            t57 = -6.21814d-2*t4*t55*t56
            t58 = 1/t1**1.3333333333333333d+0
            t59 = 2.747773264188438d-3*t12*t58
            t60 = 2.11607075208357d-1*t22*t53*t6-1.269642451250142d+0*t5
     1         *(7.876233178997433d-1*(-1.3127055298329054d-1*t19*t53*t5
     2         4-1.7344776604086162d-3*t52)*t6-1.3127055298329054d-1*t20
     3         *t53*t54)/t21**2
            t61 = 1/t23
            t62 = 3.37738d-2*t18*t60*t61
            t63 = -7.769549222703733d-4*t24*t58
            t64 = t25*t26*(-3.37738d-2*t18*t60*t61+1.709920934161365d+0*
     1         (-3.10907d-2*t27*(2.11607075208357d-1*t31*t53*t6-1.269642
     2         451250142d+0*t5*(7.876233178997433d-1*(-1.312705529832905
     3         4d-1*t28*t53*t54-2.0096226153166658d-3*t52)*t6-1.31270552
     4         98329054d-1*t29*t53*t54)/t30**2)/t32+1.3210398931339265d-
     5         3*t33*t58-2.747773264188438d-3*t12*t58+6.21814d-2*t4*t55*
     6         t56)+7.769549222703733d-4*t24*t58)
            t65 = -4*t25*t34/t1**5
            t66 = t13**3
            t67 = 1/t1**2
            t68 = t13*t67
            t69 = -t14
            t70 = t69+t68
            t71 = t15**3.333333333333333d-1
            t72 = -t13*t67
            t73 = t72+t14
            t74 = t16**3.333333333333333d-1
            t75 = 5.848223622634648d-1*t35*(2.564881401242048d+0*t73*t74
     1         +2.564881401242048d+0*t70*t71)+5.848223622634648d-1*t17*(
     2         4*t26*t34*t66+t65+t64+t63+t62)+t59+t57
            t76 = 1.0d+0*t36
            t77 = 1/t50
            t78 = 1/t71
            t79 = 1/t74
            t80 = 3.333333333333333d-1*t73*t79+3.333333333333333d-1*t70*
     1         t78
            t81 = t1**1.6666666666666674d-1
            t82 = 1/t40**3.0d+0
            t83 = -3.1782517399910487d-1*t39*t43*t49*t81*t82
            t84 = 1/t48**2
            t85 = -3.1782517399910487d-1*t39*t43*t47*t81*t82
            t86 = 1/t46**2
            t87 = 1/t37**4.0d+0
            t88 = 3.109069086965489d-2*t38*t51
            t89 = t68+t14
            t90 = t72+t69
            t91 = 5.848223622634648d-1*t35*(2.564881401242048d+0*t74*t90
     1         +2.564881401242048d+0*t71*t89)+5.848223622634648d-1*t17*(
     2         -4*t26*t34*t66+t65+t64+t63+t62)+t59+t57
            t92 = 3.333333333333333d-1*t79*t90+3.333333333333333d-1*t78*
     1         t89
            t93 = 1/t40**4.0d+0
            t94 = 3.109069086965489d-2*t1*t38*t77*(1.3621078885675922d-1
     1         *t41*t43*t49-1.855337900098064d-2*t39*t47*t84*t87*t93)*wg
     2         ht
            fnc(iq) = (3.109069086965489d-2*t1*t38*t51+1.0d+0*t1*t36)*wg
     1         ht+fnc(iq)
            Amat(iq,D1_RA) = (t88+3.109069086965489d-2*t1*t38*t77*(-1.36
     1         21078885675922d-1*t39*t41*t43*t84*(-1.3621078885675922d-1
     2         *t39*t41*t43*t45*t86*(9.649190532874448d+1*t36*t80*t87-3.
     3         216396844291483d+1*t44*t75)+t85-2.7242157771351844d-1*t39
     4         *t41*t44*t47*t80)+t83-2.7242157771351844d-1*t39*t41*t44*t
     5         49*t80)+9.327207260896466d-2*t1*t42*t51*t80+t76+1.0d+0*t1
     6         *t75)*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = (3.109069086965489d-2*t1*t38*t77*(-1.362107
     1         8885675922d-1*t39*t41*t43*t84*(-1.3621078885675922d-1*t39
     2         *t41*t43*t45*t86*(9.649190532874448d+1*t36*t87*t92-3.2163
     3         96844291483d+1*t44*t91)-2.7242157771351844d-1*t39*t41*t44
     4         *t47*t92+t85)-2.7242157771351844d-1*t39*t41*t44*t49*t92+t
     5         83)+9.327207260896466d-2*t1*t42*t51*t92+1.0d+0*t1*t91+t88
     6         +t76)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = t94+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 3.109069086965489d-2*t1*t38*t77*(2.7242157
     1         771351844d-1*t41*t43*t49-3.710675800196128d-2*t39*t47*t84
     2         *t87*t93)*wght+Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = t94+Cmat(iq,D1_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 1.3212998810398843d-2*t3+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t3+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t3+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t2*t22+1.0d+0
            t24 = log(t23)
            t25 = 6.901399211255826d-2*t10+1.0d+0
            t26 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t17*t18-3.10907d-2*t11*t9)-3.37738d-2*t24*t25)+3
     2         .37738d-2*t24*t25)-6.21814d-2*t17*t18
            t27 = rhoa**1.1666666666666667d+0
            t28 = 1/t27**2.0d+0
            t29 = exp(-6.432793688582967d+1*t26)
            t30 = t29-1.0d+0
            t31 = 1/t30
            t32 = 2.1622114952063792d-1*gammaaa*t28*t31+1.0d+0
            t33 = 1/t32
            t34 = 2.1622114952063792d-1*gammaaa*t28*t33+1.0d+0
            t35 = log(t34)
            t36 = 1/rhoa**1.3333333333333333d+0
            t37 = 1/rhoa**1.3333333333333336d+0
            t38 = 1/t2**3
            t39 = 1/rhoa**6.666666666666667d-1
            t40 = 1/t16
            t41 = 2.11607075208357d-1*t15*t3*t39-1.269642451250142d+0*t2
     1         *(7.876233178997433d-1*t3*(-1.3127055298329054d-1*t12*t38
     2         *t39-3.169132786263567d-3*t37)-1.3127055298329054d-1*t13*
     3         t38*t39)/t14**2
            t42 = 1/t23
            t43 = 2.11607075208357d-1*t22*t3*t39-1.269642451250142d+0*t2
     1         *(7.876233178997433d-1*t3*(-1.3127055298329054d-1*t19*t38
     2         *t39-1.7344776604086162d-3*t37)-1.3127055298329054d-1*t20
     3         *t38*t39)/t21**2
            t44 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         3210398931339265d-3*t36*t9-3.10907d-2*t11*(2.116070752083
     2         57d-1*t3*t39*t7-1.269642451250142d+0*t2*(7.87623317899743
     3         3d-1*t3*(-1.3127055298329054d-1*t38*t39*t4-2.009622615316
     4         6658d-3*t37)-1.3127055298329054d-1*t38*t39*t5)/t6**2)/t8+
     5         6.21814d-2*t18*t40*t41-2.747773264188438d-3*t17*t36)-3.37
     6         738d-2*t25*t42*t43+7.769549222703733d-4*t24*t36)+3.37738d
     7         -2*t25*t42*t43-7.769549222703733d-4*t24*t36)-6.21814d-2*t
     8         18*t40*t41+2.747773264188438d-3*t17*t36
            t45 = 1/t34
            t46 = rhoa**1.6666666666666674d-1
            t47 = 1/t27**3.0d+0
            t48 = 1/t32**2
            fnc(iq) = (1.5545345434827443d-2*rhoa*t35+1.0d+0*rhoa*t26)*w
     1         ght+fnc(iq)
            Amat(iq,D1_RA) = (1.5545345434827443d-2*rhoa*t45*(-2.1622114
     1         952063792d-1*gammaaa*t28*(1.3909060459745137d+1*gammaaa*t
     2         28*t29*t44/t30**2-5.045160155481552d-1*gammaaa*t31*t46*t4
     3         7)*t48-5.045160155481552d-1*gammaaa*t33*t46*t47)+1.0d+0*r
     4         hoa*t44+1.5545345434827443d-2*t35+1.0d+0*t26)*wght+Amat(i
     5         q,D1_RA)
            Cmat(iq,D1_GAA) = 1.5545345434827443d-2*rhoa*t45*(2.16221149
     1         52063792d-1*t28*t33-4.675158550002606d-2*gammaaa*t31*t48/
     2         t27**4.0d+0)*wght+Cmat(iq,D1_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 1.3212998810398843d-2*t3+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t3+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t3+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t2*t22+1.0d+0
            t24 = log(t23)
            t25 = 6.901399211255826d-2*t10+1.0d+0
            t26 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t17*t18-3.10907d-2*t11*t9)-3.37738d-2*t24*t25)+3
     2         .37738d-2*t24*t25)-6.21814d-2*t17*t18
            t27 = rhob**1.1666666666666667d+0
            t28 = 1/t27**2.0d+0
            t29 = exp(-6.432793688582967d+1*t26)
            t30 = t29-1.0d+0
            t31 = 1/t30
            t32 = 2.1622114952063792d-1*gammabb*t28*t31+1.0d+0
            t33 = 1/t32
            t34 = 2.1622114952063792d-1*gammabb*t28*t33+1.0d+0
            t35 = log(t34)
            t36 = 1/rhob**1.3333333333333333d+0
            t37 = 1/rhob**1.3333333333333336d+0
            t38 = 1/t2**3
            t39 = 1/rhob**6.666666666666667d-1
            t40 = 1/t16
            t41 = 2.11607075208357d-1*t15*t3*t39-1.269642451250142d+0*t2
     1         *(7.876233178997433d-1*t3*(-1.3127055298329054d-1*t12*t38
     2         *t39-3.169132786263567d-3*t37)-1.3127055298329054d-1*t13*
     3         t38*t39)/t14**2
            t42 = 1/t23
            t43 = 2.11607075208357d-1*t22*t3*t39-1.269642451250142d+0*t2
     1         *(7.876233178997433d-1*t3*(-1.3127055298329054d-1*t19*t38
     2         *t39-1.7344776604086162d-3*t37)-1.3127055298329054d-1*t20
     3         *t38*t39)/t21**2
            t44 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         3210398931339265d-3*t36*t9-3.10907d-2*t11*(2.116070752083
     2         57d-1*t3*t39*t7-1.269642451250142d+0*t2*(7.87623317899743
     3         3d-1*t3*(-1.3127055298329054d-1*t38*t39*t4-2.009622615316
     4         6658d-3*t37)-1.3127055298329054d-1*t38*t39*t5)/t6**2)/t8+
     5         6.21814d-2*t18*t40*t41-2.747773264188438d-3*t17*t36)-3.37
     6         738d-2*t25*t42*t43+7.769549222703733d-4*t24*t36)+3.37738d
     7         -2*t25*t42*t43-7.769549222703733d-4*t24*t36)-6.21814d-2*t
     8         18*t40*t41+2.747773264188438d-3*t17*t36
            t45 = 1/t34
            t46 = rhob**1.6666666666666674d-1
            t47 = 1/t27**3.0d+0
            t48 = 1/t32**2
            fnc(iq) = (1.5545345434827443d-2*rhob*t35+1.0d+0*rhob*t26)*w
     1         ght+fnc(iq)
            Amat(iq,D1_RB) = (1.5545345434827443d-2*rhob*t45*(-2.1622114
     1         952063792d-1*gammabb*t28*(1.3909060459745137d+1*gammabb*t
     2         28*t29*t44/t30**2-5.045160155481552d-1*gammabb*t31*t46*t4
     3         7)*t48-5.045160155481552d-1*gammabb*t33*t46*t47)+1.0d+0*r
     4         hob*t44+1.5545345434827443d-2*t35+1.0d+0*t26)*wght+Amat(i
     5         q,D1_RB)
            Cmat(iq,D1_GBB) = 1.5545345434827443d-2*rhob*t45*(2.16221149
     1         52063792d-1*t28*t33-4.675158550002606d-2*gammabb*t31*t48/
     2         t27**4.0d+0)*wght+Cmat(iq,D1_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_spbe functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& 0.1325688999052018\,{\it t_3}+1.0\\\\ 
C>   {\it t_5} &=& \sqrt{{\it t_2}}\\\\ 
C>   {\it t_6} &=& {{1}\over{{\it t_5}}}\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_5}}
C>    \over{0.7876233178997433\,{\it t_6}\,\left(0.7876233178997433
C>    \,{\it t_6}\,\left(0.02414199311453321\,{\it t_6}
C>    +0.10186556948\right)+0.22308199064\right)+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_9} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{10}} &=& 1.0-{\it t_8}\,{\it t_9}\\\\ 
C>   {\it t_{11}} &=& {\it t_8}\,{\it t_9}+1.0\\\\ 
C>   {\it t_{12}} &=& 0.06901399211255826\,{\it t_3}+1.0\\\\ 
C>   {\it t_{13}} &=& \log \left({{1.269642451250142\,{
C>    \it t_5}}\over{0.7876233178997433\,{\it t_6}\,
C>    \left(0.7876233178997433\,{\it t_6}\,\left(0.01321299881039884
C>    \,{\it t_6}+0.029729725188\right)+0.12236585478\right)
C>    +0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{14}} &=& 0.5848223622634648\,\left(1.923661050931536
C>    \,{\it t_{11}}^{{{4}\over{3}}}+1.923661050931536\,{
C>    \it t_{10}}^{{{4}\over{3}}}-3.847322101863072\right)\,
C>    \left({{{\it t_8}^4\,\left(1.709920934161365\,\left(0.0621814
C>    \,{\it t_4}\,{\it t_7}-0.0310907\,\left(0.1274696188700087
C>    \,{\it t_3}+1.0\right)\,\log \left({{1.269642451250142\,{
C>    \it t_5}}\over{0.7876233178997433\,{\it t_6}\,
C>    \left(0.7876233178997433\,{\it t_6}\,\left(0.01530901310039024
C>    \,{\it t_6}+0.10465751434\right)+0.19269083139\right)
C>    +0.43896648423}}+1.0\right)\right)-0.0337738\,{\it t_{12}}
C>    \,{\it t_{13}}\right)}\over{{\it t_1}^4}}+0.0337738\,{
C>    \it t_{12}}\,{\it t_{13}}\right)-0.0621814\,{\it t_4}\,{
C>    \it t_7}\\\\ 
C>   {\it t_{15}} &=& 0.5\,{\it t_{11}}^{{{2}\over{3}}}+0.5\,{
C>    \it t_{10}}^{{{2}\over{3}}}\\\\ 
C>   {\it t_{16}} &=& {\it t_{15}}^{3.0}\\\\ 
C>   {\it t_{17}} &=& {{1}\over{\left({
C>    \it t_1}^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{18}} &=& {{1}\over{{\it t_{15}}^{2.0}}}\\\\ 
C>   {\it t_{19}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{20}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{21}} &=& \sqrt{{\it t_{20}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{{\it t_{21}}}}\\\\ 
C>   {\it t_{23}} &=& {{1}\over{{\it t_{20}}}}\\\\ 
C>   {\it t_{24}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{21}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{22}}+0.10186556948\right)
C>    \,{\it t_{22}}+0.22308199064\right)\,{\it t_{22}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{25}} &=& 0.1325688999052018\,{\it t_{23}}+1.0\\\\ 
C>   {\it t_{26}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{21}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{22}}
C>    +0.029729725188\right)\,{\it t_{22}}+0.12236585478\right)\,{
C>    \it t_{22}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{27}} &=& 0.06901399211255826\,{\it t_{23}}+1.0\\\\ 
C>   {\it t_{28}} &=& 0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{26}}\,{\it t_{27}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{24}}\,{\it t_{25}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{21}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{22}}+0.10465751434\right)
C>    \,{\it t_{22}}+0.19269083139\right)\,{\it t_{22}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{23}}+1.0\right)\right)-0.0337738\,{\it t_{26}}\,{
C>    \it t_{27}}\right)\right)-0.0621814\,{\it t_{24}}\,{
C>    \it t_{25}}\\\\ 
C>   {\it t_{29}} &=& {{1}\over{
C>    \left(\rho_s^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   f &=& 0.03109069086965489\,{\it t_1}\,{\it t_{16}}\,\log 
C>    \left({{0.1362107888567592\,{\it t_{17}}\,{\it t_{18}}\,{
C>    \it t_{19}}}\over{{{0.1362107888567592\,{\it t_{17}}\,{
C>    \it t_{18}}\,{\it t_{19}}}\over{{{1}
C>    \over{e^{{{32.16396844291483\,{\it t_{14}}}\over{{
C>    \it t_{16}}}}}}}-1.0}}+1.0}}+1.0\right)+1.0\,{\it t_1}\,{
C>    \it t_{14}}\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 0.01554534543482744\,\rho_s\,\log 
C>    \left({{0.2162211495206379\,{\it t_{29}}\,\sigma_{ss}}
C>    \over{{{0.2162211495206379\,{\it t_{29}}\,\sigma_{ss}}
C>    \over{{{1}\over{e^{64.32793688582967\,{\it t_{28}}}}}-1.0}}
C>    +1.0}}+1.0\right)+1.0\,{\it t_{28}}\,\rho_s\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] M Swart, M Sola, FM Bickelhaupt, J.Chem.Phys. 131
C>    , 094103 (2009)  , DOI: 
C> <a href="https://doi.org/10.1063/1.3213193 "> 
C> 10.1063/1.3213193 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_spbe_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Amat2,Cmat,Cmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,*)  !< [Output] The 2nd derivative wrt rgamma 
                                    !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = log(1.4251254664507676d+0*t2/(7.016926042943223d-1*t3*(
     1         7.016926042943223d-1*(2.150807071909054d-2*t3+1.018655694
     2         8d-1)*t3+2.2308199064d-1)+4.7231125998d-1)+1.0d+0)
            t5 = 1/t1
            t6 = 1.0522000558389215d-1*t5+1.0d+0
            t7 = rhoa**1.1666666666666667d+0
            t8 = 1/t7**2.0d+0
            t9 = 2.1508070719090538d-2*t3+1.0186556948d-1
            t10 = 7.016926042943222d-1*t3*t9+2.2308199064d-1
            t11 = 7.016926042943222d-1*t10*t3+4.7231125998d-1
            t12 = 1/t11
            t13 = 1.425125466450768d+0*t12*t2+1.0d+0
            t14 = log(t13)
            t15 = 1.0522000558389213d-1*t5+1.0d+0
            t16 = 1/rhoa**1.3333333333333333d+0
            t17 = 1/t13
            t18 = 1/t11**2
            t19 = 1/rhoa**1.3333333333333336d+0
            t20 = 1/t2**3
            t21 = 1/rhoa**6.666666666666667d-1
            t22 = -5.847438369119352d-2*t20*t21*t9-1.2576711796854242d-3
     1         *t19
            t23 = 7.016926042943222d-1*t22*t3-5.847438369119352d-2*t10*t
     1         20*t21
            t24 = 1.1876045553756398d-1*t12*t21*t3-1.425125466450768d+0*
     1         t18*t2*t23
            t25 = 1.090454542535705d-3*t14*t16-6.21814d-2*t15*t17*t24
            t26 = exp(2.0000005873362642d+0*t14*t15)
            t27 = t26-1.0d+0
            t28 = 1/t27
            t29 = 1.0811057476031893d-1*gammaaa*t28*t8+1.0d+0
            t30 = 1/t29
            t31 = 1.0811057476031893d-1*gammaaa*t30*t8+1.0d+0
            t32 = 1/t31
            t33 = rhoa**1.6666666666666674d-1
            t34 = 1/t7**3.0d+0
            t35 = 1/t29**2
            t36 = 1/t27**2
            t37 = 3.4772651149362827d+0*gammaaa*t25*t26*t36*t8-1.2612900
     1         388703877d-1*gammaaa*t28*t33*t34
            t38 = -1.0811057476031893d-1*gammaaa*t35*t37*t8-1.2612900388
     1         703877d-1*gammaaa*t30*t33*t34
            t39 = log(t31)
            t40 = 1/t7**4.0d+0
            t41 = 2.7027643690079733d-2*t30*t8-2.9219740937516275d-3*gam
     1         maaa*t28*t35*t40
            t42 = 5.405528738015947d-2*t30*t8-5.843948187503255d-3*gamma
     1         aa*t28*t35*t40
            t43 = 2.0d+0*t25
            t44 = -7.269696950238034d-4*t14/rhoa**2.333333333333333d+0
            t45 = log(1.425125466450768d+0*t2/(7.016926042943222d-1*t3*(
     1         7.016926042943222d-1*(1.1771443702974158d-2*t3+2.97297251
     2         88d-2)*t3+1.2236585478d-1)+3.497952466d-1)+1.0d+0)
            t46 = 5.477644184000001d-2*t5+1.0d+0
            t47 = 1/rhoa**2
            t48 = 2.18090908507141d-3*t16*t17*t24
            t49 = 6.21814d-2*t15*t24**2/t13**2
            t50 = 1/rhoa**1.6666666666666669d+0
            t51 = 1/t2**5
            t52 = -6.21814d-2*t15*t17*(-1.425125466450768d+0*t18*t2*(7.0
     1         16926042943222d-1*t3*(1.4618595922798375d-2*t19*t51*t9+1.
     2         949146123039784d-2*t20*t50*t9+9.432533847640683d-4/rhoa**
     3         2.3333333333333334d+0)+1.4618595922798375d-2*t10*t19*t51+
     4         1.949146123039784d-2*t10*t20*t50-1.1694876738238703d-1*t2
     5         0*t21*t22)-3.9586818512521327d-2*t12*t3*t50-2.37520911075
     6         12796d-1*t18*t21*t23*t3+2.850250932901536d+0*t2*t23**2/t1
     7         1**3-9.896704628130328d-3*t12*t19*t20)
            t53 = t52+t49+t48+8.443450000000001d-3*t45*t46*t47+t44
            t54 = 1/t31**2
            t55 = -6.218138173930978d-2*rhoa*t38**2*t54
            t56 = 6.218138173930978d-2*t38
            t57 = rhoa**3.333333333333335d-1
            t58 = 2.2072575680231782d-1*gammaaa*t30*t40*t57
            t59 = 1/rhoa**8.333333333333333d-1
            t60 = -1.0510750323919903d-2*gammaaa*t30*t34*t59
            t61 = 2.5225800777407753d-1*gammaaa*t33*t34*t35*t37
            t62 = 1/t29**3
            t63 = 2.1622114952063787d-1*gammaaa*t37**2*t62*t8
            t64 = 2.2072575680231782d-1*gammaaa*t28*t40*t57
            t65 = -1.0510750323919903d-2*gammaaa*t28*t34*t59
            t66 = -8.113618601517993d+0*gammaaa*t25*t26*t33*t34*t36
            t67 = t25**2
            t68 = 1/t27**3
            t69 = exp(4.0000011746725284d+0*t14*t15)
            t70 = 1/rhoa
            t71 = t52+t49+t48-8.44345d-3*t45*t46*t47+t44
            t72 = 1/t7**5.0d+0
            t73 = (t32*(6.218138173930978d-2*rhoa*(-1.0811057476031893d-
     1         1*gammaaa*t35*t8*(8.693162787340707d-1*t25*t26*t36*t8-3.1
     2         53225097175969d-2*t28*t33*t34)-2.7027643690079733d-2*t35*
     3         t37*t8+3.408969776043566d-3*gammaaa*t28*t33*t35*t72+5.843
     4         948187503255d-3*gammaaa*t28*t37*t40*t62-3.153225097175969
     5         d-2*t30*t33*t34)+3.109069086965489d-2*t41)-6.218138173930
     6         978d-2*rhoa*t38*t41*t54)*wght
            t74 = 1/t7**6.0d+0
            t75 = 6.218138173930978d-2*rhoa*t32*(1.5794814935512527d-4*g
     1         ammaaa*t36*t62*t74-1.4609870468758138d-3*t28*t35*t40)*wgh
     2         t-6.218138173930978d-2*rhoa*t41**2*t54*wght
            fnc(iq) = (6.218138173930978d-2*rhoa*log(1.0811057476031892d
     1         -1*gammaaa*t8/(1.0811057476031892d-1*gammaaa*t8/(exp(2.00
     2         00005873362642d+0*t4*t6)-1.0d+0)+1.0d+0)+1.0d+0)-1.243628
     3         d-1*rhoa*t4*t6)*wght+fnc(iq)
            Amat(iq,D1_RA) = (3.109069086965489d-2*t39+6.218138173930978
     1         d-2*rhoa*t32*t38+2.0d+0*rhoa*t25-6.21814d-2*t14*t15)*wght
     2         +Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 6.218138173930978d-2*rhoa*t32*t41*wght+Cma
     1         t(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 6.218138173930978d-2*rhoa*t32*t42*wght+Cma
     1         t(iq,D1_GAB)
            Amat2(iq,D2_RA_RA) = (t32*(6.218138173930978d-2*rhoa*(-1.081
     1         1057476031893d-1*gammaaa*t35*t8*(2.236852908489184d+2*gam
     2         maaa*t67*t68*t69*t8-1.118426454244592d+2*gammaaa*t26*t36*
     3         t67*t8-1.0811057476031893d-1*gammaaa*t26*t36*(3.333334312
     4         2271053d-1*t14*t15*t47-3.216396844291483d+1*t53)*t8+1.201
     5         2286084479878d-2*gammaaa*t28*t47*t8+t66+t65+t64)+1.201228
     6         6084479878d-2*gammaaa*t30*t47*t8+t63+t61+t60+t58)+t56)-1.
     7         0363563623218294d-2*t39*t70+t55+2.0d+0*rhoa*t53+t43)*wght
     8         +Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = (t32*(6.218138173930978d-2*rhoa*(-1.081
     1         1057476031893d-1*gammaaa*t35*t8*(-1.0811057476031893d-1*g
     2         ammaaa*t26*t36*(-3.216396844291483d+1*t71-3.3333343122271
     3         064d-1*t14*t15*t47)*t8+2.2368529084891842d+2*gammaaa*t67*
     4         t68*t69*t8-1.1184264542445921d+2*gammaaa*t26*t36*t67*t8-1
     5         .201228608447988d-2*gammaaa*t28*t47*t8+t66+t65+t64)-1.201
     6         228608447988d-2*gammaaa*t30*t47*t8+t63+t61+t60+t58)+t56)+
     7         2.0d+0*rhoa*t71+1.0363563623218296d-2*t39*t70+t55+t43)*wg
     8         ht+Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = t73+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = (t32*(6.218138173930978d-2*rhoa*(-1.08
     1         11057476031893d-1*gammaaa*t35*t8*(1.7386325574681413d+0*t
     2         25*t26*t36*t8-6.306450194351938d-2*t28*t33*t34)-5.4055287
     3         38015947d-2*t35*t37*t8+6.817939552087132d-3*gammaaa*t28*t
     4         33*t35*t72+1.168789637500651d-2*gammaaa*t28*t37*t40*t62-6
     5         .306450194351938d-2*t30*t33*t34)+3.109069086965489d-2*t42
     6         )-6.218138173930978d-2*rhoa*t38*t42*t54)*wght+Cmat2(iq,D2
     7         _RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t73+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = t75+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = 6.218138173930978d-2*rhoa*t32*(3.1589
     1         629871025054d-4*gammaaa*t36*t62*t74-2.9219740937516275d-3
     2         *t28*t35*t40)*wght-6.218138173930978d-2*rhoa*t41*t42*t54*
     3         wght+Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = t75+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = 6.218138173930978d-2*rhoa*t32*(6.3179
     1         25974205011d-4*gammaaa*t36*t62*t74-5.843948187503255d-3*t
     2         28*t35*t40)*wght-6.218138173930978d-2*rhoa*t42**2*t54*wgh
     3         t+Cmat2(iq,D2_GAB_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = 1/t2
            t4 = 1.325688999052018d-1*t3+1.0d+0
            t5 = t2**5.0d-1
            t6 = 1/t5
            t7 = 2.4141993114533214d-2*t6+1.0186556948d-1
            t8 = 7.876233178997433d-1*t6*t7+2.2308199064d-1
            t9 = 7.876233178997433d-1*t6*t8+4.7231125998d-1
            t10 = 1/t9
            t11 = 1.269642451250142d+0*t10*t5+1.0d+0
            t12 = log(t11)
            t13 = rhoa-rhob
            t14 = 1/t1
            t15 = 1.0d+0-t13*t14
            t16 = t15**1.3333333333333333d+0
            t17 = t13*t14+1.0d+0
            t18 = t17**1.3333333333333333d+0
            t19 = 1.923661050931536d+0*t18+1.923661050931536d+0*t16-3.84
     1         7322101863072d+0
            t20 = 6.901399211255826d-2*t3+1.0d+0
            t21 = 1.3212998810398843d-2*t6+2.9729725188d-2
            t22 = 7.876233178997433d-1*t21*t6+1.2236585478d-1
            t23 = 7.876233178997433d-1*t22*t6+3.497952466d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t24*t5+1.0d+0
            t26 = log(t25)
            t27 = t13**4
            t28 = 1/t1**4
            t29 = 1.2746961887000874d-1*t3+1.0d+0
            t30 = 1.530901310039024d-2*t6+1.0465751434d-1
            t31 = 7.876233178997433d-1*t30*t6+1.9269083139d-1
            t32 = 7.876233178997433d-1*t31*t6+4.3896648423d-1
            t33 = 1/t32
            t34 = 1.269642451250142d+0*t33*t5+1.0d+0
            t35 = log(t34)
            t36 = 1.709920934161365d+0*(6.21814d-2*t12*t4-3.10907d-2*t29
     1         *t35)-3.37738d-2*t20*t26
            t37 = t27*t28*t36+3.37738d-2*t20*t26
            t38 = 5.848223622634648d-1*t19*t37-6.21814d-2*t12*t4
            t39 = t15**6.666666666666666d-1
            t40 = t17**6.666666666666666d-1
            t41 = 5.0d-1*t40+5.0d-1*t39
            t42 = t41**3.0d+0
            t43 = gammabb+2.0d+0*gammaab+gammaaa
            t44 = t1**1.1666666666666667d+0
            t45 = 1/t44**2.0d+0
            t46 = t41**2.0d+0
            t47 = 1/t46
            t48 = 1/t42
            t49 = exp(-3.216396844291483d+1*t38*t48)
            t50 = t49-1.0d+0
            t51 = 1/t50
            t52 = 1.3621078885675922d-1*t43*t45*t47*t51+1.0d+0
            t53 = 1/t52
            t54 = 1.3621078885675922d-1*t43*t45*t47*t53+1.0d+0
            t55 = log(t54)
            t56 = 1/t1**1.3333333333333336d+0
            t57 = 1/t1**6.666666666666667d-1
            t58 = 1/t5**3
            t59 = -1.3127055298329054d-1*t57*t58*t7-3.169132786263567d-3
     1         *t56
            t60 = 7.876233178997433d-1*t59*t6-1.3127055298329054d-1*t57*
     1         t58*t8
            t61 = 1/t9**2
            t62 = 2.11607075208357d-1*t10*t57*t6-1.269642451250142d+0*t5
     1         *t60*t61
            t63 = 1/t11
            t64 = -6.21814d-2*t4*t62*t63
            t65 = 1/t1**1.3333333333333333d+0
            t66 = 2.747773264188438d-3*t12*t65
            t67 = -1.3127055298329054d-1*t21*t57*t58-1.7344776604086162d
     1         -3*t56
            t68 = 7.876233178997433d-1*t6*t67-1.3127055298329054d-1*t22*
     1         t57*t58
            t69 = 1/t23**2
            t70 = 2.11607075208357d-1*t24*t57*t6-1.269642451250142d+0*t5
     1         *t68*t69
            t71 = 1/t25
            t72 = 3.37738d-2*t20*t70*t71
            t73 = -7.769549222703733d-4*t26*t65
            t74 = -1.3127055298329054d-1*t30*t57*t58-2.0096226153166658d
     1         -3*t56
            t75 = 7.876233178997433d-1*t6*t74-1.3127055298329054d-1*t31*
     1         t57*t58
            t76 = 1/t32**2
            t77 = 2.11607075208357d-1*t33*t57*t6-1.269642451250142d+0*t5
     1         *t75*t76
            t78 = 1/t34
            t79 = 1.709920934161365d+0*(-3.10907d-2*t29*t77*t78+1.321039
     1         8931339265d-3*t35*t65-2.747773264188438d-3*t12*t65+6.2181
     2         4d-2*t4*t62*t63)-3.37738d-2*t20*t70*t71+7.769549222703733
     3         d-4*t26*t65
            t80 = t27*t28*t79
            t81 = 1/t1**5
            t82 = -4*t27*t36*t81
            t83 = t13**3
            t84 = 4*t28*t36*t83+t82+t80+t73+t72
            t85 = 1/t1**2
            t86 = t13*t85
            t87 = -t14
            t88 = t87+t86
            t89 = t15**3.333333333333333d-1
            t90 = -t13*t85
            t91 = t90+t14
            t92 = t17**3.333333333333333d-1
            t93 = 2.564881401242048d+0*t91*t92+2.564881401242048d+0*t88*
     1         t89
            t94 = 5.848223622634648d-1*t37*t93+5.848223622634648d-1*t19*
     1         t84+t66+t64
            t95 = 1.0d+0*t38
            t96 = 1/t54
            t97 = 1/t89
            t98 = 1/t92
            t99 = 3.333333333333333d-1*t91*t98+3.333333333333333d-1*t88*
     1         t97
            t100 = t1**1.6666666666666674d-1
            t101 = 1/t44**3.0d+0
            t102 = -3.1782517399910487d-1*t100*t101*t43*t47*t53
            t103 = 1/t52**2
            t104 = -3.1782517399910487d-1*t100*t101*t43*t47*t51
            t105 = 1/t50**2
            t106 = 1/t41**4.0d+0
            t107 = 9.649190532874448d+1*t106*t38*t99-3.216396844291483d+
     1         1*t48*t94
            t108 = -2.7242157771351844d-1*t43*t45*t48*t51*t99-1.36210788
     1         85675922d-1*t105*t107*t43*t45*t47*t49+t104
            t109 = -2.7242157771351844d-1*t43*t45*t48*t53*t99-1.36210788
     1         85675922d-1*t103*t108*t43*t45*t47+t102
            t110 = 3.109069086965489d-2*t42*t55
            t111 = -4*t28*t36*t83+t82+t80+t73+t72
            t112 = t86+t14
            t113 = t90+t87
            t114 = 2.564881401242048d+0*t113*t92+2.564881401242048d+0*t1
     1         12*t89
            t115 = t66+t64+5.848223622634648d-1*t114*t37+5.8482236226346
     1         48d-1*t111*t19
            t116 = 3.333333333333333d-1*t113*t98+3.333333333333333d-1*t1
     1         12*t97
            t117 = 9.649190532874448d+1*t106*t116*t38-3.216396844291483d
     1         +1*t115*t48
            t118 = -2.7242157771351844d-1*t116*t43*t45*t48*t51-1.3621078
     1         885675922d-1*t105*t117*t43*t45*t47*t49+t104
            t119 = -2.7242157771351844d-1*t116*t43*t45*t48*t53-1.3621078
     1         885675922d-1*t103*t118*t43*t45*t47+t102
            t120 = 1/t44**4.0d+0
            t121 = 1.3621078885675922d-1*t45*t47*t53-1.855337900098064d-
     1         2*t103*t106*t120*t43*t51
            t122 = 3.109069086965489d-2*t1*t121*t42*t96*wght
            t123 = 2.7242157771351844d-1*t45*t47*t53-3.710675800196128d-
     1         2*t103*t106*t120*t43*t51
            t124 = t62**2
            t125 = 1/t11**2
            t126 = 6.21814d-2*t124*t125*t4
            t127 = 1/t1**2.3333333333333334d+0
            t128 = 1/t5**5
            t129 = 1/t1**1.6666666666666669d+0
            t130 = 2.539284902500284d+0*t5*t60**2/t9**3-1.26964245125014
     1         2d+0*t5*t61*(8.751370198886037d-2*t129*t58*t8+6.563527649
     2         164527d-2*t128*t56*t8+7.876233178997433d-1*t6*(8.75137019
     3         8886037d-2*t129*t58*t7+6.563527649164527d-2*t128*t56*t7+4
     4         .753699179395351d-3*t127)-2.625411059665811d-1*t57*t58*t5
     5         9)-4.23214150416714d-1*t57*t6*t60*t61-1.4107138347223802d
     6         -1*t10*t129*t6-3.52678458680595d-2*t10*t56*t58
            t131 = -6.21814d-2*t130*t4*t63
            t132 = 5.495546528376876d-3*t62*t63*t65
            t133 = 1/t1**2.333333333333333d+0
            t134 = -3.663697685584584d-3*t12*t133
            t135 = t70**2
            t136 = 1/t25**2
            t137 = -3.37738d-2*t135*t136*t20
            t138 = -4.23214150416714d-1*t57*t6*t68*t69-1.269642451250142
     1         d+0*t5*(-2.625411059665811d-1*t57*t58*t67+7.8762331789974
     2         33d-1*(8.751370198886037d-2*t129*t21*t58+6.56352764916452
     3         7d-2*t128*t21*t56+2.601716490612924d-3*t127)*t6+8.7513701
     4         98886037d-2*t129*t22*t58+6.563527649164527d-2*t128*t22*t5
     5         6)*t69+2.539284902500284d+0*t5*t68**2/t23**3-1.4107138347
     6         223802d-1*t129*t24*t6-3.52678458680595d-2*t24*t56*t58
            t139 = 3.37738d-2*t138*t20*t71
            t140 = -1.5539098445407465d-3*t65*t70*t71
            t141 = 1.0359398963604977d-3*t133*t26
            t142 = t27*t28*(1.709920934161365d+0*(2.642079786267853d-3*t
     1         65*t77*t78-3.10907d-2*t29*(-4.23214150416714d-1*t57*t6*t7
     2         5*t76-1.269642451250142d+0*t5*(-2.625411059665811d-1*t57*
     3         t58*t74+7.876233178997433d-1*(8.751370198886037d-2*t129*t
     4         30*t58+6.563527649164527d-2*t128*t30*t56+3.01443392297499
     5         83d-3*t127)*t6+8.751370198886037d-2*t129*t31*t58+6.563527
     6         649164527d-2*t128*t31*t56)*t76+2.539284902500284d+0*t5*t7
     7         5**2/t32**3-1.4107138347223802d-1*t129*t33*t6-3.526784586
     8         80595d-2*t33*t56*t58)*t78+3.10907d-2*t29*t77**2/t34**2-5.
     9         495546528376876d-3*t62*t63*t65+6.21814d-2*t130*t4*t63-6.2
     :         1814d-2*t124*t125*t4-1.7613865241785687d-3*t133*t35+3.663
     ;         697685584584d-3*t12*t133)+1.5539098445407465d-3*t65*t70*t
     <         71-3.37738d-2*t138*t20*t71-1.0359398963604977d-3*t133*t26
     =         +3.37738d-2*t135*t136*t20)
            t143 = -8*t27*t79*t81
            t144 = 20*t27*t36/t1**6
            t145 = t13**2
            t146 = 12*t145*t28*t36
            t147 = t88**2
            t148 = 1/t39
            t149 = 1/t1**3
            t150 = -2*t13*t149
            t151 = 2*t85
            t152 = t151+t150
            t153 = t91**2
            t154 = 1/t40
            t155 = 2*t13*t149
            t156 = -2*t85
            t157 = t156+t155
            t158 = 1.1696447245269297d+0*t84*t93+5.848223622634648d-1*t3
     1         7*(2.564881401242048d+0*t157*t92+2.564881401242048d+0*t15
     2         2*t89+8.549604670806825d-1*t153*t154+8.549604670806825d-1
     3         *t147*t148)+5.848223622634648d-1*t19*(-32*t36*t81*t83+8*t
     4         28*t79*t83+t146+t144+t143+t142+t141+t140+t139+t137)+t134+
     5         t132+t131+t126
            t159 = t99**2
            t160 = 1/t16
            t161 = 1/t18
            t162 = 3.333333333333333d-1*t157*t98+3.333333333333333d-1*t1
     1         52*t97-1.111111111111111d-1*t153*t161-1.111111111111111d-
     2         1*t147*t160
            t163 = t1**3.333333333333335d-1
            t164 = 1.1123881089968671d+0*t120*t163*t43*t47*t53
            t165 = 1/t1**8.333333333333333d-1
            t166 = -5.297086233318417d-2*t101*t165*t43*t47*t53
            t167 = 1.1123881089968671d+0*t120*t163*t43*t47*t51
            t168 = -5.297086233318417d-2*t101*t165*t43*t47*t51
            t169 = 1/t41**5.0d+0
            t170 = exp(-6.432793688582966d+1*t38*t48)
            t171 = 1/t50**3
            t172 = t107**2
            t173 = 1/t52**3
            t174 = 1/t54**2
            t175 = 5.848223622634648d-1*t111*t93+5.848223622634648d-1*t3
     1         7*(5.129762802484096d+0*t13*t149*t92+8.549604670806825d-1
     2         *t113*t154*t91-5.129762802484096d+0*t13*t149*t89+8.549604
     3         670806825d-1*t112*t148*t88)+5.848223622634648d-1*t114*t84
     4         +5.848223622634648d-1*t19*(-12*t145*t28*t36+t144+t143+t14
     5         2+t141+t140+t139+t137)+t134+t132+t131+t126
            t176 = 6.666666666666666d-1*t13*t149*t98-6.666666666666666d-
     1         1*t13*t149*t97-1.111111111111111d-1*t113*t161*t91-1.11111
     2         1111111111d-1*t112*t160*t88
            t177 = t112**2
            t178 = t156+t150
            t179 = t113**2
            t180 = t155+t151
            t181 = 5.848223622634648d-1*t37*(2.564881401242048d+0*t180*t
     1         92+2.564881401242048d+0*t178*t89+8.549604670806825d-1*t15
     2         4*t179+8.549604670806825d-1*t148*t177)+5.848223622634648d
     3         -1*t19*(32*t36*t81*t83-8*t28*t79*t83+t146+t144+t143+t142+
     4         t141+t140+t139+t137)+t134+t132+t131+t126+1.16964472452692
     5         97d+0*t111*t114
            t182 = t116**2
            t183 = 3.333333333333333d-1*t180*t98+3.333333333333333d-1*t1
     1         78*t97-1.111111111111111d-1*t161*t179-1.111111111111111d-
     2         1*t160*t177
            t184 = t117**2
            t185 = 3.109069086965489d-2*t121*t42
            t186 = -3.1782517399910487d-1*t100*t101*t47*t53
            t187 = 1/t44**5.0d+0
            t188 = 4.3291217668954834d-2*t100*t103*t106*t187*t43*t51
            t189 = -3.1782517399910487d-1*t100*t101*t47*t51
            t190 = (t96*(3.109069086965489d-2*t1*t42*(-1.362107888567592
     1         2d-1*t103*t43*t45*t47*(-2.7242157771351844d-1*t45*t48*t51
     2         *t99-1.3621078885675922d-1*t105*t107*t45*t47*t49+t189)-2.
     3         7242157771351844d-1*t45*t48*t53*t99+3.710675800196128d-2*
     4         t103*t120*t169*t43*t51*t99+3.710675800196128d-2*t106*t108
     5         *t120*t173*t43*t51-1.3621078885675922d-1*t103*t108*t45*t4
     6         7+t188+t186)+9.327207260896466d-2*t1*t121*t46*t99+t185)-3
     7         .109069086965489d-2*t1*t109*t121*t174*t42)*wght
            t191 = 3.109069086965489d-2*t123*t42
            t192 = -6.356503479982097d-1*t100*t101*t47*t53
            t193 = 8.658243533790967d-2*t100*t103*t106*t187*t43*t51
            t194 = -6.356503479982097d-1*t100*t101*t47*t51
            t195 = ((3.109069086965489d-2*t1*t42*(-2.7242157771351844d-1
     1         *t116*t45*t48*t53-1.3621078885675922d-1*t103*t43*t45*t47*
     2         (-2.7242157771351844d-1*t116*t45*t48*t51-1.36210788856759
     3         22d-1*t105*t117*t45*t47*t49+t189)+3.710675800196128d-2*t1
     4         06*t118*t120*t173*t43*t51+3.710675800196128d-2*t103*t116*
     5         t120*t169*t43*t51-1.3621078885675922d-1*t103*t118*t45*t47
     6         +t188+t186)+9.327207260896466d-2*t1*t116*t121*t46+t185)*t
     7         96-3.109069086965489d-2*t1*t119*t121*t174*t42)*wght
            t196 = 1/t44**6.0d+0
            t197 = 1/t41**6.0d+0
            t198 = 3.109069086965489d-2*t1*t42*(5.054340779364009d-3*t10
     1         5*t173*t196*t197*t43-3.710675800196128d-2*t103*t106*t120*
     2         t51)*t96*wght-3.109069086965489d-2*t1*t121**2*t174*t42*wg
     3         ht
            t199 = 3.109069086965489d-2*t1*t42*(1.0108681558728018d-2*t1
     1         05*t173*t196*t197*t43-7.421351600392256d-2*t103*t106*t120
     2         *t51)*t96*wght-3.109069086965489d-2*t1*t121*t123*t174*t42
     3         *wght
            fnc(iq) = (3.109069086965489d-2*t1*t42*t55+1.0d+0*t1*t38)*wg
     1         ht+fnc(iq)
            Amat(iq,D1_RA) = (9.327207260896466d-2*t1*t46*t55*t99+3.1090
     1         69086965489d-2*t1*t109*t42*t96+t95+1.0d+0*t1*t94+t110)*wg
     2         ht+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = (3.109069086965489d-2*t1*t119*t42*t96+t95+9
     1         .327207260896466d-2*t1*t116*t46*t55+1.0d+0*t1*t115+t110)*
     2         wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = t122+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 3.109069086965489d-2*t1*t123*t42*t96*wght+
     1         Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = t122+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RA_RA) = (t96*(3.109069086965489d-2*t1*t42*(-1.3
     1         621078885675922d-1*t103*t43*t45*t47*(-1.3621078885675922d
     2         -1*t105*t43*t45*t47*t49*(1.9298381065748896d+2*t106*t94*t
     3         99-3.216396844291483d+1*t158*t48-3.859676213149779d+2*t15
     4         9*t169*t38+9.649190532874448d+1*t106*t162*t38)+1.27130069
     5         59964196d+0*t100*t101*t43*t48*t51*t99+5.448431554270369d-
     6         1*t105*t107*t43*t45*t48*t49*t99-2.7242157771351844d-1*t16
     7         2*t43*t45*t48*t51+8.172647331405554d-1*t106*t159*t43*t45*
     8         t51-1.3621078885675922d-1*t105*t172*t43*t45*t47*t49+6.356
     9         503479982097d-1*t100*t101*t105*t107*t43*t47*t49+2.7242157
     :         771351844d-1*t170*t171*t172*t43*t45*t47+t168+t167)+1.2713
     ;         006959964196d+0*t100*t101*t43*t48*t53*t99+5.4484315542703
     <         69d-1*t103*t108*t43*t45*t48*t99-2.7242157771351844d-1*t16
     =         2*t43*t45*t48*t53+8.172647331405554d-1*t106*t159*t43*t45*
     >         t53+2.7242157771351844d-1*t108**2*t173*t43*t45*t47+6.3565
     ?         03479982097d-1*t100*t101*t103*t108*t43*t47+t166+t164)+1.8
     @         654414521792934d-1*t1*t109*t46*t99+6.218138173930978d-2*t
     1         109*t42)+1.8654414521792934d-1*t46*t55*t99+2.0d+0*t94+9.3
     2         27207260896466d-2*t1*t162*t46*t55+1.8654414521792934d-1*t
     3         1*t159*t41*t55-3.109069086965489d-2*t1*t109**2*t174*t42+1
     4         .0d+0*t1*t158)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = (t96*(3.109069086965489d-2*t1*t42*(-1.3
     1         621078885675922d-1*t103*t43*t45*t47*(-1.3621078885675922d
     2         -1*t105*t43*t45*t47*t49*(-3.859676213149779d+2*t116*t169*
     3         t38*t99+9.649190532874448d+1*t106*t115*t99+9.649190532874
     4         448d+1*t106*t116*t94-3.216396844291483d+1*t175*t48+9.6491
     5         90532874448d+1*t106*t176*t38)+6.356503479982097d-1*t100*t
     6         101*t43*t48*t51*t99+8.172647331405554d-1*t106*t116*t43*t4
     7         5*t51*t99+2.7242157771351844d-1*t105*t117*t43*t45*t48*t49
     8         *t99-2.7242157771351844d-1*t176*t43*t45*t48*t51+6.3565034
     9         79982097d-1*t100*t101*t116*t43*t48*t51+2.7242157771351844
     :         d-1*t105*t107*t116*t43*t45*t48*t49-1.3621078885675922d-1*
     ;         t105*t107*t117*t43*t45*t47*t49+3.1782517399910487d-1*t100
     <         *t101*t105*t117*t43*t47*t49+3.1782517399910487d-1*t100*t1
     =         01*t105*t107*t43*t47*t49+2.7242157771351844d-1*t107*t117*
     >         t170*t171*t43*t45*t47+t168+t167)+6.356503479982097d-1*t10
     ?         0*t101*t43*t48*t53*t99+8.172647331405554d-1*t106*t116*t43
     @         *t45*t53*t99+2.7242157771351844d-1*t103*t118*t43*t45*t48*
     1         t99-2.7242157771351844d-1*t176*t43*t45*t48*t53+6.35650347
     2         9982097d-1*t100*t101*t116*t43*t48*t53+2.7242157771351844d
     3         -1*t103*t108*t116*t43*t45*t48+2.7242157771351844d-1*t108*
     4         t118*t173*t43*t45*t47+3.1782517399910487d-1*t100*t101*t10
     5         3*t118*t43*t47+3.1782517399910487d-1*t100*t101*t103*t108*
     6         t43*t47+t166+t164)+9.327207260896466d-2*t1*t119*t46*t99+9
     7         .327207260896466d-2*t1*t109*t116*t46+3.109069086965489d-2
     8         *t119*t42+3.109069086965489d-2*t109*t42)+9.32720726089646
     9         6d-2*t46*t55*t99+1.8654414521792934d-1*t1*t116*t41*t55*t9
     :         9+1.0d+0*t94+9.327207260896466d-2*t1*t176*t46*t55+9.32720
     ;         7260896466d-2*t116*t46*t55-3.109069086965489d-2*t1*t109*t
     <         119*t174*t42+1.0d+0*t1*t175+1.0d+0*t115)*wght+Amat2(iq,D2
     =         _RA_RB)
            Amat2(iq,D2_RB_RB) = ((3.109069086965489d-2*t1*t42*(-2.72421
     1         57771351844d-1*t183*t43*t45*t48*t53+1.2713006959964196d+0
     2         *t100*t101*t116*t43*t48*t53+8.172647331405554d-1*t106*t18
     3         2*t43*t45*t53-1.3621078885675922d-1*t103*t43*t45*t47*(-2.
     4         7242157771351844d-1*t183*t43*t45*t48*t51+1.27130069599641
     5         96d+0*t100*t101*t116*t43*t48*t51+8.172647331405554d-1*t10
     6         6*t182*t43*t45*t51-1.3621078885675922d-1*t105*t43*t45*t47
     7         *(-3.216396844291483d+1*t181*t48+9.649190532874448d+1*t10
     8         6*t183*t38-3.859676213149779d+2*t169*t182*t38+1.929838106
     9         5748896d+2*t106*t115*t116)*t49+5.448431554270369d-1*t105*
     :         t116*t117*t43*t45*t48*t49-1.3621078885675922d-1*t105*t184
     ;         *t43*t45*t47*t49+6.356503479982097d-1*t100*t101*t105*t117
     <         *t43*t47*t49+2.7242157771351844d-1*t170*t171*t184*t43*t45
     =         *t47+t168+t167)+5.448431554270369d-1*t103*t116*t118*t43*t
     >         45*t48+2.7242157771351844d-1*t118**2*t173*t43*t45*t47+6.3
     ?         56503479982097d-1*t100*t101*t103*t118*t43*t47+t166+t164)+
     @         1.8654414521792934d-1*t1*t116*t119*t46+6.218138173930978d
     1         -2*t119*t42)*t96+9.327207260896466d-2*t1*t183*t46*t55+1.8
     2         654414521792934d-1*t116*t46*t55+1.8654414521792934d-1*t1*
     3         t182*t41*t55-3.109069086965489d-2*t1*t119**2*t174*t42+1.0
     4         d+0*t1*t181+2.0d+0*t115)*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = t190+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = (t96*(3.109069086965489d-2*t1*t42*(-1.
     1         3621078885675922d-1*t103*t43*t45*t47*(-5.448431554270369d
     2         -1*t45*t48*t51*t99-2.7242157771351844d-1*t105*t107*t45*t4
     3         7*t49+t194)-5.448431554270369d-1*t45*t48*t53*t99+7.421351
     4         600392256d-2*t103*t120*t169*t43*t51*t99+7.421351600392256
     5         d-2*t106*t108*t120*t173*t43*t51-2.7242157771351844d-1*t10
     6         3*t108*t45*t47+t193+t192)+9.327207260896466d-2*t1*t123*t4
     7         6*t99+t191)-3.109069086965489d-2*t1*t109*t123*t174*t42)*w
     8         ght+Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t190+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = t195+Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = ((3.109069086965489d-2*t1*t42*(-5.4484
     1         31554270369d-1*t116*t45*t48*t53-1.3621078885675922d-1*t10
     2         3*t43*t45*t47*(-5.448431554270369d-1*t116*t45*t48*t51-2.7
     3         242157771351844d-1*t105*t117*t45*t47*t49+t194)+7.42135160
     4         0392256d-2*t106*t118*t120*t173*t43*t51+7.421351600392256d
     5         -2*t103*t116*t120*t169*t43*t51-2.7242157771351844d-1*t103
     6         *t118*t45*t47+t193+t192)+9.327207260896466d-2*t1*t116*t12
     7         3*t46+t191)*t96-3.109069086965489d-2*t1*t119*t123*t174*t4
     8         2)*wght+Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = t195+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = t198+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = t199+Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = t198+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = 3.109069086965489d-2*t1*t42*(2.021736
     1         3117456036d-2*t105*t173*t196*t197*t43-1.4842703200784513d
     2         -1*t103*t106*t120*t51)*t96*wght-3.109069086965489d-2*t1*t
     3         123**2*t174*t42*wght+Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = t199+Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = t198+Cmat2(iq,D2_GBB_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 1.3212998810398843d-2*t3+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t3+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t3+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t2*t22+1.0d+0
            t24 = log(t23)
            t25 = 6.901399211255826d-2*t10+1.0d+0
            t26 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t17*t18-3.10907d-2*t11*t9)-3.37738d-2*t24*t25)+3
     2         .37738d-2*t24*t25)-6.21814d-2*t17*t18
            t27 = rhoa**1.1666666666666667d+0
            t28 = 1/t27**2.0d+0
            t29 = exp(-6.432793688582967d+1*t26)
            t30 = t29-1.0d+0
            t31 = 1/t30
            t32 = 2.1622114952063792d-1*gammaaa*t28*t31+1.0d+0
            t33 = 1/t32
            t34 = 2.1622114952063792d-1*gammaaa*t28*t33+1.0d+0
            t35 = log(t34)
            t36 = 1/rhoa**1.3333333333333333d+0
            t37 = 1/t8
            t38 = 1/t6**2
            t39 = 1/rhoa**1.3333333333333336d+0
            t40 = 1/t2**3
            t41 = 1/rhoa**6.666666666666667d-1
            t42 = -1.3127055298329054d-1*t4*t40*t41-2.0096226153166658d-
     1         3*t39
            t43 = 7.876233178997433d-1*t3*t42-1.3127055298329054d-1*t40*
     1         t41*t5
            t44 = 2.11607075208357d-1*t3*t41*t7-1.269642451250142d+0*t2*
     1         t38*t43
            t45 = 1/t16
            t46 = 1/t14**2
            t47 = -1.3127055298329054d-1*t12*t40*t41-3.169132786263567d-
     1         3*t39
            t48 = 7.876233178997433d-1*t3*t47-1.3127055298329054d-1*t13*
     1         t40*t41
            t49 = 2.11607075208357d-1*t15*t3*t41-1.269642451250142d+0*t2
     1         *t46*t48
            t50 = 1/t23
            t51 = 1/t21**2
            t52 = -1.3127055298329054d-1*t19*t40*t41-1.7344776604086162d
     1         -3*t39
            t53 = 7.876233178997433d-1*t3*t52-1.3127055298329054d-1*t20*
     1         t40*t41
            t54 = 2.11607075208357d-1*t22*t3*t41-1.269642451250142d+0*t2
     1         *t51*t53
            t55 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         3210398931339265d-3*t36*t9+6.21814d-2*t18*t45*t49-3.10907
     2         d-2*t11*t37*t44-2.747773264188438d-3*t17*t36)-3.37738d-2*
     3         t25*t50*t54+7.769549222703733d-4*t24*t36)+3.37738d-2*t25*
     4         t50*t54-7.769549222703733d-4*t24*t36)-6.21814d-2*t18*t45*
     5         t49+2.747773264188438d-3*t17*t36
            t56 = 1/t34
            t57 = rhoa**1.6666666666666674d-1
            t58 = 1/t27**3.0d+0
            t59 = 1/t32**2
            t60 = 1/t30**2
            t61 = 1.3909060459745137d+1*gammaaa*t28*t29*t55*t60-5.045160
     1         155481552d-1*gammaaa*t31*t57*t58
            t62 = -2.1622114952063792d-1*gammaaa*t28*t59*t61-5.045160155
     1         481552d-1*gammaaa*t33*t57*t58
            t63 = 1/t27**4.0d+0
            t64 = 2.1622114952063792d-1*t28*t33-4.675158550002606d-2*gam
     1         maaa*t31*t59*t63
            t65 = 1/rhoa**2.333333333333333d+0
            t66 = 1/rhoa**2.3333333333333334d+0
            t67 = 1/rhoa**1.6666666666666669d+0
            t68 = 1/t2**5
            t69 = 1/t16**2
            t70 = t49**2
            t71 = -1.269642451250142d+0*t2*t46*(7.876233178997433d-1*t3*
     1         (6.563527649164527d-2*t12*t39*t68+8.751370198886037d-2*t1
     2         2*t40*t67+4.753699179395351d-3*t66)+6.563527649164527d-2*
     3         t13*t39*t68+8.751370198886037d-2*t13*t40*t67-2.6254110596
     4         65811d-1*t40*t41*t47)-1.4107138347223802d-1*t15*t3*t67+2.
     5         539284902500284d+0*t2*t48**2/t14**3-4.23214150416714d-1*t
     6         3*t41*t46*t48-3.52678458680595d-2*t15*t39*t40
            t72 = 1/t23**2
            t73 = t54**2
            t74 = -1.269642451250142d+0*t2*t51*(7.876233178997433d-1*t3*
     1         (6.563527649164527d-2*t19*t39*t68+8.751370198886037d-2*t1
     2         9*t40*t67+2.601716490612924d-3*t66)+6.563527649164527d-2*
     3         t20*t39*t68+8.751370198886037d-2*t20*t40*t67-2.6254110596
     4         65811d-1*t40*t41*t52)-1.4107138347223802d-1*t22*t3*t67+2.
     5         539284902500284d+0*t2*t53**2/t21**3-4.23214150416714d-1*t
     6         3*t41*t51*t53-3.52678458680595d-2*t22*t39*t40
            t75 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-1
     1         .7613865241785687d-3*t65*t9+3.10907d-2*t11*t44**2/t8**2+6
     2         .21814d-2*t18*t45*t71-6.21814d-2*t18*t69*t70-3.10907d-2*t
     3         11*t37*(-1.4107138347223802d-1*t3*t67*t7-3.52678458680595
     4         d-2*t39*t40*t7-1.269642451250142d+0*t2*t38*(7.87623317899
     5         7433d-1*t3*(6.563527649164527d-2*t39*t4*t68+8.75137019888
     6         6037d-2*t4*t40*t67+3.0144339229749983d-3*t66)+6.563527649
     7         164527d-2*t39*t5*t68+8.751370198886037d-2*t40*t5*t67-2.62
     8         5411059665811d-1*t40*t41*t42)+2.539284902500284d+0*t2*t43
     9         **2/t6**3-4.23214150416714d-1*t3*t38*t41*t43)+3.663697685
     :         584584d-3*t17*t65-5.495546528376876d-3*t36*t45*t49+2.6420
     ;         79786267853d-3*t36*t37*t44)-3.37738d-2*t25*t50*t74+3.3773
     <         8d-2*t25*t72*t73-1.0359398963604977d-3*t24*t65+1.55390984
     =         45407465d-3*t36*t50*t54)+3.37738d-2*t25*t50*t74-3.37738d-
     >         2*t25*t72*t73+1.0359398963604977d-3*t24*t65-1.55390984454
     ?         07465d-3*t36*t50*t54)-6.21814d-2*t18*t45*t71+6.21814d-2*t
     @         18*t69*t70-3.663697685584584d-3*t17*t65+5.495546528376876
     1         d-3*t36*t45*t49
            t76 = rhoa**3.333333333333335d-1
            t77 = 1/rhoa**8.333333333333333d-1
            t78 = t55**2
            t79 = 1/t32**3
            t80 = 1/t34**2
            fnc(iq) = (1.5545345434827443d-2*rhoa*t35+1.0d+0*rhoa*t26)*w
     1         ght+fnc(iq)
            Amat(iq,D1_RA) = (1.5545345434827443d-2*rhoa*t56*t62+1.0d+0*
     1         rhoa*t55+1.5545345434827443d-2*t35+1.0d+0*t26)*wght+Amat(
     2         iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.5545345434827443d-2*rhoa*t56*t64*wght+Cm
     1         at(iq,D1_GAA)
            Amat2(iq,D2_RA_RA) = (-1.5545345434827443d-2*rhoa*t62**2*t80
     1         +t56*(1.5545345434827443d-2*rhoa*(4.3244229904127585d-1*g
     2         ammaaa*t28*t61**2*t79-2.1622114952063792d-1*gammaaa*t28*t
     3         59*(-8.947411633956742d+2*gammaaa*t28*t29*t60*t78+1.78948
     4         23267913484d+3*gammaaa*exp(-1.2865587377165935d+2*t26)*t2
     5         8*t78/t30**3-8.408600259135923d-2*gammaaa*t31*t58*t77+1.7
     6         65806054418543d+0*gammaaa*t31*t63*t76+1.3909060459745137d
     7         +1*gammaaa*t28*t29*t60*t75-6.490894881214397d+1*gammaaa*t
     8         29*t55*t57*t58*t60)-8.408600259135923d-2*gammaaa*t33*t58*
     9         t77+1.765806054418543d+0*gammaaa*t33*t63*t76+1.0090320310
     :         963104d+0*gammaaa*t57*t58*t59*t61)+3.1090690869654886d-2*
     ;         t62)+1.0d+0*rhoa*t75+2.0d+0*t55)*wght+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = (t56*(1.5545345434827443d-2*rhoa*(9.35
     1         0317100005212d-2*gammaaa*t31*t61*t63*t79-2.16221149520637
     2         92d-1*t28*t59*t61-2.1622114952063792d-1*gammaaa*t28*t59*(
     3         1.3909060459745137d+1*t28*t29*t55*t60-5.045160155481552d-
     4         1*t31*t57*t58)+1.0908703283339415d-1*gammaaa*t31*t57*t59/
     5         t27**5.0d+0-5.045160155481552d-1*t33*t57*t58)+1.554534543
     6         4827443d-2*t64)-1.5545345434827443d-2*rhoa*t62*t64*t80)*w
     7         ght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = -1.5545345434827443d-2*rhoa*t64**2*t8
     1         0*wght+1.5545345434827443d-2*rhoa*t56*(2.0217363117456047
     2         d-2*gammaaa*t60*t79/t27**6.0d+0-9.350317100005212d-2*t31*
     3         t59*t63)*wght+Cmat2(iq,D2_GAA_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 1.3212998810398843d-2*t3+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t3+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t3+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t2*t22+1.0d+0
            t24 = log(t23)
            t25 = 6.901399211255826d-2*t10+1.0d+0
            t26 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t17*t18-3.10907d-2*t11*t9)-3.37738d-2*t24*t25)+3
     2         .37738d-2*t24*t25)-6.21814d-2*t17*t18
            t27 = rhob**1.1666666666666667d+0
            t28 = 1/t27**2.0d+0
            t29 = exp(-6.432793688582967d+1*t26)
            t30 = t29-1.0d+0
            t31 = 1/t30
            t32 = 2.1622114952063792d-1*gammabb*t28*t31+1.0d+0
            t33 = 1/t32
            t34 = 2.1622114952063792d-1*gammabb*t28*t33+1.0d+0
            t35 = log(t34)
            t36 = 1/rhob**1.3333333333333333d+0
            t37 = 1/t8
            t38 = 1/t6**2
            t39 = 1/rhob**1.3333333333333336d+0
            t40 = 1/t2**3
            t41 = 1/rhob**6.666666666666667d-1
            t42 = -1.3127055298329054d-1*t4*t40*t41-2.0096226153166658d-
     1         3*t39
            t43 = 7.876233178997433d-1*t3*t42-1.3127055298329054d-1*t40*
     1         t41*t5
            t44 = 2.11607075208357d-1*t3*t41*t7-1.269642451250142d+0*t2*
     1         t38*t43
            t45 = 1/t16
            t46 = 1/t14**2
            t47 = -1.3127055298329054d-1*t12*t40*t41-3.169132786263567d-
     1         3*t39
            t48 = 7.876233178997433d-1*t3*t47-1.3127055298329054d-1*t13*
     1         t40*t41
            t49 = 2.11607075208357d-1*t15*t3*t41-1.269642451250142d+0*t2
     1         *t46*t48
            t50 = 1/t23
            t51 = 1/t21**2
            t52 = -1.3127055298329054d-1*t19*t40*t41-1.7344776604086162d
     1         -3*t39
            t53 = 7.876233178997433d-1*t3*t52-1.3127055298329054d-1*t20*
     1         t40*t41
            t54 = 2.11607075208357d-1*t22*t3*t41-1.269642451250142d+0*t2
     1         *t51*t53
            t55 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         3210398931339265d-3*t36*t9+6.21814d-2*t18*t45*t49-3.10907
     2         d-2*t11*t37*t44-2.747773264188438d-3*t17*t36)-3.37738d-2*
     3         t25*t50*t54+7.769549222703733d-4*t24*t36)+3.37738d-2*t25*
     4         t50*t54-7.769549222703733d-4*t24*t36)-6.21814d-2*t18*t45*
     5         t49+2.747773264188438d-3*t17*t36
            t56 = 1/t34
            t57 = rhob**1.6666666666666674d-1
            t58 = 1/t27**3.0d+0
            t59 = 1/t32**2
            t60 = 1/t30**2
            t61 = 1.3909060459745137d+1*gammabb*t28*t29*t55*t60-5.045160
     1         155481552d-1*gammabb*t31*t57*t58
            t62 = -2.1622114952063792d-1*gammabb*t28*t59*t61-5.045160155
     1         481552d-1*gammabb*t33*t57*t58
            t63 = 1/t27**4.0d+0
            t64 = 2.1622114952063792d-1*t28*t33-4.675158550002606d-2*gam
     1         mabb*t31*t59*t63
            t65 = 1/rhob**2.333333333333333d+0
            t66 = 1/rhob**2.3333333333333334d+0
            t67 = 1/rhob**1.6666666666666669d+0
            t68 = 1/t2**5
            t69 = 1/t16**2
            t70 = t49**2
            t71 = -1.269642451250142d+0*t2*t46*(7.876233178997433d-1*t3*
     1         (6.563527649164527d-2*t12*t39*t68+8.751370198886037d-2*t1
     2         2*t40*t67+4.753699179395351d-3*t66)+6.563527649164527d-2*
     3         t13*t39*t68+8.751370198886037d-2*t13*t40*t67-2.6254110596
     4         65811d-1*t40*t41*t47)-1.4107138347223802d-1*t15*t3*t67+2.
     5         539284902500284d+0*t2*t48**2/t14**3-4.23214150416714d-1*t
     6         3*t41*t46*t48-3.52678458680595d-2*t15*t39*t40
            t72 = 1/t23**2
            t73 = t54**2
            t74 = -1.269642451250142d+0*t2*t51*(7.876233178997433d-1*t3*
     1         (6.563527649164527d-2*t19*t39*t68+8.751370198886037d-2*t1
     2         9*t40*t67+2.601716490612924d-3*t66)+6.563527649164527d-2*
     3         t20*t39*t68+8.751370198886037d-2*t20*t40*t67-2.6254110596
     4         65811d-1*t40*t41*t52)-1.4107138347223802d-1*t22*t3*t67+2.
     5         539284902500284d+0*t2*t53**2/t21**3-4.23214150416714d-1*t
     6         3*t41*t51*t53-3.52678458680595d-2*t22*t39*t40
            t75 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-1
     1         .7613865241785687d-3*t65*t9+3.10907d-2*t11*t44**2/t8**2+6
     2         .21814d-2*t18*t45*t71-6.21814d-2*t18*t69*t70-3.10907d-2*t
     3         11*t37*(-1.4107138347223802d-1*t3*t67*t7-3.52678458680595
     4         d-2*t39*t40*t7-1.269642451250142d+0*t2*t38*(7.87623317899
     5         7433d-1*t3*(6.563527649164527d-2*t39*t4*t68+8.75137019888
     6         6037d-2*t4*t40*t67+3.0144339229749983d-3*t66)+6.563527649
     7         164527d-2*t39*t5*t68+8.751370198886037d-2*t40*t5*t67-2.62
     8         5411059665811d-1*t40*t41*t42)+2.539284902500284d+0*t2*t43
     9         **2/t6**3-4.23214150416714d-1*t3*t38*t41*t43)+3.663697685
     :         584584d-3*t17*t65-5.495546528376876d-3*t36*t45*t49+2.6420
     ;         79786267853d-3*t36*t37*t44)-3.37738d-2*t25*t50*t74+3.3773
     <         8d-2*t25*t72*t73-1.0359398963604977d-3*t24*t65+1.55390984
     =         45407465d-3*t36*t50*t54)+3.37738d-2*t25*t50*t74-3.37738d-
     >         2*t25*t72*t73+1.0359398963604977d-3*t24*t65-1.55390984454
     ?         07465d-3*t36*t50*t54)-6.21814d-2*t18*t45*t71+6.21814d-2*t
     @         18*t69*t70-3.663697685584584d-3*t17*t65+5.495546528376876
     1         d-3*t36*t45*t49
            t76 = rhob**3.333333333333335d-1
            t77 = 1/rhob**8.333333333333333d-1
            t78 = t55**2
            t79 = 1/t32**3
            t80 = 1/t34**2
            fnc(iq) = (1.5545345434827443d-2*rhob*t35+1.0d+0*rhob*t26)*w
     1         ght+fnc(iq)
            Amat(iq,D1_RB) = (1.5545345434827443d-2*rhob*t56*t62+1.0d+0*
     1         rhob*t55+1.5545345434827443d-2*t35+1.0d+0*t26)*wght+Amat(
     2         iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.5545345434827443d-2*rhob*t56*t64*wght+Cm
     1         at(iq,D1_GBB)
            Amat2(iq,D2_RB_RB) = (-1.5545345434827443d-2*rhob*t62**2*t80
     1         +t56*(1.5545345434827443d-2*rhob*(4.3244229904127585d-1*g
     2         ammabb*t28*t61**2*t79-2.1622114952063792d-1*gammabb*t28*t
     3         59*(-8.947411633956742d+2*gammabb*t28*t29*t60*t78+1.78948
     4         23267913484d+3*gammabb*exp(-1.2865587377165935d+2*t26)*t2
     5         8*t78/t30**3-8.408600259135923d-2*gammabb*t31*t58*t77+1.7
     6         65806054418543d+0*gammabb*t31*t63*t76+1.3909060459745137d
     7         +1*gammabb*t28*t29*t60*t75-6.490894881214397d+1*gammabb*t
     8         29*t55*t57*t58*t60)-8.408600259135923d-2*gammabb*t33*t58*
     9         t77+1.765806054418543d+0*gammabb*t33*t63*t76+1.0090320310
     :         963104d+0*gammabb*t57*t58*t59*t61)+3.1090690869654886d-2*
     ;         t62)+1.0d+0*rhob*t75+2.0d+0*t55)*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = (t56*(1.5545345434827443d-2*rhob*(9.35
     1         0317100005212d-2*gammabb*t31*t61*t63*t79-2.16221149520637
     2         92d-1*t28*t59*t61-2.1622114952063792d-1*gammabb*t28*t59*(
     3         1.3909060459745137d+1*t28*t29*t55*t60-5.045160155481552d-
     4         1*t31*t57*t58)+1.0908703283339415d-1*gammabb*t31*t57*t59/
     5         t27**5.0d+0-5.045160155481552d-1*t33*t57*t58)+1.554534543
     6         4827443d-2*t64)-1.5545345434827443d-2*rhob*t62*t64*t80)*w
     7         ght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = -1.5545345434827443d-2*rhob*t64**2*t8
     1         0*wght+1.5545345434827443d-2*rhob*t56*(2.0217363117456047
     2         d-2*gammabb*t60*t79/t27**6.0d+0-9.350317100005212d-2*t31*
     3         t59*t63)*wght+Cmat2(iq,D2_GBB_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_spbe functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& 0.1325688999052018\,{\it t_3}+1.0\\\\ 
C>   {\it t_5} &=& \sqrt{{\it t_2}}\\\\ 
C>   {\it t_6} &=& {{1}\over{{\it t_5}}}\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_5}}
C>    \over{0.7876233178997433\,{\it t_6}\,\left(0.7876233178997433
C>    \,{\it t_6}\,\left(0.02414199311453321\,{\it t_6}
C>    +0.10186556948\right)+0.22308199064\right)+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_9} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{10}} &=& 1.0-{\it t_8}\,{\it t_9}\\\\ 
C>   {\it t_{11}} &=& {\it t_8}\,{\it t_9}+1.0\\\\ 
C>   {\it t_{12}} &=& 0.06901399211255826\,{\it t_3}+1.0\\\\ 
C>   {\it t_{13}} &=& \log \left({{1.269642451250142\,{
C>    \it t_5}}\over{0.7876233178997433\,{\it t_6}\,
C>    \left(0.7876233178997433\,{\it t_6}\,\left(0.01321299881039884
C>    \,{\it t_6}+0.029729725188\right)+0.12236585478\right)
C>    +0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{14}} &=& 0.5848223622634648\,\left(1.923661050931536
C>    \,{\it t_{11}}^{{{4}\over{3}}}+1.923661050931536\,{
C>    \it t_{10}}^{{{4}\over{3}}}-3.847322101863072\right)\,
C>    \left({{{\it t_8}^4\,\left(1.709920934161365\,\left(0.0621814
C>    \,{\it t_4}\,{\it t_7}-0.0310907\,\left(0.1274696188700087
C>    \,{\it t_3}+1.0\right)\,\log \left({{1.269642451250142\,{
C>    \it t_5}}\over{0.7876233178997433\,{\it t_6}\,
C>    \left(0.7876233178997433\,{\it t_6}\,\left(0.01530901310039024
C>    \,{\it t_6}+0.10465751434\right)+0.19269083139\right)
C>    +0.43896648423}}+1.0\right)\right)-0.0337738\,{\it t_{12}}
C>    \,{\it t_{13}}\right)}\over{{\it t_1}^4}}+0.0337738\,{
C>    \it t_{12}}\,{\it t_{13}}\right)-0.0621814\,{\it t_4}\,{
C>    \it t_7}\\\\ 
C>   {\it t_{15}} &=& 0.5\,{\it t_{11}}^{{{2}\over{3}}}+0.5\,{
C>    \it t_{10}}^{{{2}\over{3}}}\\\\ 
C>   {\it t_{16}} &=& {\it t_{15}}^{3.0}\\\\ 
C>   {\it t_{17}} &=& {{1}\over{\left({
C>    \it t_1}^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{18}} &=& {{1}\over{{\it t_{15}}^{2.0}}}\\\\ 
C>   {\it t_{19}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{20}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{21}} &=& \sqrt{{\it t_{20}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{{\it t_{21}}}}\\\\ 
C>   {\it t_{23}} &=& {{1}\over{{\it t_{20}}}}\\\\ 
C>   {\it t_{24}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{21}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{22}}+0.10186556948\right)
C>    \,{\it t_{22}}+0.22308199064\right)\,{\it t_{22}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{25}} &=& 0.1325688999052018\,{\it t_{23}}+1.0\\\\ 
C>   {\it t_{26}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{21}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{22}}
C>    +0.029729725188\right)\,{\it t_{22}}+0.12236585478\right)\,{
C>    \it t_{22}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{27}} &=& 0.06901399211255826\,{\it t_{23}}+1.0\\\\ 
C>   {\it t_{28}} &=& 0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{26}}\,{\it t_{27}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{24}}\,{\it t_{25}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{21}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{22}}+0.10465751434\right)
C>    \,{\it t_{22}}+0.19269083139\right)\,{\it t_{22}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{23}}+1.0\right)\right)-0.0337738\,{\it t_{26}}\,{
C>    \it t_{27}}\right)\right)-0.0621814\,{\it t_{24}}\,{
C>    \it t_{25}}\\\\ 
C>   {\it t_{29}} &=& {{1}\over{
C>    \left(\rho_s^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   f &=& 0.03109069086965489\,{\it t_1}\,{\it t_{16}}\,\log 
C>    \left({{0.1362107888567592\,{\it t_{17}}\,{\it t_{18}}\,{
C>    \it t_{19}}}\over{{{0.1362107888567592\,{\it t_{17}}\,{
C>    \it t_{18}}\,{\it t_{19}}}\over{{{1}
C>    \over{e^{{{32.16396844291483\,{\it t_{14}}}\over{{
C>    \it t_{16}}}}}}}-1.0}}+1.0}}+1.0\right)+1.0\,{\it t_1}\,{
C>    \it t_{14}}\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 0.01554534543482744\,\rho_s\,\log 
C>    \left({{0.2162211495206379\,{\it t_{29}}\,\sigma_{ss}}
C>    \over{{{0.2162211495206379\,{\it t_{29}}\,\sigma_{ss}}
C>    \over{{{1}\over{e^{64.32793688582967\,{\it t_{28}}}}}-1.0}}
C>    +1.0}}+1.0\right)+1.0\,{\it t_{28}}\,\rho_s\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] M Swart, M Sola, FM Bickelhaupt, J.Chem.Phys. 131
C>    , 094103 (2009)  , DOI: 
C> <a href="https://doi.org/10.1063/1.3213193 "> 
C> 10.1063/1.3213193 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_spbe_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,*)  !< [Output] The 2nd derivative wrt rgamma 
                                    !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,*)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,*)  !< [Output] The 3rd derivative wrt rgamma 
                                    !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = log(1.4251254664507676d+0*t2/(7.016926042943223d-1*t3*(
     1         7.016926042943223d-1*(2.150807071909054d-2*t3+1.018655694
     2         8d-1)*t3+2.2308199064d-1)+4.7231125998d-1)+1.0d+0)
            t5 = 1/t1
            t6 = 1.0522000558389215d-1*t5+1.0d+0
            t7 = rhoa**1.1666666666666667d+0
            t8 = 1/t7**2.0d+0
            t9 = 2.1508070719090538d-2*t3+1.0186556948d-1
            t10 = 7.016926042943222d-1*t3*t9+2.2308199064d-1
            t11 = 7.016926042943222d-1*t10*t3+4.7231125998d-1
            t12 = 1/t11
            t13 = 1.425125466450768d+0*t12*t2+1.0d+0
            t14 = log(t13)
            t15 = 1.0522000558389213d-1*t5+1.0d+0
            t16 = 1/rhoa**1.3333333333333333d+0
            t17 = 1/t13
            t18 = 1/t11**2
            t19 = 1/rhoa**1.3333333333333336d+0
            t20 = 1/t2**3
            t21 = 1/rhoa**6.666666666666667d-1
            t22 = -5.847438369119352d-2*t20*t21*t9-1.2576711796854242d-3
     1         *t19
            t23 = 7.016926042943222d-1*t22*t3-5.847438369119352d-2*t10*t
     1         20*t21
            t24 = 1.1876045553756398d-1*t12*t21*t3-1.425125466450768d+0*
     1         t18*t2*t23
            t25 = 1.090454542535705d-3*t14*t16-6.21814d-2*t15*t17*t24
            t26 = exp(2.0000005873362642d+0*t14*t15)
            t27 = t26-1.0d+0
            t28 = 1/t27
            t29 = 1.0811057476031893d-1*gammaaa*t28*t8+1.0d+0
            t30 = 1/t29
            t31 = 1.0811057476031893d-1*gammaaa*t30*t8+1.0d+0
            t32 = 1/t31
            t33 = rhoa**1.6666666666666674d-1
            t34 = 1/t7**3.0d+0
            t35 = 1/t29**2
            t36 = 1/t27**2
            t37 = 3.4772651149362827d+0*gammaaa*t25*t26*t36*t8-1.2612900
     1         388703877d-1*gammaaa*t28*t33*t34
            t38 = -1.0811057476031893d-1*gammaaa*t35*t37*t8-1.2612900388
     1         703877d-1*gammaaa*t30*t33*t34
            t39 = log(t31)
            t40 = 1/t7**4.0d+0
            t41 = 2.7027643690079733d-2*t30*t8-2.9219740937516275d-3*gam
     1         maaa*t28*t35*t40
            t42 = 5.405528738015947d-2*t30*t8-5.843948187503255d-3*gamma
     1         aa*t28*t35*t40
            t43 = 2.0d+0*t25
            t44 = 1/rhoa**2.333333333333333d+0
            t45 = -7.269696950238034d-4*t14*t44
            t46 = 1.1771443702974158d-2*t3+2.9729725188d-2
            t47 = 7.016926042943222d-1*t3*t46+1.2236585478d-1
            t48 = 7.016926042943222d-1*t3*t47+3.497952466d-1
            t49 = 1/t48
            t50 = 1.425125466450768d+0*t2*t49+1.0d+0
            t51 = log(t50)
            t52 = 5.477644184000001d-2*t5+1.0d+0
            t53 = 1/rhoa**2
            t54 = 2.18090908507141d-3*t16*t17*t24
            t55 = 1/t13**2
            t56 = t24**2
            t57 = 6.21814d-2*t15*t55*t56
            t58 = 1/t11**3
            t59 = t23**2
            t60 = 1/rhoa**2.3333333333333334d+0
            t61 = 1/rhoa**1.6666666666666669d+0
            t62 = 1/t2**5
            t63 = 1.4618595922798375d-2*t19*t62*t9+1.949146123039784d-2*
     1         t20*t61*t9+9.432533847640683d-4*t60
            t64 = 7.016926042943222d-1*t3*t63+1.4618595922798375d-2*t10*
     1         t19*t62+1.949146123039784d-2*t10*t20*t61-1.16948767382387
     2         03d-1*t20*t21*t22
            t65 = -1.425125466450768d+0*t18*t2*t64-3.9586818512521327d-2
     1         *t12*t3*t61+2.850250932901536d+0*t2*t58*t59-2.37520911075
     2         12796d-1*t18*t21*t23*t3-9.896704628130328d-3*t12*t19*t20
            t66 = -6.21814d-2*t15*t17*t65
            t67 = t66+t57+t54+8.443450000000001d-3*t51*t52*t53+t45
            t68 = 1/t31**2
            t69 = t38**2
            t70 = -6.218138173930978d-2*rhoa*t68*t69
            t71 = 6.218138173930978d-2*t38
            t72 = rhoa**3.333333333333335d-1
            t73 = 2.2072575680231782d-1*gammaaa*t30*t40*t72
            t74 = 1/rhoa**8.333333333333333d-1
            t75 = -1.0510750323919903d-2*gammaaa*t30*t34*t74
            t76 = 2.5225800777407753d-1*gammaaa*t33*t34*t35*t37
            t77 = 1/t29**3
            t78 = t37**2
            t79 = 2.1622114952063787d-1*gammaaa*t77*t78*t8
            t80 = 2.2072575680231782d-1*gammaaa*t28*t40*t72
            t81 = -1.0510750323919903d-2*gammaaa*t28*t34*t74
            t82 = -8.113618601517993d+0*gammaaa*t25*t26*t33*t34*t36
            t83 = t25**2
            t84 = 3.3333343122271053d-1*t14*t15*t53-3.216396844291483d+1
     1         *t67
            t85 = 1/t27**3
            t86 = exp(4.0000011746725284d+0*t14*t15)
            t87 = 2.236852908489184d+2*gammaaa*t8*t83*t85*t86-1.08110574
     1         76031893d-1*gammaaa*t26*t36*t8*t84-1.118426454244592d+2*g
     2         ammaaa*t26*t36*t8*t83+t82+t81+t80+1.2012286084479878d-2*g
     3         ammaaa*t28*t53*t8
            t88 = -1.0811057476031893d-1*gammaaa*t35*t8*t87+1.2012286084
     1         479878d-2*gammaaa*t30*t53*t8+t79+t76+t75+t73
            t89 = 6.218138173930978d-2*rhoa*t88+t71
            t90 = 1/rhoa
            t91 = t66+t57+t54-8.44345d-3*t51*t52*t53+t45
            t92 = -3.216396844291483d+1*t91-3.3333343122271064d-1*t14*t1
     1         5*t53
            t93 = -1.0811057476031893d-1*gammaaa*t26*t36*t8*t92+2.236852
     1         9084891842d+2*gammaaa*t8*t83*t85*t86-1.1184264542445921d+
     2         2*gammaaa*t26*t36*t8*t83+t82+t81+t80-1.201228608447988d-2
     3         *gammaaa*t28*t53*t8
            t94 = -1.0811057476031893d-1*gammaaa*t35*t8*t93-1.2012286084
     1         47988d-2*gammaaa*t30*t53*t8+t79+t76+t75+t73
            t95 = 6.218138173930978d-2*rhoa*t94+t71
            t96 = 1/t7**5.0d+0
            t97 = 8.693162787340707d-1*t25*t26*t36*t8-3.153225097175969d
     1         -2*t28*t33*t34
            t98 = -1.0811057476031893d-1*gammaaa*t35*t8*t97+3.4089697760
     1         43566d-3*gammaaa*t28*t33*t35*t96-2.7027643690079733d-2*t3
     2         5*t37*t8+5.843948187503255d-3*gammaaa*t28*t37*t40*t77-3.1
     3         53225097175969d-2*t30*t33*t34
            t99 = 6.218138173930978d-2*rhoa*t98+3.109069086965489d-2*t41
            t100 = (t32*t99-6.218138173930978d-2*rhoa*t38*t41*t68)*wght
            t101 = 1.7386325574681413d+0*t25*t26*t36*t8-6.30645019435193
     1         8d-2*t28*t33*t34
            t102 = 6.817939552087132d-3*gammaaa*t28*t33*t35*t96-5.405528
     1         738015947d-2*t35*t37*t8-1.0811057476031893d-1*gammaaa*t10
     2         1*t35*t8+1.168789637500651d-2*gammaaa*t28*t37*t40*t77-6.3
     3         06450194351938d-2*t30*t33*t34
            t103 = 3.109069086965489d-2*t42+6.218138173930978d-2*rhoa*t1
     1         02
            t104 = t41**2
            t105 = 1/t7**6.0d+0
            t106 = 1.5794814935512527d-4*gammaaa*t105*t36*t77-1.46098704
     1         68758138d-3*t28*t35*t40
            t107 = 6.218138173930978d-2*rhoa*t106*t32*wght-6.21813817393
     1         0978d-2*rhoa*t104*t68*wght
            t108 = 3.1589629871025054d-4*gammaaa*t105*t36*t77-2.92197409
     1         37516275d-3*t28*t35*t40
            t109 = t42**2
            t110 = 6.317925974205011d-4*gammaaa*t105*t36*t77-5.843948187
     1         503255d-3*t28*t35*t40
            t111 = 8.48131310861104d-4*t14/rhoa**3.333333333333333d+0
            t112 = 1/rhoa**3
            t113 = -2.1809090850714105d-3*t17*t24*t44
            t114 = 3.37738d-2*(1.1876045553756398d-1*t21*t3*t49-1.425125
     1         466450768d+0*t2*(7.016926042943222d-1*t3*(-5.847438369119
     2         352d-2*t20*t21*t46-6.883279156869946d-4*t19)-5.8474383691
     3         19352d-2*t20*t21*t47)/t48**2)*t52/t50-3.083347652359653d-
     4         4*t16*t51
            t115 = -3.2713636276071156d-3*t16*t55*t56
            t116 = 3.2713636276071156d-3*t16*t17*t65
            t117 = -1.243628d-1*t15*t24**3/t13**3
            t118 = 1.865442d-1*t15*t24*t55*t65
            t119 = 1/rhoa**2.666666666666667d+0
            t120 = 1/t2**7
            t121 = 1/rhoa**2.0d+0
            t122 = -6.21814d-2*t15*t17*(-1.425125466450768d+0*t18*t2*(7.
     1         016926042943222d-1*t3*(-1.4618595922798375d-2*t60*t62*t9-
     2         1.6242884358664864d-2*t119*t20*t9-6.091081634499322d-3*t1
     3         20*t121*t9-1.161599075681677d-3/rhoa**3.3333333333333337d
     4         +0)-1.7542315107358056d-1*t20*t21*t63-1.4618595922798375d
     5         -2*t10*t60*t62+4.385578776839513d-2*t19*t22*t62+5.8474383
     6         69119352d-2*t20*t22*t61-1.6242884358664864d-2*t10*t119*t2
     7         0-6.091081634499322d-3*t10*t120*t121)+8.550752798704606d+
     8         0*t2*t23*t58*t64-3.5628136661269194d-1*t18*t21*t3*t64+2.4
     9         74176157032582d-3*t12*t121*t62+1.1876045553756398d-1*t18*
     :         t23*t3*t61+9.89670462813033d-3*t12*t20*t60+7.125627332253
     ;         839d-1*t21*t3*t58*t59+3.29890154271011d-2*t119*t12*t3-8.5
     <         50752798704606d+0*t2*t23**3/t11**4+2.969011388439098d-2*t
     =         18*t19*t20*t23)
            t123 = 7.500000000000002d-1*t114*t53-2.533035d-2*t112*t51*t5
     1         2+t122+t118+t117+t116+t115+t113+t111
            t124 = 1/t31**3
            t125 = 1.2436276347861956d-1*rhoa*t124*t38**3
            t126 = -3.109069086965489d-2*t69
            t127 = -t38*t89
            t128 = rhoa**5.000000000000002d-1
            t129 = -5.150267658720751d-1*gammaaa*t128*t30*t96
            t130 = 1/rhoa**6.666666666666665d-1
            t131 = 5.518143920057951d-2*gammaaa*t130*t30*t40
            t132 = 1/rhoa**1.8333333333333332d+0
            t133 = -7.567740233222326d-1*gammaaa*t33*t34*t77*t78
            t134 = 1/t29**4
            t135 = -6.486634485619136d-1*gammaaa*t134*t37**3*t8
            t136 = -5.150267658720751d-1*gammaaa*t128*t28*t96
            t137 = 5.518143920057951d-2*gammaaa*t130*t28*t40
            t138 = 3.9144925898560723d+2*gammaaa*t26*t33*t34*t36*t83
            t139 = t25**3
            t140 = 3.597303318004418d+3*gammaaa*t139*t26*t36*t8
            t141 = -7.828985179712145d+2*gammaaa*t33*t34*t83*t85*t86
            t142 = -2.1583819908026508d+4*gammaaa*t139*t8*t85*t86
            t143 = 2.1583819908026508d+4*gammaaa*t139*exp(6.000001762008
     1         792d+0*t14*t15)*t8/t27**4
            t144 = -2.4999999999999994d-1*t114*t53+8.44345d-3*t112*t51*t
     1         52+t122+t118+t117+t116+t115+t113+t111
            t145 = 1.2436276347861956d-1*rhoa*t124*t41*t69
            t146 = 6.218138173930978d-2*t98
            t147 = 5.518143920057945d-2*t30*t40*t72
            t148 = -2.6276875809799755d-3*t30*t34*t74
            t149 = -5.96569710807624d-3*gammaaa*t105*t28*t35*t72
            t150 = 2.840808146702972d-4*gammaaa*t28*t35*t74*t96
            t151 = 2.5225800777407753d-1*gammaaa*t33*t34*t35*t97
            t152 = 6.306450194351938d-2*t33*t34*t35*t37
            t153 = -1.3635879104174264d-2*gammaaa*t28*t33*t37*t77*t96
            t154 = 4.3244229904127574d-1*gammaaa*t37*t77*t8*t97
            t155 = 5.405528738015947d-2*t77*t78*t8
            t156 = -1.7531844562509766d-2*gammaaa*t134*t28*t40*t78
            t157 = 5.518143920057945d-2*t28*t40*t72
            t158 = -2.6276875809799755d-3*t28*t34*t74
            t159 = -2.0284046503794984d+0*t25*t26*t33*t34*t36
            t160 = -1.2436276347861956d-1*rhoa*t38*t98
            t161 = (t32*(-1.0363563623218294d-2*t41*t90+6.21813817393097
     1         8d-2*rhoa*(-2.7027643690079733d-2*t35*t8*t87+5.8439481875
     2         03255d-3*gammaaa*t28*t40*t77*t87-1.0811057476031893d-1*ga
     3         mmaaa*t35*t8*(5.592132271222959d+1*t8*t83*t85*t86-2.70276
     4         43690079733d-2*t26*t36*t8*t84-2.7960661356114797d+1*t26*t
     5         36*t8*t83+3.00307152111997d-3*t28*t53*t8+t159+t158+t157)+
     6         3.00307152111997d-3*t30*t53*t8-3.2466378819462516d-4*gamm
     7         aaa*t28*t35*t40*t53+t156+t155+t154+t153+t152+t151+t150+t1
     8         49+t148+t147)+t146)+t68*(t160-t41*t89)+t145)*wght
            t162 = 1.2436276347861956d-1*rhoa*t124*t42*t69
            t163 = 6.218138173930978d-2*t102
            t164 = 1.1036287840115891d-1*t30*t40*t72
            t165 = -5.255375161959951d-3*t30*t34*t74
            t166 = -1.1931394216152481d-2*gammaaa*t105*t28*t35*t72
            t167 = 5.681616293405944d-4*gammaaa*t28*t35*t74*t96
            t168 = 2.5225800777407753d-1*gammaaa*t101*t33*t34*t35
            t169 = 1.2612900388703877d-1*t33*t34*t35*t37
            t170 = -2.727175820834853d-2*gammaaa*t28*t33*t37*t77*t96
            t171 = 4.3244229904127574d-1*gammaaa*t101*t37*t77*t8
            t172 = 1.0811057476031893d-1*t77*t78*t8
            t173 = -3.506368912501953d-2*gammaaa*t134*t28*t40*t78
            t174 = 1.1036287840115891d-1*t28*t40*t72
            t175 = -5.255375161959951d-3*t28*t34*t74
            t176 = -4.0568093007589967d+0*t25*t26*t33*t34*t36
            t177 = -1.2436276347861956d-1*rhoa*t102*t38
            t178 = 1/t7**7.0d+0
            t179 = -5.405528738015947d-2*t35*t8*t97
            t180 = 1.168789637500651d-2*gammaaa*t28*t40*t77*t97
            t181 = (t68*(-t41*t99-6.218138173930978d-2*rhoa*t41*t98-6.21
     1         8138173930978d-2*rhoa*t106*t38)+t32*(6.218138173930978d-2
     2         *rhoa*(1.704484888021783d-3*t28*t33*t35*t96+2.92197409375
     3         16275d-3*t28*t37*t40*t77-1.8427284091431279d-4*gammaaa*t1
     4         78*t33*t36*t77-4.7384444806537585d-4*gammaaa*t105*t134*t3
     5         6*t37+t180+t179)+3.109069086965489d-2*t106)+1.24362763478
     6         61956d-1*rhoa*t104*t124*t38)*wght
            t182 = 1.2436276347861956d-1*rhoa*t124*t38*t41*t42
            t183 = t32*(6.218138173930978d-2*rhoa*(3.408969776043566d-3*
     1         t28*t33*t35*t96-2.7027643690079733d-2*t101*t35*t8+5.84394
     2         8187503255d-3*t28*t37*t40*t77+5.843948187503255d-3*gammaa
     3         a*t101*t28*t40*t77-3.6854568182862557d-4*gammaaa*t178*t33
     4         *t36*t77-9.476888961307517d-4*gammaaa*t105*t134*t36*t37+t
     5         180+t179)+3.109069086965489d-2*t108)
            t184 = -6.218138173930978d-2*rhoa*t108*t38
            t185 = 1/t7**8.0d+0
            t186 = 6.218138173930978d-2*rhoa*t32*(1.1846111201634398d-4*
     1         t105*t36*t77-1.280689890683347d-5*gammaaa*t134*t185*t85)*
     2         wght-1.8654414521792934d-1*rhoa*t106*t41*t68*wght+1.24362
     3         76347861956d-1*rhoa*t124*t41**3*wght
            t187 = t68*(-6.218138173930978d-2*rhoa*t106*t42*wght-1.24362
     1         76347861956d-1*rhoa*t108*t41*wght)+6.218138173930978d-2*r
     2         hoa*t32*(2.3692222403268795d-4*t105*t36*t77-2.56137978136
     3         6694d-5*gammaaa*t134*t185*t85)*wght+1.2436276347861956d-1
     4         *rhoa*t104*t124*t42*wght
            fnc(iq) = (6.218138173930978d-2*rhoa*log(1.0811057476031892d
     1         -1*gammaaa*t8/(1.0811057476031892d-1*gammaaa*t8/(exp(2.00
     2         00005873362642d+0*t4*t6)-1.0d+0)+1.0d+0)+1.0d+0)-1.243628
     3         d-1*rhoa*t4*t6)*wght+fnc(iq)
            Amat(iq,D1_RA) = (3.109069086965489d-2*t39+6.218138173930978
     1         d-2*rhoa*t32*t38+2.0d+0*rhoa*t25-6.21814d-2*t14*t15)*wght
     2         +Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 6.218138173930978d-2*rhoa*t32*t41*wght+Cma
     1         t(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 6.218138173930978d-2*rhoa*t32*t42*wght+Cma
     1         t(iq,D1_GAB)
            Amat2(iq,D2_RA_RA) = (-1.0363563623218294d-2*t39*t90+t32*t89
     1         +t70+2.0d+0*rhoa*t67+t43)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = (t32*t95+2.0d+0*rhoa*t91+1.036356362321
     1         8296d-2*t39*t90+t70+t43)*wght+Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = t100+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = (t103*t32-6.218138173930978d-2*rhoa*t3
     1         8*t42*t68)*wght+Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t100+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = t107+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = -6.218138173930978d-2*rhoa*t41*t42*t6
     1         8*wght+6.218138173930978d-2*rhoa*t108*t32*wght+Cmat2(iq,D
     2         2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = t107+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = -6.218138173930978d-2*rhoa*t109*t68*w
     1         ght+6.218138173930978d-2*rhoa*t110*t32*wght+Cmat2(iq,D2_G
     2         AB_GAB)
            Amat3(iq,D3_RA_RA_RA) = (t32*(-3.1090690869654886d-2*t38*t90
     1         +9.327207260896466d-2*t88+6.218138173930978d-2*rhoa*(6.48
     2         6634485619136d-1*gammaaa*t37*t77*t8*t87+3.783870116611163
     3         d-1*gammaaa*t33*t34*t35*t87-1.0811057476031893d-1*gammaaa
     4         *t35*t8*(-2.0863590689617695d+1*gammaaa*t25*t8*t84*t85*t8
     5         6+1.0431795344808847d+1*gammaaa*t25*t26*t36*t8*t84+3.7838
     6         70116611163d-1*gammaaa*t26*t33*t34*t36*t84-1.081105747603
     7         1893d-1*gammaaa*t26*t36*(-1.608198422145741d+1*t25*t53-1.
     8         0000002936681321d+0*t112*t14*t15-3.216396844291483d+1*t12
     9         3)*t8+1.1590883716454273d+0*gammaaa*t25*t26*t36*t53*t8-3.
     :         603685825343965d-2*gammaaa*t112*t28*t8-1.0142023251897499
     ;         d+0*gammaaa*t25*t26*t34*t36*t74+2.1298248828984737d+1*gam
     <         maaa*t25*t26*t36*t40*t72-3.766352199404629d-2*gammaaa*t13
     =         2*t28*t34+t143+t142+t141+t140+t138+t137+t136)-3.603685825
     >         3439635d-2*gammaaa*t35*t37*t53*t8-3.603685825343965d-2*ga
     ?         mmaaa*t112*t30*t8+3.153225097175971d-2*gammaaa*t34*t35*t3
     @         7*t74-6.621772704069536d-1*gammaaa*t35*t37*t40*t72-3.7663
     1         52199404629d-2*gammaaa*t132*t30*t34+t135+t133+t131+t129))
     2         +t68*(-1.2436276347861956d-1*rhoa*t38*t88+t127+t126)+3.0d
     3         +0*t67+1.554534543482745d-2*t39*t53+t125+2.0d+0*rhoa*t123
     4         )*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = (t68*(-1.2436276347861956d-1*rhoa*t3
     1         8*t94+t127+t126)+t32*(6.218138173930978d-2*t94+6.21813817
     2         3930978d-2*rhoa*(4.3244229904127574d-1*gammaaa*t37*t77*t8
     3         *t93+2.5225800777407753d-1*gammaaa*t33*t34*t35*t93-1.0811
     4         057476031893d-1*gammaaa*t35*t8*(-1.3909060459745132d+1*ga
     5         mmaaa*t25*t8*t85*t86*t92+6.954530229872565d+0*gammaaa*t25
     6         *t26*t36*t8*t92+2.5225800777407753d-1*gammaaa*t26*t33*t34
     7         *t36*t92-6.954530229872565d+0*gammaaa*t25*t8*t84*t85*t86+
     8         3.4772651149362827d+0*gammaaa*t25*t26*t36*t8*t84+1.261290
     9         0388703877d-1*gammaaa*t26*t33*t34*t36*t84-1.0811057476031
     :         893d-1*gammaaa*t26*t36*(5.360661407152473d+0*t25*t53+3.33
     ;         3334312227107d-1*t112*t14*t15-3.216396844291483d+1*t144)*
     <         t8-3.8636279054847583d-1*gammaaa*t25*t26*t36*t53*t8+1.201
     =         2286084479884d-2*gammaaa*t112*t28*t8-1.0142023251897496d+
     >         0*gammaaa*t25*t26*t34*t36*t74+2.1298248828984734d+1*gamma
     ?         aa*t25*t26*t36*t40*t72+1.8393813066859827d-2*gammaaa*t132
     @         *t28*t34+t143+t142+t141+t140+t138+t137+t136)+2.1622114952
     1         063787d-1*gammaaa*t37*t77*t8*t87+1.2612900388703877d-1*ga
     2         mmaaa*t33*t34*t35*t87+1.2012286084479881d-2*gammaaa*t35*t
     3         37*t53*t8+1.2012286084479884d-2*gammaaa*t112*t30*t8+3.153
     4         2250971759707d-2*gammaaa*t34*t35*t37*t74-6.62177270406953
     5         5d-1*gammaaa*t35*t37*t40*t72+1.8393813066859827d-2*gammaa
     6         a*t132*t30*t34+t135+t133+t131+t129)+1.0363563623218297d-2
     7         *t38*t90+3.109069086965489d-2*t88)+2.0d+0*t91+1.0d+0*t67-
     8         5.181781811609151d-3*t39*t53+2.0d+0*rhoa*t144+t125)*wght+
     9         Amat3(iq,D3_RA_RA_RB)
            Cmat3(iq,D3_RA_RA_GAA) = t161+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = (t32*(-1.0363563623218294d-2*t42*t9
     1         0+6.218138173930978d-2*rhoa*(-5.405528738015947d-2*t35*t8
     2         *t87+1.168789637500651d-2*gammaaa*t28*t40*t77*t87-1.08110
     3         57476031893d-1*gammaaa*t35*t8*(1.118426454244592d+2*t8*t8
     4         3*t85*t86-5.405528738015947d-2*t26*t36*t8*t84-5.592132271
     5         222959d+1*t26*t36*t8*t83+6.00614304223994d-3*t28*t53*t8+t
     6         176+t175+t174)+6.00614304223994d-3*t30*t53*t8-6.493275763
     7         892503d-4*gammaaa*t28*t35*t40*t53+t173+t172+t171+t170+t16
     8         9+t168+t167+t166+t165+t164)+t163)+t68*(t177-t42*t89)+t162
     9         )*wght+Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = t161+Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = (t68*(t160-t41*t95)+t32*(6.21813817
     1         3930978d-2*rhoa*(-2.7027643690079733d-2*t35*t8*t93+5.8439
     2         48187503255d-3*gammaaa*t28*t40*t77*t93-1.0811057476031893
     3         d-1*gammaaa*t35*t8*(-2.7027643690079733d-2*t26*t36*t8*t92
     4         +5.59213227122296d+1*t8*t83*t85*t86-2.79606613561148d+1*t
     5         26*t36*t8*t83-3.00307152111997d-3*t28*t53*t8+t159+t158+t1
     6         57)-3.00307152111997d-3*t30*t53*t8+3.2466378819462527d-4*
     7         gammaaa*t28*t35*t40*t53+t156+t155+t154+t153+t152+t151+t15
     8         0+t149+t148+t147)+1.0363563623218296d-2*t41*t90+t146)+t14
     9         5)*wght+Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = (t68*(t177-t42*t95)+t32*(6.21813817
     1         3930978d-2*rhoa*(-5.405528738015947d-2*t35*t8*t93+1.16878
     2         9637500651d-2*gammaaa*t28*t40*t77*t93-1.0811057476031893d
     3         -1*gammaaa*t35*t8*(-5.405528738015947d-2*t26*t36*t8*t92+1
     4         .1184264542445921d+2*t8*t83*t85*t86-5.59213227122296d+1*t
     5         26*t36*t8*t83-6.00614304223994d-3*t28*t53*t8+t176+t175+t1
     6         74)-6.00614304223994d-3*t30*t53*t8+6.493275763892505d-4*g
     7         ammaaa*t28*t35*t40*t53+t173+t172+t171+t170+t169+t168+t167
     8         +t166+t165+t164)+1.0363563623218296d-2*t42*t90+t163)+t162
     9         )*wght+Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_GAA_GAA) = t181+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = (t68*(-t42*t99-6.218138173930978d-
     1         2*rhoa*t102*t41+t184)+t183+t182)*wght+Cmat3(iq,D3_RA_GAA_
     2         GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = t181+Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = (t32*(6.218138173930978d-2*rhoa*(6
     1         .817939552087132d-3*t28*t33*t35*t96-1.0811057476031893d-1
     2         *t101*t35*t8+1.168789637500651d-2*t28*t37*t40*t77+2.33757
     3         9275001302d-2*gammaaa*t101*t28*t40*t77-7.370913636572511d
     4         -4*gammaaa*t178*t33*t36*t77-1.8953777922615034d-3*gammaaa
     5         *t105*t134*t36*t37)+3.109069086965489d-2*t110)+(-t103*t42
     6         -6.218138173930978d-2*rhoa*t102*t42-6.218138173930978d-2*
     7         rhoa*t110*t38)*t68+1.2436276347861956d-1*rhoa*t109*t124*t
     8         38)*wght+Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = (t68*(-6.218138173930978d-2*rhoa*t
     1         42*t98-t103*t41+t184)+t183+t182)*wght+Cmat3(iq,D3_RA_GAB_
     2         GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = t181+Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = t186+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = t187+Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = t186+Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = t68*(-1.2436276347861956d-1*rhoa*
     1         t108*t42*wght-6.218138173930978d-2*rhoa*t110*t41*wght)+6.
     2         218138173930978d-2*rhoa*t32*(4.738444480653759d-4*t105*t3
     3         6*t77-5.122759562733388d-5*gammaaa*t134*t185*t85)*wght+1.
     4         2436276347861956d-1*rhoa*t109*t124*t41*wght+Cmat3(iq,D3_G
     5         AA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = t187+Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = 6.218138173930978d-2*rhoa*t32*(9.
     1         476888961307518d-4*t105*t36*t77-1.0245519125466776d-4*gam
     2         maaa*t134*t185*t85)*wght-1.8654414521792934d-1*rhoa*t110*
     3         t42*t68*wght+1.2436276347861956d-1*rhoa*t124*t42**3*wght+
     4         Cmat3(iq,D3_GAB_GAB_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = 1/t2
            t4 = 1.325688999052018d-1*t3+1.0d+0
            t5 = t2**5.0d-1
            t6 = 1/t5
            t7 = 2.4141993114533214d-2*t6+1.0186556948d-1
            t8 = 7.876233178997433d-1*t6*t7+2.2308199064d-1
            t9 = 7.876233178997433d-1*t6*t8+4.7231125998d-1
            t10 = 1/t9
            t11 = 1.269642451250142d+0*t10*t5+1.0d+0
            t12 = log(t11)
            t13 = rhoa-rhob
            t14 = 1/t1
            t15 = 1.0d+0-t13*t14
            t16 = t15**1.3333333333333333d+0
            t17 = t13*t14+1.0d+0
            t18 = t17**1.3333333333333333d+0
            t19 = 1.923661050931536d+0*t18+1.923661050931536d+0*t16-3.84
     1         7322101863072d+0
            t20 = 6.901399211255826d-2*t3+1.0d+0
            t21 = 1.3212998810398843d-2*t6+2.9729725188d-2
            t22 = 7.876233178997433d-1*t21*t6+1.2236585478d-1
            t23 = 7.876233178997433d-1*t22*t6+3.497952466d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t24*t5+1.0d+0
            t26 = log(t25)
            t27 = t13**4
            t28 = 1/t1**4
            t29 = 1.2746961887000874d-1*t3+1.0d+0
            t30 = 1.530901310039024d-2*t6+1.0465751434d-1
            t31 = 7.876233178997433d-1*t30*t6+1.9269083139d-1
            t32 = 7.876233178997433d-1*t31*t6+4.3896648423d-1
            t33 = 1/t32
            t34 = 1.269642451250142d+0*t33*t5+1.0d+0
            t35 = log(t34)
            t36 = 1.709920934161365d+0*(6.21814d-2*t12*t4-3.10907d-2*t29
     1         *t35)-3.37738d-2*t20*t26
            t37 = t27*t28*t36+3.37738d-2*t20*t26
            t38 = 5.848223622634648d-1*t19*t37-6.21814d-2*t12*t4
            t39 = t15**6.666666666666666d-1
            t40 = t17**6.666666666666666d-1
            t41 = 5.0d-1*t40+5.0d-1*t39
            t42 = t41**3.0d+0
            t43 = gammabb+2.0d+0*gammaab+gammaaa
            t44 = t1**1.1666666666666667d+0
            t45 = 1/t44**2.0d+0
            t46 = t41**2.0d+0
            t47 = 1/t46
            t48 = 1/t42
            t49 = exp(-3.216396844291483d+1*t38*t48)
            t50 = t49-1.0d+0
            t51 = 1/t50
            t52 = 1.3621078885675922d-1*t43*t45*t47*t51+1.0d+0
            t53 = 1/t52
            t54 = 1.3621078885675922d-1*t43*t45*t47*t53+1.0d+0
            t55 = log(t54)
            t56 = 1/t1**1.3333333333333336d+0
            t57 = 1/t1**6.666666666666667d-1
            t58 = 1/t5**3
            t59 = -1.3127055298329054d-1*t57*t58*t7-3.169132786263567d-3
     1         *t56
            t60 = 7.876233178997433d-1*t59*t6-1.3127055298329054d-1*t57*
     1         t58*t8
            t61 = 1/t9**2
            t62 = 2.11607075208357d-1*t10*t57*t6-1.269642451250142d+0*t5
     1         *t60*t61
            t63 = 1/t11
            t64 = -6.21814d-2*t4*t62*t63
            t65 = 1/t1**1.3333333333333333d+0
            t66 = 2.747773264188438d-3*t12*t65
            t67 = -1.3127055298329054d-1*t21*t57*t58-1.7344776604086162d
     1         -3*t56
            t68 = 7.876233178997433d-1*t6*t67-1.3127055298329054d-1*t22*
     1         t57*t58
            t69 = 1/t23**2
            t70 = 2.11607075208357d-1*t24*t57*t6-1.269642451250142d+0*t5
     1         *t68*t69
            t71 = 1/t25
            t72 = 3.37738d-2*t20*t70*t71
            t73 = -7.769549222703733d-4*t26*t65
            t74 = -1.3127055298329054d-1*t30*t57*t58-2.0096226153166658d
     1         -3*t56
            t75 = 7.876233178997433d-1*t6*t74-1.3127055298329054d-1*t31*
     1         t57*t58
            t76 = 1/t32**2
            t77 = 2.11607075208357d-1*t33*t57*t6-1.269642451250142d+0*t5
     1         *t75*t76
            t78 = 1/t34
            t79 = 1.709920934161365d+0*(-3.10907d-2*t29*t77*t78+1.321039
     1         8931339265d-3*t35*t65-2.747773264188438d-3*t12*t65+6.2181
     2         4d-2*t4*t62*t63)-3.37738d-2*t20*t70*t71+7.769549222703733
     3         d-4*t26*t65
            t80 = t27*t28*t79
            t81 = 1/t1**5
            t82 = -4*t27*t36*t81
            t83 = t13**3
            t84 = 4*t28*t36*t83+t82+t80+t73+t72
            t85 = 1/t1**2
            t86 = t13*t85
            t87 = -t14
            t88 = t87+t86
            t89 = t15**3.333333333333333d-1
            t90 = -t13*t85
            t91 = t90+t14
            t92 = t17**3.333333333333333d-1
            t93 = 2.564881401242048d+0*t91*t92+2.564881401242048d+0*t88*
     1         t89
            t94 = 5.848223622634648d-1*t37*t93+5.848223622634648d-1*t19*
     1         t84+t66+t64
            t95 = 1.0d+0*t38
            t96 = 1/t54
            t97 = 1/t89
            t98 = 1/t92
            t99 = 3.333333333333333d-1*t91*t98+3.333333333333333d-1*t88*
     1         t97
            t100 = t1**1.6666666666666674d-1
            t101 = 1/t44**3.0d+0
            t102 = -3.1782517399910487d-1*t100*t101*t43*t47*t53
            t103 = 1/t52**2
            t104 = -3.1782517399910487d-1*t100*t101*t43*t47*t51
            t105 = 1/t50**2
            t106 = 1/t41**4.0d+0
            t107 = 9.649190532874448d+1*t106*t38*t99-3.216396844291483d+
     1         1*t48*t94
            t108 = -2.7242157771351844d-1*t43*t45*t48*t51*t99-1.36210788
     1         85675922d-1*t105*t107*t43*t45*t47*t49+t104
            t109 = -2.7242157771351844d-1*t43*t45*t48*t53*t99-1.36210788
     1         85675922d-1*t103*t108*t43*t45*t47+t102
            t110 = 3.109069086965489d-2*t42*t55
            t111 = -4*t28*t36*t83+t82+t80+t73+t72
            t112 = t86+t14
            t113 = t90+t87
            t114 = 2.564881401242048d+0*t113*t92+2.564881401242048d+0*t1
     1         12*t89
            t115 = t66+t64+5.848223622634648d-1*t114*t37+5.8482236226346
     1         48d-1*t111*t19
            t116 = 3.333333333333333d-1*t113*t98+3.333333333333333d-1*t1
     1         12*t97
            t117 = 9.649190532874448d+1*t106*t116*t38-3.216396844291483d
     1         +1*t115*t48
            t118 = -2.7242157771351844d-1*t116*t43*t45*t48*t51-1.3621078
     1         885675922d-1*t105*t117*t43*t45*t47*t49+t104
            t119 = -2.7242157771351844d-1*t116*t43*t45*t48*t53-1.3621078
     1         885675922d-1*t103*t118*t43*t45*t47+t102
            t120 = 1/t44**4.0d+0
            t121 = 1.3621078885675922d-1*t45*t47*t53-1.855337900098064d-
     1         2*t103*t106*t120*t43*t51
            t122 = 3.109069086965489d-2*t1*t121*t42*t96*wght
            t123 = 2.7242157771351844d-1*t45*t47*t53-3.710675800196128d-
     1         2*t103*t106*t120*t43*t51
            t124 = t62**2
            t125 = 1/t11**2
            t126 = 6.21814d-2*t124*t125*t4
            t127 = t60**2
            t128 = 1/t9**3
            t129 = 1/t1**2.3333333333333334d+0
            t130 = 1/t5**5
            t131 = 1/t1**1.6666666666666669d+0
            t132 = 8.751370198886037d-2*t131*t58*t7+6.563527649164527d-2
     1         *t130*t56*t7+4.753699179395351d-3*t129
            t133 = 8.751370198886037d-2*t131*t58*t8+6.563527649164527d-2
     1         *t130*t56*t8+7.876233178997433d-1*t132*t6-2.6254110596658
     2         11d-1*t57*t58*t59
            t134 = -4.23214150416714d-1*t57*t6*t60*t61-1.269642451250142
     1         d+0*t133*t5*t61-1.4107138347223802d-1*t10*t131*t6-3.52678
     2         458680595d-2*t10*t56*t58+2.539284902500284d+0*t127*t128*t
     3         5
            t135 = -6.21814d-2*t134*t4*t63
            t136 = 5.495546528376876d-3*t62*t63*t65
            t137 = 1/t1**2.333333333333333d+0
            t138 = -3.663697685584584d-3*t12*t137
            t139 = t70**2
            t140 = 1/t25**2
            t141 = -3.37738d-2*t139*t140*t20
            t142 = t68**2
            t143 = 1/t23**3
            t144 = 8.751370198886037d-2*t131*t21*t58+6.563527649164527d-
     1         2*t130*t21*t56+2.601716490612924d-3*t129
            t145 = -2.625411059665811d-1*t57*t58*t67+7.876233178997433d-
     1         1*t144*t6+8.751370198886037d-2*t131*t22*t58+6.56352764916
     2         4527d-2*t130*t22*t56
            t146 = -4.23214150416714d-1*t57*t6*t68*t69-1.269642451250142
     1         d+0*t145*t5*t69-1.4107138347223802d-1*t131*t24*t6-3.52678
     2         458680595d-2*t24*t56*t58+2.539284902500284d+0*t142*t143*t
     3         5
            t147 = 3.37738d-2*t146*t20*t71
            t148 = -1.5539098445407465d-3*t65*t70*t71
            t149 = 1.0359398963604977d-3*t137*t26
            t150 = t77**2
            t151 = 1/t34**2
            t152 = t75**2
            t153 = 1/t32**3
            t154 = 8.751370198886037d-2*t131*t30*t58+6.563527649164527d-
     1         2*t130*t30*t56+3.0144339229749983d-3*t129
            t155 = -2.625411059665811d-1*t57*t58*t74+7.876233178997433d-
     1         1*t154*t6+8.751370198886037d-2*t131*t31*t58+6.56352764916
     2         4527d-2*t130*t31*t56
            t156 = -4.23214150416714d-1*t57*t6*t75*t76-1.269642451250142
     1         d+0*t155*t5*t76-1.4107138347223802d-1*t131*t33*t6-3.52678
     2         458680595d-2*t33*t56*t58+2.539284902500284d+0*t152*t153*t
     3         5
            t157 = 1.709920934161365d+0*(2.642079786267853d-3*t65*t77*t7
     1         8-3.10907d-2*t156*t29*t78-5.495546528376876d-3*t62*t63*t6
     2         5+6.21814d-2*t134*t4*t63-6.21814d-2*t124*t125*t4-1.761386
     3         5241785687d-3*t137*t35+3.10907d-2*t150*t151*t29+3.6636976
     4         85584584d-3*t12*t137)+1.5539098445407465d-3*t65*t70*t71-3
     5         .37738d-2*t146*t20*t71-1.0359398963604977d-3*t137*t26+3.3
     6         7738d-2*t139*t140*t20
            t158 = t157*t27*t28
            t159 = -8*t27*t79*t81
            t160 = 1/t1**6
            t161 = 20*t160*t27*t36
            t162 = t13**2
            t163 = 12*t162*t28*t36
            t164 = -32*t36*t81*t83+8*t28*t79*t83+t163+t161+t159+t158+t14
     1         9+t148+t147+t141
            t165 = t88**2
            t166 = 1/t39
            t167 = 1/t1**3
            t168 = -2*t13*t167
            t169 = 2*t85
            t170 = t169+t168
            t171 = t91**2
            t172 = 1/t40
            t173 = 2*t13*t167
            t174 = -2*t85
            t175 = t174+t173
            t176 = 2.564881401242048d+0*t175*t92+2.564881401242048d+0*t1
     1         70*t89+8.549604670806825d-1*t171*t172+8.549604670806825d-
     2         1*t165*t166
            t177 = 1.1696447245269297d+0*t84*t93+5.848223622634648d-1*t1
     1         76*t37+5.848223622634648d-1*t164*t19+t138+t136+t135+t126
            t178 = t99**2
            t179 = 1/t16
            t180 = 1/t18
            t181 = 3.333333333333333d-1*t175*t98+3.333333333333333d-1*t1
     1         70*t97-1.111111111111111d-1*t171*t180-1.111111111111111d-
     2         1*t165*t179
            t182 = t1**3.333333333333335d-1
            t183 = 1.1123881089968671d+0*t120*t182*t43*t47*t53
            t184 = 1/t1**8.333333333333333d-1
            t185 = -5.297086233318417d-2*t101*t184*t43*t47*t53
            t186 = 1.1123881089968671d+0*t120*t182*t43*t47*t51
            t187 = -5.297086233318417d-2*t101*t184*t43*t47*t51
            t188 = 1/t41**5.0d+0
            t189 = 1.9298381065748896d+2*t106*t94*t99-3.216396844291483d
     1         +1*t177*t48-3.859676213149779d+2*t178*t188*t38+9.64919053
     2         2874448d+1*t106*t181*t38
            t190 = exp(-6.432793688582966d+1*t38*t48)
            t191 = 1/t50**3
            t192 = t107**2
            t193 = 1.2713006959964196d+0*t100*t101*t43*t48*t51*t99+5.448
     1         431554270369d-1*t105*t107*t43*t45*t48*t49*t99-2.724215777
     2         1351844d-1*t181*t43*t45*t48*t51+8.172647331405554d-1*t106
     3         *t178*t43*t45*t51-1.3621078885675922d-1*t105*t192*t43*t45
     4         *t47*t49-1.3621078885675922d-1*t105*t189*t43*t45*t47*t49+
     5         6.356503479982097d-1*t100*t101*t105*t107*t43*t47*t49+2.72
     6         42157771351844d-1*t190*t191*t192*t43*t45*t47+t187+t186
            t194 = 1/t52**3
            t195 = t108**2
            t196 = 1.2713006959964196d+0*t100*t101*t43*t48*t53*t99+5.448
     1         431554270369d-1*t103*t108*t43*t45*t48*t99-2.7242157771351
     2         844d-1*t181*t43*t45*t48*t53+8.172647331405554d-1*t106*t17
     3         8*t43*t45*t53+2.7242157771351844d-1*t194*t195*t43*t45*t47
     4         -1.3621078885675922d-1*t103*t193*t43*t45*t47+6.3565034799
     5         82097d-1*t100*t101*t103*t108*t43*t47+t185+t183
            t197 = 1.8654414521792934d-1*t1*t109*t46*t99+3.1090690869654
     1         89d-2*t1*t196*t42+6.218138173930978d-2*t109*t42
            t198 = 1/t54**2
            t199 = t109**2
            t200 = -12*t162*t28*t36+t161+t159+t158+t149+t148+t147+t141
            t201 = 5.129762802484096d+0*t13*t167*t92+8.549604670806825d-
     1         1*t113*t172*t91-5.129762802484096d+0*t13*t167*t89+8.54960
     2         4670806825d-1*t112*t166*t88
            t202 = 5.848223622634648d-1*t111*t93+5.848223622634648d-1*t1
     1         14*t84+5.848223622634648d-1*t201*t37+5.848223622634648d-1
     2         *t19*t200+t138+t136+t135+t126
            t203 = 6.666666666666666d-1*t13*t167*t98-6.666666666666666d-
     1         1*t13*t167*t97-1.111111111111111d-1*t113*t180*t91-1.11111
     2         1111111111d-1*t112*t179*t88
            t204 = -3.859676213149779d+2*t116*t188*t38*t99+9.64919053287
     1         4448d+1*t106*t115*t99+9.649190532874448d+1*t106*t116*t94-
     2         3.216396844291483d+1*t202*t48+9.649190532874448d+1*t106*t
     3         203*t38
            t205 = 6.356503479982097d-1*t100*t101*t43*t48*t51*t99+8.1726
     1         47331405554d-1*t106*t116*t43*t45*t51*t99+2.72421577713518
     2         44d-1*t105*t117*t43*t45*t48*t49*t99-2.7242157771351844d-1
     3         *t203*t43*t45*t48*t51+6.356503479982097d-1*t100*t101*t116
     4         *t43*t48*t51+2.7242157771351844d-1*t105*t107*t116*t43*t45
     5         *t48*t49-1.3621078885675922d-1*t105*t204*t43*t45*t47*t49-
     6         1.3621078885675922d-1*t105*t107*t117*t43*t45*t47*t49+3.17
     7         82517399910487d-1*t100*t101*t105*t117*t43*t47*t49+3.17825
     8         17399910487d-1*t100*t101*t105*t107*t43*t47*t49+2.72421577
     9         71351844d-1*t107*t117*t190*t191*t43*t45*t47+t187+t186
            t206 = 6.356503479982097d-1*t100*t101*t43*t48*t53*t99+8.1726
     1         47331405554d-1*t106*t116*t43*t45*t53*t99+2.72421577713518
     2         44d-1*t103*t118*t43*t45*t48*t99-2.7242157771351844d-1*t20
     3         3*t43*t45*t48*t53+6.356503479982097d-1*t100*t101*t116*t43
     4         *t48*t53+2.7242157771351844d-1*t103*t108*t116*t43*t45*t48
     5         -1.3621078885675922d-1*t103*t205*t43*t45*t47+2.7242157771
     6         351844d-1*t108*t118*t194*t43*t45*t47+3.1782517399910487d-
     7         1*t100*t101*t103*t118*t43*t47+3.1782517399910487d-1*t100*
     8         t101*t103*t108*t43*t47+t185+t183
            t207 = 9.327207260896466d-2*t1*t119*t46*t99+9.32720726089646
     1         6d-2*t1*t109*t116*t46+3.109069086965489d-2*t1*t206*t42+3.
     2         109069086965489d-2*t119*t42+3.109069086965489d-2*t109*t42
            t208 = 32*t36*t81*t83-8*t28*t79*t83+t163+t161+t159+t158+t149
     1         +t148+t147+t141
            t209 = t112**2
            t210 = t174+t168
            t211 = t113**2
            t212 = t173+t169
            t213 = 2.564881401242048d+0*t212*t92+2.564881401242048d+0*t2
     1         10*t89+8.549604670806825d-1*t172*t211+8.549604670806825d-
     2         1*t166*t209
            t214 = 5.848223622634648d-1*t213*t37+5.848223622634648d-1*t1
     1         9*t208+t138+t136+t135+t126+1.1696447245269297d+0*t111*t11
     2         4
            t215 = t116**2
            t216 = 3.333333333333333d-1*t212*t98+3.333333333333333d-1*t2
     1         10*t97-1.111111111111111d-1*t180*t211-1.111111111111111d-
     2         1*t179*t209
            t217 = -3.216396844291483d+1*t214*t48+9.649190532874448d+1*t
     1         106*t216*t38-3.859676213149779d+2*t188*t215*t38+1.9298381
     2         065748896d+2*t106*t115*t116
            t218 = t117**2
            t219 = -2.7242157771351844d-1*t216*t43*t45*t48*t51+1.2713006
     1         959964196d+0*t100*t101*t116*t43*t48*t51+8.172647331405554
     2         d-1*t106*t215*t43*t45*t51+5.448431554270369d-1*t105*t116*
     3         t117*t43*t45*t48*t49-1.3621078885675922d-1*t105*t218*t43*
     4         t45*t47*t49-1.3621078885675922d-1*t105*t217*t43*t45*t47*t
     5         49+6.356503479982097d-1*t100*t101*t105*t117*t43*t47*t49+2
     6         .7242157771351844d-1*t190*t191*t218*t43*t45*t47+t187+t186
            t220 = t118**2
            t221 = -2.7242157771351844d-1*t216*t43*t45*t48*t53+1.2713006
     1         959964196d+0*t100*t101*t116*t43*t48*t53+8.172647331405554
     2         d-1*t106*t215*t43*t45*t53+5.448431554270369d-1*t103*t116*
     3         t118*t43*t45*t48+2.7242157771351844d-1*t194*t220*t43*t45*
     4         t47-1.3621078885675922d-1*t103*t219*t43*t45*t47+6.3565034
     5         79982097d-1*t100*t101*t103*t118*t43*t47+t185+t183
            t222 = 1.8654414521792934d-1*t1*t116*t119*t46+3.109069086965
     1         489d-2*t1*t221*t42+6.218138173930978d-2*t119*t42
            t223 = t119**2
            t224 = 3.109069086965489d-2*t121*t42
            t225 = -3.1782517399910487d-1*t100*t101*t47*t53
            t226 = 1/t44**5.0d+0
            t227 = 4.3291217668954834d-2*t100*t103*t106*t226*t43*t51
            t228 = -3.1782517399910487d-1*t100*t101*t47*t51
            t229 = -2.7242157771351844d-1*t45*t48*t51*t99-1.362107888567
     1         5922d-1*t105*t107*t45*t47*t49+t228
            t230 = -2.7242157771351844d-1*t45*t48*t53*t99+3.710675800196
     1         128d-2*t103*t120*t188*t43*t51*t99+3.710675800196128d-2*t1
     2         06*t108*t120*t194*t43*t51-1.3621078885675922d-1*t103*t229
     3         *t43*t45*t47-1.3621078885675922d-1*t103*t108*t45*t47+t227
     4         +t225
            t231 = 9.327207260896466d-2*t1*t121*t46*t99+3.10906908696548
     1         9d-2*t1*t230*t42+t224
            t232 = (t231*t96-3.109069086965489d-2*t1*t109*t121*t198*t42)
     1         *wght
            t233 = 3.109069086965489d-2*t123*t42
            t234 = -6.356503479982097d-1*t100*t101*t47*t53
            t235 = 8.658243533790967d-2*t100*t103*t106*t226*t43*t51
            t236 = -6.356503479982097d-1*t100*t101*t47*t51
            t237 = -5.448431554270369d-1*t45*t48*t51*t99-2.7242157771351
     1         844d-1*t105*t107*t45*t47*t49+t236
            t238 = -5.448431554270369d-1*t45*t48*t53*t99+7.4213516003922
     1         56d-2*t103*t120*t188*t43*t51*t99+7.421351600392256d-2*t10
     2         6*t108*t120*t194*t43*t51-1.3621078885675922d-1*t103*t237*
     3         t43*t45*t47-2.7242157771351844d-1*t103*t108*t45*t47+t235+
     4         t234
            t239 = 9.327207260896466d-2*t1*t123*t46*t99+3.10906908696548
     1         9d-2*t1*t238*t42+t233
            t240 = -2.7242157771351844d-1*t116*t45*t48*t51-1.36210788856
     1         75922d-1*t105*t117*t45*t47*t49+t228
            t241 = -2.7242157771351844d-1*t116*t45*t48*t53+3.71067580019
     1         6128d-2*t106*t118*t120*t194*t43*t51+3.710675800196128d-2*
     2         t103*t116*t120*t188*t43*t51-1.3621078885675922d-1*t103*t2
     3         40*t43*t45*t47-1.3621078885675922d-1*t103*t118*t45*t47+t2
     4         27+t225
            t242 = 9.327207260896466d-2*t1*t116*t121*t46+3.1090690869654
     1         89d-2*t1*t241*t42+t224
            t243 = (t242*t96-3.109069086965489d-2*t1*t119*t121*t198*t42)
     1         *wght
            t244 = -5.448431554270369d-1*t116*t45*t48*t51-2.724215777135
     1         1844d-1*t105*t117*t45*t47*t49+t236
            t245 = -5.448431554270369d-1*t116*t45*t48*t53+7.421351600392
     1         256d-2*t106*t118*t120*t194*t43*t51+7.421351600392256d-2*t
     2         103*t116*t120*t188*t43*t51-1.3621078885675922d-1*t103*t24
     3         4*t43*t45*t47-2.7242157771351844d-1*t103*t118*t45*t47+t23
     4         5+t234
            t246 = 9.327207260896466d-2*t1*t116*t123*t46+3.1090690869654
     1         89d-2*t1*t245*t42+t233
            t247 = t121**2
            t248 = 1/t44**6.0d+0
            t249 = 1/t41**6.0d+0
            t250 = 5.054340779364009d-3*t105*t194*t248*t249*t43-3.710675
     1         800196128d-2*t103*t106*t120*t51
            t251 = 3.109069086965489d-2*t1*t250*t42*t96*wght-3.109069086
     1         965489d-2*t1*t198*t247*t42*wght
            t252 = 1.0108681558728018d-2*t105*t194*t248*t249*t43-7.42135
     1         1600392256d-2*t103*t106*t120*t51
            t253 = 3.109069086965489d-2*t1*t252*t42*t96*wght-3.109069086
     1         965489d-2*t1*t121*t123*t198*t42*wght
            t254 = t123**2
            t255 = 2.0217363117456036d-2*t105*t194*t248*t249*t43-1.48427
     1         03200784513d-1*t103*t106*t120*t51
            t256 = t62**3
            t257 = 1/t11**3
            t258 = -1.243628d-1*t256*t257*t4
            t259 = 1.865442d-1*t125*t134*t4*t62
            t260 = -8.243319792565315d-3*t124*t125*t65
            t261 = 1/t1**3.3333333333333337d+0
            t262 = 1/t1**2.0d+0
            t263 = 1/t5**7
            t264 = 1/t1**2.666666666666667d+0
            t265 = -7.617854707500852d+0*t5*t60**3/t9**4-1.2696424512501
     1         42d+0*t5*t61*(-1.4585616998143394d-1*t264*t58*t8-5.469606
     2         374303773d-2*t262*t263*t8-1.3127055298329054d-1*t129*t130
     3         *t8+7.876233178997433d-1*t6*(-1.4585616998143394d-1*t264*
     4         t58*t7-5.469606374303773d-2*t262*t263*t7-1.31270552983290
     5         54d-1*t129*t130*t7-1.1708185015918181d-2*t261)+2.62541105
     6         9665811d-1*t131*t58*t59+1.9690582947493582d-1*t130*t56*t5
     7         9-3.9381165894987163d-1*t132*t57*t58)+4.2321415041671406d
     8         -1*t131*t6*t60*t61+1.0580353760417849d-1*t56*t58*t60*t61-
     9         6.34821225625071d-1*t133*t57*t6*t61+7.617854707500852d+0*
     :         t128*t133*t5*t60+1.269642451250142d+0*t127*t128*t57*t6+2.
     ;         3511897245373004d-1*t10*t264*t6+7.053569173611901d-2*t10*
     <         t129*t58+1.763392293402975d-2*t10*t130*t262
            t266 = -6.21814d-2*t265*t4*t63
            t267 = 8.243319792565315d-3*t134*t63*t65
            t268 = -1.0991093056753751d-2*t137*t62*t63
            t269 = 1/t1**3.333333333333333d+0
            t270 = 8.548627933030694d-3*t12*t269
            t271 = t88**3
            t272 = 1/t15**1.6666666666666669d+0
            t273 = 6*t13*t28
            t274 = -6*t167
            t275 = t274+t273
            t276 = t91**3
            t277 = 1/t17**1.6666666666666669d+0
            t278 = -6*t13*t28
            t279 = 6*t167
            t280 = t279+t278
            t281 = t70**3
            t282 = 1/t25**3
            t283 = 6.75476d-2*t20*t281*t282
            t284 = -1.013214d-1*t140*t146*t20*t70
            t285 = 2.33086476681112d-3*t139*t140*t65
            t286 = 4.2321415041671406d-1*t131*t6*t68*t69+1.0580353760417
     1         849d-1*t56*t58*t68*t69-1.269642451250142d+0*t5*(2.6254110
     2         59665811d-1*t131*t58*t67+1.9690582947493582d-1*t130*t56*t
     3         67+7.876233178997433d-1*(-1.4585616998143394d-1*t21*t264*
     4         t58-5.469606374303773d-2*t21*t262*t263-6.407931356509611d
     5         -3*t261-1.3127055298329054d-1*t129*t130*t21)*t6-3.9381165
     6         894987163d-1*t144*t57*t58-1.4585616998143394d-1*t22*t264*
     7         t58-5.469606374303773d-2*t22*t262*t263-1.3127055298329054
     8         d-1*t129*t130*t22)*t69-6.34821225625071d-1*t145*t57*t6*t6
     9         9-7.617854707500852d+0*t5*t68**3/t23**4+7.617854707500852
     :         d+0*t143*t145*t5*t68+1.269642451250142d+0*t142*t143*t57*t
     ;         6+2.3511897245373004d-1*t24*t264*t6+7.053569173611901d-2*
     <         t129*t24*t58+1.763392293402975d-2*t130*t24*t262
            t287 = 3.37738d-2*t20*t286*t71
            t288 = -2.33086476681112d-3*t146*t65*t71
            t289 = 3.107819689081493d-3*t137*t70*t71
            t290 = -2.4171930915078277d-3*t26*t269
            t291 = t27*t28*(1.709920934161365d+0*(-5.284159572535706d-3*
     1         t137*t77*t78-3.10907d-2*t29*(4.2321415041671406d-1*t131*t
     2         6*t75*t76+1.0580353760417849d-1*t56*t58*t75*t76-1.2696424
     3         51250142d+0*t5*(2.625411059665811d-1*t131*t58*t74+1.96905
     4         82947493582d-1*t130*t56*t74+7.876233178997433d-1*(-1.4585
     5         616998143394d-1*t264*t30*t58-5.469606374303773d-2*t262*t2
     6         63*t30-1.3127055298329054d-1*t129*t130*t30-7.424439106586
     7         571d-3*t261)*t6-3.9381165894987163d-1*t154*t57*t58-1.4585
     8         616998143394d-1*t264*t31*t58-5.469606374303773d-2*t262*t2
     9         63*t31-1.3127055298329054d-1*t129*t130*t31)*t76-6.3482122
     :         5625071d-1*t155*t57*t6*t76-7.617854707500852d+0*t5*t75**3
     ;         /t32**4+7.617854707500852d+0*t153*t155*t5*t75+1.269642451
     <         250142d+0*t152*t153*t57*t6+2.3511897245373004d-1*t264*t33
     =         *t6+7.053569173611901d-2*t129*t33*t58+1.763392293402975d-
     >         2*t130*t262*t33)*t78+3.96311967940178d-3*t156*t65*t78-6.2
     ?         1814d-2*t29*t77**3/t34**3+9.327209999999999d-2*t151*t156*
     @         t29*t77-8.243319792565315d-3*t134*t63*t65-3.9631196794017
     1         8d-3*t150*t151*t65+8.243319792565315d-3*t124*t125*t65+1.0
     2         991093056753751d-2*t137*t62*t63+6.21814d-2*t265*t4*t63-1.
     3         865442d-1*t125*t134*t4*t62+1.243628d-1*t256*t257*t4+4.109
     4         9018897499934d-3*t269*t35-8.548627933030694d-3*t12*t269)-
     5         3.107819689081493d-3*t137*t70*t71+2.33086476681112d-3*t14
     6         6*t65*t71-3.37738d-2*t20*t286*t71+1.013214d-1*t140*t146*t
     7         20*t70-2.33086476681112d-3*t139*t140*t65-6.75476d-2*t20*t
     8         281*t282+2.4171930915078277d-3*t26*t269)
            t292 = -12*t157*t27*t81
            t293 = 60*t160*t27*t79
            t294 = 36*t162*t28*t79
            t295 = -120*t27*t36/t1**7
            t296 = -144*t162*t36*t81
            t297 = 24*t13*t28*t36
            t298 = 1.7544670867903944d+0*t164*t93+5.848223622634648d-1*t
     1         37*(2.564881401242048d+0*t280*t92+2.5648814012420473d+0*t
     2         172*t175*t91+2.564881401242048d+0*t275*t89+2.564881401242
     3         0473d+0*t166*t170*t88-5.69973644720455d-1*t276*t277-5.699
     4         73644720455d-1*t271*t272)+1.7544670867903944d+0*t176*t84+
     5         5.848223622634648d-1*t19*(-96*t79*t81*t83+240*t160*t36*t8
     6         3+12*t157*t28*t83+t297+t296+t295+t294+t293+t292+t291+t290
     7         +t289+t288+t287+t285+t284+t283)+t270+t268+t267+t266+t260+
     8         t259+t258
            t299 = t99**3
            t300 = 1/t15**2.3333333333333334d+0
            t301 = 1/t17**2.3333333333333334d+0
            t302 = 3.333333333333333d-1*t280*t98+3.333333333333333d-1*t2
     1         75*t97-3.333333333333333d-1*t175*t180*t91-3.3333333333333
     2         33d-1*t170*t179*t88+1.4814814814814814d-1*t276*t301+1.481
     3         4814814814814d-1*t271*t300
            t303 = t1**5.000000000000002d-1
            t304 = -5.191144508652046d+0*t226*t303*t43*t47*t53
            t305 = 1/t1**6.666666666666665d-1
            t306 = 5.561940544984338d-1*t120*t305*t43*t47*t53
            t307 = 1/t1**1.8333333333333332d+0
            t308 = 4.414238527765347d-2*t101*t307*t43*t47*t53
            t309 = -5.191144508652046d+0*t226*t303*t43*t47*t51
            t310 = 5.561940544984338d-1*t120*t305*t43*t47*t51
            t311 = 4.414238527765347d-2*t101*t307*t43*t47*t51
            t312 = exp(-9.649190532874448d+1*t38*t48)
            t313 = 1/t50**4
            t314 = t107**3
            t315 = 1/t52**4
            t316 = -3.109069086965489d-2*t199*t42
            t317 = 1/t54**3
            t318 = 2.0d+0*t202
            t319 = t273-2*t167
            t320 = t278+2*t167
            t321 = -12*t162*t28*t79
            t322 = 48*t162*t36*t81
            t323 = -24*t13*t28*t36
            t324 = 1.1696447245269297d+0*t200*t93+5.848223622634648d-1*t
     1         37*(2.564881401242048d+0*t320*t92+3.41984186832273d+0*t13
     2         *t167*t172*t91+2.564881401242048d+0*t319*t89-3.4198418683
     3         2273d+0*t13*t166*t167*t88-5.69973644720455d-1*t113*t171*t
     4         277-5.69973644720455d-1*t112*t165*t272+8.549604670806825d
     5         -1*t113*t172*t175+8.549604670806825d-1*t112*t166*t170)+1.
     6         1696447245269297d+0*t201*t84+5.848223622634648d-1*t19*(-3
     7         2*t79*t81*t83+80*t160*t36*t83+4*t157*t28*t83+t323+t322+t3
     8         21+t295+t293+t292+t291+t290+t289+t288+t287+t285+t284+t283
     9         )+t270+t268+t267+t266+t260+t259+t258+5.848223622634648d-1
     :         *t111*t176+5.848223622634648d-1*t114*t164
            t325 = 1.8654414521792934d-1*t119*t46*t99
            t326 = 1.8654414521792934d-1*t109*t116*t46
            t327 = 6.218138173930978d-2*t206*t42
            t328 = -3.813902087989258d+0*t100*t101*t106*t116*t43*t53*t99
            t329 = 1.2713006959964196d+0*t100*t101*t203*t43*t48*t53
            t330 = 3.333333333333333d-1*t320*t98+3.333333333333333d-1*t3
     1         19*t97-4.444444444444444d-1*t13*t167*t180*t91+4.444444444
     2         444444d-1*t13*t167*t179*t88+1.4814814814814814d-1*t113*t1
     3         71*t301+1.4814814814814814d-1*t112*t165*t300-1.1111111111
     4         11111d-1*t113*t175*t180-1.111111111111111d-1*t112*t170*t1
     5         79
            t331 = -1.2713006959964196d+0*t100*t101*t103*t118*t43*t48*t9
     1         9
            t332 = -1.2713006959964196d+0*t100*t101*t103*t108*t116*t43*t
     1         48
            t333 = -1.2713006959964196d+0*t100*t101*t108*t118*t194*t43*t
     1         47
            t334 = 6.356503479982097d-1*t100*t101*t103*t205*t43*t47
            t335 = -3.813902087989258d+0*t100*t101*t106*t116*t43*t51*t99
            t336 = 1.2713006959964196d+0*t100*t101*t203*t43*t48*t51
            t337 = 6.356503479982097d-1*t100*t101*t105*t204*t43*t47*t49
            t338 = -1.2713006959964196d+0*t100*t101*t105*t117*t43*t48*t4
     1         9*t99
            t339 = -1.2713006959964196d+0*t100*t101*t105*t107*t116*t43*t
     1         48*t49
            t340 = -1.2713006959964196d+0*t100*t101*t107*t117*t190*t191*
     1         t43*t47
            t341 = 6.356503479982097d-1*t100*t101*t105*t107*t117*t43*t47
     1         *t49
            t342 = 1.9298381065748896d+2*t106*t116*t38-6.432793688582966
     1         d+1*t115*t48
            t343 = 3.7308829043585867d-1*t116*t41*t55*t99
            t344 = 1.8654414521792934d-1*t203*t46*t55
            t345 = 5.848223622634648d-1*t208*t93+5.848223622634648d-1*t3
     1         7*(-1.5389288407452287d+1*t13*t28*t92-5.129762802484096d+
     2         0*t167*t92-5.69973644720455d-1*t211*t277*t91+8.5496046708
     3         06825d-1*t172*t212*t91+1.5389288407452287d+1*t13*t28*t89+
     4         5.129762802484096d+0*t167*t89-5.69973644720455d-1*t209*t2
     5         72*t88+8.549604670806825d-1*t166*t210*t88+3.4198418683227
     6         3d+0*t113*t13*t167*t172-3.41984186832273d+0*t112*t13*t166
     7         *t167)+5.848223622634648d-1*t213*t84+5.848223622634648d-1
     8         *t19*(32*t79*t81*t83-80*t160*t36*t83-4*t157*t28*t83+t322+
     9         t321+t297+t295+t293+t292+t291+t290+t289+t288+t287+t285+t2
     :         84+t283)+t270+t268+t267+t266+t260+t259+t258+1.16964472452
     ;         69297d+0*t111*t201+1.1696447245269297d+0*t114*t200
            t346 = -2.0d+0*t13*t28*t98-6.666666666666666d-1*t167*t98+2.0
     1         d+0*t13*t28*t97+6.666666666666666d-1*t167*t97+1.481481481
     2         4814814d-1*t211*t301*t91-1.111111111111111d-1*t180*t212*t
     3         91+1.4814814814814814d-1*t209*t300*t88-1.111111111111111d
     4         -1*t179*t210*t88-4.444444444444444d-1*t113*t13*t167*t180+
     5         4.444444444444444d-1*t112*t13*t167*t179
            t347 = t112**3
            t348 = t279+t273
            t349 = t113**3
            t350 = t278+t274
            t351 = 5.848223622634648d-1*t37*(2.564881401242048d+0*t350*t
     1         92+2.564881401242048d+0*t348*t89-5.69973644720455d-1*t277
     2         *t349-5.69973644720455d-1*t272*t347+2.5648814012420473d+0
     3         *t113*t172*t212+2.5648814012420473d+0*t112*t166*t210)+5.8
     4         48223622634648d-1*t19*(96*t79*t81*t83-240*t160*t36*t83-12
     5         *t157*t28*t83+t323+t296+t295+t294+t293+t292+t291+t290+t28
     6         9+t288+t287+t285+t284+t283)+t270+t268+t267+t266+t260+t259
     7         +t258+1.7544670867903944d+0*t111*t213+1.7544670867903944d
     8         +0*t114*t208
            t352 = t116**3
            t353 = 3.333333333333333d-1*t350*t98+3.333333333333333d-1*t3
     1         48*t97+1.4814814814814814d-1*t301*t349+1.4814814814814814
     2         d-1*t300*t347-3.333333333333333d-1*t113*t180*t212-3.33333
     3         3333333333d-1*t112*t179*t210
            t354 = t117**3
            t355 = 1.2713006959964196d+0*t100*t101*t48*t53*t99
            t356 = 1.1123881089968671d+0*t120*t182*t47*t53
            t357 = -5.297086233318417d-2*t101*t184*t47*t53
            t358 = -1.7316487067581934d-1*t100*t103*t188*t226*t43*t51*t9
     1         9
            t359 = -1.515192618413419d-1*t103*t106*t182*t248*t43*t51
            t360 = 7.215202944825808d-3*t103*t106*t184*t226*t43*t51
            t361 = 6.356503479982097d-1*t100*t101*t103*t108*t47
            t362 = -1.7316487067581934d-1*t100*t106*t108*t194*t226*t43*t
     1         51
            t363 = 1.2713006959964196d+0*t100*t101*t48*t51*t99
            t364 = 1.1123881089968671d+0*t120*t182*t47*t51
            t365 = -5.297086233318417d-2*t101*t184*t47*t51
            t366 = 6.356503479982097d-1*t100*t101*t105*t107*t47*t49
            t367 = (t96*(3.109069086965489d-2*t1*t42*(-1.362107888567592
     1         2d-1*t103*t43*t45*t47*(5.448431554270369d-1*t105*t107*t45
     2         *t48*t49*t99-2.7242157771351844d-1*t181*t45*t48*t51+8.172
     3         647331405554d-1*t106*t178*t45*t51-1.3621078885675922d-1*t
     4         105*t192*t45*t47*t49-1.3621078885675922d-1*t105*t189*t45*
     5         t47*t49+2.7242157771351844d-1*t190*t191*t192*t45*t47+t366
     6         +t365+t364+t363)-1.4842703200784513d-1*t108*t120*t188*t19
     7         4*t43*t51*t99+5.448431554270369d-1*t103*t229*t43*t45*t48*
     8         t99+5.448431554270369d-1*t103*t108*t45*t48*t99-2.72421577
     9         71351844d-1*t181*t45*t48*t53+8.172647331405554d-1*t106*t1
     :         78*t45*t53-1.1132027400588386d-1*t106*t120*t195*t315*t43*
     ;         t51-1.1132027400588386d-1*t103*t120*t178*t249*t43*t51+3.7
     <         10675800196128d-2*t106*t120*t193*t194*t43*t51+3.710675800
     =         196128d-2*t103*t120*t181*t188*t43*t51+5.448431554270369d-
     >         1*t108*t194*t229*t43*t45*t47+2.7242157771351844d-1*t194*t
     ?         195*t45*t47-1.3621078885675922d-1*t103*t193*t45*t47+6.356
     @         503479982097d-1*t100*t101*t103*t229*t43*t47+t362+t361+t36
     1         0+t359+t358+t357+t356+t355)+1.8654414521792934d-1*t1*t230
     2         *t46*t99+1.8654414521792934d-1*t121*t46*t99+9.32720726089
     3         6466d-2*t1*t121*t181*t46+6.218138173930978d-2*t230*t42+1.
     4         8654414521792934d-1*t1*t121*t178*t41)+t198*(-6.2181381739
     5         30978d-2*t1*t109*t230*t42-t121*t197)+6.218138173930978d-2
     6         *t1*t121*t199*t317*t42)*wght
            t368 = 2.2247762179937342d+0*t120*t182*t47*t53
            t369 = -1.0594172466636834d-1*t101*t184*t47*t53
            t370 = -3.030385236826838d-1*t103*t106*t182*t248*t43*t51
            t371 = 1.4430405889651615d-2*t103*t106*t184*t226*t43*t51
            t372 = 2.2247762179937342d+0*t120*t182*t47*t51
            t373 = -1.0594172466636834d-1*t101*t184*t47*t51
            t374 = (t96*(3.109069086965489d-2*t1*t42*(-1.362107888567592
     1         2d-1*t103*t43*t45*t47*(6.356503479982097d-1*t100*t101*t48
     2         *t51*t99+8.172647331405554d-1*t106*t116*t45*t51*t99+2.724
     3         2157771351844d-1*t105*t117*t45*t48*t49*t99-2.724215777135
     4         1844d-1*t203*t45*t48*t51+6.356503479982097d-1*t100*t101*t
     5         116*t48*t51+2.7242157771351844d-1*t105*t107*t116*t45*t48*
     6         t49-1.3621078885675922d-1*t105*t204*t45*t47*t49-1.3621078
     7         885675922d-1*t105*t107*t117*t45*t47*t49+3.178251739991048
     8         7d-1*t100*t101*t105*t117*t47*t49+3.1782517399910487d-1*t1
     9         00*t101*t105*t107*t47*t49+2.7242157771351844d-1*t107*t117
     :         *t190*t191*t45*t47+t365+t364)+6.356503479982097d-1*t100*t
     ;         101*t48*t53*t99+8.172647331405554d-1*t106*t116*t45*t53*t9
     <         9-1.1132027400588386d-1*t103*t116*t120*t249*t43*t51*t99-8
     =         .658243533790967d-2*t100*t103*t188*t226*t43*t51*t99-7.421
     >         351600392256d-2*t118*t120*t188*t194*t43*t51*t99+2.7242157
     ?         771351844d-1*t103*t240*t43*t45*t48*t99+2.7242157771351844
     @         d-1*t103*t118*t45*t48*t99-2.7242157771351844d-1*t203*t45*
     1         t48*t53+6.356503479982097d-1*t100*t101*t116*t48*t53-1.113
     2         2027400588386d-1*t106*t108*t118*t120*t315*t43*t51-8.65824
     3         3533790967d-2*t100*t106*t118*t194*t226*t43*t51-8.65824353
     4         3790967d-2*t100*t106*t108*t194*t226*t43*t51-8.65824353379
     5         0967d-2*t100*t103*t116*t188*t226*t43*t51+3.71067580019612
     6         8d-2*t106*t120*t194*t205*t43*t51+3.710675800196128d-2*t10
     7         3*t120*t188*t203*t43*t51-7.421351600392256d-2*t108*t116*t
     8         120*t188*t194*t43*t51+2.7242157771351844d-1*t103*t116*t22
     9         9*t43*t45*t48+2.7242157771351844d-1*t103*t108*t116*t45*t4
     :         8+2.7242157771351844d-1*t108*t194*t240*t43*t45*t47+2.7242
     ;         157771351844d-1*t118*t194*t229*t43*t45*t47-1.362107888567
     <         5922d-1*t103*t205*t45*t47+2.7242157771351844d-1*t108*t118
     =         *t194*t45*t47+3.1782517399910487d-1*t100*t101*t103*t240*t
     >         43*t47+3.1782517399910487d-1*t100*t101*t103*t229*t43*t47+
     ?         3.1782517399910487d-1*t100*t101*t103*t118*t47+3.178251739
     @         9910487d-1*t100*t101*t103*t108*t47+t360+t359+t357+t356)+9
     1         .327207260896466d-2*t1*t241*t46*t99+9.327207260896466d-2*
     2         t121*t46*t99+1.8654414521792934d-1*t1*t116*t121*t41*t99+9
     3         .327207260896466d-2*t1*t116*t230*t46+9.327207260896466d-2
     4         *t1*t121*t203*t46+9.327207260896466d-2*t116*t121*t46+3.10
     5         9069086965489d-2*t241*t42+3.109069086965489d-2*t230*t42)+
     6         t198*(-3.109069086965489d-2*t1*t109*t241*t42-3.1090690869
     7         65489d-2*t1*t119*t230*t42-t121*t207)+6.218138173930978d-2
     8         *t1*t109*t119*t121*t317*t42)*wght
            t375 = 1.2713006959964196d+0*t100*t101*t116*t48*t53
            t376 = -1.7316487067581934d-1*t100*t103*t116*t188*t226*t43*t
     1         51
            t377 = 6.356503479982097d-1*t100*t101*t103*t118*t47
            t378 = -1.7316487067581934d-1*t100*t106*t118*t194*t226*t43*t
     1         51
            t379 = 1.2713006959964196d+0*t100*t101*t116*t48*t51
            t380 = 6.356503479982097d-1*t100*t101*t105*t117*t47*t49
            t381 = ((3.109069086965489d-2*t1*t42*(-2.7242157771351844d-1
     1         *t216*t45*t48*t53+8.172647331405554d-1*t106*t215*t45*t53-
     2         1.3621078885675922d-1*t103*t43*t45*t47*(-2.72421577713518
     3         44d-1*t216*t45*t48*t51+8.172647331405554d-1*t106*t215*t45
     4         *t51+5.448431554270369d-1*t105*t116*t117*t45*t48*t49-1.36
     5         21078885675922d-1*t105*t218*t45*t47*t49-1.362107888567592
     6         2d-1*t105*t217*t45*t47*t49+2.7242157771351844d-1*t190*t19
     7         1*t218*t45*t47+t380+t379+t365+t364)-1.1132027400588386d-1
     8         *t106*t120*t220*t315*t43*t51-1.1132027400588386d-1*t103*t
     9         120*t215*t249*t43*t51+3.710675800196128d-2*t106*t120*t194
     :         *t219*t43*t51+3.710675800196128d-2*t103*t120*t188*t216*t4
     ;         3*t51-1.4842703200784513d-1*t116*t118*t120*t188*t194*t43*
     <         t51+5.448431554270369d-1*t103*t116*t240*t43*t45*t48+5.448
     =         431554270369d-1*t103*t116*t118*t45*t48+5.448431554270369d
     >         -1*t118*t194*t240*t43*t45*t47+2.7242157771351844d-1*t194*
     ?         t220*t45*t47-1.3621078885675922d-1*t103*t219*t45*t47+6.35
     @         6503479982097d-1*t100*t101*t103*t240*t43*t47+t378+t377+t3
     1         76+t375+t360+t359+t357+t356)+1.8654414521792934d-1*t1*t11
     2         6*t241*t46+9.327207260896466d-2*t1*t121*t216*t46+1.865441
     3         4521792934d-1*t116*t121*t46+6.218138173930978d-2*t241*t42
     4         +1.8654414521792934d-1*t1*t121*t215*t41)*t96+t198*(-6.218
     5         138173930978d-2*t1*t119*t241*t42-t121*t222)+6.21813817393
     6         0978d-2*t1*t121*t223*t317*t42)*wght
            t382 = 3.109069086965489d-2*t250*t42
            t383 = 1/t41**7.0d+0
            t384 = 1/t44**7.0d+0
            t385 = -1.1793461818516023d-2*t100*t105*t194*t249*t384*t43
            t386 = 8.658243533790967d-2*t100*t103*t106*t226*t51
            t387 = -2.7242157771351844d-1*t103*t229*t45*t47
            t388 = 7.421351600392256d-2*t106*t120*t194*t229*t43*t51
            t389 = (t96*(3.109069086965489d-2*t1*t42*(7.421351600392256d
     1         -2*t103*t120*t188*t51*t99-1.0108681558728018d-2*t105*t194
     2         *t248*t383*t43*t99+7.421351600392256d-2*t106*t108*t120*t1
     3         94*t51-1.5163022338092028d-2*t105*t108*t248*t249*t315*t43
     4         +t388+t387+t386+t385)+9.327207260896466d-2*t1*t250*t46*t9
     5         9+t382)+t198*(-3.109069086965489d-2*t1*t109*t250*t42-3.10
     6         9069086965489d-2*t1*t121*t230*t42-t121*t231)+6.2181381739
     7         30978d-2*t1*t109*t247*t317*t42)*wght
            t390 = 6.218138173930978d-2*t1*t109*t121*t123*t317*t42
            t391 = 3.109069086965489d-2*t252*t42
            t392 = -2.3586923637032045d-2*t100*t105*t194*t249*t384*t43
            t393 = 1.7316487067581934d-1*t100*t103*t106*t226*t51
            t394 = t96*(3.109069086965489d-2*t1*t42*(1.4842703200784513d
     1         -1*t103*t120*t188*t51*t99-2.0217363117456036d-2*t105*t194
     2         *t248*t383*t43*t99+3.710675800196128d-2*t106*t120*t194*t2
     3         37*t43*t51+1.4842703200784513d-1*t106*t108*t120*t194*t51-
     4         1.3621078885675922d-1*t103*t237*t45*t47-3.032604467618405
     5         5d-2*t105*t108*t248*t249*t315*t43+t393+t392+t388+t387)+9.
     6         327207260896466d-2*t1*t252*t46*t99+t391)
            t395 = -3.109069086965489d-2*t1*t109*t252*t42
            t396 = 3.109069086965489d-2*t255*t42
            t397 = -4.717384727406409d-2*t100*t105*t194*t249*t384*t43
            t398 = 3.463297413516387d-1*t100*t103*t106*t226*t51
            t399 = -2.7242157771351844d-1*t103*t240*t45*t47
            t400 = 7.421351600392256d-2*t106*t120*t194*t240*t43*t51
            t401 = ((3.109069086965489d-2*t1*t42*(7.421351600392256d-2*t
     1         106*t118*t120*t194*t51+7.421351600392256d-2*t103*t116*t12
     2         0*t188*t51-1.0108681558728018d-2*t105*t116*t194*t248*t383
     3         *t43-1.5163022338092028d-2*t105*t118*t248*t249*t315*t43+t
     4         400+t399+t386+t385)+9.327207260896466d-2*t1*t116*t250*t46
     5         +t382)*t96+t198*(-3.109069086965489d-2*t1*t119*t250*t42-3
     6         .109069086965489d-2*t1*t121*t241*t42-t121*t242)+6.2181381
     7         73930978d-2*t1*t119*t247*t317*t42)*wght
            t402 = 6.218138173930978d-2*t1*t119*t121*t123*t317*t42
            t403 = (3.109069086965489d-2*t1*t42*(3.710675800196128d-2*t1
     1         06*t120*t194*t244*t43*t51+1.4842703200784513d-1*t106*t118
     2         *t120*t194*t51+1.4842703200784513d-1*t103*t116*t120*t188*
     3         t51-1.3621078885675922d-1*t103*t244*t45*t47-2.02173631174
     4         56036d-2*t105*t116*t194*t248*t383*t43-3.0326044676184055d
     5         -2*t105*t118*t248*t249*t315*t43+t400+t399+t393+t392)+9.32
     6         7207260896466d-2*t1*t116*t252*t46+t391)*t96
            t404 = -3.109069086965489d-2*t1*t119*t252*t42
            t405 = 1/t44**8.0d+0
            t406 = 1/t41**8.0d+0
            t407 = 3.109069086965489d-2*t1*t42*(1.5163022338092028d-2*t1
     1         05*t194*t248*t249-2.065367234124177d-3*t191*t315*t405*t40
     2         6*t43)*t96*wght+6.218138173930978d-2*t1*t121**3*t317*t42*
     3         wght-9.327207260896466d-2*t1*t121*t198*t250*t42*wght
            t408 = t198*(-6.218138173930978d-2*t1*t121*t252*t42*wght-3.1
     1         09069086965489d-2*t1*t123*t250*t42*wght)+3.10906908696548
     2         9d-2*t1*t42*(3.0326044676184055d-2*t105*t194*t248*t249-4.
     3         130734468248354d-3*t191*t315*t405*t406*t43)*t96*wght+6.21
     4         8138173930978d-2*t1*t123*t247*t317*t42*wght
            t409 = t198*(-3.109069086965489d-2*t1*t121*t255*t42*wght-6.2
     1         18138173930978d-2*t1*t123*t252*t42*wght)+3.10906908696548
     2         9d-2*t1*t42*(6.065208935236811d-2*t105*t194*t248*t249-8.2
     3         61468936496708d-3*t191*t315*t405*t406*t43)*t96*wght+6.218
     4         138173930978d-2*t1*t121*t254*t317*t42*wght
            fnc(iq) = (3.109069086965489d-2*t1*t42*t55+1.0d+0*t1*t38)*wg
     1         ht+fnc(iq)
            Amat(iq,D1_RA) = (9.327207260896466d-2*t1*t46*t55*t99+3.1090
     1         69086965489d-2*t1*t109*t42*t96+t95+1.0d+0*t1*t94+t110)*wg
     2         ht+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = (3.109069086965489d-2*t1*t119*t42*t96+t95+9
     1         .327207260896466d-2*t1*t116*t46*t55+1.0d+0*t1*t115+t110)*
     2         wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = t122+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 3.109069086965489d-2*t1*t123*t42*t96*wght+
     1         Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = t122+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RA_RA) = (1.8654414521792934d-1*t46*t55*t99+t197
     1         *t96+2.0d+0*t94+9.327207260896466d-2*t1*t181*t46*t55+1.86
     2         54414521792934d-1*t1*t178*t41*t55-3.109069086965489d-2*t1
     3         *t198*t199*t42+1.0d+0*t1*t177)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = (9.327207260896466d-2*t46*t55*t99+1.865
     1         4414521792934d-1*t1*t116*t41*t55*t99+t207*t96+1.0d+0*t94+
     2         9.327207260896466d-2*t1*t203*t46*t55+9.327207260896466d-2
     3         *t116*t46*t55-3.109069086965489d-2*t1*t109*t119*t198*t42+
     4         1.0d+0*t1*t202+1.0d+0*t115)*wght+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = (t222*t96+9.327207260896466d-2*t1*t216*
     1         t46*t55+1.8654414521792934d-1*t116*t46*t55+1.865441452179
     2         2934d-1*t1*t215*t41*t55-3.109069086965489d-2*t1*t198*t223
     3         *t42+1.0d+0*t1*t214+2.0d+0*t115)*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = t232+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = (t239*t96-3.109069086965489d-2*t1*t109
     1         *t123*t198*t42)*wght+Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t232+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = t243+Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = (t246*t96-3.109069086965489d-2*t1*t119
     1         *t123*t198*t42)*wght+Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = t243+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = t251+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = t253+Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = t251+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = 3.109069086965489d-2*t1*t255*t42*t96*
     1         wght-3.109069086965489d-2*t1*t198*t254*t42*wght+Cmat2(iq,
     2         D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = t253+Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = t251+Cmat2(iq,D2_GBB_GBB)
            Amat3(iq,D3_RA_RA_RA) = (t96*(3.109069086965489d-2*t1*t42*(-
     1         1.3621078885675922d-1*t103*t43*t45*t47*(-1.36210788856759
     2         22d-1*t105*t43*t45*t47*t49*(-1.1579028639449339d+3*t181*t
     3         188*t38*t99+2.8947571598623345d+2*t106*t177*t99-1.1579028
     4         639449339d+3*t178*t188*t94+2.8947571598623345d+2*t106*t18
     5         1*t94-3.216396844291483d+1*t298*t48+9.649190532874448d+1*
     6         t106*t302*t38+1.9298381065748896d+3*t249*t299*t38)+2.7242
     7         157771351844d-1*t190*t191*t192*t43*t45*t47*(1.92983810657
     8         48896d+2*t106*t38*t99-6.432793688582966d+1*t48*t94)+3.178
     9         2517399910504d-1*t101*t184*t43*t48*t51*t99-6.674328653981
     :         203d+0*t120*t182*t43*t48*t51*t99+2.4517941994216663d+0*t1
     ;         06*t181*t43*t45*t51*t99+8.172647331405554d-1*t105*t192*t4
     <         3*t45*t48*t49*t99+8.172647331405554d-1*t105*t189*t43*t45*
     =         t48*t49*t99-3.813902087989258d+0*t100*t101*t105*t107*t43*
     >         t48*t49*t99-1.6345294662811108d+0*t190*t191*t192*t43*t45*
     ?         t48*t99-2.7242157771351844d-1*t302*t43*t45*t48*t51+1.9069
     @         51043994629d+0*t100*t101*t181*t43*t48*t51-3.2690589325622
     1         216d+0*t188*t299*t43*t45*t51-5.720853131983887d+0*t100*t1
     2         01*t106*t178*t43*t51+8.172647331405554d-1*t105*t107*t181*
     3         t43*t45*t48*t49-1.3621078885675922d-1*t105*t314*t43*t45*t
     4         47*t49-4.086323665702777d-1*t105*t107*t189*t43*t45*t47*t4
     5         9+9.534755219973146d-1*t100*t101*t105*t192*t43*t47*t49+9.
     6         534755219973146d-1*t100*t101*t105*t189*t43*t47*t49+1.5891
     7         258699955252d-1*t101*t105*t107*t184*t43*t47*t49-3.3371643
     8         269906015d+0*t105*t107*t120*t182*t43*t47*t49-2.4517941994
     9         216663d+0*t105*t106*t107*t178*t43*t45*t49-8.1726473314055
     :         54d-1*t312*t313*t314*t43*t45*t47+2.7242157771351844d-1*t1
     ;         90*t191*t314*t43*t45*t47+8.172647331405554d-1*t107*t189*t
     <         190*t191*t43*t45*t47-1.906951043994629d+0*t100*t101*t190*
     =         t191*t192*t43*t47+t311+t310+t309)+3.1782517399910504d-1*t
     >         101*t184*t43*t48*t53*t99-6.674328653981203d+0*t120*t182*t
     ?         43*t48*t53*t99+2.4517941994216663d+0*t106*t181*t43*t45*t5
     @         3*t99-1.6345294662811108d+0*t194*t195*t43*t45*t48*t99+8.1
     1         72647331405554d-1*t103*t193*t43*t45*t48*t99-3.81390208798
     2         9258d+0*t100*t101*t103*t108*t43*t48*t99-2.724215777135184
     3         4d-1*t302*t43*t45*t48*t53+1.906951043994629d+0*t100*t101*
     4         t181*t43*t48*t53-3.2690589325622216d+0*t188*t299*t43*t45*
     5         t53-5.720853131983887d+0*t100*t101*t106*t178*t43*t53+8.17
     6         2647331405554d-1*t103*t108*t181*t43*t45*t48-8.17264733140
     7         5554d-1*t108**3*t315*t43*t45*t47+8.172647331405554d-1*t10
     8         8*t193*t194*t43*t45*t47-1.906951043994629d+0*t100*t101*t1
     9         94*t195*t43*t47+9.534755219973146d-1*t100*t101*t103*t193*
     :         t43*t47+1.5891258699955252d-1*t101*t103*t108*t184*t43*t47
     ;         -3.3371643269906015d+0*t103*t108*t120*t182*t43*t47-2.4517
     <         941994216663d+0*t103*t106*t108*t178*t43*t45+t308+t306+t30
     =         4)+2.7981621782689403d-1*t1*t196*t46*t99+5.59632435653788
     >         1d-1*t109*t46*t99+2.7981621782689403d-1*t1*t109*t181*t46+
     ?         9.327207260896466d-2*t196*t42+5.596324356537881d-1*t1*t10
     @         9*t178*t41)+t198*(-9.327207260896466d-2*t1*t199*t46*t99-6
     1         .218138173930978d-2*t1*t109*t196*t42+t316-t109*t197)+5.59
     2         6324356537881d-1*t1*t181*t41*t55*t99+9.327207260896466d-2
     3         *t1*t302*t46*t55+2.7981621782689403d-1*t181*t46*t55+5.596
     4         324356537881d-1*t178*t41*t55+1.8654414521792934d-1*t1*t29
     5         9*t55+6.218138173930978d-2*t1*t109**3*t317*t42+1.0d+0*t1*
     6         t298+3.0d+0*t177)*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = (t96*(3.109069086965489d-2*t1*t42*(-
     1         1.3621078885675922d-1*t103*t43*t45*t47*(-1.36210788856759
     2         22d-1*t105*t43*t45*t47*t49*(-7.719352426299558d+2*t116*t1
     3         88*t94*t99-7.719352426299558d+2*t188*t203*t38*t99+1.92983
     4         81065748896d+2*t106*t202*t99+1.9298381065748896d+2*t106*t
     5         203*t94-3.216396844291483d+1*t324*t48+9.649190532874448d+
     6         1*t106*t330*t38+1.9298381065748896d+3*t116*t178*t249*t38-
     7         3.859676213149779d+2*t116*t181*t188*t38-3.859676213149779
     8         d+2*t115*t178*t188+9.649190532874448d+1*t106*t115*t181+9.
     9         649190532874448d+1*t106*t116*t177)+2.1188344933273667d-1*
     :         t101*t184*t43*t48*t51*t99-4.4495524359874683d+0*t120*t182
     ;         *t43*t48*t51*t99+1.6345294662811108d+0*t106*t203*t43*t45*
     <         t51*t99+5.448431554270369d-1*t105*t204*t43*t45*t48*t49*t9
     =         9+5.448431554270369d-1*t105*t107*t117*t43*t45*t48*t49*t99
     >         -1.2713006959964196d+0*t100*t101*t105*t107*t43*t48*t49*t9
     ?         9-1.6345294662811108d+0*t105*t106*t107*t116*t43*t45*t49*t
     @         99-1.0896863108540737d+0*t107*t117*t190*t191*t43*t45*t48*
     1         t99-2.7242157771351844d-1*t330*t43*t45*t48*t51+1.05941724
     2         66636834d-1*t101*t116*t184*t43*t48*t51-2.2247762179937342
     3         d+0*t116*t120*t182*t43*t48*t51+6.356503479982097d-1*t100*
     4         t101*t181*t43*t48*t51-3.2690589325622216d+0*t116*t178*t18
     5         8*t43*t45*t51+8.172647331405554d-1*t106*t116*t181*t43*t45
     6         *t51-1.9069510439946294d+0*t100*t101*t106*t178*t43*t51+5.
     7         448431554270369d-1*t105*t107*t203*t43*t45*t48*t49+2.72421
     8         57771351844d-1*t105*t116*t192*t43*t45*t48*t49+2.724215777
     9         1351844d-1*t105*t116*t189*t43*t45*t48*t49+2.7242157771351
     :         844d-1*t105*t117*t181*t43*t45*t48*t49-2.7242157771351844d
     ;         -1*t105*t107*t204*t43*t45*t47*t49-1.3621078885675922d-1*t
     <         105*t117*t192*t43*t45*t47*t49-1.3621078885675922d-1*t105*
     =         t117*t189*t43*t45*t47*t49+3.1782517399910487d-1*t100*t101
     >         *t105*t192*t43*t47*t49+3.1782517399910487d-1*t100*t101*t1
     ?         05*t189*t43*t47*t49+5.297086233318417d-2*t101*t105*t117*t
     @         184*t43*t47*t49+1.0594172466636834d-1*t101*t105*t107*t184
     1         *t43*t47*t49-1.1123881089968671d+0*t105*t117*t120*t182*t4
     2         3*t47*t49-2.2247762179937342d+0*t105*t107*t120*t182*t43*t
     3         47*t49-8.172647331405554d-1*t105*t106*t117*t178*t43*t45*t
     4         49-5.448431554270369d-1*t116*t190*t191*t192*t43*t45*t48+2
     5         .7242157771351844d-1*t190*t191*t192*t342*t43*t45*t47-8.17
     6         2647331405554d-1*t117*t192*t312*t313*t43*t45*t47+5.448431
     7         554270369d-1*t107*t190*t191*t204*t43*t45*t47+2.7242157771
     8         351844d-1*t117*t190*t191*t192*t43*t45*t47+2.7242157771351
     9         844d-1*t117*t189*t190*t191*t43*t45*t47-6.356503479982097d
     :         -1*t100*t101*t190*t191*t192*t43*t47+t341+t340+t339+t338+t
     ;         337+t336+t335+t311+t310+t309)+2.1188344933273667d-1*t101*
     <         t184*t43*t48*t53*t99-4.4495524359874683d+0*t120*t182*t43*
     =         t48*t53*t99+1.6345294662811108d+0*t106*t203*t43*t45*t53*t
     >         99+5.448431554270369d-1*t103*t205*t43*t45*t48*t99-1.08968
     ?         63108540737d+0*t108*t118*t194*t43*t45*t48*t99-1.271300695
     @         9964196d+0*t100*t101*t103*t108*t43*t48*t99-1.634529466281
     1         1108d+0*t103*t106*t108*t116*t43*t45*t99-2.724215777135184
     2         4d-1*t330*t43*t45*t48*t53+1.0594172466636834d-1*t101*t116
     3         *t184*t43*t48*t53-2.2247762179937342d+0*t116*t120*t182*t4
     4         3*t48*t53+6.356503479982097d-1*t100*t101*t181*t43*t48*t53
     5         -3.2690589325622216d+0*t116*t178*t188*t43*t45*t53+8.17264
     6         7331405554d-1*t106*t116*t181*t43*t45*t53-1.90695104399462
     7         94d+0*t100*t101*t106*t178*t43*t53+5.448431554270369d-1*t1
     8         03*t108*t203*t43*t45*t48-5.448431554270369d-1*t116*t194*t
     9         195*t43*t45*t48+2.7242157771351844d-1*t103*t116*t193*t43*
     :         t45*t48+2.7242157771351844d-1*t103*t118*t181*t43*t45*t48-
     ;         8.172647331405554d-1*t118*t195*t315*t43*t45*t47+5.4484315
     <         54270369d-1*t108*t194*t205*t43*t45*t47+2.7242157771351844
     =         d-1*t118*t193*t194*t43*t45*t47-6.356503479982097d-1*t100*
     >         t101*t194*t195*t43*t47+3.1782517399910487d-1*t100*t101*t1
     ?         03*t193*t43*t47+5.297086233318417d-2*t101*t103*t118*t184*
     @         t43*t47+1.0594172466636834d-1*t101*t103*t108*t184*t43*t47
     1         -1.1123881089968671d+0*t103*t118*t120*t182*t43*t47-2.2247
     2         762179937342d+0*t103*t108*t120*t182*t43*t47-8.17264733140
     3         5554d-1*t103*t106*t118*t178*t43*t45+t334+t333+t332+t331+t
     4         329+t328+t308+t306+t304)+1.8654414521792934d-1*t1*t206*t4
     5         6*t99+1.8654414521792934d-1*t109*t46*t99+3.73088290435858
     6         67d-1*t1*t109*t116*t41*t99+1.8654414521792934d-1*t1*t109*
     7         t203*t46+9.327207260896466d-2*t1*t116*t196*t46+9.32720726
     8         0896466d-2*t1*t119*t181*t46+3.109069086965489d-2*t196*t42
     9         +1.8654414521792934d-1*t1*t119*t178*t41+t327+t326+t325)+3
     :         .7308829043585867d-1*t1*t203*t41*t55*t99+9.32720726089646
     ;         6d-2*t1*t330*t46*t55+9.327207260896466d-2*t181*t46*t55+1.
     <         8654414521792934d-1*t1*t116*t181*t41*t55+1.86544145217929
     =         34d-1*t178*t41*t55+1.8654414521792934d-1*t1*t116*t178*t55
     >         +t198*(-9.327207260896466d-2*t1*t116*t199*t46-6.218138173
     ?         930978d-2*t1*t109*t206*t42+t316-t119*t197)+6.218138173930
     @         978d-2*t1*t119*t199*t317*t42+t344+t343+1.0d+0*t1*t324+t31
     1         8+1.0d+0*t177)*wght+Amat3(iq,D3_RA_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = (t96*(3.109069086965489d-2*t1*t42*(-
     1         1.3621078885675922d-1*t103*t43*t45*t47*(-1.36210788856759
     2         22d-1*t105*t43*t45*t47*t49*(1.9298381065748896d+3*t215*t2
     3         49*t38*t99-3.859676213149779d+2*t188*t216*t38*t99+9.64919
     4         0532874448d+1*t106*t214*t99-7.719352426299558d+2*t115*t11
     5         6*t188*t99+9.649190532874448d+1*t106*t216*t94-3.859676213
     6         149779d+2*t188*t215*t94-3.216396844291483d+1*t345*t48+9.6
     7         49190532874448d+1*t106*t346*t38-7.719352426299558d+2*t116
     8         *t188*t203*t38+1.9298381065748896d+2*t106*t115*t203+1.929
     9         8381065748896d+2*t106*t116*t202)+1.0594172466636834d-1*t1
     :         01*t184*t43*t48*t51*t99-2.2247762179937342d+0*t120*t182*t
     ;         43*t48*t51*t99+8.172647331405554d-1*t106*t216*t43*t45*t51
     <         *t99-3.2690589325622216d+0*t188*t215*t43*t45*t51*t99+2.72
     =         42157771351844d-1*t105*t218*t43*t45*t48*t49*t99+2.7242157
     >         771351844d-1*t105*t217*t43*t45*t48*t49*t99-1.634529466281
     ?         1108d+0*t105*t106*t116*t117*t43*t45*t49*t99-5.44843155427
     @         0369d-1*t190*t191*t218*t43*t45*t48*t99-2.7242157771351844
     1         d-1*t346*t43*t45*t48*t51+6.356503479982097d-1*t100*t101*t
     2         216*t43*t48*t51+2.1188344933273667d-1*t101*t116*t184*t43*
     3         t48*t51-4.4495524359874683d+0*t116*t120*t182*t43*t48*t51+
     4         1.6345294662811108d+0*t106*t116*t203*t43*t45*t51-1.906951
     5         043994629d+0*t100*t101*t106*t215*t43*t51+2.72421577713518
     6         44d-1*t105*t107*t216*t43*t45*t48*t49+5.448431554270369d-1
     7         *t105*t116*t204*t43*t45*t48*t49+5.448431554270369d-1*t105
     8         *t117*t203*t43*t45*t48*t49+5.448431554270369d-1*t105*t107
     9         *t116*t117*t43*t45*t48*t49-1.2713006959964196d+0*t100*t10
     :         1*t105*t116*t117*t43*t48*t49-1.3621078885675922d-1*t105*t
     ;         107*t218*t43*t45*t47*t49-1.3621078885675922d-1*t105*t107*
     <         t217*t43*t45*t47*t49-2.7242157771351844d-1*t105*t117*t204
     =         *t43*t45*t47*t49+3.1782517399910487d-1*t100*t101*t105*t21
     >         8*t43*t47*t49+3.1782517399910487d-1*t100*t101*t105*t217*t
     ?         43*t47*t49+1.0594172466636834d-1*t101*t105*t117*t184*t43*
     @         t47*t49+5.297086233318417d-2*t101*t105*t107*t184*t43*t47*
     1         t49-2.2247762179937342d+0*t105*t117*t120*t182*t43*t47*t49
     2         -1.1123881089968671d+0*t105*t107*t120*t182*t43*t47*t49-8.
     3         172647331405554d-1*t105*t106*t107*t215*t43*t45*t49-1.0896
     4         863108540737d+0*t107*t116*t117*t190*t191*t43*t45*t48+2.72
     5         42157771351844d-1*t107*t117*t190*t191*t342*t43*t45*t47-8.
     6         172647331405554d-1*t107*t218*t312*t313*t43*t45*t47+2.7242
     7         157771351844d-1*t107*t190*t191*t218*t43*t45*t47+2.7242157
     8         771351844d-1*t107*t190*t191*t217*t43*t45*t47+5.4484315542
     9         70369d-1*t117*t190*t191*t204*t43*t45*t47-6.35650347998209
     :         7d-1*t100*t101*t190*t191*t218*t43*t47+t341+t340+t339+t338
     ;         +t337+t336+t335+t311+t310+t309)+1.0594172466636834d-1*t10
     <         1*t184*t43*t48*t53*t99-2.2247762179937342d+0*t120*t182*t4
     =         3*t48*t53*t99+8.172647331405554d-1*t106*t216*t43*t45*t53*
     >         t99-3.2690589325622216d+0*t188*t215*t43*t45*t53*t99-5.448
     ?         431554270369d-1*t194*t220*t43*t45*t48*t99+2.7242157771351
     @         844d-1*t103*t219*t43*t45*t48*t99-1.6345294662811108d+0*t1
     1         03*t106*t116*t118*t43*t45*t99-2.7242157771351844d-1*t346*
     2         t43*t45*t48*t53+6.356503479982097d-1*t100*t101*t216*t43*t
     3         48*t53+2.1188344933273667d-1*t101*t116*t184*t43*t48*t53-4
     4         .4495524359874683d+0*t116*t120*t182*t43*t48*t53+1.6345294
     5         662811108d+0*t106*t116*t203*t43*t45*t53-1.906951043994629
     6         d+0*t100*t101*t106*t215*t43*t53+2.7242157771351844d-1*t10
     7         3*t108*t216*t43*t45*t48+5.448431554270369d-1*t103*t116*t2
     8         05*t43*t45*t48+5.448431554270369d-1*t103*t118*t203*t43*t4
     9         5*t48-1.0896863108540737d+0*t108*t116*t118*t194*t43*t45*t
     :         48-1.2713006959964196d+0*t100*t101*t103*t116*t118*t43*t48
     ;         -8.172647331405554d-1*t108*t220*t315*t43*t45*t47+2.724215
     <         7771351844d-1*t108*t194*t219*t43*t45*t47+5.44843155427036
     =         9d-1*t118*t194*t205*t43*t45*t47-6.356503479982097d-1*t100
     >         *t101*t194*t220*t43*t47+3.1782517399910487d-1*t100*t101*t
     ?         103*t219*t43*t47+1.0594172466636834d-1*t101*t103*t118*t18
     @         4*t43*t47+5.297086233318417d-2*t101*t103*t108*t184*t43*t4
     1         7-2.2247762179937342d+0*t103*t118*t120*t182*t43*t47-1.112
     2         3881089968671d+0*t103*t108*t120*t182*t43*t47-8.1726473314
     3         05554d-1*t103*t106*t108*t215*t43*t45+t334+t333+t332+t331+
     4         t329+t328+t308+t306+t304)+9.327207260896466d-2*t1*t221*t4
     5         6*t99+3.7308829043585867d-1*t1*t116*t119*t41*t99+9.327207
     6         260896466d-2*t1*t109*t216*t46+1.8654414521792934d-1*t1*t1
     7         16*t206*t46+1.8654414521792934d-1*t1*t119*t203*t46+1.8654
     8         414521792934d-1*t116*t119*t46+3.109069086965489d-2*t221*t
     9         42+1.8654414521792934d-1*t1*t109*t215*t41+t327+t326+t325)
     :         +1.8654414521792934d-1*t1*t216*t41*t55*t99+1.865441452179
     ;         2934d-1*t1*t215*t55*t99+9.327207260896466d-2*t1*t346*t46*
     <         t55+9.327207260896466d-2*t216*t46*t55+1.8654414521792934d
     =         -1*t215*t41*t55+3.7308829043585867d-1*t1*t116*t203*t41*t5
     >         5+t198*(-9.327207260896466d-2*t1*t109*t116*t119*t46-3.109
     ?         069086965489d-2*t1*t109*t221*t42-3.109069086965489d-2*t1*
     @         t119*t206*t42-3.109069086965489d-2*t109*t119*t42-t119*t20
     1         7)+6.218138173930978d-2*t1*t109*t223*t317*t42+1.0d+0*t1*t
     2         345+t344+t343+t318+1.0d+0*t214)*wght+Amat3(iq,D3_RA_RB_RB
     3         )
            Amat3(iq,D3_RB_RB_RB) = ((3.109069086965489d-2*t1*t42*(-2.72
     1         42157771351844d-1*t353*t43*t45*t48*t53+1.906951043994629d
     2         +0*t100*t101*t216*t43*t48*t53+3.1782517399910504d-1*t101*
     3         t116*t184*t43*t48*t53-6.674328653981203d+0*t116*t120*t182
     4         *t43*t48*t53-3.2690589325622216d+0*t188*t352*t43*t45*t53+
     5         2.4517941994216663d+0*t106*t116*t216*t43*t45*t53-5.720853
     6         131983887d+0*t100*t101*t106*t215*t43*t53-1.36210788856759
     7         22d-1*t103*t43*t45*t47*(-2.7242157771351844d-1*t353*t43*t
     8         45*t48*t51+1.906951043994629d+0*t100*t101*t216*t43*t48*t5
     9         1+3.1782517399910504d-1*t101*t116*t184*t43*t48*t51-6.6743
     :         28653981203d+0*t116*t120*t182*t43*t48*t51-3.2690589325622
     ;         216d+0*t188*t352*t43*t45*t51+2.4517941994216663d+0*t106*t
     <         116*t216*t43*t45*t51-5.720853131983887d+0*t100*t101*t106*
     =         t215*t43*t51-1.3621078885675922d-1*t105*t43*t45*t47*(-3.2
     >         16396844291483d+1*t351*t48+9.649190532874448d+1*t106*t353
     ?         *t38+1.9298381065748896d+3*t249*t352*t38-1.15790286394493
     @         39d+3*t116*t188*t216*t38+2.8947571598623345d+2*t106*t115*
     1         t216-1.1579028639449339d+3*t115*t188*t215+2.8947571598623
     2         345d+2*t106*t116*t214)*t49+8.172647331405554d-1*t105*t116
     3         *t218*t43*t45*t48*t49+8.172647331405554d-1*t105*t116*t217
     4         *t43*t45*t48*t49+8.172647331405554d-1*t105*t117*t216*t43*
     5         t45*t48*t49-3.813902087989258d+0*t100*t101*t105*t116*t117
     6         *t43*t48*t49-1.3621078885675922d-1*t105*t354*t43*t45*t47*
     7         t49-4.086323665702777d-1*t105*t117*t217*t43*t45*t47*t49+9
     8         .534755219973146d-1*t100*t101*t105*t218*t43*t47*t49+9.534
     9         755219973146d-1*t100*t101*t105*t217*t43*t47*t49+1.5891258
     :         699955252d-1*t101*t105*t117*t184*t43*t47*t49-3.3371643269
     ;         906015d+0*t105*t117*t120*t182*t43*t47*t49-2.4517941994216
     <         663d+0*t105*t106*t117*t215*t43*t45*t49-1.6345294662811108
     =         d+0*t116*t190*t191*t218*t43*t45*t48-8.172647331405554d-1*
     >         t312*t313*t354*t43*t45*t47+2.7242157771351844d-1*t190*t19
     ?         1*t354*t43*t45*t47+2.7242157771351844d-1*t190*t191*t218*t
     @         342*t43*t45*t47+8.172647331405554d-1*t117*t190*t191*t217*
     1         t43*t45*t47-1.906951043994629d+0*t100*t101*t190*t191*t218
     2         *t43*t47+t311+t310+t309)-1.6345294662811108d+0*t116*t194*
     3         t220*t43*t45*t48+8.172647331405554d-1*t103*t116*t219*t43*
     4         t45*t48+8.172647331405554d-1*t103*t118*t216*t43*t45*t48-3
     5         .813902087989258d+0*t100*t101*t103*t116*t118*t43*t48-8.17
     6         2647331405554d-1*t118**3*t315*t43*t45*t47+8.1726473314055
     7         54d-1*t118*t194*t219*t43*t45*t47-1.906951043994629d+0*t10
     8         0*t101*t194*t220*t43*t47+9.534755219973146d-1*t100*t101*t
     9         103*t219*t43*t47+1.5891258699955252d-1*t101*t103*t118*t18
     :         4*t43*t47-3.3371643269906015d+0*t103*t118*t120*t182*t43*t
     ;         47-2.4517941994216663d+0*t103*t106*t118*t215*t43*t45+t308
     <         +t306+t304)+2.7981621782689403d-1*t1*t116*t221*t46+2.7981
     =         621782689403d-1*t1*t119*t216*t46+5.596324356537881d-1*t11
     >         6*t119*t46+9.327207260896466d-2*t221*t42+5.59632435653788
     ?         1d-1*t1*t119*t215*t41)*t96+9.327207260896466d-2*t1*t353*t
     @         46*t55+2.7981621782689403d-1*t216*t46*t55+5.5963243565378
     1         81d-1*t1*t116*t216*t41*t55+5.596324356537881d-1*t215*t41*
     2         t55+1.8654414521792934d-1*t1*t352*t55+t198*(-9.3272072608
     3         96466d-2*t1*t116*t223*t46-3.109069086965489d-2*t223*t42-6
     4         .218138173930978d-2*t1*t119*t221*t42-t119*t222)+6.2181381
     5         73930978d-2*t1*t119**3*t317*t42+1.0d+0*t1*t351+3.0d+0*t21
     6         4)*wght+Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RA_RA_GAA) = t367+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = (t96*(3.109069086965489d-2*t1*t42*(
     1         -1.3621078885675922d-1*t103*t43*t45*t47*(2.54260139199283
     2         9d+0*t100*t101*t48*t51*t99+1.0896863108540737d+0*t105*t10
     3         7*t45*t48*t49*t99-5.448431554270369d-1*t181*t45*t48*t51+1
     4         .6345294662811108d+0*t106*t178*t45*t51-2.7242157771351844
     5         d-1*t105*t192*t45*t47*t49-2.7242157771351844d-1*t105*t189
     6         *t45*t47*t49+1.2713006959964196d+0*t100*t101*t105*t107*t4
     7         7*t49+5.448431554270369d-1*t190*t191*t192*t45*t47+t373+t3
     8         72)+2.542601391992839d+0*t100*t101*t48*t53*t99-3.46329741
     9         3516387d-1*t100*t103*t188*t226*t43*t51*t99-2.968540640156
     :         9026d-1*t108*t120*t188*t194*t43*t51*t99+5.448431554270369
     ;         d-1*t103*t237*t43*t45*t48*t99+1.0896863108540737d+0*t103*
     <         t108*t45*t48*t99-5.448431554270369d-1*t181*t45*t48*t53+1.
     =         6345294662811108d+0*t106*t178*t45*t53-2.2264054801176772d
     >         -1*t106*t120*t195*t315*t43*t51-2.2264054801176772d-1*t103
     ?         *t120*t178*t249*t43*t51-3.463297413516387d-1*t100*t106*t1
     @         08*t194*t226*t43*t51+7.421351600392256d-2*t106*t120*t193*
     1         t194*t43*t51+7.421351600392256d-2*t103*t120*t181*t188*t43
     2         *t51+5.448431554270369d-1*t108*t194*t237*t43*t45*t47+5.44
     3         8431554270369d-1*t194*t195*t45*t47-2.7242157771351844d-1*
     4         t103*t193*t45*t47+6.356503479982097d-1*t100*t101*t103*t23
     5         7*t43*t47+1.2713006959964196d+0*t100*t101*t103*t108*t47+t
     6         371+t370+t369+t368)+1.8654414521792934d-1*t1*t238*t46*t99
     7         +1.8654414521792934d-1*t123*t46*t99+9.327207260896466d-2*
     8         t1*t123*t181*t46+6.218138173930978d-2*t238*t42+1.86544145
     9         21792934d-1*t1*t123*t178*t41)+t198*(-6.218138173930978d-2
     :         *t1*t109*t238*t42-t123*t197)+6.218138173930978d-2*t1*t123
     ;         *t199*t317*t42)*wght+Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = t367+Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = t374+Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = (t96*(3.109069086965489d-2*t1*t42*(
     1         -1.3621078885675922d-1*t103*t43*t45*t47*(1.63452946628111
     2         08d+0*t106*t116*t45*t51*t99+5.448431554270369d-1*t105*t11
     3         7*t45*t48*t49*t99-5.448431554270369d-1*t203*t45*t48*t51+5
     4         .448431554270369d-1*t105*t107*t116*t45*t48*t49-2.72421577
     5         71351844d-1*t105*t204*t45*t47*t49-2.7242157771351844d-1*t
     6         105*t107*t117*t45*t47*t49+5.448431554270369d-1*t107*t117*
     7         t190*t191*t45*t47+t380+t379+t373+t372+t366+t363)+1.634529
     8         4662811108d+0*t106*t116*t45*t53*t99-2.2264054801176772d-1
     9         *t103*t116*t120*t249*t43*t51*t99-1.4842703200784513d-1*t1
     :         18*t120*t188*t194*t43*t51*t99+2.7242157771351844d-1*t103*
     ;         t244*t43*t45*t48*t99+5.448431554270369d-1*t103*t118*t45*t
     <         48*t99-5.448431554270369d-1*t203*t45*t48*t53-2.2264054801
     =         176772d-1*t106*t108*t118*t120*t315*t43*t51+7.421351600392
     >         256d-2*t106*t120*t194*t205*t43*t51+7.421351600392256d-2*t
     ?         103*t120*t188*t203*t43*t51-1.4842703200784513d-1*t108*t11
     @         6*t120*t188*t194*t43*t51+2.7242157771351844d-1*t103*t116*
     1         t237*t43*t45*t48+5.448431554270369d-1*t103*t108*t116*t45*
     2         t48+2.7242157771351844d-1*t108*t194*t244*t43*t45*t47+2.72
     3         42157771351844d-1*t118*t194*t237*t43*t45*t47-2.7242157771
     4         351844d-1*t103*t205*t45*t47+5.448431554270369d-1*t108*t11
     5         8*t194*t45*t47+3.1782517399910487d-1*t100*t101*t103*t244*
     6         t43*t47+3.1782517399910487d-1*t100*t101*t103*t237*t43*t47
     7         +t378+t377+t376+t375+t371+t370+t369+t368+t362+t361+t358+t
     8         355)+9.327207260896466d-2*t1*t245*t46*t99+9.3272072608964
     9         66d-2*t123*t46*t99+1.8654414521792934d-1*t1*t116*t123*t41
     :         *t99+9.327207260896466d-2*t1*t116*t238*t46+9.327207260896
     ;         466d-2*t1*t123*t203*t46+9.327207260896466d-2*t116*t123*t4
     <         6+3.109069086965489d-2*t245*t42+3.109069086965489d-2*t238
     =         *t42)+t198*(-3.109069086965489d-2*t1*t109*t245*t42-3.1090
     >         69086965489d-2*t1*t119*t238*t42-t123*t207)+6.218138173930
     ?         978d-2*t1*t109*t119*t123*t317*t42)*wght+Cmat3(iq,D3_RA_RB
     @         _GAB)
            Cmat3(iq,D3_RA_RB_GBB) = t374+Cmat3(iq,D3_RA_RB_GBB)
            Cmat3(iq,D3_RB_RB_GAA) = t381+Cmat3(iq,D3_RB_RB_GAA)
            Cmat3(iq,D3_RB_RB_GAB) = ((3.109069086965489d-2*t1*t42*(-5.4
     1         48431554270369d-1*t216*t45*t48*t53+2.542601391992839d+0*t
     2         100*t101*t116*t48*t53+1.6345294662811108d+0*t106*t215*t45
     3         *t53-1.3621078885675922d-1*t103*t43*t45*t47*(-5.448431554
     4         270369d-1*t216*t45*t48*t51+2.542601391992839d+0*t100*t101
     5         *t116*t48*t51+1.6345294662811108d+0*t106*t215*t45*t51+1.0
     6         896863108540737d+0*t105*t116*t117*t45*t48*t49-2.724215777
     7         1351844d-1*t105*t218*t45*t47*t49-2.7242157771351844d-1*t1
     8         05*t217*t45*t47*t49+1.2713006959964196d+0*t100*t101*t105*
     9         t117*t47*t49+5.448431554270369d-1*t190*t191*t218*t45*t47+
     :         t373+t372)-2.2264054801176772d-1*t106*t120*t220*t315*t43*
     ;         t51-2.2264054801176772d-1*t103*t120*t215*t249*t43*t51-3.4
     <         63297413516387d-1*t100*t106*t118*t194*t226*t43*t51-3.4632
     =         97413516387d-1*t100*t103*t116*t188*t226*t43*t51+7.4213516
     >         00392256d-2*t106*t120*t194*t219*t43*t51+7.421351600392256
     ?         d-2*t103*t120*t188*t216*t43*t51-2.9685406401569026d-1*t11
     @         6*t118*t120*t188*t194*t43*t51+5.448431554270369d-1*t103*t
     1         116*t244*t43*t45*t48+1.0896863108540737d+0*t103*t116*t118
     2         *t45*t48+5.448431554270369d-1*t118*t194*t244*t43*t45*t47+
     3         5.448431554270369d-1*t194*t220*t45*t47-2.7242157771351844
     4         d-1*t103*t219*t45*t47+6.356503479982097d-1*t100*t101*t103
     5         *t244*t43*t47+1.2713006959964196d+0*t100*t101*t103*t118*t
     6         47+t371+t370+t369+t368)+1.8654414521792934d-1*t1*t116*t24
     7         5*t46+9.327207260896466d-2*t1*t123*t216*t46+1.86544145217
     8         92934d-1*t116*t123*t46+6.218138173930978d-2*t245*t42+1.86
     9         54414521792934d-1*t1*t123*t215*t41)*t96+t198*(-6.21813817
     :         3930978d-2*t1*t119*t245*t42-t123*t222)+6.218138173930978d
     ;         -2*t1*t123*t223*t317*t42)*wght+Cmat3(iq,D3_RB_RB_GAB)
            Cmat3(iq,D3_RB_RB_GBB) = t381+Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RA_GAA_GAA) = t389+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = (t198*(-3.109069086965489d-2*t1*t1
     1         21*t238*t42+t395-t123*t231)+t394+t390)*wght+Cmat3(iq,D3_R
     2         A_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = t389+Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = (t96*(3.109069086965489d-2*t1*t42*
     1         (2.9685406401569026d-1*t103*t120*t188*t51*t99-4.043472623
     2         491207d-2*t105*t194*t248*t383*t43*t99+1.4842703200784513d
     3         -1*t106*t120*t194*t237*t43*t51+2.9685406401569026d-1*t106
     4         *t108*t120*t194*t51-5.448431554270369d-1*t103*t237*t45*t4
     5         7-6.065208935236811d-2*t105*t108*t248*t249*t315*t43+t398+
     6         t397)+9.327207260896466d-2*t1*t255*t46*t99+t396)+t198*(-3
     7         .109069086965489d-2*t1*t109*t255*t42-3.109069086965489d-2
     8         *t1*t123*t238*t42-t123*t239)+6.218138173930978d-2*t1*t109
     9         *t254*t317*t42)*wght+Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = (t198*(-3.109069086965489d-2*t1*t1
     1         23*t230*t42+t395-t121*t239)+t394+t390)*wght+Cmat3(iq,D3_R
     2         A_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = t389+Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_RB_GAA_GAA) = t401+Cmat3(iq,D3_RB_GAA_GAA)
            Cmat3(iq,D3_RB_GAA_GAB) = (t198*(-3.109069086965489d-2*t1*t1
     1         21*t245*t42+t404-t123*t242)+t403+t402)*wght+Cmat3(iq,D3_R
     2         B_GAA_GAB)
            Cmat3(iq,D3_RB_GAA_GBB) = t401+Cmat3(iq,D3_RB_GAA_GBB)
            Cmat3(iq,D3_RB_GAB_GAB) = ((3.109069086965489d-2*t1*t42*(1.4
     1         842703200784513d-1*t106*t120*t194*t244*t43*t51+2.96854064
     2         01569026d-1*t106*t118*t120*t194*t51+2.9685406401569026d-1
     3         *t103*t116*t120*t188*t51-5.448431554270369d-1*t103*t244*t
     4         45*t47-4.043472623491207d-2*t105*t116*t194*t248*t383*t43-
     5         6.065208935236811d-2*t105*t118*t248*t249*t315*t43+t398+t3
     6         97)+9.327207260896466d-2*t1*t116*t255*t46+t396)*t96+t198*
     7         (-3.109069086965489d-2*t1*t119*t255*t42-3.109069086965489
     8         d-2*t1*t123*t245*t42-t123*t246)+6.218138173930978d-2*t1*t
     9         119*t254*t317*t42)*wght+Cmat3(iq,D3_RB_GAB_GAB)
            Cmat3(iq,D3_RB_GAB_GBB) = (t198*(-3.109069086965489d-2*t1*t1
     1         23*t241*t42+t404-t121*t246)+t403+t402)*wght+Cmat3(iq,D3_R
     2         B_GAB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = t401+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = t407+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = t408+Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = t407+Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = t409+Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = t408+Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAA_GBB_GBB) = t407+Cmat3(iq,D3_GAA_GBB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = 3.109069086965489d-2*t1*t42*(1.21
     1         30417870473623d-1*t105*t194*t248*t249-1.6522937872993415d
     2         -2*t191*t315*t405*t406*t43)*t96*wght+6.218138173930978d-2
     3         *t1*t123**3*t317*t42*wght-9.327207260896466d-2*t1*t123*t1
     4         98*t255*t42*wght+Cmat3(iq,D3_GAB_GAB_GAB)
            Cmat3(iq,D3_GAB_GAB_GBB) = t409+Cmat3(iq,D3_GAB_GAB_GBB)
            Cmat3(iq,D3_GAB_GBB_GBB) = t408+Cmat3(iq,D3_GAB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = t407+Cmat3(iq,D3_GBB_GBB_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 1.3212998810398843d-2*t3+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t3+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t3+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t2*t22+1.0d+0
            t24 = log(t23)
            t25 = 6.901399211255826d-2*t10+1.0d+0
            t26 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t17*t18-3.10907d-2*t11*t9)-3.37738d-2*t24*t25)+3
     2         .37738d-2*t24*t25)-6.21814d-2*t17*t18
            t27 = rhoa**1.1666666666666667d+0
            t28 = 1/t27**2.0d+0
            t29 = exp(-6.432793688582967d+1*t26)
            t30 = t29-1.0d+0
            t31 = 1/t30
            t32 = 2.1622114952063792d-1*gammaaa*t28*t31+1.0d+0
            t33 = 1/t32
            t34 = 2.1622114952063792d-1*gammaaa*t28*t33+1.0d+0
            t35 = log(t34)
            t36 = 1/rhoa**1.3333333333333333d+0
            t37 = 1/t8
            t38 = 1/t6**2
            t39 = 1/rhoa**1.3333333333333336d+0
            t40 = 1/t2**3
            t41 = 1/rhoa**6.666666666666667d-1
            t42 = -1.3127055298329054d-1*t4*t40*t41-2.0096226153166658d-
     1         3*t39
            t43 = 7.876233178997433d-1*t3*t42-1.3127055298329054d-1*t40*
     1         t41*t5
            t44 = 2.11607075208357d-1*t3*t41*t7-1.269642451250142d+0*t2*
     1         t38*t43
            t45 = 1/t16
            t46 = 1/t14**2
            t47 = -1.3127055298329054d-1*t12*t40*t41-3.169132786263567d-
     1         3*t39
            t48 = 7.876233178997433d-1*t3*t47-1.3127055298329054d-1*t13*
     1         t40*t41
            t49 = 2.11607075208357d-1*t15*t3*t41-1.269642451250142d+0*t2
     1         *t46*t48
            t50 = 1/t23
            t51 = 1/t21**2
            t52 = -1.3127055298329054d-1*t19*t40*t41-1.7344776604086162d
     1         -3*t39
            t53 = 7.876233178997433d-1*t3*t52-1.3127055298329054d-1*t20*
     1         t40*t41
            t54 = 2.11607075208357d-1*t22*t3*t41-1.269642451250142d+0*t2
     1         *t51*t53
            t55 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         3210398931339265d-3*t36*t9+6.21814d-2*t18*t45*t49-3.10907
     2         d-2*t11*t37*t44-2.747773264188438d-3*t17*t36)-3.37738d-2*
     3         t25*t50*t54+7.769549222703733d-4*t24*t36)+3.37738d-2*t25*
     4         t50*t54-7.769549222703733d-4*t24*t36)-6.21814d-2*t18*t45*
     5         t49+2.747773264188438d-3*t17*t36
            t56 = 1/t34
            t57 = rhoa**1.6666666666666674d-1
            t58 = 1/t27**3.0d+0
            t59 = 1/t32**2
            t60 = 1/t30**2
            t61 = 1.3909060459745137d+1*gammaaa*t28*t29*t55*t60-5.045160
     1         155481552d-1*gammaaa*t31*t57*t58
            t62 = -2.1622114952063792d-1*gammaaa*t28*t59*t61-5.045160155
     1         481552d-1*gammaaa*t33*t57*t58
            t63 = 1/t27**4.0d+0
            t64 = 2.1622114952063792d-1*t28*t33-4.675158550002606d-2*gam
     1         maaa*t31*t59*t63
            t65 = 1/rhoa**2.333333333333333d+0
            t66 = 1/t8**2
            t67 = t44**2
            t68 = 1/t6**3
            t69 = t43**2
            t70 = 1/rhoa**2.3333333333333334d+0
            t71 = 1/rhoa**1.6666666666666669d+0
            t72 = 1/t2**5
            t73 = 6.563527649164527d-2*t39*t4*t72+8.751370198886037d-2*t
     1         4*t40*t71+3.0144339229749983d-3*t70
            t74 = 7.876233178997433d-1*t3*t73+6.563527649164527d-2*t39*t
     1         5*t72+8.751370198886037d-2*t40*t5*t71-2.625411059665811d-
     2         1*t40*t41*t42
            t75 = -1.269642451250142d+0*t2*t38*t74-1.4107138347223802d-1
     1         *t3*t7*t71-3.52678458680595d-2*t39*t40*t7+2.5392849025002
     2         84d+0*t2*t68*t69-4.23214150416714d-1*t3*t38*t41*t43
            t76 = 1/t16**2
            t77 = t49**2
            t78 = 1/t14**3
            t79 = t48**2
            t80 = 6.563527649164527d-2*t12*t39*t72+8.751370198886037d-2*
     1         t12*t40*t71+4.753699179395351d-3*t70
            t81 = 7.876233178997433d-1*t3*t80+6.563527649164527d-2*t13*t
     1         39*t72+8.751370198886037d-2*t13*t40*t71-2.625411059665811
     2         d-1*t40*t41*t47
            t82 = -1.269642451250142d+0*t2*t46*t81+2.539284902500284d+0*
     1         t2*t78*t79-1.4107138347223802d-1*t15*t3*t71-4.23214150416
     2         714d-1*t3*t41*t46*t48-3.52678458680595d-2*t15*t39*t40
            t83 = 1/t23**2
            t84 = t54**2
            t85 = 1/t21**3
            t86 = t53**2
            t87 = 6.563527649164527d-2*t19*t39*t72+8.751370198886037d-2*
     1         t19*t40*t71+2.601716490612924d-3*t70
            t88 = 7.876233178997433d-1*t3*t87+6.563527649164527d-2*t20*t
     1         39*t72+8.751370198886037d-2*t20*t40*t71-2.625411059665811
     2         d-1*t40*t41*t52
            t89 = -1.269642451250142d+0*t2*t51*t88+2.539284902500284d+0*
     1         t2*t85*t86-1.4107138347223802d-1*t22*t3*t71-4.23214150416
     2         714d-1*t3*t41*t51*t53-3.52678458680595d-2*t22*t39*t40
            t90 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-1
     1         .7613865241785687d-3*t65*t9+6.21814d-2*t18*t45*t82-6.2181
     2         4d-2*t18*t76*t77-3.10907d-2*t11*t37*t75+3.10907d-2*t11*t6
     3         6*t67+3.663697685584584d-3*t17*t65-5.495546528376876d-3*t
     4         36*t45*t49+2.642079786267853d-3*t36*t37*t44)-3.37738d-2*t
     5         25*t50*t89+3.37738d-2*t25*t83*t84-1.0359398963604977d-3*t
     6         24*t65+1.5539098445407465d-3*t36*t50*t54)+3.37738d-2*t25*
     7         t50*t89-3.37738d-2*t25*t83*t84+1.0359398963604977d-3*t24*
     8         t65-1.5539098445407465d-3*t36*t50*t54)-6.21814d-2*t18*t45
     9         *t82+6.21814d-2*t18*t76*t77-3.663697685584584d-3*t17*t65+
     :         5.495546528376876d-3*t36*t45*t49
            t91 = rhoa**3.333333333333335d-1
            t92 = 1/rhoa**8.333333333333333d-1
            t93 = t55**2
            t94 = exp(-1.2865587377165935d+2*t26)
            t95 = 1/t30**3
            t96 = 1.7894823267913484d+3*gammaaa*t28*t93*t94*t95-8.947411
     1         633956742d+2*gammaaa*t28*t29*t60*t93-8.408600259135923d-2
     2         *gammaaa*t31*t58*t92+1.765806054418543d+0*gammaaa*t31*t63
     3         *t91+1.3909060459745137d+1*gammaaa*t28*t29*t60*t90-6.4908
     4         94881214397d+1*gammaaa*t29*t55*t57*t58*t60
            t97 = 1/t32**3
            t98 = t61**2
            t99 = 4.3244229904127585d-1*gammaaa*t28*t97*t98-2.1622114952
     1         063792d-1*gammaaa*t28*t59*t96-8.408600259135923d-2*gammaa
     2         a*t33*t58*t92+1.765806054418543d+0*gammaaa*t33*t63*t91+1.
     3         0090320310963104d+0*gammaaa*t57*t58*t59*t61
            t100 = 1.5545345434827443d-2*rhoa*t99+3.1090690869654886d-2*
     1         t62
            t101 = 1/t34**2
            t102 = t62**2
            t103 = 1/t27**5.0d+0
            t104 = 1.3909060459745137d+1*t28*t29*t55*t60-5.0451601554815
     1         52d-1*t31*t57*t58
            t105 = 9.350317100005212d-2*gammaaa*t31*t61*t63*t97-2.162211
     1         4952063792d-1*t28*t59*t61+1.0908703283339415d-1*gammaaa*t
     2         103*t31*t57*t59-2.1622114952063792d-1*gammaaa*t104*t28*t5
     3         9-5.045160155481552d-1*t33*t57*t58
            t106 = 1.5545345434827443d-2*t64+1.5545345434827443d-2*rhoa*
     1         t105
            t107 = t64**2
            t108 = 1/t27**6.0d+0
            t109 = 2.0217363117456047d-2*gammaaa*t108*t60*t97-9.35031710
     1         0005212d-2*t31*t59*t63
            t110 = 1/rhoa**3.333333333333333d+0
            t111 = 1/rhoa**3.3333333333333337d+0
            t112 = 1/rhoa**2.666666666666667d+0
            t113 = 1/t2**7
            t114 = 1/rhoa**2.0d+0
            t115 = 1/t16**3
            t116 = t49**3
            t117 = 7.617854707500852d+0*t2*t48*t78*t81-6.34821225625071d
     1         -1*t3*t41*t46*t81-1.269642451250142d+0*t2*t46*(-3.9381165
     2         894987163d-1*t40*t41*t80+7.876233178997433d-1*t3*(-1.3127
     3         055298329054d-1*t12*t70*t72-1.4585616998143394d-1*t112*t1
     4         2*t40-5.469606374303773d-2*t113*t114*t12-1.17081850159181
     5         81d-2*t111)-1.3127055298329054d-1*t13*t70*t72+1.969058294
     6         7493582d-1*t39*t47*t72+2.625411059665811d-1*t40*t47*t71-1
     7         .4585616998143394d-1*t112*t13*t40-5.469606374303773d-2*t1
     8         13*t114*t13)+1.269642451250142d+0*t3*t41*t78*t79+1.763392
     9         293402975d-2*t114*t15*t72+4.2321415041671406d-1*t3*t46*t4
     :         8*t71+7.053569173611901d-2*t15*t40*t70-7.617854707500852d
     ;         +0*t2*t48**3/t14**4+1.0580353760417849d-1*t39*t40*t46*t48
     <         +2.3511897245373004d-1*t112*t15*t3
            t118 = 1/t23**3
            t119 = t54**3
            t120 = 7.617854707500852d+0*t2*t53*t85*t88-6.34821225625071d
     1         -1*t3*t41*t51*t88-1.269642451250142d+0*t2*t51*(-3.9381165
     2         894987163d-1*t40*t41*t87+7.876233178997433d-1*t3*(-1.3127
     3         055298329054d-1*t19*t70*t72-1.4585616998143394d-1*t112*t1
     4         9*t40-5.469606374303773d-2*t113*t114*t19-6.40793135650961
     5         1d-3*t111)-1.3127055298329054d-1*t20*t70*t72+1.9690582947
     6         493582d-1*t39*t52*t72+2.625411059665811d-1*t40*t52*t71-1.
     7         4585616998143394d-1*t112*t20*t40-5.469606374303773d-2*t11
     8         3*t114*t20)+1.269642451250142d+0*t3*t41*t85*t86+1.7633922
     9         93402975d-2*t114*t22*t72+4.2321415041671406d-1*t3*t51*t53
     :         *t71+7.053569173611901d-2*t22*t40*t70-7.617854707500852d+
     ;         0*t2*t53**3/t21**4+1.0580353760417849d-1*t39*t40*t51*t53+
     <         2.3511897245373004d-1*t112*t22*t3
            t121 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(4
     1         .1099018897499934d-3*t110*t9-1.865442d-1*t18*t49*t76*t82-
     2         8.243319792565315d-3*t36*t45*t82-6.21814d-2*t11*t44**3/t8
     3         **3+8.243319792565315d-3*t36*t76*t77+9.327209999999999d-2
     4         *t11*t44*t66*t75+3.96311967940178d-3*t36*t37*t75-3.10907d
     5         -2*t11*t37*(7.617854707500852d+0*t2*t43*t68*t74-6.3482122
     6         5625071d-1*t3*t38*t41*t74-1.269642451250142d+0*t2*t38*(-3
     7         .9381165894987163d-1*t40*t41*t73+7.876233178997433d-1*t3*
     8         (-1.3127055298329054d-1*t4*t70*t72-1.4585616998143394d-1*
     9         t112*t4*t40-5.469606374303773d-2*t113*t114*t4-7.424439106
     :         586571d-3*t111)-1.3127055298329054d-1*t5*t70*t72+1.969058
     ;         2947493582d-1*t39*t42*t72+2.625411059665811d-1*t40*t42*t7
     <         1-1.4585616998143394d-1*t112*t40*t5-5.469606374303773d-2*
     =         t113*t114*t5)+1.763392293402975d-2*t114*t7*t72+4.23214150
     >         41671406d-1*t3*t38*t43*t71+7.053569173611901d-2*t40*t7*t7
     ?         0+2.3511897245373004d-1*t112*t3*t7+1.269642451250142d+0*t
     @         3*t41*t68*t69-7.617854707500852d+0*t2*t43**3/t6**4+1.0580
     1         353760417849d-1*t38*t39*t40*t43)-3.96311967940178d-3*t36*
     2         t66*t67+1.0991093056753751d-2*t45*t49*t65-5.2841595725357
     3         06d-3*t37*t44*t65+6.21814d-2*t117*t18*t45+1.243628d-1*t11
     4         5*t116*t18-8.548627933030694d-3*t110*t17)+1.013214d-1*t25
     5         *t54*t83*t89+2.33086476681112d-3*t36*t50*t89-2.3308647668
     6         1112d-3*t36*t83*t84-3.107819689081493d-3*t50*t54*t65-3.37
     7         738d-2*t120*t25*t50-6.75476d-2*t118*t119*t25+2.4171930915
     8         078277d-3*t110*t24)-1.013214d-1*t25*t54*t83*t89-2.3308647
     9         6681112d-3*t36*t50*t89+2.33086476681112d-3*t36*t83*t84+3.
     :         107819689081493d-3*t50*t54*t65+3.37738d-2*t120*t25*t50+6.
     ;         75476d-2*t118*t119*t25-2.4171930915078277d-3*t110*t24)+1.
     <         865442d-1*t18*t49*t76*t82+8.243319792565315d-3*t36*t45*t8
     =         2-8.243319792565315d-3*t36*t76*t77-1.0991093056753751d-2*
     >         t45*t49*t65-6.21814d-2*t117*t18*t45-1.243628d-1*t115*t116
     ?         *t18+8.548627933030694d-3*t110*t17
            t122 = rhoa**5.000000000000002d-1
            t123 = 1/rhoa**6.666666666666665d-1
            t124 = 1/rhoa**1.8333333333333332d+0
            t125 = t55**3
            t126 = 1/t32**4
            t127 = 1/t34**3
            fnc(iq) = (1.5545345434827443d-2*rhoa*t35+1.0d+0*rhoa*t26)*w
     1         ght+fnc(iq)
            Amat(iq,D1_RA) = (1.5545345434827443d-2*rhoa*t56*t62+1.0d+0*
     1         rhoa*t55+1.5545345434827443d-2*t35+1.0d+0*t26)*wght+Amat(
     2         iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.5545345434827443d-2*rhoa*t56*t64*wght+Cm
     1         at(iq,D1_GAA)
            Amat2(iq,D2_RA_RA) = (1.0d+0*rhoa*t90+t100*t56+2.0d+0*t55-1.
     1         5545345434827443d-2*rhoa*t101*t102)*wght+Amat2(iq,D2_RA_R
     2         A)
            Cmat2(iq,D2_RA_GAA) = (t106*t56-1.5545345434827443d-2*rhoa*t
     1         101*t62*t64)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = 1.5545345434827443d-2*rhoa*t109*t56*w
     1         ght-1.5545345434827443d-2*rhoa*t101*t107*wght+Cmat2(iq,D2
     2         _GAA_GAA)
            Amat3(iq,D3_RA_RA_RA) = (t101*(-3.1090690869654886d-2*rhoa*t
     1         62*t99-t100*t62-1.5545345434827443d-2*t102)+t56*(4.663603
     2         6304482326d-2*t99+1.5545345434827443d-2*rhoa*(-3.02709609
     3         3288931d+0*gammaaa*t57*t58*t97*t98+1.2973268971238278d+0*
     4         gammaaa*t28*t61*t96*t97+1.5135480466444656d+0*gammaaa*t57
     5         *t58*t59*t96-2.1622114952063792d-1*gammaaa*t28*t59*(-1.25
     6         2637628753944d+4*gammaaa*t57*t58*t93*t94*t95+5.3684469803
     7         74045d+3*gammaaa*t28*t55*t90*t94*t95-3.453411185284245d+5
     8         *gammaaa*t125*t28*t94*t95+6.263188143769719d+3*gammaaa*t2
     9         9*t57*t58*t60*t93-1.6227237203036002d+1*gammaaa*t29*t55*t
     :         58*t60*t92+3.4077198126375585d+2*gammaaa*t29*t55*t60*t63*
     ;         t91-9.736342321821596d+1*gammaaa*t29*t57*t58*t60*t90-2.68
     <         42234901870227d+3*gammaaa*t28*t29*t55*t60*t90+8.829030272
     =         092719d-1*gammaaa*t123*t31*t63+5.755685308807075d+4*gamma
     >         aa*t125*t28*t29*t60+1.3909060459745137d+1*gammaaa*t121*t2
     ?         8*t29*t60+7.007166882613269d-2*gammaaa*t124*t31*t58-8.240
     @         428253953201d+0*gammaaa*t103*t122*t31+3.453411185284245d+
     1         5*gammaaa*t125*exp(-1.92983810657489d+2*t26)*t28/t30**4)+
     2         2.522580077740777d-1*gammaaa*t58*t59*t61*t92-5.2974181632
     3         55629d+0*gammaaa*t59*t61*t63*t91+8.829030272092719d-1*gam
     4         maaa*t123*t33*t63-1.2973268971238278d+0*gammaaa*t126*t28*
     5         t61**3+7.007166882613269d-2*gammaaa*t124*t33*t58-8.240428
     6         253953201d+0*gammaaa*t103*t122*t33))+3.0d+0*t90+3.1090690
     7         869654886d-2*rhoa*t127*t62**3+1.0d+0*rhoa*t121)*wght+Amat
     8         3(iq,D3_RA_RA_RA)
            Cmat3(iq,D3_RA_RA_GAA) = (t56*(1.5545345434827443d-2*rhoa*(4
     1         .3244229904127585d-1*t28*t97*t98-2.805095130001564d-1*gam
     2         maaa*t126*t31*t63*t98+9.350317100005212d-2*gammaaa*t31*t6
     3         3*t96*t97-4.363481313335766d-1*gammaaa*t103*t31*t57*t61*t
     4         97+8.648845980825517d-1*gammaaa*t104*t28*t61*t97-2.162211
     5         4952063792d-1*t28*t59*t96-2.1622114952063792d-1*gammaaa*t
     6         28*t59*(1.7894823267913484d+3*t28*t93*t94*t95-8.947411633
     7         956742d+2*t28*t29*t60*t93-8.408600259135923d-2*t31*t58*t9
     8         2+1.765806054418543d+0*t31*t63*t91+1.3909060459745137d+1*
     9         t28*t29*t60*t90-6.490894881214397d+1*t29*t55*t57*t58*t60)
     :         +1.8181172138899032d-2*gammaaa*t103*t31*t59*t92-8.4086002
     ;         59135923d-2*t33*t58*t92+1.765806054418543d+0*t33*t63*t91-
     <         3.818046149168795d-1*gammaaa*t108*t31*t59*t91+1.009032031
     =         0963104d+0*t57*t58*t59*t61+1.0090320310963104d+0*gammaaa*
     >         t104*t57*t58*t59)+3.1090690869654886d-2*t105)+t101*(-t100
     ?         *t64-3.1090690869654886d-2*rhoa*t105*t62)+3.1090690869654
     @         886d-2*rhoa*t102*t127*t64)*wght+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_GAA_GAA) = (t56*(1.5545345434827443d-2*rhoa*(
     1         1.8700634200010424d-1*t31*t61*t63*t97+1.8700634200010424d
     2         -1*gammaaa*t104*t31*t63*t97-4.7173847274064107d-2*gammaaa
     3         *t57*t60*t97/t27**7.0d+0-6.065208935236814d-2*gammaaa*t10
     4         8*t126*t60*t61+2.181740656667883d-1*t103*t31*t57*t59-4.32
     5         44229904127585d-1*t104*t28*t59)+1.5545345434827443d-2*t10
     6         9)+t101*(-t106*t64-1.5545345434827443d-2*rhoa*t105*t64-1.
     7         5545345434827443d-2*rhoa*t109*t62)+3.1090690869654886d-2*
     8         rhoa*t107*t127*t62)*wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAA) = 1.5545345434827443d-2*rhoa*t56*(6
     1         .065208935236814d-2*t108*t60*t97-1.3114264480597485d-2*ga
     2         mmaaa*t126*t95/t27**8.0d+0)*wght+3.1090690869654886d-2*rh
     3         oa*t127*t64**3*wght-4.6636036304482326d-2*rhoa*t101*t109*
     4         t64*wght+Cmat3(iq,D3_GAA_GAA_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 1.3212998810398843d-2*t3+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t3+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t3+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t2*t22+1.0d+0
            t24 = log(t23)
            t25 = 6.901399211255826d-2*t10+1.0d+0
            t26 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t17*t18-3.10907d-2*t11*t9)-3.37738d-2*t24*t25)+3
     2         .37738d-2*t24*t25)-6.21814d-2*t17*t18
            t27 = rhob**1.1666666666666667d+0
            t28 = 1/t27**2.0d+0
            t29 = exp(-6.432793688582967d+1*t26)
            t30 = t29-1.0d+0
            t31 = 1/t30
            t32 = 2.1622114952063792d-1*gammabb*t28*t31+1.0d+0
            t33 = 1/t32
            t34 = 2.1622114952063792d-1*gammabb*t28*t33+1.0d+0
            t35 = log(t34)
            t36 = 1/rhob**1.3333333333333333d+0
            t37 = 1/t8
            t38 = 1/t6**2
            t39 = 1/rhob**1.3333333333333336d+0
            t40 = 1/t2**3
            t41 = 1/rhob**6.666666666666667d-1
            t42 = -1.3127055298329054d-1*t4*t40*t41-2.0096226153166658d-
     1         3*t39
            t43 = 7.876233178997433d-1*t3*t42-1.3127055298329054d-1*t40*
     1         t41*t5
            t44 = 2.11607075208357d-1*t3*t41*t7-1.269642451250142d+0*t2*
     1         t38*t43
            t45 = 1/t16
            t46 = 1/t14**2
            t47 = -1.3127055298329054d-1*t12*t40*t41-3.169132786263567d-
     1         3*t39
            t48 = 7.876233178997433d-1*t3*t47-1.3127055298329054d-1*t13*
     1         t40*t41
            t49 = 2.11607075208357d-1*t15*t3*t41-1.269642451250142d+0*t2
     1         *t46*t48
            t50 = 1/t23
            t51 = 1/t21**2
            t52 = -1.3127055298329054d-1*t19*t40*t41-1.7344776604086162d
     1         -3*t39
            t53 = 7.876233178997433d-1*t3*t52-1.3127055298329054d-1*t20*
     1         t40*t41
            t54 = 2.11607075208357d-1*t22*t3*t41-1.269642451250142d+0*t2
     1         *t51*t53
            t55 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         3210398931339265d-3*t36*t9+6.21814d-2*t18*t45*t49-3.10907
     2         d-2*t11*t37*t44-2.747773264188438d-3*t17*t36)-3.37738d-2*
     3         t25*t50*t54+7.769549222703733d-4*t24*t36)+3.37738d-2*t25*
     4         t50*t54-7.769549222703733d-4*t24*t36)-6.21814d-2*t18*t45*
     5         t49+2.747773264188438d-3*t17*t36
            t56 = 1/t34
            t57 = rhob**1.6666666666666674d-1
            t58 = 1/t27**3.0d+0
            t59 = 1/t32**2
            t60 = 1/t30**2
            t61 = 1.3909060459745137d+1*gammabb*t28*t29*t55*t60-5.045160
     1         155481552d-1*gammabb*t31*t57*t58
            t62 = -2.1622114952063792d-1*gammabb*t28*t59*t61-5.045160155
     1         481552d-1*gammabb*t33*t57*t58
            t63 = 1/t27**4.0d+0
            t64 = 2.1622114952063792d-1*t28*t33-4.675158550002606d-2*gam
     1         mabb*t31*t59*t63
            t65 = 1/rhob**2.333333333333333d+0
            t66 = 1/t8**2
            t67 = t44**2
            t68 = 1/t6**3
            t69 = t43**2
            t70 = 1/rhob**2.3333333333333334d+0
            t71 = 1/rhob**1.6666666666666669d+0
            t72 = 1/t2**5
            t73 = 6.563527649164527d-2*t39*t4*t72+8.751370198886037d-2*t
     1         4*t40*t71+3.0144339229749983d-3*t70
            t74 = 7.876233178997433d-1*t3*t73+6.563527649164527d-2*t39*t
     1         5*t72+8.751370198886037d-2*t40*t5*t71-2.625411059665811d-
     2         1*t40*t41*t42
            t75 = -1.269642451250142d+0*t2*t38*t74-1.4107138347223802d-1
     1         *t3*t7*t71-3.52678458680595d-2*t39*t40*t7+2.5392849025002
     2         84d+0*t2*t68*t69-4.23214150416714d-1*t3*t38*t41*t43
            t76 = 1/t16**2
            t77 = t49**2
            t78 = 1/t14**3
            t79 = t48**2
            t80 = 6.563527649164527d-2*t12*t39*t72+8.751370198886037d-2*
     1         t12*t40*t71+4.753699179395351d-3*t70
            t81 = 7.876233178997433d-1*t3*t80+6.563527649164527d-2*t13*t
     1         39*t72+8.751370198886037d-2*t13*t40*t71-2.625411059665811
     2         d-1*t40*t41*t47
            t82 = -1.269642451250142d+0*t2*t46*t81+2.539284902500284d+0*
     1         t2*t78*t79-1.4107138347223802d-1*t15*t3*t71-4.23214150416
     2         714d-1*t3*t41*t46*t48-3.52678458680595d-2*t15*t39*t40
            t83 = 1/t23**2
            t84 = t54**2
            t85 = 1/t21**3
            t86 = t53**2
            t87 = 6.563527649164527d-2*t19*t39*t72+8.751370198886037d-2*
     1         t19*t40*t71+2.601716490612924d-3*t70
            t88 = 7.876233178997433d-1*t3*t87+6.563527649164527d-2*t20*t
     1         39*t72+8.751370198886037d-2*t20*t40*t71-2.625411059665811
     2         d-1*t40*t41*t52
            t89 = -1.269642451250142d+0*t2*t51*t88+2.539284902500284d+0*
     1         t2*t85*t86-1.4107138347223802d-1*t22*t3*t71-4.23214150416
     2         714d-1*t3*t41*t51*t53-3.52678458680595d-2*t22*t39*t40
            t90 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-1
     1         .7613865241785687d-3*t65*t9+6.21814d-2*t18*t45*t82-6.2181
     2         4d-2*t18*t76*t77-3.10907d-2*t11*t37*t75+3.10907d-2*t11*t6
     3         6*t67+3.663697685584584d-3*t17*t65-5.495546528376876d-3*t
     4         36*t45*t49+2.642079786267853d-3*t36*t37*t44)-3.37738d-2*t
     5         25*t50*t89+3.37738d-2*t25*t83*t84-1.0359398963604977d-3*t
     6         24*t65+1.5539098445407465d-3*t36*t50*t54)+3.37738d-2*t25*
     7         t50*t89-3.37738d-2*t25*t83*t84+1.0359398963604977d-3*t24*
     8         t65-1.5539098445407465d-3*t36*t50*t54)-6.21814d-2*t18*t45
     9         *t82+6.21814d-2*t18*t76*t77-3.663697685584584d-3*t17*t65+
     :         5.495546528376876d-3*t36*t45*t49
            t91 = rhob**3.333333333333335d-1
            t92 = 1/rhob**8.333333333333333d-1
            t93 = t55**2
            t94 = exp(-1.2865587377165935d+2*t26)
            t95 = 1/t30**3
            t96 = 1.7894823267913484d+3*gammabb*t28*t93*t94*t95-8.947411
     1         633956742d+2*gammabb*t28*t29*t60*t93-8.408600259135923d-2
     2         *gammabb*t31*t58*t92+1.765806054418543d+0*gammabb*t31*t63
     3         *t91+1.3909060459745137d+1*gammabb*t28*t29*t60*t90-6.4908
     4         94881214397d+1*gammabb*t29*t55*t57*t58*t60
            t97 = 1/t32**3
            t98 = t61**2
            t99 = 4.3244229904127585d-1*gammabb*t28*t97*t98-2.1622114952
     1         063792d-1*gammabb*t28*t59*t96-8.408600259135923d-2*gammab
     2         b*t33*t58*t92+1.765806054418543d+0*gammabb*t33*t63*t91+1.
     3         0090320310963104d+0*gammabb*t57*t58*t59*t61
            t100 = 1.5545345434827443d-2*rhob*t99+3.1090690869654886d-2*
     1         t62
            t101 = 1/t34**2
            t102 = t62**2
            t103 = 1/t27**5.0d+0
            t104 = 1.3909060459745137d+1*t28*t29*t55*t60-5.0451601554815
     1         52d-1*t31*t57*t58
            t105 = 9.350317100005212d-2*gammabb*t31*t61*t63*t97-2.162211
     1         4952063792d-1*t28*t59*t61+1.0908703283339415d-1*gammabb*t
     2         103*t31*t57*t59-2.1622114952063792d-1*gammabb*t104*t28*t5
     3         9-5.045160155481552d-1*t33*t57*t58
            t106 = 1.5545345434827443d-2*t64+1.5545345434827443d-2*rhob*
     1         t105
            t107 = t64**2
            t108 = 1/t27**6.0d+0
            t109 = 2.0217363117456047d-2*gammabb*t108*t60*t97-9.35031710
     1         0005212d-2*t31*t59*t63
            t110 = 1/rhob**3.333333333333333d+0
            t111 = 1/rhob**3.3333333333333337d+0
            t112 = 1/rhob**2.666666666666667d+0
            t113 = 1/t2**7
            t114 = 1/rhob**2.0d+0
            t115 = 1/t16**3
            t116 = t49**3
            t117 = 7.617854707500852d+0*t2*t48*t78*t81-6.34821225625071d
     1         -1*t3*t41*t46*t81-1.269642451250142d+0*t2*t46*(-3.9381165
     2         894987163d-1*t40*t41*t80+7.876233178997433d-1*t3*(-1.3127
     3         055298329054d-1*t12*t70*t72-1.4585616998143394d-1*t112*t1
     4         2*t40-5.469606374303773d-2*t113*t114*t12-1.17081850159181
     5         81d-2*t111)-1.3127055298329054d-1*t13*t70*t72+1.969058294
     6         7493582d-1*t39*t47*t72+2.625411059665811d-1*t40*t47*t71-1
     7         .4585616998143394d-1*t112*t13*t40-5.469606374303773d-2*t1
     8         13*t114*t13)+1.269642451250142d+0*t3*t41*t78*t79+1.763392
     9         293402975d-2*t114*t15*t72+4.2321415041671406d-1*t3*t46*t4
     :         8*t71+7.053569173611901d-2*t15*t40*t70-7.617854707500852d
     ;         +0*t2*t48**3/t14**4+1.0580353760417849d-1*t39*t40*t46*t48
     <         +2.3511897245373004d-1*t112*t15*t3
            t118 = 1/t23**3
            t119 = t54**3
            t120 = 7.617854707500852d+0*t2*t53*t85*t88-6.34821225625071d
     1         -1*t3*t41*t51*t88-1.269642451250142d+0*t2*t51*(-3.9381165
     2         894987163d-1*t40*t41*t87+7.876233178997433d-1*t3*(-1.3127
     3         055298329054d-1*t19*t70*t72-1.4585616998143394d-1*t112*t1
     4         9*t40-5.469606374303773d-2*t113*t114*t19-6.40793135650961
     5         1d-3*t111)-1.3127055298329054d-1*t20*t70*t72+1.9690582947
     6         493582d-1*t39*t52*t72+2.625411059665811d-1*t40*t52*t71-1.
     7         4585616998143394d-1*t112*t20*t40-5.469606374303773d-2*t11
     8         3*t114*t20)+1.269642451250142d+0*t3*t41*t85*t86+1.7633922
     9         93402975d-2*t114*t22*t72+4.2321415041671406d-1*t3*t51*t53
     :         *t71+7.053569173611901d-2*t22*t40*t70-7.617854707500852d+
     ;         0*t2*t53**3/t21**4+1.0580353760417849d-1*t39*t40*t51*t53+
     <         2.3511897245373004d-1*t112*t22*t3
            t121 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(4
     1         .1099018897499934d-3*t110*t9-1.865442d-1*t18*t49*t76*t82-
     2         8.243319792565315d-3*t36*t45*t82-6.21814d-2*t11*t44**3/t8
     3         **3+8.243319792565315d-3*t36*t76*t77+9.327209999999999d-2
     4         *t11*t44*t66*t75+3.96311967940178d-3*t36*t37*t75-3.10907d
     5         -2*t11*t37*(7.617854707500852d+0*t2*t43*t68*t74-6.3482122
     6         5625071d-1*t3*t38*t41*t74-1.269642451250142d+0*t2*t38*(-3
     7         .9381165894987163d-1*t40*t41*t73+7.876233178997433d-1*t3*
     8         (-1.3127055298329054d-1*t4*t70*t72-1.4585616998143394d-1*
     9         t112*t4*t40-5.469606374303773d-2*t113*t114*t4-7.424439106
     :         586571d-3*t111)-1.3127055298329054d-1*t5*t70*t72+1.969058
     ;         2947493582d-1*t39*t42*t72+2.625411059665811d-1*t40*t42*t7
     <         1-1.4585616998143394d-1*t112*t40*t5-5.469606374303773d-2*
     =         t113*t114*t5)+1.763392293402975d-2*t114*t7*t72+4.23214150
     >         41671406d-1*t3*t38*t43*t71+7.053569173611901d-2*t40*t7*t7
     ?         0+2.3511897245373004d-1*t112*t3*t7+1.269642451250142d+0*t
     @         3*t41*t68*t69-7.617854707500852d+0*t2*t43**3/t6**4+1.0580
     1         353760417849d-1*t38*t39*t40*t43)-3.96311967940178d-3*t36*
     2         t66*t67+1.0991093056753751d-2*t45*t49*t65-5.2841595725357
     3         06d-3*t37*t44*t65+6.21814d-2*t117*t18*t45+1.243628d-1*t11
     4         5*t116*t18-8.548627933030694d-3*t110*t17)+1.013214d-1*t25
     5         *t54*t83*t89+2.33086476681112d-3*t36*t50*t89-2.3308647668
     6         1112d-3*t36*t83*t84-3.107819689081493d-3*t50*t54*t65-3.37
     7         738d-2*t120*t25*t50-6.75476d-2*t118*t119*t25+2.4171930915
     8         078277d-3*t110*t24)-1.013214d-1*t25*t54*t83*t89-2.3308647
     9         6681112d-3*t36*t50*t89+2.33086476681112d-3*t36*t83*t84+3.
     :         107819689081493d-3*t50*t54*t65+3.37738d-2*t120*t25*t50+6.
     ;         75476d-2*t118*t119*t25-2.4171930915078277d-3*t110*t24)+1.
     <         865442d-1*t18*t49*t76*t82+8.243319792565315d-3*t36*t45*t8
     =         2-8.243319792565315d-3*t36*t76*t77-1.0991093056753751d-2*
     >         t45*t49*t65-6.21814d-2*t117*t18*t45-1.243628d-1*t115*t116
     ?         *t18+8.548627933030694d-3*t110*t17
            t122 = rhob**5.000000000000002d-1
            t123 = 1/rhob**6.666666666666665d-1
            t124 = 1/rhob**1.8333333333333332d+0
            t125 = t55**3
            t126 = 1/t32**4
            t127 = 1/t34**3
            fnc(iq) = (1.5545345434827443d-2*rhob*t35+1.0d+0*rhob*t26)*w
     1         ght+fnc(iq)
            Amat(iq,D1_RB) = (1.5545345434827443d-2*rhob*t56*t62+1.0d+0*
     1         rhob*t55+1.5545345434827443d-2*t35+1.0d+0*t26)*wght+Amat(
     2         iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.5545345434827443d-2*rhob*t56*t64*wght+Cm
     1         at(iq,D1_GBB)
            Amat2(iq,D2_RB_RB) = (1.0d+0*rhob*t90+t100*t56+2.0d+0*t55-1.
     1         5545345434827443d-2*rhob*t101*t102)*wght+Amat2(iq,D2_RB_R
     2         B)
            Cmat2(iq,D2_RB_GBB) = (t106*t56-1.5545345434827443d-2*rhob*t
     1         101*t62*t64)*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.5545345434827443d-2*rhob*t109*t56*w
     1         ght-1.5545345434827443d-2*rhob*t101*t107*wght+Cmat2(iq,D2
     2         _GBB_GBB)
            Amat3(iq,D3_RB_RB_RB) = (t101*(-3.1090690869654886d-2*rhob*t
     1         62*t99-t100*t62-1.5545345434827443d-2*t102)+t56*(4.663603
     2         6304482326d-2*t99+1.5545345434827443d-2*rhob*(-3.02709609
     3         3288931d+0*gammabb*t57*t58*t97*t98+1.2973268971238278d+0*
     4         gammabb*t28*t61*t96*t97+1.5135480466444656d+0*gammabb*t57
     5         *t58*t59*t96-2.1622114952063792d-1*gammabb*t28*t59*(-1.25
     6         2637628753944d+4*gammabb*t57*t58*t93*t94*t95+5.3684469803
     7         74045d+3*gammabb*t28*t55*t90*t94*t95-3.453411185284245d+5
     8         *gammabb*t125*t28*t94*t95+6.263188143769719d+3*gammabb*t2
     9         9*t57*t58*t60*t93-1.6227237203036002d+1*gammabb*t29*t55*t
     :         58*t60*t92+3.4077198126375585d+2*gammabb*t29*t55*t60*t63*
     ;         t91-9.736342321821596d+1*gammabb*t29*t57*t58*t60*t90-2.68
     <         42234901870227d+3*gammabb*t28*t29*t55*t60*t90+8.829030272
     =         092719d-1*gammabb*t123*t31*t63+5.755685308807075d+4*gamma
     >         bb*t125*t28*t29*t60+1.3909060459745137d+1*gammabb*t121*t2
     ?         8*t29*t60+7.007166882613269d-2*gammabb*t124*t31*t58-8.240
     @         428253953201d+0*gammabb*t103*t122*t31+3.453411185284245d+
     1         5*gammabb*t125*exp(-1.92983810657489d+2*t26)*t28/t30**4)+
     2         2.522580077740777d-1*gammabb*t58*t59*t61*t92-5.2974181632
     3         55629d+0*gammabb*t59*t61*t63*t91+8.829030272092719d-1*gam
     4         mabb*t123*t33*t63-1.2973268971238278d+0*gammabb*t126*t28*
     5         t61**3+7.007166882613269d-2*gammabb*t124*t33*t58-8.240428
     6         253953201d+0*gammabb*t103*t122*t33))+3.0d+0*t90+3.1090690
     7         869654886d-2*rhob*t127*t62**3+1.0d+0*rhob*t121)*wght+Amat
     8         3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RB_RB_GBB) = (t56*(1.5545345434827443d-2*rhob*(4
     1         .3244229904127585d-1*t28*t97*t98-2.805095130001564d-1*gam
     2         mabb*t126*t31*t63*t98+9.350317100005212d-2*gammabb*t31*t6
     3         3*t96*t97-4.363481313335766d-1*gammabb*t103*t31*t57*t61*t
     4         97+8.648845980825517d-1*gammabb*t104*t28*t61*t97-2.162211
     5         4952063792d-1*t28*t59*t96-2.1622114952063792d-1*gammabb*t
     6         28*t59*(1.7894823267913484d+3*t28*t93*t94*t95-8.947411633
     7         956742d+2*t28*t29*t60*t93-8.408600259135923d-2*t31*t58*t9
     8         2+1.765806054418543d+0*t31*t63*t91+1.3909060459745137d+1*
     9         t28*t29*t60*t90-6.490894881214397d+1*t29*t55*t57*t58*t60)
     :         +1.8181172138899032d-2*gammabb*t103*t31*t59*t92-8.4086002
     ;         59135923d-2*t33*t58*t92+1.765806054418543d+0*t33*t63*t91-
     <         3.818046149168795d-1*gammabb*t108*t31*t59*t91+1.009032031
     =         0963104d+0*t57*t58*t59*t61+1.0090320310963104d+0*gammabb*
     >         t104*t57*t58*t59)+3.1090690869654886d-2*t105)+t101*(-t100
     ?         *t64-3.1090690869654886d-2*rhob*t105*t62)+3.1090690869654
     @         886d-2*rhob*t102*t127*t64)*wght+Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = (t56*(1.5545345434827443d-2*rhob*(
     1         1.8700634200010424d-1*t31*t61*t63*t97+1.8700634200010424d
     2         -1*gammabb*t104*t31*t63*t97-4.7173847274064107d-2*gammabb
     3         *t57*t60*t97/t27**7.0d+0-6.065208935236814d-2*gammabb*t10
     4         8*t126*t60*t61+2.181740656667883d-1*t103*t31*t57*t59-4.32
     5         44229904127585d-1*t104*t28*t59)+1.5545345434827443d-2*t10
     6         9)+t101*(-t106*t64-1.5545345434827443d-2*rhob*t105*t64-1.
     7         5545345434827443d-2*rhob*t109*t62)+3.1090690869654886d-2*
     8         rhob*t107*t127*t62)*wght+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = 1.5545345434827443d-2*rhob*t56*(6
     1         .065208935236814d-2*t108*t60*t97-1.3114264480597485d-2*ga
     2         mmabb*t126*t95/t27**8.0d+0)*wght+3.1090690869654886d-2*rh
     3         ob*t127*t64**3*wght-4.6636036304482326d-2*rhob*t101*t109*
     4         t64*wght+Cmat3(iq,D3_GBB_GBB_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
