/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_RegisteredSoftwareInventoryProfileAccess.h"

const string instanceID="OpenDRIM:SoftwareInventory:1.0.1";

int SoftwareInventory_OpenDRIM_RegisteredSoftwareInventoryProfile_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_RegisteredSoftwareInventoryProfile_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_RegisteredSoftwareInventoryProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RegisteredSoftwareInventoryProfile>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_RegisteredSoftwareInventoryProfile instance;
	instance.setInstanceID(instanceID);
	
	if(discriminant=="ei")
		CF_assert(SoftwareInventory_OpenDRIM_RegisteredSoftwareInventoryProfile_populate(instance, errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_RegisteredSoftwareInventoryProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RegisteredSoftwareInventoryProfile& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.InstanceID!=instanceID)
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}

	CF_assert(SoftwareInventory_OpenDRIM_RegisteredSoftwareInventoryProfile_populate(instance, errorMessage));
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_RegisteredSoftwareInventoryProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSoftwareInventoryProfile& newInstance, const OpenDRIM_RegisteredSoftwareInventoryProfile& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareInventory_OpenDRIM_RegisteredSoftwareInventoryProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSoftwareInventoryProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareInventory_OpenDRIM_RegisteredSoftwareInventoryProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSoftwareInventoryProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareInventory_OpenDRIM_RegisteredSoftwareInventoryProfile_populate(OpenDRIM_RegisteredSoftwareInventoryProfile& instance, string& errorMessage) {
	_E_;
	vector<unsigned short> AdvertiseTypes;

	instance.setRegisteredName("Software Inventory");
	instance.setRegisteredVersion("1.0.1");
	instance.setRegisteredOrganization(2);	// DMTF

	AdvertiseTypes.push_back(2);			// Not Advertised
	instance.setAdvertiseTypes(AdvertiseTypes);
	_L_;
	return OK;
}

