##############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Revision 1.0
# Date: 2009/01/30
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

import unittest
from report import mantisreporter


class MantisReporterTestCase(unittest.TestCase):

    ## Initial Set UP
    mantis_rep_obj = mantisreporter.MantisReporter()

    def setUp(self):
        setattr(self.mantis_rep_obj, 'host', '172.17.1.109')
        setattr(self.mantis_rep_obj, 'db_name', 'mantis')
        setattr(self.mantis_rep_obj, 'mysql_passwd', 'test')
        setattr(self.mantis_rep_obj, 'project_name', 'unit_test')
        setattr(self.mantis_rep_obj, 'mantis_user_name', 'unit_test')
        setattr(self.mantis_rep_obj, 'mysql_user_name', 'test')

        setattr(self.mantis_rep_obj, 'summary', 'Unit Test Summay')
        setattr(self.mantis_rep_obj, 'description', 'Unit Test Description')
        setattr(self.mantis_rep_obj, 'aditional_info', 'Unit Test Additional Info')


    def test_closeDbConn(self):
        print "\nTesting Mantis Reporter Test Suite ..."
        req_out_put = None

        self.mantis_rep_obj._openDbConn()
        out_put = self.mantis_rep_obj._closeDbConn()
        self.assertEquals(out_put, req_out_put)


    def test_openDbConn_succ(self):
        req_out_put = None

        out_put = self.mantis_rep_obj._openDbConn()
        self.mantis_rep_obj._closeDbConn()
        self.assertEquals(out_put, req_out_put)


    def test_openDbConn_fail(self):
        req_out_put = 'Exception'
        setattr(self.mantis_rep_obj, 'mysql_user_name', '')
        setattr(self.mantis_rep_obj, 'mysql_passwd', '')
        setattr(self.mantis_rep_obj, 'db_name', '')

        try:
            out_put = self.mantis_rep_obj._openDbConn()
        except Exception, msg:
            out_put = "Exception"
            self.assertEquals(out_put, req_out_put)


    def test_exec_query1(self):
        req_out_put = ()

        out_put = self.mantis_rep_obj._openDbConn()
        steps_to_reproduce = ''
        description = 'Unit Test Desc'
        aditional_info = 'Unit Test Add-Info'

        query_string = "insert into mantis_bug_text_table (description, steps_to_reproduce, additional_information) values ('%s', '%s', '%s')" % (description.replace("'", "&qt"), steps_to_reproduce, aditional_info.replace("'", "&qt").replace('"', '&qt').replace("NULL", ""))

        out_put = self.mantis_rep_obj.exec_query(query_string)
        self.mantis_rep_obj._closeDbConn()
        self.assertNotEquals(out_put, req_out_put)


    def test_exec_query2(self):
        req_out_put = ()

        out_put = self.mantis_rep_obj._openDbConn()
        steps_to_reproduce = ''
        description = 'Unit Test Desc'
        aditional_info = 'Unit Test Add-Info'

        mantis_user_name = 'unit_test'
        only_execute = False
        query_string = "select id from mantis_user_table where username='%s'" % mantis_user_name
        out_put = self.mantis_rep_obj.exec_query(query_string, only_execute)
        self.mantis_rep_obj._closeDbConn()
        self.assertNotEquals(out_put, req_out_put)

    def test_createMantisTask1(self):
        req_out_put = False

        out_put = self.mantis_rep_obj.createMantisTask()
        self.mantis_rep_obj._closeDbConn()
        self.assertNotEquals(out_put, req_out_put)


    def test_createMantisTask2(self):
        req_out_put = False

        setattr(self.mantis_rep_obj, 'project_name', 'unit_test12')
        out_put = self.mantis_rep_obj.createMantisTask()
        self.mantis_rep_obj._closeDbConn()
        self.assertEquals(out_put, req_out_put)


    def test_execute1(self):
        req_out_put = False

        setattr(self.mantis_rep_obj, 'project_name', 'unit_test12')
        out_put = self.mantis_rep_obj.execute()
        self.assertEquals(out_put, req_out_put)


    def test_execute2(self):
        req_out_put = False

        out_put = self.mantis_rep_obj.execute()
        self.assertNotEquals(out_put, req_out_put)


if __name__ == '__main__':
    unittest.main()
