# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 117-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53396);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 117-1 (cvs)";
 script_name(name);

 desc = "The remote host is missing an update to cvs
announced via advisory DSA 117-1.

Kim Nielsen recently found an internal problem with the CVS server and
reported it to the vuln-dev mailing list.  The problem is triggered by
an improperly initialized global variable.  A user exploiting this can
crash the CVS server, which may be accessed through the pserver
service and running under a remote user id.  It is not yet clear if
the remote account can be exposed, through.

This problem has been fixed in version 1.10.7-9 for the stable Debian
distribution and in version newer than 1.11.1p1debian-3 for the
testing and unstable distribution of Debian (not yet uploaded,
though).

We recommend that you upgrade your CVS package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20117-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 117-1 (cvs)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cvs-doc", ver:"1.10.7-9", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cvs", ver:"1.10.7-9", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
