###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for squid FEDORA-2007-4161
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861294);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "FEDORA", value: "2007-4161");
  script_cve_id("CVE-2007-6239");
  script_name( "Fedora Update for squid FEDORA-2007-4161");
  desc = "

  Vulnerability Insight:
  Squid is a high-performance proxy caching server for Web clients,
  supporting FTP, gopher, and HTTP data objects. Unlike traditional
  caching software, Squid handles all requests in a single,
  non-blocking, I/O-driven process. Squid keeps meta data and especially
  hot objects cached in RAM, caches DNS lookups, supports non-blocking
  DNS lookups, and implements negative caching of failed requests.
  
  Squid consists of a main server program squid, a Domain Name System
  lookup program (dnsserver), a program for retrieving FTP data
  (ftpget), and some management and client tools.


  Affected Software/OS:
  squid on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-December/msg00507.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of squid");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.6.STABLE16~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.6.STABLE16~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"squid-debuginfo", rpm:"squid-debuginfo~2.6.STABLE16~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"squid-debuginfo", rpm:"squid-debuginfo~2.6.STABLE16~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.6.STABLE16~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}