###############################################################################
# OpenVAS Vulnerability Test
# $Id: open_media_collectors_database_37941.nasl 7519 2010-05-04 08:46:50Z chandra $
#
# Open Media Collectors Database Multiple Local File Include Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100469);
 script_bugtraq_id(37941);
 script_version ("1.0-$Revision: 7519 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Open Media Collectors Database Multiple Local File Include Vulnerabilities");

desc = "Overview:
Open Media Collectors Database (OpenDb) is prone to multiple local file-
include vulnerabilities because it fails to properly sanitize user-
supplied input.

An attacker can exploit these vulnerabilities to obtain
potentially sensitive information and execute arbitrary local
scripts in the context of the webserver process. This may allow
the attacker to compromise the application and the computer; other
attacks are also possible.

OpenDb 1.5.0.4 is vulnerable; other versions may also be affected.

References:
http://www.securityfocus.com/bid/37941
http://sourceforge.net/project/showfiles.php?group_id=37089&package_id=29402&release_id=573315

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if OpenDb version is 1.5.0.4");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("open_media_collectors_database_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/opendb")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_equal(version: vers, test_version: "1.5.0.4")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
