###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-058.nasl 5265 2009-10-14 09:16:45Z oct $
#
# Microsoft Windows Kernel Privilege Escalation Vulnerability (971486)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900963);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-2515", "CVE-2009-2516", "CVE-2009-2517");
  script_bugtraq_id(36623, 36624, 36625);
  script_name("Microsoft Windows Kernel Privilege Escalation Vulnerability (971486)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-058.

  Vulnerability Insight:
  Several flaws arise in the Windows kernel due to,
  - incorrect truncation of a 64-bit value to a 32-bit value.
  - insufficient validation of certain data/pointers passed from user mode.
  - improper handling of certain exceptions.

  Impact:
  Successful exploitation could allow attackers to execute arbitrary code with
  elevated privileges or system may stop responding.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2K  Service Pack 4 and prior.
  Microsoft Windows XP  Service Pack 3 and prior.
  Microsoft Windows 2K3 Service Pack 2 and prior.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms09-058.mspx

  References:
  http://secunia.com/advisories/35372/
  http://www.vupen.com/english/advisories/2009/2893
  http://www.microsoft.com/technet/security/bulletin/MS09-058.mspx

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of ntoskrnl.exe");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

# MS09-058 Hotfix check
if(hotfix_missing(name:"971486") == 0){
  exit(0);
}

exePath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!exePath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exePath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                    string:exePath + "\ntoskrnl.exe");

exeVer = GetVer(file:file, share:share);
if(!exeVer){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for ntoskrnl.exe version < 5.0.2195.7319
  if(version_is_less(version:exeVer, test_version:"5.0.2195.7319")){
    security_hole(0);
  }
}

# Windows XP
else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for ntoskrnl.exe < 5.1.2600.3610
    if(version_is_less(version:exeVer, test_version:"5.1.2600.3610")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep for ntoskrnl.exe < 5.1.2600.5857
    if(version_is_less(version:exeVer, test_version:"5.1.2600.5857")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}

# Windows 2003
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for ntoskrnl.exe version < 5.2.3790.4566
    if(version_is_less(version:exeVer, test_version:"5.2.3790.4566")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
