##############################################################################
#
#  Softalk Mail Server IMAP Denial of Service Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/09
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0171
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900119);
 script_cve_id("CVE-2008-4041");
 script_bugtraq_id(30970);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_tag(name:"cvss_base", value:"6.3");
 script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_name("Softalk Mail Server IMAP Denial of Service Vulnerability");
 script_summary("Check for vulnerable version of Softalk");
 desc = "
 Overview : The host is running Softalk Mail Server, which is prone to denial
 of service vulnerability.

 Vulnerability Insight :
        The issue is caused due to inadequate boundary checks on specially 
        crafted IMAP commands. The service can by crashed sending malicious 
        IMAP command sequences.

        Impact: Successful exploitation crashes the affected server denying the
        service to legitimate users. 

 Impact Level : Application

 Affected Software/OS :
        Softalk Mail Server versions 8.5.1 and prior on Windows (all)

 Fix : Upgrade to Softalk Mail Server version 8.6.0 or later,
 For updates refer, http://www.softalkltd.com/products/download_wm.asp

 References :
 http://secunia.com/advisories/31715/
 http://www.securityfocus.com/archive/1/495896

 CVSS Score :
        CVSS Base Score     : 6.3 (AV:N/AC:M/Au:SI/C:N/I:N/A:C)
        CVSS Temporal Score : 5.7
 Risk factor : High";

 script_description(desc);
 script_dependencies("find_service.nes");
 exit(0);
}


 include("imap_func.inc");

 port = get_kb_item("Services/imap");
 if(!port){
        port = 143;
 }

 if(!get_port_state(port)) {
        exit(0);
 }
 
 banner = get_imap_banner(port); 
 if(!banner){
        exit(0);
 }

 if(egrep(pattern:"Softalk Mail Server ([0-7]\..*|8\.([0-4](\..*)?|5(\.0" +
                      "(\..*)?)?|5\.1))[^.0-9]", string:banner)){
        security_warning(port);
 }
