Minutes from 67th OpenVDB TSC meeting, Oct 20th, 2020, (EDT)

Attendees: *Nick* A., *Jeff* L., *Ken* M., *Dan* B.

Additional Attendees: Johannes Meng (Intel), JT Nelson (Blender),
Andre Pradhana (DW), Bruce Cherniak (Intel)

Regrets: *Peter* C.

Agenda:

1) Confirm quorum
2) Secretary
3) ASWF Questions
4) Screen-sharing
5) Faster CSG Operations (PR785)
6) Review Process Retrospective
7) Next Meeting

1) Quorum was confirmed.

2) Secretary was Dan Bailey

3) ASWF Questions

Ken is providing some project-specific questions to the ASWF tomorrow. Various
questions posed such as locking-down the tree configuration, usage of the Maya
plugin, etc. Any others people think of, please share with Ken before tomorrow.

4) Screen-sharing

Screen-sharing is still disabled in our ASWF calls. Ken is joining the meeting
using his NVidia Zoom account and believes the host account is the official
openvdb gmail account. Ken to look into how to unlock screen-sharing and/or to
discuss with John about changing which account is the host account. In this
instance, Dan's ILM Zoom account was used to host a new call with screen-sharing
enabled.

5) Faster CSG Operations (PR785)

Dan re-presented the theory behind this functionality as presented in the
Siggraph 2019 OpenVDB Course and gave an overview of the code changes in the PR,
answering questions from the TSC as they came up. Changes are organized in the
PR by commit.

Some areas of discussion and/or investigation include:

Ken highlighted that different words of a node mask could in theory be modified
concurrently to unlock parallelism across a single node.

Nick and Jeff wish to try and resolve the confusion of sometimes using a bool
threaded parameter and sometimes using a bool serial parameter across the
codebase in general. Using bool serial is probably the right decision here to
maintain consistency, but would be nice to fix in an independent effort. Jeff
suggested using an enum to maintain backwards compatibility.

Ken raised that the new DynamicNodeManager class needs more documentation. Dan
to address this.

Nick raised that there were issues in the past with threading a core method that
was previously unthreaded as a result of nested parallelism. Dan to investigate
whether there are situations in which construction of the LeafManager or
NodeManager happens inside a thread.

Jeff and Ken raised concerns with the TreeToMerge class accepting either const
or non-const trees and users inadvertently picking the wrong one. The suggestion
proposed here is to add a dummy class parameter to each constructor similar to
tbb::split to make construction more explicit. Potentially this dummy class
could be part of the Types header. Dan to look into making this change.

This feature has been deployed at ILM along with the VDB Merge SOP that is not
part of this PR. Main item of feedback was that the Tree visitor pattern was
previously being used with a const tree as the NodeManager required a non-const
tree. Dan has extended the NodeManager to accept a const tree following the
implementation of the LeafManager which also does this. This change is now
included as part of this PR.

Jeff proposes that we aim to approve this PR by the TSC meeting next week.

6) Review Process Retrospective

Big changes such as AX, NanoVDB and the PR discussed here are hard to get into
the codebase. Bikeshedding occurs and smaller, simpler changes tend to be
discussed and merged as priority. Need to keep trying to address how to unblock
changes that are hard to review and particularly those that are refactoring
large portions of the existing codebase.

Public API is most important to review as that can be time-consuming to try and
change later. Bugs in the implementation details will often be discovered in due
course but that should not hold up features progressing. Provided there is
decent unit test coverage of new functionality being added and that all of the
existing unit tests pass, that should help to lower the barrier to approval.

Ken reiterates that we should perceive the master branch in GitHub as in
development. Users deploying directly from this take on a fair amount of risk.

In general, all in favor of using this live code review process again in these
types of cases to help push the project forwards.

7) Next Meeting

Next meeting is October 27th, 2020. 1pm-2pm EDT (GMT-4). Jeff will be dressed up
for Halloween.
