Minutes from 12th OpenVDB TSC meeting, Mar. 28, 2019

Attendees: *Ken* M., *Nick* A., *Dan* B., *Peter* C.

Additional Attendees: Andrew Pearce (DWA), Thanh Ha (LF)

Apologies: *Jeff* L.

Agenda:

1) Confirmation of quorum
2) Selection of secretary
3) TAC Update
4) Multi-Res Grid
5) Out-of-Core Read-only Grid
6) Instantiation / Compile-times
7) Tools vs Grid Methods
8) Release Schedule
9) CMake/CI Update
10) Improve / Update Cookbooks
11) CLA Check
12) Update Website
13) Documentation on how to file bug-reports or ask questions
14) Grid Iterator Performance
15) Next Meeting

1) A quorum was confirmed. Ken was phoning in, so Dan chaired.

2) Secretary - Dan Bailey

3) TAC Update

No-one available to represent OpenVDB in TAC Meeting the day before. Dan sent
Daniel Heckenberg a brief summary of OpenVDB updates which were shared. Thanh
gave a brief update from the TAC Meeting. The ASWF board are in support of using
Circle CI but remain interested in being able to provide reproducible builds
outside of Circle. Thanh also announced he was leaving the Linux Foundation for
a startup. Andrew Grimberg is taking over his responsibilities and is already
up-to-speed. It is envisioned that Andrew will attend the TAC and CI working
group meetings, but likely not the project TSC meetings.

4) Multi-Res Grid

Ken has received a comprehensive response from Autodesk answering the TSC
questions regarding Autodesk's proposal for introducing the Multi-Res Grid to
OpenVDB. He will be sending it around to the group shortly for discussion in the
next meeting. First impressions look promising.

5) Out-of-Core Read-only Grid

Ken has a working implementation of an out-of-core VDB grid. It is read-only,
supports random access with a pre-defined fixed memory footprint and can be
built from a standard out-of-core VDB grid. A fully out-of-core VDB grid
requires half the memory footprint of a standard VDB grid in out-of-core mode.
Savings are also possible through not supporting very old file formats. Ken
plans to release at Weta and then to look to introduce to the OpenVDB codebase.
Some concerns from Peter and Dan about introducing a new Grid structure, but
keen on understanding more of the implementation details.

6) Instantiation / Compile-times

Compilation of applications and plugins built against OpenVDB is slow and uses a
lot of memory, which we wish to address. Peter wants to consider baking the
configuration of the grid so as to improve compilation times and suggests asking
users whether they ever change the grid configuration. Ken mentioned that he
knows people change the size of the leaf node for GPU and other uses, but
unaware of many people changing the configuration of the tree. He wants to find
out if this is a consideration for Autodesk's Multi-Res Grid. Potential
investigation around where the compilation time is going could help direct our
efforts. Explicit template specialization also worth looking into.

7) Tools vs Grid Methods

Over time, there has been a gradual migration towards using free functions in
the tools directory instead of adding to the Grid and Tree classes. Question of
whether it's a good time to introduce a policy around this and to look at
removing some of the Grid and Tree methods. Ken proposed that the first step is
to look at all the methods and confirm whether they can currently be removed or
whether they need new access functions to be able to remove them. This change is
also expected to improve compilation times. Removing virtual functions needs to
be done in a major release, so they would need to be marked deprecated in a
prior release.

8) Release Schedule

Peter proposes we do a new release in the next few weeks. It was decided that
the next release should be 6.1.0, as there is a lot of new functionality and
some of the changes appear that they may affect the API. Unanimous vote in
favour. Potentially hold off to ensure we can include CMake changes. Peter
proposes adding static casts to fix the precision warnings as a temporary
solution so that we can make this release compile with strict mode enabled
without behavior changes. Ken proposes another minor/patch release shortly
before Siggraph. Rough plan is to do a new 7.0 release in September / October
which changes ABI, so we should start gathering ideas now. This new major
release can also be when we mark methods as deprecated that we intend to remove
in early 2020.

9) CMake/CI Update

Nick gave an update on his progress with refactoring CMake, his stage branch
contains further improvements. Main issues are around IlmBase/OpenEXR version
suffixes and case-sensitivity of CMake modules. Peter is currently testing with
DWA infrastructure and has run into a few issues, particularly around GLFW. Dan
has added CircleCI support which now builds all third-party dependencies from
scratch. More testing to come. Dan proposes changing the syntax, Nick suggested
after this PR gets merged is a good time. Peter asked about improved ways to
help users build against OpenVDB instead of using openvdb_print, Dan suggested a
"Hello World" sample might be a nice way of getting people started. Nick says
there is still some work needed on introducing a CMake module and improving the
find package mechanism for building against OpenVDB.

10) Improve / Update Cookbooks

Dan suggested building the cookbooks as part of the CI. Peter and Ken proposed
instead turning the cookbook examples into samples modeled after the SideFX HDK
samples with links from the documentation where relevant.

11) CLA Check

Thanh says to follow up with John regarding the progress of this.

12) Update Website

Website originally designed by Mihai Alden, needs some updating. All present
should seek permission for images from their respective studios to add to the
website with the aim for an update to be completed by Siggraph.

13) Documentation on how to file bug-reports or ask questions

General desire to keep Google forum around to avoid having to ask 600 or so
users to re-subscribe. Need a proposal on what to do with other communication
mechanisms such as GitHub issues and mailing lists. Dan to do a first draft of
changes to contributing.md.

14) Grid Iterator Performance

Dan raised performance issues with the grid iterator. When used in
tools::extrema(), it represented as much as 30x performance differential. Ken
mentioned that it's a significant problem and often his first question to a user
asking about performance is around which iterator they are using. The main issue
is poor ability to split when threading. Peter highlighted that this iterator
was designed for convenience, not performance and that performance varies based
on the use. Ken believes people are using it by accident without realizing the
performance consequences and better documentation wouldn't necessarily address
this. Two potential solutions were discussed - removing the grid iterator
entirely and re-writing it to offer a faster, underlying implementation.

15) Next Meeting

Our next TSC meeting is scheduled for Thursday April 11, 2019 11am-12pm PST.

