--
-- $Id: pgcmp--3.1.sql 1594 2020-11-03 15:31:20Z coelho $
--

-- complain if script is sourced in psql, rather than via CREATE EXTENSION
\echo Use "CREATE EXTENSION pgcmp" to load this file. \quit

--
-- XOR AGGREGATE
--

-- default behavior for strict functions used: NULLs are ignored

DROP AGGREGATE IF EXISTS XOR(bit);
CREATE AGGREGATE XOR(
  BASETYPE = BIT,
  SFUNC = bitxor,
  STYPE = BIT
);

DROP AGGREGATE IF EXISTS XOR(INT2);
CREATE AGGREGATE XOR(
  BASETYPE = INT2,
  SFUNC = int2xor,
  STYPE = INT2
);

DROP AGGREGATE IF EXISTS XOR(INT4);
CREATE AGGREGATE XOR(
  BASETYPE = INT4,
  SFUNC = int4xor,
  STYPE = INT4
);

DROP AGGREGATE IF EXISTS XOR(INT8);
CREATE AGGREGATE XOR(
  BASETYPE = INT8,
  SFUNC = int8xor,
  STYPE = INT8
);

--
-- CASTS
--

-- LOAD 'MODULE_PATHNAME';

CREATE OR REPLACE FUNCTION varbit(BYTEA, INT, BOOL)
RETURNS VARBIT
LANGUAGE C
IMMUTABLE STRICT
AS 'MODULE_PATHNAME', 'varbitfrombytea';

-- bit and varbit are binary compatible...
CREATE OR REPLACE FUNCTION tobit(BYTEA, INT, BOOL)
RETURNS BIT
LANGUAGE C
IMMUTABLE STRICT
AS 'MODULE_PATHNAME', 'varbitfrombytea';

CREATE OR REPLACE FUNCTION bytea(VARBIT, INT, BOOL)
RETURNS BYTEA
LANGUAGE C
IMMUTABLE STRICT
AS 'MODULE_PATHNAME', 'varbittobytea';

CREATE OR REPLACE FUNCTION bytea(BIT, INT, BOOL)
RETURNS BYTEA
LANGUAGE C
IMMUTABLE STRICT
AS 'MODULE_PATHNAME', 'varbittobytea';

CREATE OR REPLACE FUNCTION varbit2int2(VARBIT, INT, BOOL)
RETURNS INT2
LANGUAGE C
IMMUTABLE STRICT
AS 'MODULE_PATHNAME', 'varbittoint2';

CREATE OR REPLACE FUNCTION bit2int2(BIT, INT, BOOL)
RETURNS INT2
LANGUAGE C
IMMUTABLE STRICT
AS 'MODULE_PATHNAME', 'varbittoint2';

-- no data loss, very similar types
-- AS IMPLICIT would be ok?
DROP CAST IF EXISTS (BYTEA AS VARBIT);
CREATE CAST (BYTEA AS VARBIT)
WITH FUNCTION varbit(BYTEA, INT, BOOL);

DROP CAST IF EXISTS (BYTEA AS BIT);
CREATE CAST (BYTEA AS BIT)
WITH FUNCTION tobit(BYTEA, INT, BOOL);

-- data loss: the bit length is rounded up
-- AS ASSIGNMENT?

DROP CAST IF EXISTS (VARBIT AS BYTEA);
CREATE CAST (VARBIT AS BYTEA)
WITH FUNCTION bytea(VARBIT, INT, BOOL);

DROP CAST IF EXISTS (BIT AS BYTEA);
CREATE CAST (BIT AS BYTEA)
WITH FUNCTION bytea(BIT, INT, BOOL);

DROP CAST IF EXISTS (VARBIT AS INT2);
CREATE CAST (VARBIT AS INT2)
WITH FUNCTION varbit2int2(VARBIT, INT, BOOL);

DROP CAST IF EXISTS (BIT AS INT2);
CREATE CAST (BIT AS INT2)
WITH FUNCTION bit2int2(BIT, INT, BOOL);

--
-- CHECKSUMS
--

LOAD 'MODULE_PATHNAME';

CREATE OR REPLACE FUNCTION cksum2(TEXT)
RETURNS INT2
LANGUAGE C
CALLED ON NULL INPUT
AS 'MODULE_PATHNAME', 'text_checksum2';

CREATE OR REPLACE FUNCTION cksum4(TEXT)
RETURNS INT4
LANGUAGE C
CALLED ON NULL INPUT
AS 'MODULE_PATHNAME', 'text_checksum4';

CREATE OR REPLACE FUNCTION cksum8(TEXT)
RETURNS INT8
LANGUAGE C
CALLED ON NULL INPUT
AS 'MODULE_PATHNAME', 'text_checksum8';

CREATE OR REPLACE FUNCTION fnv2(TEXT)
RETURNS INT2
LANGUAGE C
CALLED ON NULL INPUT
AS 'MODULE_PATHNAME', 'text_fnv2';

CREATE OR REPLACE FUNCTION fnv4(TEXT)
RETURNS INT4
LANGUAGE C
CALLED ON NULL INPUT
AS 'MODULE_PATHNAME', 'text_fnv4';

CREATE OR REPLACE FUNCTION fnv8(TEXT)
RETURNS INT8
LANGUAGE C
CALLED ON NULL INPUT
AS 'MODULE_PATHNAME', 'text_fnv8';
