#!/usr/bin/perl
#
# For python folks: show me the equivalent code for this
#

print "header {\n";
print "    title = \"Syslog picviz analysis\";\n";
print "}\n";

print "axes {\n";
print "    timeline t [label=\"Timeline\"];\n";
#print "    string   cat [label=\"Category\"];\n";
print "    ipv4     source [label=\"Source\"];\n";
print "    integer  port [label=\"Port\"];\n";
print "    enum     dnsaction [label=\"DNS Action\"];\n";
print "    enum     type [label=\"Type\"];\n";
print "    string   url [label=\"URL\",relative=\"true\"];\n";
print "}\n";

print "data {\n";

while ($line = <>) {

	$typed = 0;

	$line =~ s/\\/\\\\/g;
	$line =~ s/\"/\\"/g; # We escape our quotes
        $line =~ s/&//g; # We escape our quotes
        $line =~ s/<//g; # We escape our quotes
        $line =~ s/>//g; # We escape our quotes

	$line =~ m/.* (\d+:\d+:\d+).\d+ (\S+): (\S+): \S+ (\d+.\d+.\d+.\d+)#(\d+): (.*) '(.*)\/(.*)\/(.*)' (.*)/;

#	print "$1,$2,$3,$4,$5,$6,$7,$8,$9,$10\n";


        $t=$1;
        $cat=$2;
	$msgtype=$3; # info, warning, error
        $source=$4;
	$port=$5;
        $dnsaction=$6;
	$url=$7;
	$type=$8;

	if ($t=="") {
        } else {
	# 29-Jul-2008 09:14:09.692 update-security: error: client 84.91.74.38#32773: update 'mylinux.net/IN' denied
        if ($msgtype =~ m/error/) {
		print "t=\"$t\", source=\"$source\", port=\"$port\", dnsaction=\"$dnsaction\", type=\"$type\", url=\"$url\" [color=\"red\"];\n";
		$typed = 1;
        }
	if ($msgtype =~ m/warning/) {
		print "t=\"$t\", source=\"$source\", port=\"$port\", dnsaction=\"$dnsaction\", type=\"$type\", url=\"$url\" [color=\"orange\"];\n";
		$typed = 1;
        }
	if ($msgtype =~ m/info/) {
		print "t=\"$t\", source=\"$source\", port=\"$port\", dnsaction=\"$dnsaction\", type=\"$type\", url=\"$url\" [color=\"blue\"];\n";
		$typed = 1;
        }

	if ($typed == 0) {
		print "t=\"$t\", cat=\"$cat\", source=\"$source\", port=\"$port\", dnsaction=\"$dnsaction\", url=\"$url\", type=\"$type\" [color=\"red\"];\n";
	}
	}
}

print "}\n";

