/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __ARBREIDEES__
#define __ARBREIDEES__

#include <src/global/global.h>

typedef struct arbreidees CONTENEUR(ArbreIdees);

#include <src/donnees/sortie/denominationidee.h>
#include <src/donnees/sortie/referencesidee.h>

typedef struct arbreideessoussections CONTENEUR_SCALAIRE(ArbreIdeesSousSections);

struct arbreideessoussections
{
	STOCKAGE_SCALAIRE(Taille) nombre;
	//Nombre de sous sections.
	TABLEAU(STOCKAGE(ArbreIdees)) soussection;
	//Sous sections de l'ide en cours.
};
/* Structure destine  recevoir les sous
 * sections d'une ide.
 */

struct arbreidees
{
	STOCKAGE(DenominationIdee) denomination;
	//Dnomination de l'ide.
	STOCKAGE_SCALAIRE(NiveauHierarchique) niveau;
	//Niveau hirarchique rel de
	//l'ide.
	STOCKAGE(ReferencesIdee) references;
	//Rfrences manant de cette ide.
	STOCKAGE_SCALAIRE(ArbreIdeesSousSections) soussections;
	//Sous sections de l'ide en cous.
};
/* Structure destine  la description
 * des diverses ides du plan.
 */

Resultat arbreidees_initialisation(TRAVAIL(ArbreIdees) arbreidees);
/* Initialise un arbre d'ides vide.
 */

Resultat arbreidees_creation_idee(TRAVAIL(ArbreIdees) arbreidees , TRAVAIL(DenominationIdee) denomination , TRAVAIL_SCALAIRE(NiveauHierarchique) niveau);
/* Cre un arbre comportant une seule ide.
 * Si l'arbre tait non vide, il est dtruit au pralable.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 * Renvoie RESULTAT_ERREUR si arbreidees est NULL.
 */

Resultat arbreidees_definition_references(TRAVAIL(ArbreIdees) arbreidees , TRAVAIL(ReferencesIdee) references);
/* Place une liste de rfrences dans l'ide racine de l'arbre
 * d'ide.
 * Renvoie RESULTAT_ERREUR si arbreidees est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat arbreidees_definition_nombresoussections(TRAVAIL(ArbreIdees) arbreidees , TRAVAIL_SCALAIRE(Taille) nombre);
/* Indique le nombre de sous sections que va avoir une ide.
 * Renvoie RESULTAT_ERREUR si arbreidees est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat arbreidees_definition_soussection(TRAVAIL(ArbreIdees) arbreidees , TRAVAIL_SCALAIRE(Indice) indice , TRAVAIL(ArbreIdees) soussection);
/* Dfinit une sous section. Exceptionnellement, cette dfinition
 * se fera sans copie ! Il ne faudra donc pas dtruire l'arbre de
 * la sous-section !
 * Renvoie RESULTAT_ERREUR si arbreidees est NULL.
 * Renvoie RESULTAT_ERREUR_DEPASSEMENT si l'indice est incorrect.
 */

Resultat arbreidees_lecture_denomination(TRAVAIL(ArbreIdees) arbreidees , REFERENCE(DenominationIdee) denomination);
/* Lit la dnomination de l'ide racine.
 * Renvoie RESULTAT_ERREUR si arbreidees est NULL.
 */

Resultat arbreidees_lecture_niveau(TRAVAIL(ArbreIdees) arbreidees , REFERENCE_SCALAIRE(NiveauHierarchique) niveau);
/* Lit le niveau de l'ide racine.
 * Renvoie RESULTAT_ERREUR si arbreidees est NULL.
 */

Resultat arbreidees_lecture_references(TRAVAIL(ArbreIdees) arbreidees , REFERENCE(ReferencesIdee) references);
/* Lit la liste des rfrences de l'ide racine.
 * Renvoie RESULTAT_ERREUR si arbreidees est NULL.
 */

Resultat arbreidees_lecture_nombresoussections(TRAVAIL(ArbreIdees) arbreidees , REFERENCE_SCALAIRE(Taille) nombre);
/* Lit le nombre de sous sections de l'ide racine.
 * Renvoie RESULTAT_ERREUR si arbreidees est NULL.
 */

Resultat arbreidees_lecture_soussection(TRAVAIL(ArbreIdees) arbreidees , TRAVAIL_SCALAIRE(Indice) indice , REFERENCE(ArbreIdees) soussection);
/* Lit une sous section de l'ide racine.
 * Renvoie RESULTAT_ERREUR si arbreidees est NULL.
 * Renvoie RESULTAT_ERREUR_DEPASSEMENT si l'indice est incorrect.
 */

Resultat arbreidees_recherche_reference(TRAVAIL(ArbreIdees) arbreidees , TRAVAIL_SCALAIRE(Chaine) reference , COREFERENCE_SCALAIRE(Booleen) correct , TRAVAIL(DenominationIdee) denomination , REFERENCE_SCALAIRE(NiveauHierarchique) niveauhierarchique , TRAVAIL_SCALAIRE(Chaine) referencepivot , TRAVAIL_SCALAIRE(TypeIdee) typepivot , REFERENCE_SCALAIRE(TypeReference) typereference);
/* Recherche une ide par sa rfrence exacte.
 * Le boolen correct indique si la rfrence
 * a t trouve, et dans ce cas, renvoie le
 * type de l'ide trouve dans type.
 * Attention : si plusieurs occurences de la
 * rfrence sont trouves, le type renvoy
 * correspond dans l'ordre de priorit  :
 * IDEE_PRESENTE, IDEE_MANQUANTE, IDEE_GENERIQUE,
 * IDEE_RACINE.
 * Si la rfrence est trouve aprs la rfrence
 * pivot, le type de rfrence sera fixe 
 * REFERENCE_IRREDUCTIBLE, et  REFERENCE_REDUCTIBLE
 * dans le cas contraire.
 * Renvoie RESULTAT_ERREUR si arbreidees est NULL.
 */

Resultat arbreidees_copie(TRAVAIL(ArbreIdees) arbreidees , TRAVAIL(ArbreIdees) copie);
/* Ralise une copie de l'arbre d'ides.
 * Si la copie tait non vide, elle est dtruite
 * avant la copie.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
 * mmoire.
 */

Resultat arbreidees_destruction(TRAVAIL(ArbreIdees) arbreidees);
/* Dtruit un arbre d'ides.
 */

#endif
