/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.KeyValueChunk;
import com.sixlegs.image.png.PngExceptionSoft;
import java.io.IOException;

final class Chunk_sPLT
extends Chunk {
    Chunk_sPLT() {
        super(Chunk.sPLT);
    }

    protected boolean beforeIDAT() {
        return true;
    }

    protected void readData() throws IOException {
        int[][] nArray;
        String string = this.in_data.readString();
        if (string.length() > 79) {
            throw new PngExceptionSoft("sPLT palette name too long");
        }
        if (this.img.data.palettes.containsKey(string = KeyValueChunk.repairKey(string))) {
            throw new PngExceptionSoft("Duplicate sPLT names");
        }
        int n = this.in_data.readUnsignedByte();
        int n2 = this.length - string.length();
        if (n == 8) {
            if (n2 % 6 != 0) {
                this.badLength();
            }
            int n3 = n2 / 6;
            nArray = new int[5][n3];
            for (int i = 0; i < n3; ++i) {
                nArray[0][i] = this.in_data.readUnsignedByte();
                nArray[1][i] = this.in_data.readUnsignedByte();
                nArray[2][i] = this.in_data.readUnsignedByte();
                nArray[3][i] = this.in_data.readUnsignedByte();
                nArray[4][i] = this.in_data.readUnsignedShort();
            }
        } else if (n == 16) {
            if (n2 % 10 != 0) {
                this.badLength();
            }
            int n4 = n2 / 10;
            nArray = new int[5][n4];
            for (int i = 0; i < n4; ++i) {
                nArray[0][i] = this.in_data.readUnsignedShort();
                nArray[1][i] = this.in_data.readUnsignedShort();
                nArray[2][i] = this.in_data.readUnsignedShort();
                nArray[3][i] = this.in_data.readUnsignedShort();
                nArray[4][i] = this.in_data.readUnsignedShort();
            }
        } else {
            throw new PngExceptionSoft("Bad sPLT sample depth: " + n);
        }
        this.img.data.palettes.put(string, nArray);
    }
}

