/* PureAdmin
 * Copyright (C) 2003 Isak Savo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Dirbrowser-widget (similar to the file-selector distributet with GTK+). This is
 * in fact a stand-alone widget that easily can be used in other projects. Please give 
 * me credit for it and leave the copyright-notice is untouched. Thx!
 *
 * Simply add dirbrowser.c and .h to you project and use the functions declared in the .h-file
 * to access the widget!
 *
 * Copyright (C) 2003 Isak Savo
 */
#ifndef __DIRBROWSER_H__
#define __DIRBROWSER_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtkdialog.h>


G_BEGIN_DECLS

/* Convinient macros for type-checking and -casting */
#define DIRBROWSER_TYPE            (dirbrowser_get_type ())
#define DIRBROWSER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), DIRBROWSER_TYPE, Dirbrowser))
#define DIRBROWSER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), DIRBROWSER_TYPE, DirBrowserClass))
#define IS_DIRBROWSER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DIRBROWSER_TYPE))
#define IS_DIRBROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DIRBROWSER_TYPE))


typedef struct _Dirbrowser       Dirbrowser;
typedef struct _DirbrowserClass  DirbrowserClass;

struct _Dirbrowser
{
	/*< private >*/
	GtkDialog parent_instance;

	/*< public >*/
	GtkWidget *main_vbox;
	GtkWidget *btnbox;
	GtkWidget *btn_home;
	GtkWidget *location;
	GtkWidget *dir_tree;
	GtkWidget *btn_cancel;
	GtkWidget *btn_ok;
	gchar     *str_directory;

	/*< private >*/
	GtkWidget *scr_win;
	GdkPixbuf *icon;
	gulong hid_entry_changed, hid_cursor_changed;
};

struct _DirbrowserClass
{
	GtkDialogClass parent_class;
};

/* Public functions, use these to access the widget */
GType          dirbrowser_get_type       (void);
GtkWidget*     dirbrowser_new             (const gchar *title);

void           dirbrowser_set_directory (Dirbrowser *dir_browser, const char *path);
G_CONST_RETURN gchar *dirbrowser_get_directory (Dirbrowser *dir_browser);

G_END_DECLS

#endif /* __DIRBROWSER_H__ */
