% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeAsset.R
\name{removeAsset}
\alias{removeAsset}
\title{Remove an asset}
\usage{
removeAsset(project, asset, url = restUrl(), token = accessToken())
}
\arguments{
\item{project}{String containing the project to remove.}

\item{asset}{String containing the asset to remove.}

\item{url}{String containing the URL of the gypsum REST API.}

\item{token}{String containing a GitHub access token to authenticate to the gypsum REST API.
The token must refer to a gypsum administrator account.}
}
\value{
\code{NULL} is invisibly returned if the asset was successfully removed.
}
\description{
Remove an asset of a project from the gypsum backend.
}
\examples{
if (interactive()) {
    # Mocking up a versioned asset.
    init <- startUpload(
        project="test-R", 
        asset="removal", 
        version="v1", 
        files=character(0),
        probation=TRUE
    )
    completeUpload(init) 

    removeAsset("test-R", asset="removal")
}
}
\seealso{
\code{\link{removeProject}}, to remove a project.

\code{\link{removeVersion}}, to remove a specific version.
}
\author{
Aaron Lun
}
