% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-matrix.R
\name{chk_matrix}
\alias{chk_matrix}
\alias{vld_matrix}
\title{Check Matrix}
\usage{
chk_matrix(x, x_name = NULL)

vld_matrix(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if is a matrix using

\code{is.matrix(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_matrix()}: Validate Matrix

}}
\examples{
# chk_matrix
chk_matrix(matrix(1))
try(chk_matrix(array(1)))
# vld_matrix
vld_matrix(1)
vld_matrix(matrix(1))
}
\seealso{
\code{\link[=is.matrix]{is.matrix()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other data_structure_checkers: 
\code{\link{chk_array}()},
\code{\link{chk_atomic}()},
\code{\link{chk_list}()},
\code{\link{chk_vector}()}
}
\concept{data_structure_checkers}
