% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition-events.R
\name{transition_events}
\alias{transition_events}
\title{Transition individual events in and out}
\usage{
transition_events(
  start,
  end = NULL,
  range = NULL,
  enter_length = NULL,
  exit_length = NULL
)
}
\arguments{
\item{start, end}{The unquoted expression giving the start and end time of
each event. If \code{end}is \code{NULL} the event will be treated as having no duration.}

\item{range}{The range the animation should span. Defaults to the range of
the events from they enter to they have exited.}

\item{enter_length, exit_length}{The unquoted expression giving the length to
be used for enter and exit for each event.}
}
\description{
This transition treats each visual element as an event in time and allows you
to control the duration and enter/exit length individually for each event.
}
\section{Label variables}{

\code{transition_components} makes the following variables available for string
literal interpretation, in addition to the general ones provided by
\code{\link[=animate]{animate()}}:
\itemize{
\item \strong{frame_time} gives the time that the current frame corresponds to
}
}

\section{Object permanence}{

\code{transition_events} does not link rows across data to the same graphic
element, so elements will be defined uniquely by each row and its specific
start, end, enter and exit.
}

\section{Computed Variables}{

It is possible to use variables calculated by the statistic to define the
transition. Simply inclose the variable in \code{stat()} in the same way as when
using computed variables in aesthetics.
}

\examples{
data <- data.frame(
  x = 1:10,
  y = runif(10),
  begin = runif(10, 1, 100),
  length = runif(10, 5, 20),
  enter = runif(10, 5, 10),
  exit = runif(10, 5, 10)
)

anim <- ggplot(data, aes(x, y)) +
  geom_col() +
  transition_events(start = begin,
                    end = begin + length,
                    enter_length = enter,
                    exit_length = exit) +
 enter_grow() +
 exit_drift(x_mod = 11) +
 exit_fade()
}
\seealso{
Other transitions: 
\code{\link{transition_components}()},
\code{\link{transition_filter}()},
\code{\link{transition_layers}()},
\code{\link{transition_manual}()},
\code{\link{transition_null}()},
\code{\link{transition_reveal}()},
\code{\link{transition_states}()},
\code{\link{transition_time}()}
}
\concept{transitions}
