% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnecessary_concatenation_linter.R
\name{unnecessary_concatenation_linter}
\alias{unnecessary_concatenation_linter}
\title{Unneeded concatenation linter}
\usage{
unnecessary_concatenation_linter(allow_single_expression = TRUE)
}
\arguments{
\item{allow_single_expression}{Logical, default \code{TRUE}. If \code{FALSE}, one-expression
usages of \code{c()} are always linted, e.g. \code{c(x)} and \code{c(matrix(...))}. In some such
cases, \code{c()} is being used for its side-effect of stripping non-name attributes;
it is usually preferable to use the more readable \code{\link[=as.vector]{as.vector()}} instead.
\code{\link[=as.vector]{as.vector()}} is not always preferable, for example with environments
(especially, \code{R6} objects), in which case \code{list()} is the better alternative.}
}
\description{
Check that the \code{\link[=c]{c()}} function is not used without arguments nor with a single constant.
}
\examples{
# will produce lints
lint(
  text = "x <- c()",
  linters = unnecessary_concatenation_linter()
)

lint(
  text = "x <- c(TRUE)",
  linters = unnecessary_concatenation_linter()
)

lint(
  text = "x <- c(1.5 + 2.5)",
  linters = unnecessary_concatenation_linter(allow_single_expression = FALSE)
)

# okay
lint(
  text = "x <- NULL",
  linters = unnecessary_concatenation_linter()
)

# In case the intent here was to seed a vector of known size
lint(
  text = "x <- integer(4L)",
  linters = unnecessary_concatenation_linter()
)

lint(
  text = "x <- TRUE",
  linters = unnecessary_concatenation_linter()
)

lint(
  text = "x <- c(1.5 + 2.5)",
  linters = unnecessary_concatenation_linter(allow_single_expression = TRUE)
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=efficiency_linters]{efficiency}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
