% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto_smooth.R
\name{pareto_khat}
\alias{pareto_khat}
\alias{pareto_khat.default}
\alias{pareto_khat.rvar}
\title{Pareto khat diagnostic}
\usage{
pareto_khat(x, ...)

\method{pareto_khat}{default}(
  x,
  tail = c("both", "right", "left"),
  r_eff = NULL,
  ndraws_tail = NULL,
  verbose = FALSE,
  ...
)

\method{pareto_khat}{rvar}(x, ...)
}
\arguments{
\item{x}{(multiple options) One of:
\itemize{
\item A matrix of draws for a single variable (iterations x chains). See
\code{\link[=extract_variable_matrix]{extract_variable_matrix()}}.
\item An \code{\link{rvar}}.
}}

\item{...}{Arguments passed to individual methods (if applicable).}

\item{tail}{(string) The tail to diagnose/smooth:
\itemize{
\item \code{"right"}: diagnose/smooth only the right (upper) tail
\item \code{"left"}: diagnose/smooth only the left (lower) tail
\item \code{"both"}: diagnose/smooth both tails and return the maximum k-hat value
}

The default is \code{"both"}.}

\item{r_eff}{(numeric) relative effective sample size estimate. If
\code{r_eff} is omitted, it will be calculated assuming the draws are
from MCMC.}

\item{ndraws_tail}{(numeric) number of draws for the tail. If
\code{ndraws_tail} is not specified, it will be calculated as
ceiling(3 * sqrt(length(x) / r_eff)) if length(x) > 225 and
length(x) / 5 otherwise (see Appendix H in Vehtari et al. (2022)).}

\item{verbose}{(logical) Should diagnostic messages be printed? If
\code{TRUE}, messages related to Pareto diagnostics will be
printed. Default is \code{FALSE}.}
}
\value{
\code{khat} estimated Generalized Pareto Distribution shape parameter k
}
\description{
Estimate Pareto k value by fitting a Generalized Pareto
Distribution to one or two tails of x. This can be used to estimate
the number of fractional moments that is useful for convergence
diagnostics. For further details see Vehtari et al. (2022).
}
\examples{
mu <- extract_variable_matrix(example_draws(), "mu")
pareto_khat(mu)

d <- as_draws_rvars(example_draws("multi_normal"))
pareto_khat(d$Sigma)
}
\references{
Aki Vehtari, Daniel Simpson, Andrew Gelman, Yuling Yao and
Jonah Gabry (2022). Pareto Smoothed Importance Sampling.
arxiv:arXiv:1507.02646
}
