% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_quality_assurance.R
\name{MarkdownReporter}
\alias{MarkdownReporter}
\title{Markdown Reporter for Test Results}
\description{
This class defines a Markdown reporter for test results, inheriting from the \code{R6::Reporter} class.
It logs test results in Markdown format and saves them to a file named \code{test_results.md}.
}
\section{Fields}{

\describe{
\item{\code{startTime}}{The start time of the test run.}

\item{\code{output}}{A character vector to store the log output.}

\item{\code{failures}}{The number of test failures.}

\item{\code{fileName}}{The name of the current test file being processed.}
}}

\section{Methods}{

\describe{
\item{\code{initialize(...)}}{Initializes the reporter, setting up the output and failures fields.}
\item{\code{log(...)}}{Logs messages to the output field.}
\item{\code{start_reporter()}}{Starts the reporter, logging the introduction and test results header.}
\item{\code{start_file(file)}}{Sets the current file name being processed.}
\item{\code{getContext()}}{Gets the context from the current file name.}
\item{\code{add_result(context, test, result)}}{Adds a test result to the log, marking it as passed or failed.}
\item{\code{end_reporter()}}{Ends the reporter, logging the summary and saving the output to a file.}
\item{\code{finalize()}}{Finalizes the reporter, displaying a message that the test results were saved.}
}
}

\keyword{internal}
