% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Class-SDMXRequestBuilder.R, R/SDMXRequestBuilder-methods.R
\docType{class}
\name{SDMXRequestBuilder}
\alias{SDMXRequestBuilder}
\alias{SDMXRequestBuilder,SDMXRequestBuilder-method}
\alias{SDMXRequestBuilder-class}
\title{Class "SDMXRequestBuilder"}
\usage{
SDMXRequestBuilder(regUrl, repoUrl, handler, compliant)
}
\arguments{
\item{regUrl}{an object of class "character" giving the base Url of the SDMX service registry}

\item{repoUrl}{an object of class "character" giving the base Url of the SDMX service repository}

\item{handler}{an object of class "function" that will be in charge of build a web request.}

\item{compliant}{an object of class "logical" indicating if the request builder is somehow compliant with a service specification}
}
\description{
A basic class to handle a SDMX service request builder
}
\details{
The \code{handler} function must have the following structure in term of arguments
(baseUrl, agencyId, resource, resourceId, version, flowRef, key, start, end, compliant)
and output (a string representing the web request to build).

The rsdmx package will as much as possible try to handler generic handlers,
e.g. an handler for SDMX REST web-services. For the latter example, a specific
builder is provided and made part of the specific and still experimental
\link{SDMXRESTRequestBuilder}.
}
\section{Slots}{

\describe{
\item{\code{regUrl}}{an object of class "character" giving the base Url of the SDMX service registry}

\item{\code{repoUrl}}{an object of class "character" giving the base Url of the SDMX service repository}

\item{\code{handler}}{an object of class "function" that will be in charge of build a web request.}

\item{\code{compliant}}{an object of class "logical" indicating if the request builder is somehow compliant with a service specification}
}}
\section{Warning}{

This class is not useful in itself, but all SDMX non-abstract classes will
encapsulate it as slot, when parsing an SDMX-ML document (Concepts, or
DataStructureDefinition)
}
\examples{
#an handler
 myHandler <- function(baseUrl, agencyId, resource, resourceId, version,
                       flowRef, key, start, end, compliant){
   req <- paste(baseUrl, agencyId, resource, flowRef, key, start, end, sep="/")
   return(req)
 }

 #how to create a SDMXRequestBuilder
 requestBuilder <- SDMXRequestBuilder(
   regUrl = "http://www.myorg.org/registry",
   repoUrl = "http://www.myorg.org/repository",
   handler = myHandler, compliant = FALSE)
}
\author{
Emmanuel Blondel, \email{emmanuel.blondel1@gmail.com}
}

