% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQLiteConnection.R,
%   R/dbAppendTable_SQLiteConnection.R, R/dbDataType_SQLiteConnection.R,
%   R/dbExistsTable_SQLiteConnection_Id.R,
%   R/dbExistsTable_SQLiteConnection_character.R,
%   R/dbGetException_SQLiteConnection.R, R/dbGetInfo_SQLiteConnection.R,
%   R/dbIsValid_SQLiteConnection.R, R/dbListTables_SQLiteConnection.R,
%   R/dbQuoteIdentifier_SQLiteConnection_SQL.R,
%   R/dbQuoteIdentifier_SQLiteConnection_character.R,
%   R/dbRemoveTable_SQLiteConnection_character.R,
%   R/dbSendQuery_SQLiteConnection_character.R,
%   R/dbUnquoteIdentifier_SQLiteConnection_SQL.R, R/show_SQLiteConnection.R,
%   R/sqlData_SQLiteConnection.R
\docType{class}
\name{SQLiteConnection-class}
\alias{SQLiteConnection-class}
\alias{format.SQLiteConnection}
\alias{dbAppendTable_SQLiteConnection}
\alias{dbAppendTable,SQLiteConnection-method}
\alias{dbDataType_SQLiteConnection}
\alias{dbDataType,SQLiteConnection-method}
\alias{dbExistsTable_SQLiteConnection_Id}
\alias{dbExistsTable,SQLiteConnection,Id-method}
\alias{dbExistsTable_SQLiteConnection_character}
\alias{dbExistsTable,SQLiteConnection,character-method}
\alias{dbGetException_SQLiteConnection}
\alias{dbGetException,SQLiteConnection-method}
\alias{dbGetInfo_SQLiteConnection}
\alias{dbGetInfo,SQLiteConnection-method}
\alias{dbIsValid_SQLiteConnection}
\alias{dbIsValid,SQLiteConnection-method}
\alias{dbListTables_SQLiteConnection}
\alias{dbListTables,SQLiteConnection-method}
\alias{dbQuoteIdentifier_SQLiteConnection_SQL}
\alias{dbQuoteIdentifier,SQLiteConnection,SQL-method}
\alias{dbQuoteIdentifier_SQLiteConnection_character}
\alias{dbQuoteIdentifier,SQLiteConnection,character-method}
\alias{dbRemoveTable_SQLiteConnection_character}
\alias{dbRemoveTable,SQLiteConnection,character-method}
\alias{dbSendQuery_SQLiteConnection_character}
\alias{dbSendQuery,SQLiteConnection,character-method}
\alias{dbUnquoteIdentifier_SQLiteConnection_SQL}
\alias{dbUnquoteIdentifier,SQLiteConnection,SQL-method}
\alias{show_SQLiteConnection}
\alias{show,SQLiteConnection-method}
\alias{sqlData_SQLiteConnection}
\alias{sqlData,SQLiteConnection-method}
\title{Class SQLiteConnection (and methods)}
\usage{
\method{format}{SQLiteConnection}(x, ...)

\S4method{dbAppendTable}{SQLiteConnection}(conn, name, value, ..., row.names = NULL)

\S4method{dbDataType}{SQLiteConnection}(dbObj, obj, ...)

\S4method{dbExistsTable}{SQLiteConnection,Id}(conn, name, ...)

\S4method{dbExistsTable}{SQLiteConnection,character}(conn, name, ...)

\S4method{dbGetException}{SQLiteConnection}(conn, ...)

\S4method{dbGetInfo}{SQLiteConnection}(dbObj, ...)

\S4method{dbIsValid}{SQLiteConnection}(dbObj, ...)

\S4method{dbListTables}{SQLiteConnection}(conn, ...)

\S4method{dbQuoteIdentifier}{SQLiteConnection,SQL}(conn, x, ...)

\S4method{dbQuoteIdentifier}{SQLiteConnection,character}(conn, x, ...)

\S4method{dbRemoveTable}{SQLiteConnection,character}(conn, name, ..., temporary = FALSE, fail_if_missing = TRUE)

\S4method{dbSendQuery}{SQLiteConnection,character}(conn, statement, params = NULL, ...)

\S4method{dbUnquoteIdentifier}{SQLiteConnection,SQL}(conn, x, ...)

\S4method{show}{SQLiteConnection}(object)

\S4method{sqlData}{SQLiteConnection}(
  con,
  value,
  row.names = pkgconfig::get_config("RSQLite::row.names.query", FALSE),
  ...
)
}
\arguments{
\item{temporary}{If \code{TRUE}, only temporary tables are considered.}

\item{fail_if_missing}{If \code{FALSE}, \code{dbRemoveTable()} succeeds if the
table doesn't exist.}
}
\description{
SQLiteConnection objects are created by passing \code{\link[=SQLite]{SQLite()}} as first
argument to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}.
They are a superclass of the \link[DBI:DBIConnection-class]{DBI::DBIConnection} class.
The "Usage" section lists the class methods overridden by \pkg{RSQLite}.
}
\seealso{
The corresponding generic functions
\code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}}, \code{\link[DBI:dbGetQuery]{DBI::dbGetQuery()}},
\code{\link[DBI:dbSendStatement]{DBI::dbSendStatement()}}, \code{\link[DBI:dbExecute]{DBI::dbExecute()}},
\code{\link[DBI:dbExistsTable]{DBI::dbExistsTable()}}, \code{\link[DBI:dbListTables]{DBI::dbListTables()}}, \code{\link[DBI:dbListFields]{DBI::dbListFields()}},
\code{\link[DBI:dbRemoveTable]{DBI::dbRemoveTable()}}, and \code{\link[DBI:sqlData]{DBI::sqlData()}}.
}
\keyword{internal}
