% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/platform.R
\name{current_r_platform}
\alias{current_r_platform}
\title{Current R platform}
\usage{
current_r_platform()
}
\description{
\code{current_r_platform()} detects the platform of the current R version.
}
\details{
It returns a string of the form \code{cpu-vendor-os-abi}, a target triplet,
see some examples below. On Linux it also includes the distribution
name and version and part of the ABI.

Examples:
\itemize{
\item \code{x86_64-apple-darwin17.0}: macOS High Sierra.
\item \code{aarch64-apple-darwin20}: macOS Big Sur on arm64.
\item \code{x86_64-w64-mingw32}: 64 bit Windows.
\item \code{i386-w64-mingw32}: 32 bit Windows.
\item \code{i386+x86_64-w64-mingw32}: 64 bit + 32 bit Windows.
\item \code{i386-pc-solaris2.10}: 32 bit Solaris. (Some broken 64 Solaris
builds might have the same platform string, unfortunately.)
\item \code{x86_64-pc-linux-gnu-debian-10}: Debian Linux 10 on x86_64.
\item \verb{x86_64-pc-linux-musl-alpine-3.14.1}: Alpine Linux.
\item \code{x86_64-pc-linux-gnu-unknown}: Unknown Linux Distribution on x86_64.
\item \code{s390x-ibm-linux-gnu-ubuntu-20.04}: Ubuntu Linux 20.04 on S390x.
\item \code{amd64-portbld-freebsd12.1}: FreeBSD 12.1 on x86_64.
}
}
\examples{
current_r_platform()
}
